/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.teavm.common.json.JsonArrayValue;
import org.teavm.common.json.JsonObjectValue;
import org.teavm.common.json.JsonParser;
import org.teavm.common.json.JsonValue;
import org.teavm.gradle.api.JSModuleType;

public class ProjectDevServerManager {
    private Set<File> serverClasspath = new LinkedHashSet<File>();
    private Set<File> classpath = new LinkedHashSet<File>();
    private String targetFileName;
    private String targetFilePath;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private Set<String> preservedClasses = new LinkedHashSet<String>();
    private JSModuleType jsModuleType;
    private String mainClass;
    private boolean stackDeobfuscated;
    private boolean indicator;
    private int port;
    private Set<File> sources = new HashSet<File>();
    private boolean autoReload;
    private String proxyUrl;
    private String proxyPath;
    private int processMemory;
    private int debugPort;
    private Process process;
    private Thread processKillHook;
    private Thread commandInputThread;
    private Thread stderrThread;
    private BufferedWriter commandOutput;
    private JsonParser jsonParser;
    private BlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue<Runnable>();
    private boolean eventQueueDone;
    private Logger logger;
    private ProgressLogger progressLogger;
    private Set<File> runningServerClasspath = new HashSet<File>();
    private Set<File> runningClasspath = new HashSet<File>();
    private String runningTargetFileName;
    private String runningTargetFilePath;
    private Map<String, String> runningProperties = new HashMap<String, String>();
    private Set<String> runningPreservedClasses = new HashSet<String>();
    private JSModuleType runningJsModuleType;
    private String runningMainClass;
    private boolean runningStackDeobfuscated;
    private boolean runningIndicator;
    private int runningPort;
    private Set<File> runningSources = new HashSet<File>();
    private boolean runningAutoReload;
    private String runningProxyUrl;
    private String runningProxyPath;
    private int runningProcessMemory;
    private int runningDebugPort;

    ProjectDevServerManager() {
        this.jsonParser = JsonParser.ofValue(this::parseCommand);
    }

    public void setServerClasspath(Set<File> serverClasspath) {
        this.serverClasspath.clear();
        this.serverClasspath.addAll(serverClasspath);
    }

    public void setClasspath(Set<File> classpath) {
        this.classpath.clear();
        this.classpath.addAll(classpath);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public void setPreservedClasses(Collection<String> preservedClasses) {
        this.preservedClasses.clear();
        this.preservedClasses.addAll(preservedClasses);
    }

    public void setJsModuleType(JSModuleType jsModuleType) {
        this.jsModuleType = jsModuleType;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = targetFilePath;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setStackDeobfuscated(boolean stackDeobfuscated) {
        this.stackDeobfuscated = stackDeobfuscated;
    }

    public void setIndicator(boolean indicator) {
        this.indicator = indicator;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSources(Set<File> sources) {
        this.sources.clear();
        this.sources.addAll(sources);
    }

    public void setAutoReload(boolean autoReload) {
        this.autoReload = autoReload;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public void setProxyPath(String proxyPath) {
        this.proxyPath = proxyPath;
    }

    public void setProcessMemory(int processMemory) {
        this.processMemory = processMemory;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public void runBuild(Logger logger, ProgressLogger progressLogger) throws IOException {
        this.restartIfNecessary(logger);
        try {
            this.schedule(() -> {
                try {
                    this.commandOutput.write("{\"type\":\"build\"}\n");
                    this.commandOutput.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (InterruptedException e) {
            return;
        }
        this.processQueue(logger, progressLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue(Logger logger, ProgressLogger progressLogger) {
        this.eventQueueDone = false;
        this.logger = logger;
        this.progressLogger = progressLogger;
        boolean[] stoppedUnexpectedly = new boolean[1];
        Thread processMonitorThread = new Thread(() -> {
            try {
                this.process.waitFor();
                this.schedule(() -> {
                    stoppedUnexpectedly[0] = true;
                });
                this.stopEventQueue();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        processMonitorThread.setDaemon(true);
        processMonitorThread.setName("Dev server process crash monitor");
        processMonitorThread.start();
        try {
            while (!this.eventQueueDone || !this.eventQueue.isEmpty()) {
                Runnable command;
                try {
                    command = this.eventQueue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
                command.run();
            }
            if (stoppedUnexpectedly[0]) {
                logger.error("Dev server process stopped unexpectedly");
                throw new GradleException();
            }
        }
        finally {
            this.logger = null;
            this.progressLogger = null;
            processMonitorThread.interrupt();
        }
    }

    private void restartIfNecessary(Logger logger) throws IOException {
        if (this.process != null && !this.checkProcess()) {
            logger.info("Changes detected in TeaVM development server config, restarting server");
            this.stop(logger);
        }
        if (this.process == null || !this.process.isAlive()) {
            this.start(logger);
        }
    }

    public void stop(Logger logger) {
        if (this.process != null) {
            logger.info("Stopping TeaVM development server, PID = {}", (Object)this.process.pid());
            if (this.process.isAlive()) {
                try {
                    this.commandOutput.write("{\"type\":\"stop\"}\n");
                    this.commandOutput.flush();
                }
                catch (IOException e) {
                    this.process.destroy();
                }
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                logger.info("Process was dead");
            }
            this.process = null;
            Runtime.getRuntime().removeShutdownHook(this.processKillHook);
            this.processKillHook = null;
            this.commandInputThread.interrupt();
            this.commandInputThread = null;
            this.stderrThread.interrupt();
            this.stderrThread = null;
            this.commandOutput = null;
        } else {
            logger.info("No development server running, doing nothing");
        }
    }

    private void start(Logger logger) throws IOException {
        logger.info("Starting TeaVM development server");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(this.getBuilderCommand().toArray(new String[0]));
        this.process = pb.start();
        this.processKillHook = new Thread(() -> this.process.destroy());
        Runtime.getRuntime().addShutdownHook(this.processKillHook);
        this.commandOutput = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream(), StandardCharsets.UTF_8));
        this.commandInputThread = new Thread(this::readCommandsFromProcess);
        this.commandInputThread.setName("TeaVM development server command reader");
        this.commandInputThread.setDaemon(true);
        this.commandInputThread.start();
        this.stderrThread = new Thread(this::readStderrFromProcess);
        this.stderrThread.setName("TeaVM development server stderr reader");
        this.stderrThread.setDaemon(true);
        this.stderrThread.start();
        logger.info("Development server started");
    }

    private void readCommandsFromProcess() {
        block14: {
            try (BufferedReader input = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));){
                while (!Thread.currentThread().isInterrupted()) {
                    String command = input.readLine();
                    if (command == null) {
                        break;
                    }
                    this.schedule(() -> this.readCommand(command));
                }
            }
            catch (IOException e) {
                try {
                    this.stopEventQueue();
                    if (this.logger != null) {
                        this.logger.error("IO error occurred reading stdout of development server process", (Throwable)e);
                    }
                }
                catch (InterruptedException e2) {
                    if (this.logger != null) {
                        this.logger.info("Development server process input thread interrupted");
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null) break block14;
                this.logger.info("Development server process input thread interrupted");
            }
        }
    }

    private void readStderrFromProcess() {
        block11: {
            try (BufferedReader input = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8));){
                while (!Thread.currentThread().isInterrupted()) {
                    String line = input.readLine();
                    if (line == null) {
                        break;
                    }
                    this.schedule(() -> this.logger.warn("server stderr: {}", (Object)line));
                }
            }
            catch (IOException e) {
                if (this.logger != null) {
                    this.logger.error("IO error occurred reading stderr of development server process", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null) break block11;
                this.logger.info("Development server process input thread interrupted");
            }
        }
    }

    private void stopEventQueue() throws InterruptedException {
        this.schedule(() -> {
            this.eventQueueDone = true;
        });
    }

    private void schedule(Runnable command) throws InterruptedException {
        this.eventQueue.put(command);
    }

    private void readCommand(String command) {
        try {
            this.jsonParser.parse((Reader)new StringReader(command));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error reading command: " + command, e);
        }
    }

    private void parseCommand(JsonValue command) {
        JsonObjectValue obj = (JsonObjectValue)command;
        String type = obj.get("type").asString();
        try {
            switch (type) {
                case "log": {
                    this.logCommand(obj);
                    break;
                }
                case "compilation-started": {
                    break;
                }
                case "compilation-progress": {
                    this.progressCommand(obj);
                    break;
                }
                case "compilation-complete": {
                    this.completeCommand(obj);
                    break;
                }
                case "compilation-cancelled": {
                    this.stopEventQueue();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logCommand(JsonObjectValue command) throws InterruptedException {
        if (this.logger == null) {
            return;
        }
        String level = command.get("level").asString();
        Object message = command.get("message").asString();
        JsonValue throwable = command.get("throwable");
        if (throwable != null) {
            message = (String)message + "\n" + throwable.asString();
        }
        String messageToReport = message;
        switch (level) {
            case "debug": {
                this.schedule(() -> this.logger.debug(messageToReport));
                break;
            }
            case "info": {
                this.schedule(() -> this.logger.info(messageToReport));
                break;
            }
            case "warning": {
                this.schedule(() -> this.logger.warn(messageToReport));
                break;
            }
            case "error": {
                this.schedule(() -> this.logger.error(messageToReport));
            }
        }
    }

    private void progressCommand(JsonObjectValue command) throws InterruptedException {
        if (this.progressLogger == null) {
            return;
        }
        double progress = command.get("progress").asNumber();
        int roundedResult = (int)(progress * 1000.0 + 5.0) / 10;
        double result = Math.min(100.0, (double)roundedResult / 10.0);
        this.schedule(() -> this.progressLogger.progress(result + " %"));
    }

    private void completeCommand(JsonObjectValue command) throws InterruptedException {
        JsonValue problemsJson = command.get("problems");
        if (problemsJson != null && this.logger != null) {
            this.reportProblems((JsonArrayValue)problemsJson);
        }
        this.stopEventQueue();
    }

    private void reportProblems(JsonArrayValue json) throws InterruptedException {
        boolean hasSevere = false;
        block8: for (int i = 0; i < json.size(); ++i) {
            JsonObjectValue problem = json.get(i).asObject();
            String severity = problem.get("severity").asString();
            StringBuilder sb = new StringBuilder();
            sb.append(problem.get("message").asString());
            sb.append(problem.get("location").asString());
            String message = sb.toString();
            switch (severity) {
                case "error": {
                    hasSevere = true;
                    this.schedule(() -> this.logger.error(message));
                    continue block8;
                }
                case "warning": {
                    this.schedule(() -> this.logger.warn(message));
                }
            }
        }
        if (hasSevere) {
            this.schedule(() -> {
                throw new GradleException("Errors occurred during TeaVM build");
            });
        }
    }

    private List<String> getBuilderCommand() {
        ArrayList<String> command = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String javaExec = javaHome + "/bin/java";
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            javaExec = javaExec + ".exe";
        }
        command.add(javaExec);
        if (!this.serverClasspath.isEmpty()) {
            command.add("-cp");
            command.add(this.serverClasspath.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        }
        this.runningServerClasspath.clear();
        this.runningServerClasspath.addAll(this.serverClasspath);
        if (this.processMemory != 0) {
            command.add("-Xmx" + this.processMemory + "m");
        }
        this.runningProcessMemory = this.processMemory;
        if (this.debugPort != 0) {
            command.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,quiet=y,address=*:" + this.debugPort);
        }
        this.runningDebugPort = this.debugPort;
        command.add("org.teavm.cli.devserver.TeaVMDevServerRunner");
        command.add("--json-interface");
        command.add("--no-watch");
        if (this.targetFileName != null) {
            command.add("--targetfile");
            command.add(this.targetFileName);
        }
        this.runningTargetFileName = this.targetFileName;
        if (this.targetFilePath != null) {
            command.add("--targetdir");
            command.add(this.targetFilePath);
        }
        this.runningTargetFilePath = this.targetFilePath;
        if (!this.classpath.isEmpty()) {
            command.add("--classpath");
            command.addAll(this.classpath.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
        }
        this.runningClasspath.clear();
        this.runningClasspath.addAll(this.classpath);
        if (!this.sources.isEmpty()) {
            command.add("--sourcepath");
            command.addAll(this.sources.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
        }
        this.runningSources.clear();
        this.runningSources.addAll(this.sources);
        if (this.port != 0) {
            command.add("--port");
            command.add(String.valueOf(this.port));
        }
        this.runningPort = this.port;
        if (this.indicator) {
            command.add("--indicator");
        }
        this.runningIndicator = this.indicator;
        if (this.stackDeobfuscated) {
            command.add("--deobfuscate-stack");
        }
        this.runningStackDeobfuscated = this.stackDeobfuscated;
        if (this.autoReload) {
            command.add("--auto-reload");
        }
        this.runningAutoReload = this.autoReload;
        if (this.proxyUrl != null) {
            command.add("--proxy-url");
            command.add(this.proxyUrl);
        }
        this.runningProxyUrl = this.proxyUrl;
        if (this.proxyPath != null) {
            command.add("--proxy-path");
            command.add(this.proxyPath);
        }
        this.runningProxyPath = this.proxyPath;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            command.add("--property");
            command.add(entry.getKey() + "=" + entry.getValue());
        }
        this.runningProperties.clear();
        this.runningProperties.putAll(this.properties);
        if (!this.preservedClasses.isEmpty()) {
            command.add("--preserved-classes");
            command.addAll(this.preservedClasses);
        }
        this.runningPreservedClasses.clear();
        this.runningPreservedClasses.addAll(this.preservedClasses);
        if (this.jsModuleType != null) {
            command.add("--js-module-type");
            command.add(this.jsModuleType.name().toLowerCase().replace('_', '-'));
        }
        this.runningJsModuleType = this.jsModuleType;
        command.add("--");
        command.add(this.mainClass);
        this.runningMainClass = this.mainClass;
        return command;
    }

    private boolean checkProcess() {
        return Objects.equals(this.serverClasspath, this.runningServerClasspath) && Objects.equals(this.classpath, this.runningClasspath) && Objects.equals(this.targetFileName, this.runningTargetFileName) && Objects.equals(this.targetFilePath, this.runningTargetFilePath) && Objects.equals(this.properties, this.runningProperties) && Objects.equals(this.preservedClasses, this.runningPreservedClasses) && Objects.equals((Object)this.jsModuleType, (Object)this.runningJsModuleType) && Objects.equals(this.mainClass, this.runningMainClass) && this.stackDeobfuscated == this.runningStackDeobfuscated && this.indicator == this.runningIndicator && this.port == this.runningPort && Objects.equals(this.sources, this.runningSources) && this.autoReload == this.runningAutoReload && Objects.equals(this.proxyUrl, this.runningProxyUrl) && Objects.equals(this.proxyPath, this.runningProxyPath) && this.processMemory == this.runningProcessMemory && this.debugPort == this.runningDebugPort;
    }
}

