/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.tasks.testing.Test;
import org.teavm.gradle.api.TeaVMTests;
import org.teavm.gradle.api.TeaVMWebTestRunner;

class TeaVMTestConfigurator {
    private TeaVMTestConfigurator() {
    }

    static void configure(Project project, TeaVMTests tests) {
        project.getTasks().withType(Test.class).configureEach(test -> {
            test.getSystemProperties().putIfAbsent("teavm.junit.target", new File(project.getLayout().getProjectDirectory().getAsFile(), "tests/teavm"));
            test.getSystemProperties().putIfAbsent("teavm.junit.threads", "1");
            test.getSystemProperties().putIfAbsent("teavm.junit.js", tests.getJs().getEnabled().get());
            test.getSystemProperties().putIfAbsent("teavm.junit.js.runner", tests.getJs().getRunner().map(TeaVMTestConfigurator::runnerToString).get());
            test.getSystemProperties().putIfAbsent("teavm.junit.js.decodeStack", tests.getJs().getDecodeStack().get());
            test.getSystemProperties().putIfAbsent("teavm.junit.wasm", tests.getWasm().getEnabled().get());
            test.getSystemProperties().putIfAbsent("teavm.junit.wasm.runner", tests.getWasm().getRunner().map(TeaVMTestConfigurator::runnerToString).get());
        });
    }

    private static String runnerToString(TeaVMWebTestRunner runner) {
        switch (runner) {
            case CHROME: {
                return "browser-chrome";
            }
            case FIREFOX: {
                return "browser-firefox";
            }
            case CUSTOM_BROWSER: {
                return "browser";
            }
        }
        return "none";
    }
}

