/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;
import org.teavm.gradle.TeaVMExtensionImpl;
import org.teavm.gradle.TeaVMTestConfigurator;
import org.teavm.gradle.api.TeaVMCConfiguration;
import org.teavm.gradle.api.TeaVMConfiguration;
import org.teavm.gradle.api.TeaVMExtension;
import org.teavm.gradle.api.TeaVMJSConfiguration;
import org.teavm.gradle.api.TeaVMWasiConfiguration;
import org.teavm.gradle.api.TeaVMWasmConfiguration;
import org.teavm.gradle.api.TeaVMWasmGCConfiguration;
import org.teavm.gradle.tasks.CopyWasmGCRuntimeTask;
import org.teavm.gradle.tasks.DisasmWebAssemblyTask;
import org.teavm.gradle.tasks.GenerateCTask;
import org.teavm.gradle.tasks.GenerateJavaScriptTask;
import org.teavm.gradle.tasks.GenerateWasiTask;
import org.teavm.gradle.tasks.GenerateWasmGCTask;
import org.teavm.gradle.tasks.GenerateWasmTask;
import org.teavm.gradle.tasks.JavaScriptDevServerTask;
import org.teavm.gradle.tasks.StopJavaScriptDevServerTask;
import org.teavm.gradle.tasks.TeaVMTask;

public class TeaVMPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "teavm";
    public static final String SOURCE_SET_NAME = "teavm";
    public static final String JS_TASK_NAME = "generateJavaScript";
    public static final String JS_DEV_SERVER_TASK_NAME = "javaScriptDevServer";
    public static final String STOP_JS_DEV_SERVER_TASK_NAME = "stopJavaScriptDevServer";
    public static final String WASM_TASK_NAME = "generateWasm";
    public static final String WASI_TASK_NAME = "generateWasi";
    public static final String WASM_GC_TASK_NAME = "generateWasmGC";
    public static final String BUILD_WASM_GC_TASK_NAME = "buildWasmGC";
    public static final String WASM_GC_COPY_RUNTIME_TASK_NAME = "copyWasmGCRuntime";
    public static final String WASM_GC_DISASSEMBLY_TASK_NAME = "disasmWasmGC";
    public static final String C_TASK_NAME = "generateC";
    public static final String CONFIGURATION_NAME = "teavm";
    public static final String CLASSPATH_CONFIGURATION_NAME = "teavmClasspath";
    public static final String TASK_GROUP = "TeaVM";
    private ObjectFactory objectFactory;

    @Inject
    public TeaVMPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(Project project) {
        this.registerExtension(project);
        this.registerConfiguration(project);
        this.registerSourceSet(project);
        this.registerTasks(project);
        this.addDependencies(project);
        this.setupWarTask(project);
        TeaVMTestConfigurator.configure(project, ((TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class)).getTests());
    }

    private void registerExtension(Project project) {
        TeaVMExtensionImpl extension = new TeaVMExtensionImpl(project, this.objectFactory);
        project.getExtensions().add(TeaVMExtension.class, "teavm", (Object)extension);
    }

    private void registerConfiguration(Project project) {
        Configuration teavm = (Configuration)project.getConfigurations().create("teavm");
        Configuration teavmClasspath = (Configuration)project.getConfigurations().create(CLASSPATH_CONFIGURATION_NAME);
        project.getConfigurations().configureEach(config -> {
            if (config.getName().equals("runtimeClasspath")) {
                teavmClasspath.extendsFrom(new Configuration[]{config});
            }
            if (config.getName().equals("compileOnly")) {
                config.extendsFrom(new Configuration[]{teavm});
            }
        });
        teavmClasspath.extendsFrom(new Configuration[]{teavm});
    }

    private void registerSourceSet(Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        if (sourceSets != null) {
            SourceSet sourceSet = (SourceSet)sourceSets.create("teavm");
            SourceSetOutput main = ((SourceSet)sourceSets.getByName("main")).getOutput();
            sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)main).plus((FileCollection)project.getConfigurations().getByName(CLASSPATH_CONFIGURATION_NAME)));
            sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)main).plus((FileCollection)project.getConfigurations().getByName("compileClasspath")));
            sourceSet.java(java -> {});
            project.getDependencies().add("testImplementation", (Object)sourceSet.getOutput());
        }
    }

    private void registerTasks(Project project) {
        Configuration compilerConfig = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)"org.teavm:teavm-tooling:0.12.0")});
        Configuration cliConfig = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)"org.teavm:teavm-cli:0.12.0")});
        this.registerJsTask(project, compilerConfig);
        this.registerJsDevServerTask(project, cliConfig);
        this.registerStopJsDevServerTask(project);
        this.registerWasmTask(project, compilerConfig);
        this.registerWasiTask(project, compilerConfig);
        this.registerWasmGCTask(project, compilerConfig);
        this.registerCTask(project, compilerConfig);
    }

    private void registerJsTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(JS_TASK_NAME, GenerateJavaScriptTask.class, task -> {
            TeaVMJSConfiguration js = extension.getJs();
            this.applyToTask(js, (TeaVMTask)((Object)task), configuration);
            task.getObfuscated().convention(js.getObfuscated());
            task.getModuleType().convention(js.getModuleType());
            task.getSourceMap().convention(js.getSourceMap());
            task.getTargetFileName().convention(js.getTargetFileName());
            task.getStrict().convention(js.getStrict());
            task.getEntryPointName().convention(js.getEntryPointName());
            task.getSourceFilePolicy().convention(js.getSourceFilePolicy());
            task.getMaxTopLevelNames().convention(js.getMaxTopLevelNames());
            this.setupSources(task.getSourceFiles(), project);
        });
    }

    private void registerJsDevServerTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(JS_DEV_SERVER_TASK_NAME, JavaScriptDevServerTask.class, task -> {
            TeaVMJSConfiguration js = extension.getJs();
            task.setGroup(TASK_GROUP);
            task.getMainClass().convention(js.getMainClass());
            task.getClasspath().from(new Object[]{task.getProject().getConfigurations().getByName(CLASSPATH_CONFIGURATION_NAME)});
            task.getPreservedClasses().addAll(js.getPreservedClasses());
            task.getJsModuleType().convention(js.getModuleType());
            task.getProcessMemory().convention(js.getDevServer().getProcessMemory());
            task.getProperties().putAll(js.getProperties());
            task.getServerClasspath().from(new Object[]{configuration});
            task.getTargetFilePath().convention(js.getRelativePathInOutputDir());
            task.getTargetFileName().convention(js.getTargetFileName());
            task.getStackDeobfuscated().convention(js.getDevServer().getStackDeobfuscated());
            task.getIndicator().convention(js.getDevServer().getIndicator());
            task.getAutoReload().convention(js.getDevServer().getAutoReload());
            task.getPort().convention(js.getDevServer().getPort());
            task.getProxyUrl().convention(js.getDevServer().getProxyUrl());
            task.getProxyPath().convention(js.getDevServer().getProxyPath());
            task.getProcessMemory().convention(js.getDevServer().getProcessMemory());
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
            if (sourceSets != null) {
                task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput()});
                task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("teavm")).getOutput()});
            }
            this.setupSources(task.getSourceFiles(), project);
        });
    }

    private void registerStopJsDevServerTask(Project project) {
        project.getTasks().create(STOP_JS_DEV_SERVER_TASK_NAME, StopJavaScriptDevServerTask.class, task -> task.setGroup(TASK_GROUP));
    }

    private void addSourceDirs(Project project, List<File> result) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        if (sourceSets != null) {
            for (SourceSet sourceSet : sourceSets) {
                result.addAll(sourceSet.getAllJava().getSourceDirectories().getFiles());
            }
        }
    }

    private void registerWasmTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().create(WASM_TASK_NAME, GenerateWasmTask.class, task -> {
            TeaVMWasmConfiguration wasm = extension.getWasm();
            this.applyToTask(wasm, (TeaVMTask)((Object)task), configuration);
            task.getExceptionsUsed().convention(wasm.getExceptionsUsed());
            task.getTargetFileName().convention(wasm.getTargetFileName());
            task.getMinHeapSize().convention(wasm.getMinHeapSize());
            task.getMaxHeapSize().convention(wasm.getMaxHeapSize());
        });
    }

    private void registerWasiTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().register(WASI_TASK_NAME, GenerateWasiTask.class, task -> {
            TeaVMWasiConfiguration wasi = extension.getWasi();
            this.applyToTask(wasi, (TeaVMTask)((Object)task), configuration);
            task.getExceptionsUsed().convention(wasi.getExceptionsUsed());
            task.getTargetFileName().convention(wasi.getTargetFileName());
            task.getMinHeapSize().convention(wasi.getMinHeapSize());
            task.getMaxHeapSize().convention(wasi.getMaxHeapSize());
        });
    }

    private void registerWasmGCTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        GenerateWasmGCTask genTask = (GenerateWasmGCTask)((Object)project.getTasks().register(WASM_GC_TASK_NAME, GenerateWasmGCTask.class, task -> {
            TeaVMWasmGCConfiguration wasmGC = extension.getWasmGC();
            this.applyToTask(wasmGC, (TeaVMTask)((Object)task), configuration);
            task.getTargetFileName().convention(wasmGC.getTargetFileName());
            task.getObfuscated().convention(wasmGC.getObfuscated());
            task.getStrict().convention(wasmGC.getStrict());
            task.getSourceMap().convention(wasmGC.getSourceMap());
            task.getSourceFilePolicy().convention(wasmGC.getSourceFilePolicy());
            task.getMinDirectBuffersSize().convention(wasmGC.getMinDirectBuffersSize());
            task.getMaxDirectBuffersSize().convention(wasmGC.getMaxDirectBuffersSize());
            this.setupSources(task.getSourceFiles(), project);
        }).get());
        TaskProvider copyRuntimeTask = project.getTasks().register(WASM_GC_COPY_RUNTIME_TASK_NAME, CopyWasmGCRuntimeTask.class, task -> {
            task.setGroup(TASK_GROUP);
            task.onlyIf(t -> (Boolean)extension.getWasmGC().getCopyRuntime().getOrElse((Object)false));
            Provider fileName = extension.getWasmGC().getTargetFileName().map(x -> x + "-runtime.js");
            task.getOutputFile().convention(extension.getWasmGC().getOutputDir().flatMap(d -> d.dir(extension.getWasmGC().getRelativePathInOutputDir())).flatMap(d -> d.file(fileName)));
            task.getDeobfuscator().convention(extension.getWasmGC().getDebugInformation());
            Provider deobfuscatorFileName = extension.getWasmGC().getTargetFileName().map(x -> x + "-deobfuscator.wasm");
            task.getDeobfuscatorOutputFile().convention(extension.getWasmGC().getOutputDir().flatMap(d -> d.dir(extension.getWasmGC().getRelativePathInOutputDir())).flatMap(d -> d.file(deobfuscatorFileName)));
            task.getModular().convention(extension.getWasmGC().getModularRuntime());
            task.getObfuscated().convention(extension.getWasmGC().getObfuscated());
        });
        TaskProvider disasmTask = project.getTasks().register(WASM_GC_DISASSEMBLY_TASK_NAME, DisasmWebAssemblyTask.class, task -> {
            task.setGroup(TASK_GROUP);
            task.dependsOn(new Object[]{genTask});
            task.onlyIf(t -> (Boolean)extension.getWasmGC().getDisassembly().getOrElse((Object)false));
            task.getHtml().set((Object)true);
            task.getInputFile().convention(project.getLayout().dir(genTask.getOutputDir()).flatMap(x -> x.file(genTask.getTargetFileName())));
            Provider fileName = extension.getWasmGC().getTargetFileName().map(x -> {
                if (x.endsWith(".wasm")) {
                    x = x.substring(0, x.length() - 5);
                }
                return x + ".wast.html";
            });
            task.getOutputFile().convention(project.getLayout().dir(genTask.getOutputDir()).flatMap(d -> d.file(fileName)));
        });
        project.getTasks().register(BUILD_WASM_GC_TASK_NAME, task -> {
            task.setGroup(TASK_GROUP);
            task.dependsOn(new Object[]{genTask, copyRuntimeTask, disasmTask});
        });
    }

    private void registerCTask(Project project, Configuration configuration) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().register(C_TASK_NAME, GenerateCTask.class, task -> {
            TeaVMCConfiguration c = extension.getC();
            this.applyToTask(c, (TeaVMTask)((Object)task), configuration);
            task.getMinHeapSize().convention(c.getMinHeapSize());
            task.getMaxHeapSize().convention(c.getMaxHeapSize());
            task.getHeapDump().convention(c.getHeapDump());
            task.getShortFileNames().convention(c.getShortFileNames());
            task.getObfuscated().convention(c.getObfuscated());
        });
    }

    private void addDependencies(Project project) {
        project.getDependencies().add("teavm", (Object)"org.teavm:teavm-classlib:0.12.0");
        project.getDependencies().add("testImplementation", (Object)"org.teavm:teavm-junit:0.12.0");
        project.getDependencies().add("testRuntimeOnly", (Object)"org.teavm:teavm-classlib:0.12.0");
    }

    private void setupWarTask(Project project) {
        TeaVMExtension extension = (TeaVMExtension)project.getExtensions().getByType(TeaVMExtension.class);
        project.getTasks().withType(War.class).configureEach(task -> {
            if (task.getName().equals("war")) {
                Property<String> relPath;
                DirectoryProperty outDir;
                Boolean jsAddedToWebApp = (Boolean)extension.getJs().getAddedToWebApp().get();
                Boolean wasmAddedToWebApp = (Boolean)extension.getWasm().getAddedToWebApp().get();
                Boolean wasmGCAddedToWebApp = (Boolean)extension.getWasmGC().getAddedToWebApp().get();
                if (jsAddedToWebApp.booleanValue()) {
                    task.dependsOn(new Object[]{project.getTasks().named(JS_TASK_NAME)});
                    outDir = extension.getJs().getOutputDir();
                    relPath = extension.getJs().getRelativePathInOutputDir();
                    task.with(new CopySpec[]{project.copySpec(spec -> {
                        spec.into((Object)relPath);
                        spec.from(new Object[]{project.files(new Object[]{outDir.map(dir -> new File(dir.getAsFile(), (String)relPath.get()))})});
                        spec.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
                    })});
                }
                if (wasmAddedToWebApp.booleanValue()) {
                    task.dependsOn(new Object[]{project.getTasks().named(WASM_TASK_NAME)});
                    outDir = extension.getWasm().getOutputDir();
                    relPath = extension.getWasm().getRelativePathInOutputDir();
                    task.with(new CopySpec[]{project.copySpec(spec -> {
                        spec.into((Object)relPath);
                        spec.from(new Object[]{project.files(new Object[]{outDir.map(dir -> new File(dir.getAsFile(), (String)relPath.get()))})});
                    })});
                }
                if (wasmGCAddedToWebApp.booleanValue()) {
                    task.dependsOn(new Object[]{project.getTasks().named(BUILD_WASM_GC_TASK_NAME)});
                    outDir = extension.getWasmGC().getOutputDir();
                    relPath = extension.getWasmGC().getRelativePathInOutputDir();
                    task.with(new CopySpec[]{project.copySpec(spec -> {
                        spec.into((Object)relPath);
                        spec.from(new Object[]{project.files(new Object[]{outDir.map(dir -> new File(dir.getAsFile(), (String)relPath.get()))})});
                    })});
                }
            }
        });
    }

    private void applyToTask(TeaVMConfiguration configuration, TeaVMTask task, Configuration toolsConfiguration) {
        task.getMainClass().convention(configuration.getMainClass());
        task.getClasspath().from(new Object[]{task.getProject().getConfigurations().getByName(CLASSPATH_CONFIGURATION_NAME)});
        task.getPreservedClasses().addAll(configuration.getPreservedClasses());
        task.getDebugInformation().convention(configuration.getDebugInformation());
        task.getFastGlobalAnalysis().convention(configuration.getFastGlobalAnalysis());
        task.getOptimization().convention(configuration.getOptimization());
        task.getOutOfProcess().convention(configuration.getOutOfProcess());
        task.getProcessMemory().convention(configuration.getProcessMemory());
        task.getProperties().putAll(configuration.getProperties());
        task.getDaemonClasspath().from(new Object[]{toolsConfiguration});
        task.getOutputDir().convention(configuration.getOutputDir().map(d -> new File(d.getAsFile(), (String)configuration.getRelativePathInOutputDir().get())));
        Project project = task.getProject();
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        if (sourceSets != null) {
            task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput()});
            task.getClasspath().from(new Object[]{((SourceSet)sourceSets.getByName("teavm")).getOutput()});
        }
        task.setGroup(TASK_GROUP);
    }

    private void setupSources(ConfigurableFileCollection sources, Project project) {
        sources.from(new Object[]{project.provider(() -> {
            ArrayList<File> result = new ArrayList<File>();
            this.addSourceDirs(project, result);
            return result;
        })});
        sources.from(new Object[]{project.provider(() -> {
            Set dependencies = project.getConfigurations().getByName("compileClasspath").getIncoming().getResolutionResult().getAllDependencies();
            ArrayList<File> result = new ArrayList<File>();
            for (DependencyResult dependencyResult : dependencies) {
                if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
                ComponentIdentifier id = ((ResolvedDependencyResult)dependencyResult).getSelected().getId();
                if (id instanceof ProjectComponentIdentifier) {
                    String path = ((ProjectComponentIdentifier)id).getProjectPath();
                    Project refProject = project.getRootProject().findProject(path);
                    if (refProject == null) continue;
                    this.addSourceDirs(refProject, result);
                    continue;
                }
                if (!(id instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)id;
                Dependency sourcesDep = project.getDependencies().create(Map.of("group", moduleId.getGroup(), "name", moduleId.getModuleIdentifier().getName(), "version", moduleId.getVersion(), "classifier", "sources"));
                Configuration tmpConfig = project.getConfigurations().detachedConfiguration(new Dependency[]{sourcesDep});
                tmpConfig.setTransitive(false);
                if (tmpConfig.getResolvedConfiguration().hasError()) continue;
                result.addAll(tmpConfig.getResolvedConfiguration().getLenientConfiguration().getArtifacts().stream().map(ResolvedArtifact::getFile).collect(Collectors.toList()));
            }
            return result;
        })});
    }
}

