/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.devserver;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.teavm.backend.javascript.JSModuleType;
import org.teavm.devserver.CodeServlet;
import org.teavm.devserver.DevServerListener;
import org.teavm.tooling.TeaVMToolLog;

public class DevServer {
    private String mainClass;
    private String[] classPath;
    private String pathToFile = "/";
    private String fileName = "classes.js";
    private List<String> sourcePath = new ArrayList<String>();
    private boolean indicator;
    private boolean deobfuscateStack;
    private boolean reloadedAutomatically;
    private boolean fileSystemWatched = true;
    private TeaVMToolLog log;
    private CodeServlet servlet;
    private List<DevServerListener> listeners = new ArrayList<DevServerListener>();
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private List<String> preservedClasses = new ArrayList<String>();
    private JSModuleType jsModuleType;
    private boolean compileOnStartup;
    private boolean logBuildErrors = true;
    private Server server;
    private int port = 9090;
    private int debugPort;
    private String proxyUrl;
    private String proxyPath = "/";

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setClassPath(String[] classPath) {
        this.classPath = classPath;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public void setPathToFile(String pathToFile) {
        if (!((String)pathToFile).startsWith("/")) {
            pathToFile = "/" + (String)pathToFile;
        }
        if (!((String)pathToFile).endsWith("/")) {
            pathToFile = (String)pathToFile + "/";
        }
        this.pathToFile = pathToFile;
    }

    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setIndicator(boolean indicator) {
        this.indicator = indicator;
    }

    public void setDeobfuscateStack(boolean deobfuscateStack) {
        this.deobfuscateStack = deobfuscateStack;
    }

    public void setReloadedAutomatically(boolean reloadedAutomatically) {
        this.reloadedAutomatically = reloadedAutomatically;
    }

    public void setFileSystemWatched(boolean fileSystemWatched) {
        this.fileSystemWatched = fileSystemWatched;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public void setProxyPath(String proxyPath) {
        this.proxyPath = proxyPath;
    }

    public List<String> getSourcePath() {
        return this.sourcePath;
    }

    public void setCompileOnStartup(boolean compileOnStartup) {
        this.compileOnStartup = compileOnStartup;
    }

    public List<String> getPreservedClasses() {
        return this.preservedClasses;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setJsModuleType(JSModuleType jsModuleType) {
        this.jsModuleType = jsModuleType;
    }

    public void invalidateCache() {
        this.servlet.invalidateCache();
    }

    public void buildProject() {
        this.servlet.buildProject();
    }

    public void cancelBuild() {
        this.servlet.cancelBuild();
    }

    public void addListener(DevServerListener listener) {
        this.listeners.add(listener);
    }

    public void setLogBuildErrors(boolean logBuildErrors) {
        this.logBuildErrors = logBuildErrors;
    }

    public void start() {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.port);
        connector.setIdleTimeout(0L);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        this.servlet = new CodeServlet(this.mainClass, this.classPath);
        this.servlet.setFileName(this.fileName);
        this.servlet.setPathToFile(this.pathToFile);
        this.servlet.setLog(this.log);
        this.servlet.getSourcePath().addAll(this.sourcePath);
        this.servlet.setIndicator(this.indicator);
        this.servlet.setDeobfuscateStack(this.deobfuscateStack);
        this.servlet.setAutomaticallyReloaded(this.reloadedAutomatically);
        this.servlet.setPort(this.port);
        this.servlet.setDebugPort(this.debugPort);
        this.servlet.setProxyUrl(this.proxyUrl);
        this.servlet.setProxyPath(this.proxyPath);
        this.servlet.setFileSystemWatched(this.fileSystemWatched);
        this.servlet.setCompileOnStartup(this.compileOnStartup);
        this.servlet.setLogBuildErrors(this.logBuildErrors);
        this.servlet.getProperties().putAll(this.properties);
        this.servlet.getPreservedClasses().addAll(this.preservedClasses);
        this.servlet.setJsModuleType(this.jsModuleType);
        for (DevServerListener listener : this.listeners) {
            this.servlet.addListener(listener);
        }
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servlet);
        servletHolder.setAsyncSupported(true);
        context.addServlet(servletHolder, "/*");
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void awaitServer() throws InterruptedException {
        this.server.join();
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.server = null;
        this.servlet = null;
    }
}

