/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.devserver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.teavm.devserver.CodeServlet;
import org.teavm.devserver.ProgressHandler;

@WebSocket
public class CodeWsEndpoint {
    private Map<Session, ProgressHandlerImpl> progressHandlerMap = new HashMap<Session, ProgressHandlerImpl>();
    private CodeServlet servlet;

    public CodeWsEndpoint(CodeServlet servlet) {
        this.servlet = servlet;
    }

    @OnWebSocketConnect
    public void open(Session session) {
        ProgressHandlerImpl progressHandler = new ProgressHandlerImpl(session);
        this.progressHandlerMap.put(session, progressHandler);
        this.servlet.addProgressHandler(progressHandler);
    }

    @OnWebSocketClose
    public void close(Session session, int code, String reason) {
        ProgressHandlerImpl handler = this.progressHandlerMap.remove(session);
        this.servlet.removeProgressHandler(handler);
    }

    static class ProgressHandlerImpl
    implements ProgressHandler {
        Session session;

        ProgressHandlerImpl(Session session) {
            this.session = session;
        }

        @Override
        public void progress(double value) {
            this.session.getRemote().sendStringByFuture("{ \"command\": \"compiling\", \"progress\": " + value + " }");
        }

        @Override
        public void complete(boolean success) {
            this.session.getRemote().sendStringByFuture("{ \"command\": \"complete\", \"success\": " + success + " }");
        }
    }
}

