/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T, K extends Comparable<K>> int binarySearch(List<? extends T> list, K key, Function<T, K> keyExtractor) {
        return CollectionUtil.binarySearch(list, key, keyExtractor, Comparable::compareTo);
    }

    public static <T, K> int binarySearch(List<? extends T> list, K key, Function<T, K> keyExtractor, Comparator<K> comparator) {
        int i;
        int l = 0;
        int u = list.size() - 1;
        while (true) {
            K t;
            int cmp;
            if ((cmp = comparator.compare(key, t = keyExtractor.apply(list.get(i = (l + u) / 2)))) == 0) {
                return i;
            }
            if (cmp > 0) {
                l = i + 1;
                if (l <= u) continue;
                return -i - 2;
            }
            u = i - 1;
            if (u < l) break;
        }
        return -i - 1;
    }
}

