/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.debug.DebugLines;
import org.teavm.backend.wasm.debug.DebugVariables;
import org.teavm.backend.wasm.generate.DwarfClassGenerator;
import org.teavm.backend.wasm.generate.DwarfGenerator;
import org.teavm.backend.wasm.model.WasmCustomSection;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.render.WasmBinaryRenderingVisitor;
import org.teavm.backend.wasm.render.WasmBinaryStatsCollector;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.backend.wasm.render.WasmBinaryWriter;
import org.teavm.backend.wasm.render.WasmSignature;
import org.teavm.backend.wasm.render.WasmSignatureCollector;

public class WasmBinaryRenderer {
    private static final int SECTION_UNKNOWN = 0;
    private static final int SECTION_TYPE = 1;
    private static final int SECTION_IMPORT = 2;
    private static final int SECTION_FUNCTION = 3;
    private static final int SECTION_TABLE = 4;
    private static final int SECTION_MEMORY = 5;
    private static final int SECTION_EXPORT = 7;
    private static final int SECTION_START = 8;
    private static final int SECTION_ELEMENT = 9;
    private static final int SECTION_CODE = 10;
    private static final int SECTION_DATA = 11;
    private static final int EXTERNAL_KIND_FUNCTION = 0;
    private static final int EXTERNAL_KIND_MEMORY = 2;
    private WasmBinaryWriter output;
    private WasmBinaryVersion version;
    private List<WasmSignature> signatures = new ArrayList<WasmSignature>();
    private Map<WasmSignature, Integer> signatureIndexes = new HashMap<WasmSignature, Integer>();
    private Map<String, Integer> functionIndexes = new HashMap<String, Integer>();
    private boolean obfuscated;
    private DwarfGenerator dwarfGenerator;
    private DwarfClassGenerator dwarfClassGen;
    private DebugLines debugLines;
    private DebugVariables debugVariables;
    private WasmBinaryStatsCollector statsCollector;

    public WasmBinaryRenderer(WasmBinaryWriter output, WasmBinaryVersion version, boolean obfuscated, DwarfGenerator dwarfGenerator, DwarfClassGenerator dwarfClassGen, DebugLines debugLines, DebugVariables debugVariables, WasmBinaryStatsCollector statsCollector) {
        this.output = output;
        this.version = version;
        this.obfuscated = obfuscated;
        this.dwarfGenerator = dwarfGenerator;
        this.dwarfClassGen = dwarfClassGen;
        this.debugLines = debugLines;
        this.debugVariables = debugVariables;
        this.statsCollector = statsCollector;
    }

    public void render(WasmModule module) {
        this.render(module, Collections::emptyList);
    }

    public void render(WasmModule module, Supplier<Collection<? extends WasmCustomSection>> customSectionSupplier) {
        this.output.writeInt32(1836278016);
        switch (this.version) {
            case V_0x1: {
                this.output.writeInt32(1);
            }
        }
        this.renderSignatures(module);
        this.renderImports(module);
        this.renderFunctions(module);
        this.renderTable(module);
        this.renderMemory(module);
        this.renderExport(module);
        this.renderStart(module);
        this.renderElement(module);
        this.renderCode(module);
        this.renderData(module);
        if (!this.obfuscated) {
            this.renderNames(module);
        }
        this.renderCustomSections(module, customSectionSupplier);
    }

    private void renderSignatures(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        WasmSignatureCollector signatureCollector = new WasmSignatureCollector(this::registerSignature);
        for (WasmFunction function : module.getFunctions().values()) {
            this.registerSignature(WasmSignature.fromFunction(function));
            for (WasmExpression part : function.getBody()) {
                part.acceptVisitor(signatureCollector);
            }
        }
        section.writeLEB(this.signatures.size());
        for (WasmSignature signature : this.signatures) {
            section.writeByte(96);
            section.writeLEB(signature.types.length - 1);
            for (int i = 1; i < signature.types.length; ++i) {
                section.writeType(signature.types[i], this.version);
            }
            if (signature.types[0] != null) {
                section.writeByte(1);
                section.writeType(signature.types[0], this.version);
                continue;
            }
            section.writeByte(0);
        }
        this.writeSection(1, "type", section.getData());
    }

    private void renderImports(WasmModule module) {
        ArrayList<WasmFunction> functions = new ArrayList<WasmFunction>();
        for (WasmFunction function : module.getFunctions().values()) {
            if (function.getImportName() == null) continue;
            this.functionIndexes.put(function.getName(), functions.size());
            functions.add(function);
        }
        if (functions.isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(functions.size());
        for (WasmFunction function : functions) {
            WasmSignature signature = WasmSignature.fromFunction(function);
            int signatureIndex = this.signatureIndexes.get(signature);
            String moduleName = function.getImportModule();
            if (moduleName == null) {
                moduleName = "";
            }
            section.writeAsciiString(moduleName);
            section.writeAsciiString(function.getImportName());
            section.writeByte(0);
            section.writeLEB(signatureIndex);
        }
        this.writeSection(2, "import", section.getData());
    }

    private void renderFunctions(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.getFunctions().values().stream().filter(function -> function.getImportName() == null).collect(Collectors.toList());
        for (WasmFunction function2 : functions) {
            this.functionIndexes.put(function2.getName(), this.functionIndexes.size());
        }
        section.writeLEB(functions.size());
        for (WasmFunction function2 : functions) {
            WasmSignature signature = WasmSignature.fromFunction(function2);
            section.writeLEB(this.signatureIndexes.get(signature));
        }
        this.writeSection(3, "function", section.getData());
    }

    private void renderTable(WasmModule module) {
        if (module.getFunctionTable().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeByte(1);
        section.writeByte(112);
        section.writeByte(0);
        section.writeLEB(this.functionIndexes.size());
        this.writeSection(4, "table", section.getData());
    }

    private void renderMemory(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeByte(1);
        section.writeByte(1);
        section.writeLEB(module.getMinMemorySize());
        section.writeLEB(module.getMaxMemorySize());
        this.writeSection(5, "memory", section.getData());
    }

    private void renderExport(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.getFunctions().values().stream().filter(function -> function.getExportName() != null).collect(Collectors.toList());
        section.writeLEB(functions.size() + 1);
        for (WasmFunction function2 : functions) {
            int functionIndex = this.functionIndexes.get(function2.getName());
            section.writeAsciiString(function2.getExportName());
            section.writeByte(0);
            section.writeLEB(functionIndex);
        }
        section.writeAsciiString("memory");
        section.writeByte(2);
        section.writeLEB(0);
        this.writeSection(7, "export", section.getData());
    }

    private void renderStart(WasmModule module) {
        if (module.getStartFunction() == null) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(this.functionIndexes.get(module.getStartFunction().getName()));
        this.writeSection(8, "start", section.getData());
    }

    private void renderElement(WasmModule module) {
        if (module.getFunctionTable().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(1);
        section.writeLEB(0);
        this.renderInitializer(section, 0);
        section.writeLEB(module.getFunctionTable().size());
        for (WasmFunction function : module.getFunctionTable()) {
            section.writeLEB(this.functionIndexes.get(function.getName()));
        }
        this.writeSection(9, "element", section.getData());
    }

    private void renderCode(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        List functions = module.getFunctions().values().stream().filter(function -> function.getImportName() == null).collect(Collectors.toList());
        section.writeLEB(functions.size());
        for (WasmFunction function2 : functions) {
            byte[] body = this.renderFunction(function2, section.getPosition() + 4);
            int startPos = section.getPosition();
            section.writeLEB4(body.length);
            section.writeBytes(body);
            int size = section.getPosition() - startPos;
            if (function2.getJavaMethod() == null) continue;
            this.statsCollector.addClassCodeSize(function2.getJavaMethod().getClassName(), size);
        }
        if (this.dwarfGenerator != null) {
            this.dwarfGenerator.setCodeSize(section.getPosition());
        }
        this.writeSection(10, "code", section.getData());
    }

    private byte[] renderFunction(WasmFunction function, int offset) {
        DwarfClassGenerator.Subprogram dwarfSubprogram;
        WasmBinaryWriter code = new WasmBinaryWriter();
        DwarfClassGenerator.Subprogram subprogram = dwarfSubprogram = this.dwarfClassGen != null ? this.dwarfClassGen.getSubprogram(function.getName()) : null;
        if (dwarfSubprogram != null) {
            dwarfSubprogram.startOffset = offset - 4;
            dwarfSubprogram.function = function;
        }
        if (this.debugLines != null && function.getJavaMethod() != null) {
            this.debugLines.start(function.getJavaMethod());
        }
        List<WasmLocal> localVariables = function.getLocalVariables();
        int parameterCount = Math.min(function.getParameters().size(), localVariables.size());
        if ((localVariables = localVariables.subList(parameterCount, localVariables.size())).isEmpty()) {
            code.writeLEB(0);
        } else {
            ArrayList<LocalEntry> localEntries = new ArrayList<LocalEntry>();
            LocalEntry currentEntry = new LocalEntry(localVariables.get(0).getType());
            for (int i = 1; i < localVariables.size(); ++i) {
                WasmType type = localVariables.get(i).getType();
                if (currentEntry.type == type) {
                    ++currentEntry.count;
                    continue;
                }
                localEntries.add(currentEntry);
                currentEntry = new LocalEntry(type);
            }
            localEntries.add(currentEntry);
            code.writeLEB(localEntries.size());
            for (LocalEntry entry : localEntries) {
                code.writeLEB(entry.count);
                code.writeType(entry.type, this.version);
            }
        }
        Map<String, Integer> importIndexes = this.functionIndexes;
        WasmBinaryRenderingVisitor visitor = new WasmBinaryRenderingVisitor(code, this.version, this.functionIndexes, importIndexes, this.signatureIndexes, this.dwarfGenerator, function.getJavaMethod() != null ? this.debugLines : null, offset);
        for (WasmExpression part : function.getBody()) {
            part.acceptVisitor(visitor);
        }
        visitor.endLocation();
        code.writeByte(11);
        if (dwarfSubprogram != null) {
            dwarfSubprogram.endOffset = code.getPosition() + offset;
        }
        if (this.debugVariables != null) {
            this.writeDebugVariables(function, offset, code.getPosition());
        }
        return code.getData();
    }

    private void writeDebugVariables(WasmFunction function, int offset, int size) {
        this.debugVariables.startSequence(offset);
        for (WasmLocal local : function.getLocalVariables()) {
            if (local.getName() == null || local.getJavaType() == null) continue;
            this.debugVariables.type(local.getName(), local.getJavaType());
            this.debugVariables.range(local.getName(), offset, offset + size, local.getIndex());
        }
        this.debugVariables.endSequence();
    }

    private void renderInitializer(WasmBinaryWriter output, int value) {
        output.writeByte(65);
        output.writeLEB(value);
        output.writeByte(11);
    }

    private void renderData(WasmModule module) {
        if (module.getSegments().isEmpty()) {
            return;
        }
        WasmBinaryWriter section = new WasmBinaryWriter();
        section.writeLEB(module.getSegments().size());
        for (WasmMemorySegment segment : module.getSegments()) {
            section.writeByte(0);
            this.renderInitializer(section, segment.getOffset());
            section.writeLEB(segment.getLength());
            int chunkSize = 65536;
            for (int i = 0; i < segment.getLength(); i += chunkSize) {
                int next = Math.min(i + chunkSize, segment.getLength());
                section.writeBytes(segment.getData(i, next - i));
            }
        }
        this.writeSection(11, "data", section.getData());
    }

    private void renderNames(WasmModule module) {
        WasmBinaryWriter section = new WasmBinaryWriter();
        WasmBinaryWriter functionsSubsection = new WasmBinaryWriter();
        Collection functions = module.getFunctions().values();
        functions = functions.stream().filter(f -> f.getImportName() == null).collect(Collectors.toList());
        functionsSubsection.writeLEB(functions.size());
        for (WasmFunction function : functions) {
            functionsSubsection.writeLEB(this.functionIndexes.get(function.getName()));
            functionsSubsection.writeAsciiString(function.getName());
        }
        byte[] payload = functionsSubsection.getData();
        section.writeLEB(1);
        section.writeLEB(payload.length);
        section.writeBytes(payload);
        this.writeSection(0, "name", section.getData());
    }

    private void renderCustomSections(WasmModule module, Supplier<Collection<? extends WasmCustomSection>> sectionSupplier) {
        for (WasmCustomSection wasmCustomSection : module.getCustomSections().values()) {
            this.renderCustomSection(wasmCustomSection);
        }
        if (sectionSupplier != null) {
            for (WasmCustomSection wasmCustomSection : sectionSupplier.get()) {
                this.renderCustomSection(wasmCustomSection);
            }
        }
    }

    private void renderCustomSection(WasmCustomSection customSection) {
        this.writeSection(0, customSection.getName(), customSection.getData());
    }

    private void registerSignature(WasmSignature signature) {
        this.signatureIndexes.computeIfAbsent(signature, key -> {
            int result = this.signatures.size();
            this.signatures.add((WasmSignature)key);
            return result;
        });
    }

    private void writeSection(int id, String name, byte[] data) {
        int start = this.output.getPosition();
        this.output.writeByte(id);
        int length = data.length;
        if (id == 0) {
            length += name.length() + 1;
        }
        this.output.writeLEB(length);
        if (id == 0) {
            this.output.writeAsciiString(name);
        }
        this.output.writeBytes(data);
        this.statsCollector.addSectionSize(name, this.output.getPosition() - start);
    }

    static class LocalEntry {
        WasmType type;
        int count = 1;

        LocalEntry(WasmType type) {
            this.type = type;
        }
    }
}

