/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.model.TextLocation;

public abstract class WasmExpression {
    private TextLocation location;

    WasmExpression() {
    }

    public TextLocation getLocation() {
        return this.location;
    }

    public void setLocation(TextLocation location) {
        this.location = location;
    }

    public abstract void acceptVisitor(WasmExpressionVisitor var1);

    public boolean isTerminating() {
        return false;
    }

    public static WasmExpression defaultValueOfType(WasmType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case INT32: {
                return new WasmInt32Constant(0);
            }
            case INT64: {
                return new WasmInt64Constant(0L);
            }
            case FLOAT32: {
                return new WasmFloat32Constant(0.0f);
            }
            case FLOAT64: {
                return new WasmFloat64Constant(0.0);
            }
        }
        throw new IllegalArgumentException();
    }
}

