/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.info;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import org.teavm.backend.wasm.debug.info.ArrayLayout;
import org.teavm.backend.wasm.debug.info.ClassLayout;
import org.teavm.backend.wasm.debug.info.FieldInfo;
import org.teavm.backend.wasm.debug.info.InterfaceLayout;
import org.teavm.backend.wasm.debug.info.PrimitiveLayout;
import org.teavm.backend.wasm.debug.info.TypeLayout;
import org.teavm.hppc.IntObjectHashMap;
import org.teavm.hppc.IntObjectMap;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;

public abstract class ClassLayoutInfo {
    private IntObjectMap<TypeLayout> layoutByAddress;

    public abstract List<? extends TypeLayout> types();

    public TypeLayout find(int address) {
        if (this.layoutByAddress == null) {
            this.layoutByAddress = new IntObjectHashMap();
            for (TypeLayout typeLayout : this.types()) {
                this.layoutByAddress.put(typeLayout.address(), (Object)typeLayout);
            }
        }
        return (TypeLayout)this.layoutByAddress.get(address);
    }

    public void dump(PrintStream out) {
        int i;
        ObjectIntHashMap indexes = new ObjectIntHashMap();
        for (i = 0; i < this.types().size(); ++i) {
            indexes.put((Object)this.types().get(i), i);
        }
        block7: for (i = 0; i < this.types().size(); ++i) {
            out.print("#" + i + ": ");
            TypeLayout type = this.types().get(i);
            out.println(type.kind().name().toLowerCase());
            out.println("  address: " + Integer.toHexString(type.address()));
            switch (type.kind()) {
                case CLASS: {
                    ClassLayoutInfo.dumpClass(out, (ObjectIntMap<TypeLayout>)indexes, (ClassLayout)type);
                    continue block7;
                }
                case INTERFACE: {
                    ClassLayoutInfo.dumpInterface(out, (InterfaceLayout)type);
                    continue block7;
                }
                case ARRAY: {
                    ClassLayoutInfo.dumpArray(out, (ObjectIntMap<TypeLayout>)indexes, (ArrayLayout)type);
                    continue block7;
                }
                case PRIMITIVE: {
                    ClassLayoutInfo.dumpPrimitive(out, (PrimitiveLayout)type);
                    continue block7;
                }
            }
        }
    }

    private static void dumpClass(PrintStream out, ObjectIntMap<TypeLayout> indexes, ClassLayout cls) {
        out.println("  name: " + cls.classRef().fullName());
        out.println("  size: " + cls.size());
        if (cls.superclass() != null) {
            out.println("  superclass: #" + indexes.get((Object)cls.superclass()));
        }
        if (!cls.staticFields().isEmpty()) {
            out.println("  static fields:");
            ClassLayoutInfo.dumpFields(out, cls.staticFields());
        }
        if (!cls.instanceFields().isEmpty()) {
            out.println("  instance fields:");
            ClassLayoutInfo.dumpFields(out, cls.instanceFields());
        }
    }

    private static void dumpFields(PrintStream out, Collection<? extends FieldInfo> fields) {
        for (FieldInfo fieldInfo : fields) {
            out.println("    " + fieldInfo.name() + ": ");
            out.println("      offset: " + Integer.toHexString(fieldInfo.address()));
            out.println("      type: " + fieldInfo.type().name().toLowerCase());
        }
    }

    private static void dumpInterface(PrintStream out, InterfaceLayout cls) {
        out.println("  name: " + cls.classRef().fullName());
    }

    private static void dumpArray(PrintStream out, ObjectIntMap<TypeLayout> indexes, ArrayLayout array) {
        out.println("  element: #" + indexes.get((Object)array.elementType()));
    }

    private static void dumpPrimitive(PrintStream out, PrimitiveLayout primitive) {
        out.println("  primitive type: " + primitive.primitiveType().name().toLowerCase());
    }
}

