/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import org.teavm.backend.wasm.WasmHeap;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.interop.Address;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.RuntimeObject;

@StaticInit
public final class WasmRuntime {
    private WasmRuntime() {
    }

    @Unmanaged
    public static int compare(int a, int b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    @Unmanaged
    public static int compareUnsigned(int a, int b) {
        return WasmRuntime.gtu(a, b) ? 1 : (WasmRuntime.ltu(a, b) ? -1 : 0);
    }

    @Unmanaged
    public static int compareUnsigned(long a, long b) {
        return WasmRuntime.gtu(a, b) ? 1 : (WasmRuntime.ltu(a, b) ? -1 : 0);
    }

    @Unmanaged
    public static int compare(long a, long b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    @Unmanaged
    public static int compare(float a, float b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    @Unmanaged
    public static int compare(double a, double b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    @Unmanaged
    public static native float min(float var0, float var1);

    @Unmanaged
    public static native double min(double var0, double var2);

    @Unmanaged
    public static native float max(float var0, float var1);

    @Unmanaged
    public static native double max(double var0, double var2);

    @Unmanaged
    public static float remainder(float a, float b) {
        return a - (float)((int)(a / b)) * b;
    }

    @Unmanaged
    public static double remainder(double a, double b) {
        return a - (double)((long)(a / b)) * b;
    }

    @Unmanaged
    private static native boolean lt(int var0, int var1);

    @Unmanaged
    private static native boolean gt(int var0, int var1);

    @Unmanaged
    private static native boolean ltu(int var0, int var1);

    @Unmanaged
    private static native boolean gtu(int var0, int var1);

    @Unmanaged
    private static native boolean lt(long var0, long var2);

    @Unmanaged
    private static native boolean gt(long var0, long var2);

    @Unmanaged
    private static native boolean ltu(long var0, long var2);

    @Unmanaged
    private static native boolean gtu(long var0, long var2);

    @Unmanaged
    private static native boolean lt(float var0, float var1);

    @Unmanaged
    private static native boolean gt(float var0, float var1);

    @Unmanaged
    private static native boolean lt(double var0, double var2);

    @Unmanaged
    private static native boolean gt(double var0, double var2);

    @Unmanaged
    public static Address align(Address address, int alignment) {
        int value = address.toInt();
        if (value == 0) {
            return address;
        }
        value = ((value - 1) / alignment + 1) * alignment;
        return Address.fromInt((int)value);
    }

    @Unmanaged
    public static int align(int value, int alignment) {
        if (value == 0) {
            return value;
        }
        value = ((value - 1) / alignment + 1) * alignment;
        return value;
    }

    @Unmanaged
    public static void print(int a) {
        WasmSupport.print(a);
    }

    @Unmanaged
    public static void printString(String s) {
        WasmSupport.printString(s);
    }

    @Unmanaged
    public static void printInt(int i) {
        WasmSupport.printInt(i);
    }

    @Unmanaged
    public static void printOutOfMemory() {
        WasmSupport.printOutOfMemory();
    }

    @Unmanaged
    public static void fillZero(Address address, int count) {
        WasmRuntime.fill(address, (byte)0, count);
    }

    @Unmanaged
    public static void fill(Address address, byte value, int count) {
    }

    @Unmanaged
    public static Address allocStack(int size) {
        Address stack = WasmHeap.stack;
        Address result = stack.add(4);
        stack = result.add((size << 2) + 4);
        stack.putInt(size);
        WasmHeap.stack = stack;
        return result;
    }

    @Unmanaged
    public static Address getStackTop() {
        return WasmHeap.stack != WasmHeap.stackAddress ? WasmHeap.stack : null;
    }

    @Unmanaged
    public static Address getNextStackFrame(Address stackFrame) {
        int size = stackFrame.getInt() + 2;
        Address result = stackFrame.add(-size * 4);
        if (result == WasmHeap.stackAddress) {
            result = null;
        }
        return result;
    }

    @Unmanaged
    public static int getStackRootCount(Address stackFrame) {
        return stackFrame.getInt();
    }

    @Unmanaged
    public static Address getStackRootPointer(Address stackFrame) {
        int size = stackFrame.getInt();
        return stackFrame.add(-size * 4);
    }

    @Unmanaged
    private static Address getExceptionHandlerPtr(Address stackFrame) {
        int size = stackFrame.getInt();
        return stackFrame.add(-size * 4 - 4);
    }

    @Unmanaged
    public static int getCallSiteId(Address stackFrame) {
        return WasmRuntime.getExceptionHandlerPtr(stackFrame).getInt();
    }

    @Unmanaged
    public static void setExceptionHandlerId(Address stackFrame, int id) {
        Address addr = WasmRuntime.getExceptionHandlerPtr(stackFrame);
        addr.putInt(addr.getInt() + id + 2);
    }

    @Unmanaged
    public static void setExceptionHandlerSkip(Address stackFrame) {
        Address addr = WasmRuntime.getExceptionHandlerPtr(stackFrame);
        addr.putInt(addr.getInt() + 1);
    }

    @Unmanaged
    public static void setExceptionHandlerRestore(Address stackFrame) {
        Address addr = WasmRuntime.getExceptionHandlerPtr(stackFrame);
        addr.putInt(addr.getInt() - 1);
    }

    @Unmanaged
    private static int hashCode(RuntimeString string) {
        int hashCode = 0;
        int length = string.characters.length;
        Address chars = Address.ofData((char[])string.characters);
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + chars.getChar();
            chars = chars.add(2);
        }
        return hashCode;
    }

    @Unmanaged
    private static boolean equals(RuntimeString first, RuntimeString second) {
        if (first.characters.length != second.characters.length) {
            return false;
        }
        Address firstChars = Address.ofData((char[])first.characters);
        Address secondChars = Address.ofData((char[])second.characters);
        int length = first.characters.length;
        for (int i = 0; i < length; ++i) {
            if (firstChars.getChar() != secondChars.getChar()) {
                return false;
            }
            firstChars = firstChars.add(2);
            secondChars = secondChars.add(2);
        }
        return true;
    }

    public static String[] resourceMapKeys(Address map) {
        String[] result = new String[WasmRuntime.resourceMapSize(map)];
        WasmRuntime.fillResourceMapKeys(map, result);
        return result;
    }

    @Unmanaged
    private static int resourceMapSize(Address map) {
        int result = 0;
        int sz = map.getInt();
        Address data = WasmRuntime.contentStart(map);
        for (int i = 0; i < sz; ++i) {
            if (data.getAddress() != null) {
                ++result;
            }
            data = data.add(Address.sizeOf() * 2);
        }
        return result;
    }

    @Unmanaged
    private static void fillResourceMapKeys(Address map, String[] target) {
        int sz = map.getInt();
        Address data = WasmRuntime.contentStart(map);
        Address targetData = Address.ofData((Object[])target);
        for (int i = 0; i < sz; ++i) {
            Address entry = data.getAddress();
            if (entry != null) {
                targetData.putAddress(entry);
                targetData = targetData.add(Address.sizeOf());
            }
            data = data.add(Address.sizeOf() * 2);
        }
    }

    @Unmanaged
    private static Address contentStart(Address resource) {
        return resource.add(Address.sizeOf());
    }

    @Unmanaged
    public static Address lookupResource(Address map, String string) {
        RuntimeString runtimeString = (RuntimeString)Address.ofObject((Object)string).toStructure();
        int hashCode = WasmRuntime.hashCode(runtimeString);
        int sz = map.getInt();
        Address content = WasmRuntime.contentStart(map);
        for (int i = 0; i < sz; ++i) {
            Address entry;
            Address key;
            int index = (hashCode + i) % sz;
            if (index < 0) {
                index += sz;
            }
            if ((key = (entry = content.add(index * Address.sizeOf() * 2)).getAddress()) == null) {
                return null;
            }
            if (!WasmRuntime.equals((RuntimeString)key.toStructure(), runtimeString)) continue;
            return entry;
        }
        return null;
    }

    @Unmanaged
    public static Address lookupResource(Address map, Address key) {
        int sz = map.getInt();
        Address content = WasmRuntime.contentStart(map);
        int hash = key.toInt();
        for (int i = 0; i < sz; ++i) {
            Address entry;
            Address entryKey;
            int index = (hash + i) % sz;
            if (index < 0) {
                index += sz;
            }
            if ((entryKey = (entry = content.add(index * Address.sizeOf() * 2)).getAddress()) == null) {
                return null;
            }
            if (key != entryKey) continue;
            return entry;
        }
        return null;
    }

    @Unmanaged
    public static native void callFunctionFromTable(int var0, RuntimeObject var1);

    static class RuntimeString
    extends RuntimeObject {
        char[] characters;

        RuntimeString() {
        }
    }
}

