/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.intrinsics.ref;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;

public class WeakReferenceGenerator
implements Generator {
    @Override
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "<init>": {
                this.generateConstructor(context, writer);
                break;
            }
            case "get": {
                this.generateGet(context, writer);
                break;
            }
            case "clear": {
                this.generateClear(context, writer);
            }
        }
    }

    private void generateConstructor(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("var supported").ws().append("=").ws();
        this.isSupported(writer).append(";").softNewLine();
        writer.append("var value").ws().append("=").ws().append("supported").ws().append("?").ws().append("new $rt_globals.WeakRef(").append(context.getParameterName(1)).append(")").ws();
        writer.append(":").ws().append(context.getParameterName(0)).append(";").softNewLine();
        writer.append(context.getParameterName(0)).append(".").appendField(new FieldReference(WeakReference.class.getName(), "value")).ws().append("=").ws().append("value;").softNewLine();
        writer.appendIf().append(context.getParameterName(2)).ws().append("!==").ws().append("null").ws().append("&&").ws().append("supported)").appendBlockStart();
        writer.append("var registry").ws().append("=").ws().append(context.getParameterName(2)).append(".").appendField(new FieldReference(ReferenceQueue.class.getName(), "registry")).append(";").softNewLine();
        writer.appendIf().append("registry").ws().append("!==").ws().append("null)").ws();
        writer.append("registry.register(").append(context.getParameterName(1)).append(",").ws().append(context.getParameterName(0)).append(");").softNewLine();
        writer.appendBlockEnd();
    }

    private void generateGet(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("var value").ws().append("=").ws().append(context.getParameterName(0)).append(".").appendField(new FieldReference(WeakReference.class.getName(), "value")).append(";").softNewLine();
        writer.appendIf();
        this.isSupported(writer).append(")").appendBlockStart();
        writer.appendIf().append("value").ws().append("===").ws().append("null)").ws().append("return null;").softNewLine();
        writer.append("var result").ws().append("=").ws().append("value.deref();").softNewLine();
        writer.append("return typeof result").ws().append("!==").ws().append("'undefined'").ws().append("?").ws().append("result").ws().append(":").ws().append("null;").softNewLine();
        writer.appendElse();
        writer.append("return value;").softNewLine();
        writer.appendBlockEnd();
    }

    private void generateClear(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append(context.getParameterName(0)).append(".").appendField(new FieldReference(WeakReference.class.getName(), "value")).ws();
        writer.append("=").ws().append("null;").softNewLine();
    }

    private SourceWriter isSupported(SourceWriter writer) throws IOException {
        return writer.append("typeof ").append("$rt_globals.WeakRef").ws().append("!==").ws().append("'undefined'");
    }
}

