/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.MethodReference;

public class LongIntrinsic
implements Intrinsic {
    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(Long.class.getName())) {
            return false;
        }
        switch (method.getName()) {
            case "divideUnsigned": 
            case "remainderUnsigned": 
            case "compareUnsigned": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "divideUnsigned": {
                this.writeBinary(context, invocation, "/");
                break;
            }
            case "remainderUnsigned": {
                this.writeBinary(context, invocation, "%");
                break;
            }
            case "compareUnsigned": {
                context.writer().print("teavm_compare_u64(");
                context.emit(invocation.getArguments().get(0));
                context.writer().print(", ");
                context.emit(invocation.getArguments().get(1));
                context.writer().print(")");
            }
        }
    }

    private void writeBinary(IntrinsicContext context, InvocationExpr invocation, String operation) {
        context.writer().print("((int64_t) ((uint64_t) ");
        context.emit(invocation.getArguments().get(0));
        context.writer().print(" " + operation + " (uint64_t) ");
        context.emit(invocation.getArguments().get(1));
        context.writer().print("))");
    }
}

