/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.hppc.ObjectByteHashMap;
import org.teavm.hppc.ObjectByteMap;
import org.teavm.vm.BuildTarget;

public class IncrementalDirectoryBuildTarget
implements BuildTarget {
    private File directory;
    private Set<String> writtenFiles = new HashSet<String>();
    private Set<String> formerWrittenFiles = new HashSet<String>();
    private ObjectByteMap<String> knownExistingFiles = new ObjectByteHashMap();
    private Map<String, FileDescriptor> knownDescriptors = new HashMap<String, FileDescriptor>();

    public IncrementalDirectoryBuildTarget(File directory) {
        this.directory = directory;
    }

    public void reset() {
        for (String fileName : this.formerWrittenFiles) {
            if (this.writtenFiles.contains(fileName)) continue;
            new File(this.directory, fileName).delete();
            this.knownExistingFiles.put((Object)fileName, (byte)0);
            this.knownDescriptors.remove(fileName);
        }
        this.formerWrittenFiles.clear();
        this.formerWrittenFiles.addAll(this.writtenFiles);
        this.writtenFiles.clear();
    }

    @Override
    public OutputStream createResource(String fileName) {
        this.writtenFiles.add(fileName);
        return new OutputStreamImpl(new File(this.directory, fileName), fileName);
    }

    private static long hash(byte[] data) {
        long hash = -3750763034362895579L;
        for (byte b : data) {
            hash *= 1099511628211L;
            hash ^= (long)(b & 0xFF);
        }
        return hash;
    }

    class OutputStreamImpl
    extends OutputStream {
        private File file;
        private String name;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();

        OutputStreamImpl(File file, String name) {
            this.file = file;
            this.name = name;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkNotClosed();
            this.bytes.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkNotClosed();
            this.bytes.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            boolean exists;
            this.checkNotClosed();
            byte[] data = this.bytes.toByteArray();
            this.bytes = null;
            byte cachedExisting = IncrementalDirectoryBuildTarget.this.knownExistingFiles.getOrDefault((Object)this.name, (byte)-1);
            if (cachedExisting < 0) {
                cachedExisting = this.file.exists() ? (byte)1 : 0;
                IncrementalDirectoryBuildTarget.this.knownExistingFiles.put((Object)this.name, cachedExisting);
            }
            boolean bl = exists = cachedExisting != 0;
            if (!exists || this.isChanged(this.file, data)) {
                this.file.getParentFile().mkdirs();
                try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.file));){
                    ((OutputStream)output).write(data);
                }
            }
        }

        private boolean isChanged(File file, byte[] data) throws IOException {
            int bytesRead;
            FileDescriptor descriptor = IncrementalDirectoryBuildTarget.this.knownDescriptors.get(this.name);
            long hash = IncrementalDirectoryBuildTarget.hash(data);
            if (descriptor != null) {
                if (descriptor.hash != hash || descriptor.length != data.length) {
                    descriptor.hash = hash;
                    descriptor.length = data.length;
                    return true;
                }
                return false;
            }
            descriptor = new FileDescriptor();
            IncrementalDirectoryBuildTarget.this.knownDescriptors.put(this.name, descriptor);
            descriptor.hash = hash;
            descriptor.length = data.length;
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[4096];
            int index = 0;
            while ((bytesRead = ((InputStream)input).read(buffer)) >= 0) {
                if (bytesRead + index > data.length) {
                    return true;
                }
                for (int i = 0; i < bytesRead; ++i) {
                    if (buffer[i] == data[index++]) continue;
                    return true;
                }
            }
            return index < data.length;
        }

        private void checkNotClosed() throws IOException {
            if (this.bytes == null) {
                throw new IOException("Already closed");
            }
        }
    }

    static class FileDescriptor {
        long hash;
        int length;

        FileDescriptor() {
        }
    }
}

