/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.transformation;

import java.util.HashSet;
import java.util.Set;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.Program;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.util.DominatorWalker;
import org.teavm.model.util.DominatorWalkerCallback;
import org.teavm.model.util.DominatorWalkerContext;

public class ClassInitInsertion {
    private static final MethodDescriptor CLINIT = new MethodDescriptor("<clinit>", Void.TYPE);
    private ClassReaderSource classSource;

    public ClassInitInsertion(ClassReaderSource classSource) {
        this.classSource = classSource;
    }

    public void apply(MethodReader method, Program program) {
        if (program.basicBlockCount() == 0) {
            return;
        }
        String currentClass = null;
        if (method.hasModifier(ElementModifier.STATIC)) {
            currentClass = method.getOwnerName();
        }
        Visitor visitor = new Visitor(currentClass);
        new DominatorWalker(program).walk(visitor);
    }

    class Visitor
    extends AbstractInstructionVisitor
    implements DominatorWalkerCallback<State> {
        private String currentClass;
        private DominatorWalkerContext context;
        Set<String> initializedClasses = new HashSet<String>();
        private State state;

        Visitor(String currentClass) {
            this.currentClass = currentClass;
            if (currentClass != null) {
                this.initializedClasses.add(currentClass);
            }
        }

        @Override
        public void setContext(DominatorWalkerContext context) {
            this.context = context;
        }

        @Override
        public State visit(BasicBlock block) {
            this.state = new State();
            if (this.context.isExceptionHandler(block.getIndex())) {
                this.markAllClassesAsNotInitialized();
                if (this.currentClass != null) {
                    this.markClassAsInitialized(this.currentClass);
                }
            }
            for (Instruction instruction : block) {
                instruction.acceptVisitor(this);
            }
            return this.state;
        }

        @Override
        public void endVisit(BasicBlock block, State state) {
            if (state.oldInitializedClasses != null) {
                this.initializedClasses.clear();
                this.initializedClasses.addAll(state.oldInitializedClasses);
            } else {
                this.initializedClasses.removeAll(state.newInitializedClasses);
            }
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() == null) {
                this.initializeClass(insn.getField().getClassName(), insn);
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (insn.getInstance() == null) {
                this.initializeClass(insn.getField().getClassName(), insn);
            }
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getInstance() == null) {
                this.markClassAsInitialized(insn.getMethod().getClassName());
            }
        }

        @Override
        public void visit(InitClassInstruction insn) {
            this.markClassAsInitialized(insn.getClassName());
        }

        private void initializeClass(String className, Instruction instruction) {
            ClassReader cls;
            if (this.markClassAsInitialized(className) && ((cls = ClassInitInsertion.this.classSource.get(className)) == null || cls.getMethod(CLINIT) != null)) {
                InitClassInstruction initInsn = new InitClassInstruction();
                initInsn.setClassName(className);
                initInsn.setLocation(instruction.getLocation());
                instruction.insertPrevious(initInsn);
            }
        }

        boolean markClassAsInitialized(String className) {
            if (this.initializedClasses.add(className)) {
                if (this.state.newInitializedClasses != null) {
                    this.state.newInitializedClasses.add(className);
                }
                return true;
            }
            return false;
        }

        private void markAllClassesAsNotInitialized() {
            if (this.state.newInitializedClasses != null) {
                this.state.oldInitializedClasses = new HashSet<String>();
                for (String className : this.initializedClasses) {
                    if (this.state.newInitializedClasses.contains(className)) continue;
                    this.state.oldInitializedClasses.add(className);
                }
                this.state.newInitializedClasses = null;
            }
            this.initializedClasses.clear();
        }
    }

    static class State {
        Set<String> newInitializedClasses = new HashSet<String>();
        Set<String> oldInitializedClasses;

        State() {
        }
    }
}

