/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.hppc.IntArrayDeque;
import org.teavm.hppc.IntDeque;
import org.teavm.hppc.IntObjectHashMap;
import org.teavm.hppc.IntObjectMap;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.hppc.cursors.IntObjectCursor;
import org.teavm.hppc.cursors.ObjectIntCursor;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.analysis.AliasAnalysis;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;
import org.teavm.model.util.ProgramUtils;

public class RepeatedFieldReadElimination
implements MethodOptimization {
    private static final int ENTER = 0;
    private static final int EXIT = 1;
    private ClassReaderSource classSource;
    private boolean[] everythingInvalid;
    private List<IntObjectHashMap<Set<FieldReference>>> invalidFields = new ArrayList<IntObjectHashMap<Set<FieldReference>>>();
    private AliasAnalysis aliasAnalysis;
    private boolean changed;

    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        this.classSource = context.getClassSource();
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        DominatorTree dom = GraphUtils.buildDominatorTree(cfg);
        this.aliasAnalysis = new AliasAnalysis();
        this.aliasAnalysis.analyze(program, context.getMethod().getDescriptor());
        this.insertInvalidationPoints(cfg, dom, program);
        new Traversal(program, dom, cfg).perform();
        return this.changed;
    }

    private void insertInvalidationPoints(Graph cfg, DominatorTree dom, Program program) {
        int[][] domFrontiers = GraphUtils.findDominanceFrontiers(cfg, dom);
        this.everythingInvalid = new boolean[program.basicBlockCount()];
        this.invalidFields.addAll(Collections.nCopies(program.basicBlockCount(), null));
        boolean[] exceptionHandlers = new boolean[program.basicBlockCount()];
        for (BasicBlock block : program.getBasicBlocks()) {
            for (TryCatchBlock tryCatchBlock : block.getTryCatchBlocks()) {
                exceptionHandlers[tryCatchBlock.getHandler().getIndex()] = true;
            }
        }
        IntArrayDeque worklist = new IntArrayDeque();
        InstructionAnalyzer instructionAnalyzer = new InstructionAnalyzer();
        for (BasicBlock block : program.getBasicBlocks()) {
            int[] frontiers = domFrontiers[block.getIndex()];
            if (frontiers.length == 0) continue;
            LinkedHashSet<FieldAndInstance> fieldsToInvalidate = new LinkedHashSet<FieldAndInstance>();
            boolean allInvalid = false;
            if (exceptionHandlers[block.getIndex()]) {
                allInvalid = true;
            } else {
                for (Instruction instruction : block) {
                    instructionAnalyzer.reset();
                    instruction.acceptVisitor(instructionAnalyzer);
                    if (instructionAnalyzer.invalidatesAll) {
                        allInvalid = true;
                        fieldsToInvalidate.clear();
                        break;
                    }
                    if (instructionAnalyzer.invalidatedField == null || this.isVolatile(instructionAnalyzer.invalidatedField)) continue;
                    fieldsToInvalidate.add(new FieldAndInstance(instructionAnalyzer.invalidatedField, instructionAnalyzer.instance));
                }
            }
            if (allInvalid) {
                worklist.addLast(frontiers);
                while (!worklist.isEmpty()) {
                    int target = worklist.removeFirst();
                    if (this.everythingInvalid[target]) continue;
                    this.everythingInvalid[target] = true;
                    this.invalidFields.set(target, null);
                    worklist.addLast(domFrontiers[target]);
                }
                continue;
            }
            for (FieldAndInstance fieldAndInstance : fieldsToInvalidate) {
                worklist.addLast(frontiers);
                int instance = fieldAndInstance.instance;
                FieldReference field = fieldAndInstance.field;
                while (!worklist.isEmpty()) {
                    HashSet<FieldReference> invalidFieldsByVar;
                    int target = worklist.removeFirst();
                    if (this.everythingInvalid[target]) continue;
                    IntObjectHashMap invalidFieldsByBlock = this.invalidFields.get(target);
                    if (invalidFieldsByBlock == null) {
                        invalidFieldsByBlock = new IntObjectHashMap();
                        this.invalidFields.set(target, (IntObjectHashMap<Set<FieldReference>>)invalidFieldsByBlock);
                    }
                    if ((invalidFieldsByVar = (HashSet<FieldReference>)invalidFieldsByBlock.get(instance)) == null) {
                        invalidFieldsByVar = new HashSet<FieldReference>();
                        invalidFieldsByBlock.put(instance, invalidFieldsByVar);
                    }
                    if (!invalidFieldsByVar.add(field)) continue;
                    worklist.addLast(domFrontiers[target]);
                }
            }
        }
    }

    private boolean isVolatile(FieldReference fieldRef) {
        FieldReader field = this.classSource.resolve(fieldRef);
        return field == null || field.hasModifier(ElementModifier.VOLATILE);
    }

    class Traversal {
        Program program;
        IntDeque worklist = new IntArrayDeque();
        IntObjectMap<ObjectIntMap<FieldReference>> cacheVars = new IntObjectHashMap();
        Deque<State> stateStack = new ArrayDeque<State>();
        Graph domGraph;
        InstructionAnalyzer instructionAnalyzer = new InstructionAnalyzer();

        Traversal(Program program, DominatorTree dom, Graph cfg) {
            this.program = program;
            this.worklist.addLast(0);
            this.worklist.addLast(0);
            this.domGraph = GraphUtils.buildDominatorGraph(dom, cfg.size());
        }

        void perform() {
            while (!this.worklist.isEmpty()) {
                int operation = this.worklist.removeLast();
                int blockIndex = this.worklist.removeLast();
                BasicBlock block = this.program.basicBlockAt(blockIndex);
                switch (operation) {
                    case 0: {
                        this.enterBlock(block);
                        break;
                    }
                    case 1: {
                        this.exitBlock();
                    }
                }
            }
        }

        private void enterBlock(BasicBlock block) {
            this.stateStack.addLast(new State());
            this.invalidatePreparedFields(block);
            for (Instruction instruction : block) {
                if (instruction instanceof GetFieldInstruction) {
                    this.handleGetField((GetFieldInstruction)instruction);
                    continue;
                }
                this.instructionAnalyzer.reset();
                instruction.acceptVisitor(this.instructionAnalyzer);
                if (this.instructionAnalyzer.invalidatesAll) {
                    this.invalidateAllFields();
                    continue;
                }
                if (this.instructionAnalyzer.invalidatedField == null) continue;
                FieldReference field = this.instructionAnalyzer.invalidatedField;
                int instance = this.instructionAnalyzer.instance;
                if (RepeatedFieldReadElimination.this.isVolatile(field)) continue;
                this.invalidateField(instance, field);
                this.storeIntoCache(instance, field, this.instructionAnalyzer.newValue);
            }
            this.worklist.addLast(block.getIndex());
            this.worklist.addLast(1);
            for (Object successor : (Object)this.domGraph.outgoingEdges(block.getIndex())) {
                this.worklist.addLast((int)successor);
                this.worklist.addLast(0);
            }
        }

        private void invalidatePreparedFields(BasicBlock block) {
            if (RepeatedFieldReadElimination.this.everythingInvalid[block.getIndex()]) {
                this.invalidateAllFields();
                return;
            }
            IntObjectHashMap<Set<FieldReference>> invalidFieldsByBlock = RepeatedFieldReadElimination.this.invalidFields.get(block.getIndex());
            if (invalidFieldsByBlock != null) {
                for (IntObjectCursor cursor : invalidFieldsByBlock) {
                    int instance = cursor.key;
                    for (FieldReference field : (Set)cursor.value) {
                        this.invalidateField(instance, field);
                    }
                }
            }
        }

        private void handleGetField(GetFieldInstruction instruction) {
            int cachedVar;
            FieldReference field = instruction.getField();
            if (RepeatedFieldReadElimination.this.isVolatile(field)) {
                return;
            }
            int instanceIndex = instruction.getInstance() != null ? instruction.getInstance().getIndex() : -1;
            ObjectIntMap cacheVarsByInstance = (ObjectIntMap)this.cacheVars.get(instanceIndex);
            if (cacheVarsByInstance == null) {
                cacheVarsByInstance = new ObjectIntHashMap();
                this.cacheVars.put(instanceIndex, (Object)cacheVarsByInstance);
            }
            if ((cachedVar = cacheVarsByInstance.getOrDefault((Object)field, -1)) >= 0) {
                AssignInstruction assign = new AssignInstruction();
                assign.setReceiver(instruction.getReceiver());
                assign.setAssignee(this.program.variableAt(cachedVar));
                assign.setLocation(instruction.getLocation());
                instruction.replace(assign);
                RepeatedFieldReadElimination.this.changed = true;
            } else {
                cachedVar = instruction.getReceiver().getIndex();
                cacheVarsByInstance.put((Object)field, cachedVar);
                this.markFieldAsAdded(instanceIndex, field);
            }
        }

        private void storeIntoCache(int instance, FieldReference field, int value) {
            ObjectIntMap cacheVarsByInstance = (ObjectIntMap)this.cacheVars.get(instance);
            if (cacheVarsByInstance == null) {
                cacheVarsByInstance = new ObjectIntHashMap();
                this.cacheVars.put(instance, (Object)cacheVarsByInstance);
            }
            cacheVarsByInstance.put((Object)field, value);
            this.markFieldAsAdded(instance, field);
        }

        private void markFieldAsAdded(int instance, FieldReference field) {
            State state = this.currentState();
            ObjectIntMap removedFieldsByInstance = (ObjectIntMap)state.removedCacheFields.get(instance);
            if (removedFieldsByInstance == null || !removedFieldsByInstance.containsKey((Object)field)) {
                HashSet<FieldReference> fields = (HashSet<FieldReference>)state.addedCacheFields.get(instance);
                if (fields == null) {
                    fields = new HashSet<FieldReference>();
                    state.addedCacheFields.put(instance, fields);
                }
                fields.add(field);
            }
        }

        private void invalidateAllFields() {
            State state = this.currentState();
            for (IntObjectCursor instanceCursor : this.cacheVars) {
                int instance = instanceCursor.key;
                ObjectIntMap cacheVarsByInstance = (ObjectIntMap)instanceCursor.value;
                for (ObjectIntCursor fieldCursor : cacheVarsByInstance) {
                    FieldReference field = (FieldReference)fieldCursor.key;
                    int value = fieldCursor.value;
                    this.markFieldAsRemoved(state, instance, field, value);
                }
            }
            this.cacheVars.clear();
        }

        private void invalidateField(int instance, FieldReference field) {
            if (instance == -1) {
                this.invalidateSingleField(instance, field);
                return;
            }
            if (RepeatedFieldReadElimination.this.aliasAnalysis.affectsEverything(instance)) {
                this.invalidateFieldOnAllInstances(field);
            } else {
                for (int affectedVar : RepeatedFieldReadElimination.this.aliasAnalysis.affectedVariables(instance)) {
                    this.invalidateSingleField(affectedVar, field);
                }
                for (int affectedVar : RepeatedFieldReadElimination.this.aliasAnalysis.getExternalObjects()) {
                    this.invalidateSingleField(affectedVar, field);
                }
            }
        }

        private void invalidateSingleField(int instance, FieldReference field) {
            ObjectIntMap cacheVarsByInstance = (ObjectIntMap)this.cacheVars.get(instance);
            if (cacheVarsByInstance == null || !cacheVarsByInstance.containsKey((Object)field)) {
                return;
            }
            int value = cacheVarsByInstance.remove((Object)field);
            State state = this.currentState();
            this.markFieldAsRemoved(state, instance, field, value);
        }

        private void invalidateFieldOnAllInstances(FieldReference field) {
            for (IntObjectCursor instanceCursor : this.cacheVars) {
                int instance = instanceCursor.key;
                int value = ((ObjectIntMap)instanceCursor.value).getOrDefault((Object)field, -1);
                if (value < 0) continue;
                ((ObjectIntMap)instanceCursor.value).remove((Object)field);
                State state = this.currentState();
                this.markFieldAsRemoved(state, instance, field, value);
            }
        }

        private void markFieldAsRemoved(State state, int instance, FieldReference field, int value) {
            Set addedFieldsByInstance = (Set)state.addedCacheFields.get(instance);
            if (addedFieldsByInstance == null || !addedFieldsByInstance.contains(field)) {
                ObjectIntMap removedFieldsByInstance = (ObjectIntMap)state.removedCacheFields.get(instance);
                if (removedFieldsByInstance == null) {
                    removedFieldsByInstance = new ObjectIntHashMap();
                    state.removedCacheFields.put(instance, (Object)removedFieldsByInstance);
                }
                if (!removedFieldsByInstance.containsKey((Object)field)) {
                    removedFieldsByInstance.put((Object)field, value);
                }
            }
        }

        private void exitBlock() {
            int instance;
            State state = this.stateStack.removeLast();
            for (IntObjectCursor instanceCursor : state.addedCacheFields) {
                instance = instanceCursor.key;
                ObjectIntMap cachedFieldsByInstances = (ObjectIntMap)this.cacheVars.get(instance);
                if (cachedFieldsByInstances == null) continue;
                for (FieldReference field : (Set)instanceCursor.value) {
                    cachedFieldsByInstances.remove((Object)field);
                }
                if (!cachedFieldsByInstances.isEmpty()) continue;
                this.cacheVars.remove(instance);
            }
            for (IntObjectCursor instanceCursor : state.removedCacheFields) {
                instance = instanceCursor.key;
                ObjectIntMap cacheVarsByInstance = (ObjectIntMap)this.cacheVars.get(instance);
                if (cacheVarsByInstance == null) {
                    cacheVarsByInstance = new ObjectIntHashMap();
                    this.cacheVars.put(instance, (Object)cacheVarsByInstance);
                }
                for (ObjectIntCursor fieldCursor : (ObjectIntMap)instanceCursor.value) {
                    FieldReference field = (FieldReference)fieldCursor.key;
                    int value = fieldCursor.value;
                    cacheVarsByInstance.put((Object)field, value);
                }
            }
        }

        private State currentState() {
            return this.stateStack.getLast();
        }
    }

    static class InstructionAnalyzer
    extends AbstractInstructionVisitor {
        boolean invalidatesAll;
        FieldReference invalidatedField;
        int instance;
        int newValue;

        InstructionAnalyzer() {
        }

        void reset() {
            this.invalidatesAll = false;
            this.invalidatedField = null;
            this.instance = -1;
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            this.invalidatedField = insn.getField();
            this.instance = insn.getInstance() != null ? insn.getInstance().getIndex() : -1;
            this.newValue = insn.getValue().getIndex();
        }

        @Override
        public void visit(InvokeInstruction insn) {
            this.invalidatesAll = true;
        }
    }

    static class FieldAndInstance {
        final FieldReference field;
        final int instance;

        FieldAndInstance(FieldReference field, int instance) {
            this.field = field;
            this.instance = instance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldAndInstance)) {
                return false;
            }
            FieldAndInstance that = (FieldAndInstance)o;
            return this.instance == that.instance && this.field.equals(that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.instance);
        }
    }

    static class State {
        IntObjectMap<ObjectIntMap<FieldReference>> removedCacheFields = new IntObjectHashMap();
        IntObjectMap<Set<FieldReference>> addedCacheFields = new IntObjectHashMap();

        State() {
        }
    }
}

