/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.hppc.ObjectByteHashMap;
import org.teavm.hppc.ObjectByteMap;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.StaticInit;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ProgramReader;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.model.instructions.AbstractInstructionReader;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.optimization.Devirtualization;

public class ClassInitializerAnalysis
implements ClassInitializerInfo {
    private static final MethodDescriptor CLINIT = new MethodDescriptor("<clinit>", Void.TYPE);
    private static final byte BEING_ANALYZED = 1;
    private static final byte DYNAMIC = 2;
    private static final byte STATIC = 3;
    private ObjectByteMap<String> classStatuses = new ObjectByteHashMap();
    private Map<MethodReference, MethodInfo> methodInfoMap = new HashMap<MethodReference, MethodInfo>();
    private ListableClassReaderSource classes;
    private ClassHierarchy hierarchy;
    private List<String> order = new ArrayList<String>();
    private List<? extends String> readonlyOrder = Collections.unmodifiableList(this.order);
    private String currentAnalyzedClass;
    private DependencyInfo dependencyInfo;

    public ClassInitializerAnalysis(ListableClassReaderSource classes, ClassHierarchy hierarchy) {
        this.classes = classes;
        this.hierarchy = hierarchy;
    }

    public void analyze(DependencyInfo dependencyInfo) {
        if (this.methodInfoMap == null) {
            return;
        }
        this.dependencyInfo = dependencyInfo;
        for (String className : this.classes.getClassNames()) {
            this.analyze(className);
        }
        this.methodInfoMap = null;
        this.classes = null;
        this.hierarchy = null;
        this.dependencyInfo = null;
    }

    @Override
    public boolean isDynamicInitializer(String className) {
        return this.classStatuses.get((Object)className) != 3;
    }

    @Override
    public List<? extends String> getInitializationOrder() {
        return this.readonlyOrder;
    }

    private void analyze(String className) {
        MethodInfo initializerInfo;
        byte classStatus = this.classStatuses.get((Object)className);
        switch (classStatus) {
            case 1: {
                if (!className.equals(this.currentAnalyzedClass)) {
                    this.classStatuses.put((Object)className, (byte)2);
                }
                return;
            }
            case 2: 
            case 3: {
                return;
            }
        }
        ClassReader cls = this.classes.get(className);
        if (cls == null || cls.getAnnotations().get(StaticInit.class.getName()) != null) {
            this.classStatuses.put((Object)className, (byte)3);
            return;
        }
        this.classStatuses.put((Object)className, (byte)1);
        String previousClass = this.currentAnalyzedClass;
        this.currentAnalyzedClass = className;
        MethodReader initializer = cls.getMethod(CLINIT);
        boolean isStatic = true;
        if (initializer != null && this.isDynamicInitializer(initializerInfo = this.analyzeMethod(initializer), className)) {
            isStatic = false;
        }
        this.currentAnalyzedClass = previousClass;
        if (this.classStatuses.get((Object)className) == 1) {
            this.classStatuses.put((Object)className, isStatic ? (byte)3 : 2);
            if (isStatic && initializer != null) {
                this.order.add(className);
            }
        }
    }

    private boolean isDynamicInitializer(MethodInfo methodInfo, String className) {
        if (methodInfo.anyFieldModified) {
            return true;
        }
        if (methodInfo.classesWithModifiedFields != null) {
            for (String affectedClass : methodInfo.classesWithModifiedFields) {
                if (affectedClass.equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    private MethodInfo analyzeMethod(MethodReader method) {
        MethodInfo methodInfo = this.methodInfoMap.get(method.getReference());
        if (methodInfo == null) {
            methodInfo = new MethodInfo(method.getReference());
            this.methodInfoMap.put(method.getReference(), methodInfo);
            String currentClass = method.getDescriptor().equals(CLINIT) ? method.getOwnerName() : null;
            InstructionAnalyzer reader = new InstructionAnalyzer(currentClass, methodInfo);
            ProgramReader program = method.getProgram();
            if (program == null) {
                methodInfo.anyFieldModified = this.hasSideEffects(method);
            } else {
                for (BasicBlockReader basicBlockReader : program.getBasicBlocks()) {
                    basicBlockReader.readAllInstructions(reader);
                }
            }
            if (method.hasModifier(ElementModifier.SYNCHRONIZED)) {
                reader.initClass("java.lang.Thread");
            }
            methodInfo.complete = true;
        }
        return methodInfo;
    }

    private boolean hasSideEffects(MethodReader method) {
        if (method.hasModifier(ElementModifier.ABSTRACT)) {
            return false;
        }
        if (method.getAnnotations().get(NoSideEffects.class.getName()) != null) {
            return false;
        }
        ClassReader containingClass = this.classes.get(method.getOwnerName());
        return containingClass.getAnnotations().get(NoSideEffects.class.getName()) == null;
    }

    static class MethodInfo {
        MethodReference method;
        boolean complete;
        Set<String> classesWithModifiedFields;
        boolean anyFieldModified;

        MethodInfo(MethodReference method) {
            this.method = method;
        }
    }

    class InstructionAnalyzer
    extends AbstractInstructionReader {
        String currentClass;
        MethodInfo methodInfo;
        MethodDependencyInfo methodDep;

        InstructionAnalyzer(String currentClass, MethodInfo methodInfo) {
            this.currentClass = currentClass;
            this.methodInfo = methodInfo;
            this.methodDep = ClassInitializerAnalysis.this.dependencyInfo.getMethod(methodInfo.method);
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            this.analyzeInitializer("java.lang.String");
        }

        @Override
        public void create(VariableReader receiver, String type) {
            this.analyzeInitializer(type);
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            if (instance == null) {
                this.touchField(field);
            }
        }

        @Override
        public void putField(VariableReader instance, FieldReference field, VariableReader value, ValueType fieldType) {
            if (instance == null) {
                FieldReader fieldReader;
                ClassReader cls = ClassInitializerAnalysis.this.classes.get(field.getClassName());
                if (cls != null && (fieldReader = cls.getField(field.getFieldName())) != null && fieldReader.hasModifier(ElementModifier.FINAL)) {
                    return;
                }
                this.touchField(field);
            }
        }

        private void touchField(FieldReference field) {
            this.analyzeInitializer(field.getClassName());
            if (!this.methodInfo.anyFieldModified && !field.getClassName().equals(this.currentClass)) {
                if (this.methodInfo.classesWithModifiedFields == null) {
                    this.methodInfo.classesWithModifiedFields = new HashSet<String>();
                }
                this.methodInfo.classesWithModifiedFields.add(field.getClassName());
            }
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            if (type == InvocationType.VIRTUAL) {
                ValueDependencyInfo instanceDep = this.methodDep.getVariable(instance.getIndex());
                Set<MethodReference> implementations = Devirtualization.implementations(ClassInitializerAnalysis.this.hierarchy, ClassInitializerAnalysis.this.dependencyInfo, instanceDep.getTypes(), method);
                for (MethodReference implementation : implementations) {
                    this.invokeMethod(implementation);
                }
            } else {
                this.analyzeInitializer(method.getClassName());
                this.invokeMethod(method);
            }
        }

        private void invokeMethod(MethodReference method) {
            MethodReader methodReader;
            ClassReader cls = ClassInitializerAnalysis.this.classes.get(method.getClassName());
            if (cls != null && (methodReader = cls.getMethod(method.getDescriptor())) != null) {
                this.analyzeCalledMethod(ClassInitializerAnalysis.this.analyzeMethod(methodReader));
            }
        }

        @Override
        public void initClass(String className) {
            this.analyzeInitializer(className);
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
            this.initClass("java.lang.Thread");
        }

        @Override
        public void monitorExit(VariableReader objectRef) {
            this.initClass("java.lang.Thread");
        }

        void analyzeInitializer(String className) {
            if (className.equals(this.currentClass) || className.equals(this.methodInfo.method.getClassName())) {
                return;
            }
            ClassInitializerAnalysis.this.analyze(className);
            if (ClassInitializerAnalysis.this.isDynamicInitializer(className)) {
                this.methodInfo.anyFieldModified = true;
            }
        }

        private void analyzeCalledMethod(MethodInfo calledMethod) {
            if (this.methodInfo.anyFieldModified) {
                return;
            }
            if (calledMethod.anyFieldModified) {
                this.methodInfo.anyFieldModified = true;
                this.methodInfo.classesWithModifiedFields = null;
            } else if (calledMethod.classesWithModifiedFields != null) {
                for (String className : calledMethod.classesWithModifiedFields) {
                    if (className.equals(this.currentClass)) continue;
                    if (this.methodInfo.classesWithModifiedFields == null) {
                        this.methodInfo.classesWithModifiedFields = new HashSet<String>();
                    }
                    this.methodInfo.classesWithModifiedFields.add(className);
                }
            }
        }
    }
}

