/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.teavm.backend.wasm.debug.DebugLines;
import org.teavm.backend.wasm.generate.DwarfGenerator;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.backend.wasm.render.WasmBinaryWriter;
import org.teavm.backend.wasm.render.WasmSignature;
import org.teavm.model.InliningInfo;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;

class WasmBinaryRenderingVisitor
implements WasmExpressionVisitor {
    private WasmBinaryWriter writer;
    private WasmBinaryVersion version;
    private Map<String, Integer> functionIndexes;
    private Map<String, Integer> importedIndexes;
    private Map<WasmSignature, Integer> signatureIndexes;
    private DwarfGenerator dwarfGenerator;
    private DebugLines debugLines;
    private int addressOffset;
    private int depth;
    private Map<WasmBlock, Integer> blockDepths = new HashMap<WasmBlock, Integer>();
    private List<MethodReference> methodStack = new ArrayList<MethodReference>();
    private List<MethodReference> currentMethodStack = new ArrayList<MethodReference>();
    private TextLocation textLocationToEmit;
    private boolean deferTextLocationToEmit;
    private TextLocation lastEmittedLocation;
    private int positionToEmit;
    private List<TextLocation> locationStack = new ArrayList<TextLocation>();

    WasmBinaryRenderingVisitor(WasmBinaryWriter writer, WasmBinaryVersion version, Map<String, Integer> functionIndexes, Map<String, Integer> importedIndexes, Map<WasmSignature, Integer> signatureIndexes, DwarfGenerator dwarfGenerator, DebugLines debugLines, int addressOffset) {
        this.writer = writer;
        this.version = version;
        this.functionIndexes = functionIndexes;
        this.importedIndexes = importedIndexes;
        this.signatureIndexes = signatureIndexes;
        this.dwarfGenerator = dwarfGenerator;
        this.addressOffset = addressOffset;
        this.debugLines = debugLines;
    }

    @Override
    public void visit(WasmBlock expression) {
        this.pushLocation(expression);
        this.pushLocation(expression);
        int blockDepth = 1;
        this.depth += blockDepth;
        this.blockDepths.put(expression, this.depth);
        this.writer.writeByte(expression.isLoop() ? 3 : 2);
        this.writeBlockType(expression.getType());
        for (WasmExpression part : expression.getBody()) {
            part.acceptVisitor(this);
        }
        this.popLocation();
        this.writer.writeByte(11);
        this.popLocation();
        this.blockDepths.remove(expression);
        this.depth -= blockDepth;
    }

    private void writeBlockType(WasmType type) {
        this.writer.writeType(type, this.version);
    }

    @Override
    public void visit(WasmBranch expression) {
        this.pushLocation(expression);
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
        expression.getCondition().acceptVisitor(this);
        this.writer.writeByte(13);
        this.writeLabel(expression.getTarget());
        this.popLocation();
    }

    @Override
    public void visit(WasmBreak expression) {
        this.pushLocation(expression);
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
        }
        this.writer.writeByte(12);
        this.writeLabel(expression.getTarget());
        this.popLocation();
    }

    @Override
    public void visit(WasmSwitch expression) {
        this.pushLocation(expression);
        expression.getSelector().acceptVisitor(this);
        this.writer.writeByte(14);
        this.writer.writeLEB(expression.getTargets().size());
        for (WasmBlock target : expression.getTargets()) {
            int targetDepth = this.blockDepths.get(target);
            int relativeDepth = this.depth - targetDepth;
            this.writer.writeLEB(relativeDepth);
        }
        int defaultDepth = this.blockDepths.get(expression.getDefaultTarget());
        int relativeDepth = this.depth - defaultDepth;
        this.writer.writeLEB(relativeDepth);
        this.popLocation();
    }

    @Override
    public void visit(WasmConditional expression) {
        this.pushLocation(expression);
        this.pushLocation(expression);
        expression.getCondition().acceptVisitor(this);
        this.writer.writeByte(4);
        this.writeBlockType(expression.getType());
        ++this.depth;
        this.blockDepths.put(expression.getThenBlock(), this.depth);
        for (WasmExpression part : expression.getThenBlock().getBody()) {
            part.acceptVisitor(this);
        }
        this.blockDepths.remove(expression.getThenBlock());
        if (!expression.getElseBlock().getBody().isEmpty()) {
            this.writer.writeByte(5);
            this.blockDepths.put(expression.getElseBlock(), this.depth);
            for (WasmExpression part : expression.getElseBlock().getBody()) {
                part.acceptVisitor(this);
            }
            this.blockDepths.remove(expression.getElseBlock());
        }
        --this.depth;
        this.popLocation();
        this.writer.writeByte(11);
        this.popLocation();
    }

    @Override
    public void visit(WasmReturn expression) {
        this.pushLocation(expression);
        if (expression.getValue() != null) {
            expression.getValue().acceptVisitor(this);
        }
        this.writer.writeByte(15);
        this.popLocation();
    }

    @Override
    public void visit(WasmUnreachable expression) {
        this.pushLocation(expression);
        this.writer.writeByte(0);
        this.popLocation();
    }

    @Override
    public void visit(WasmInt32Constant expression) {
        this.pushLocation(expression);
        this.writer.writeByte(65);
        this.writer.writeSignedLEB(expression.getValue());
        this.popLocation();
    }

    @Override
    public void visit(WasmInt64Constant expression) {
        this.pushLocation(expression);
        this.writer.writeByte(66);
        this.writer.writeSignedLEB(expression.getValue());
        this.popLocation();
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
        this.pushLocation(expression);
        this.writer.writeByte(67);
        this.writer.writeFixed(Float.floatToRawIntBits(expression.getValue()));
        this.popLocation();
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
        this.pushLocation(expression);
        this.writer.writeByte(68);
        this.writer.writeFixed(Double.doubleToRawLongBits(expression.getValue()));
        this.popLocation();
    }

    @Override
    public void visit(WasmGetLocal expression) {
        this.pushLocation(expression);
        this.writer.writeByte(32);
        this.writer.writeLEB(expression.getLocal().getIndex());
        this.popLocation();
    }

    @Override
    public void visit(WasmSetLocal expression) {
        this.pushLocation(expression);
        expression.getValue().acceptVisitor(this);
        this.writer.writeByte(33);
        this.writer.writeLEB(expression.getLocal().getIndex());
        this.popLocation();
    }

    @Override
    public void visit(WasmIntBinary expression) {
        this.pushLocation(expression);
        expression.getFirst().acceptVisitor(this);
        expression.getSecond().acceptVisitor(this);
        this.render0xD(expression);
        this.popLocation();
    }

    private void render0xD(WasmIntBinary expression) {
        block0 : switch (expression.getType()) {
            case INT32: {
                switch (expression.getOperation()) {
                    case ADD: {
                        this.writer.writeByte(106);
                        break;
                    }
                    case SUB: {
                        this.writer.writeByte(107);
                        break;
                    }
                    case MUL: {
                        this.writer.writeByte(108);
                        break;
                    }
                    case DIV_SIGNED: {
                        this.writer.writeByte(109);
                        break;
                    }
                    case DIV_UNSIGNED: {
                        this.writer.writeByte(110);
                        break;
                    }
                    case REM_SIGNED: {
                        this.writer.writeByte(111);
                        break;
                    }
                    case REM_UNSIGNED: {
                        this.writer.writeByte(112);
                        break;
                    }
                    case AND: {
                        this.writer.writeByte(113);
                        break;
                    }
                    case OR: {
                        this.writer.writeByte(114);
                        break;
                    }
                    case XOR: {
                        this.writer.writeByte(115);
                        break;
                    }
                    case SHL: {
                        this.writer.writeByte(116);
                        break;
                    }
                    case SHR_SIGNED: {
                        this.writer.writeByte(117);
                        break;
                    }
                    case SHR_UNSIGNED: {
                        this.writer.writeByte(118);
                        break;
                    }
                    case ROTL: {
                        this.writer.writeByte(119);
                        break;
                    }
                    case ROTR: {
                        this.writer.writeByte(120);
                        break;
                    }
                    case EQ: {
                        this.writer.writeByte(70);
                        break;
                    }
                    case NE: {
                        this.writer.writeByte(71);
                        break;
                    }
                    case LT_SIGNED: {
                        this.writer.writeByte(72);
                        break;
                    }
                    case LT_UNSIGNED: {
                        this.writer.writeByte(73);
                        break;
                    }
                    case GT_SIGNED: {
                        this.writer.writeByte(74);
                        break;
                    }
                    case GT_UNSIGNED: {
                        this.writer.writeByte(75);
                        break;
                    }
                    case LE_SIGNED: {
                        this.writer.writeByte(76);
                        break;
                    }
                    case LE_UNSIGNED: {
                        this.writer.writeByte(77);
                        break;
                    }
                    case GE_SIGNED: {
                        this.writer.writeByte(78);
                        break;
                    }
                    case GE_UNSIGNED: {
                        this.writer.writeByte(79);
                    }
                }
                break;
            }
            case INT64: {
                switch (expression.getOperation()) {
                    case ADD: {
                        this.writer.writeByte(124);
                        break block0;
                    }
                    case SUB: {
                        this.writer.writeByte(125);
                        break block0;
                    }
                    case MUL: {
                        this.writer.writeByte(126);
                        break block0;
                    }
                    case DIV_SIGNED: {
                        this.writer.writeByte(127);
                        break block0;
                    }
                    case DIV_UNSIGNED: {
                        this.writer.writeByte(128);
                        break block0;
                    }
                    case REM_SIGNED: {
                        this.writer.writeByte(129);
                        break block0;
                    }
                    case REM_UNSIGNED: {
                        this.writer.writeByte(130);
                        break block0;
                    }
                    case AND: {
                        this.writer.writeByte(131);
                        break block0;
                    }
                    case OR: {
                        this.writer.writeByte(132);
                        break block0;
                    }
                    case XOR: {
                        this.writer.writeByte(133);
                        break block0;
                    }
                    case SHL: {
                        this.writer.writeByte(134);
                        break block0;
                    }
                    case SHR_SIGNED: {
                        this.writer.writeByte(135);
                        break block0;
                    }
                    case SHR_UNSIGNED: {
                        this.writer.writeByte(136);
                        break block0;
                    }
                    case ROTL: {
                        this.writer.writeByte(137);
                        break block0;
                    }
                    case ROTR: {
                        this.writer.writeByte(138);
                        break block0;
                    }
                    case EQ: {
                        this.writer.writeByte(81);
                        break block0;
                    }
                    case NE: {
                        this.writer.writeByte(82);
                        break block0;
                    }
                    case LT_SIGNED: {
                        this.writer.writeByte(83);
                        break block0;
                    }
                    case LT_UNSIGNED: {
                        this.writer.writeByte(84);
                        break block0;
                    }
                    case GT_SIGNED: {
                        this.writer.writeByte(85);
                        break block0;
                    }
                    case GT_UNSIGNED: {
                        this.writer.writeByte(86);
                        break block0;
                    }
                    case LE_SIGNED: {
                        this.writer.writeByte(87);
                        break block0;
                    }
                    case LE_UNSIGNED: {
                        this.writer.writeByte(88);
                        break block0;
                    }
                    case GE_SIGNED: {
                        this.writer.writeByte(89);
                        break block0;
                    }
                    case GE_UNSIGNED: {
                        this.writer.writeByte(90);
                    }
                }
            }
        }
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        this.pushLocation(expression);
        expression.getFirst().acceptVisitor(this);
        expression.getSecond().acceptVisitor(this);
        this.render0xD(expression);
        this.popLocation();
    }

    private void render0xD(WasmFloatBinary expression) {
        block0 : switch (expression.getType()) {
            case FLOAT32: {
                switch (expression.getOperation()) {
                    case ADD: {
                        this.writer.writeByte(146);
                        break;
                    }
                    case SUB: {
                        this.writer.writeByte(147);
                        break;
                    }
                    case MUL: {
                        this.writer.writeByte(148);
                        break;
                    }
                    case DIV: {
                        this.writer.writeByte(149);
                        break;
                    }
                    case MIN: {
                        this.writer.writeByte(150);
                        break;
                    }
                    case MAX: {
                        this.writer.writeByte(151);
                        break;
                    }
                    case EQ: {
                        this.writer.writeByte(91);
                        break;
                    }
                    case NE: {
                        this.writer.writeByte(92);
                        break;
                    }
                    case LT: {
                        this.writer.writeByte(93);
                        break;
                    }
                    case GT: {
                        this.writer.writeByte(94);
                        break;
                    }
                    case LE: {
                        this.writer.writeByte(95);
                        break;
                    }
                    case GE: {
                        this.writer.writeByte(96);
                    }
                }
                break;
            }
            case FLOAT64: {
                switch (expression.getOperation()) {
                    case ADD: {
                        this.writer.writeByte(160);
                        break block0;
                    }
                    case SUB: {
                        this.writer.writeByte(161);
                        break block0;
                    }
                    case MUL: {
                        this.writer.writeByte(162);
                        break block0;
                    }
                    case DIV: {
                        this.writer.writeByte(163);
                        break block0;
                    }
                    case MIN: {
                        this.writer.writeByte(164);
                        break block0;
                    }
                    case MAX: {
                        this.writer.writeByte(165);
                        break block0;
                    }
                    case EQ: {
                        this.writer.writeByte(97);
                        break block0;
                    }
                    case NE: {
                        this.writer.writeByte(98);
                        break block0;
                    }
                    case LT: {
                        this.writer.writeByte(99);
                        break block0;
                    }
                    case GT: {
                        this.writer.writeByte(100);
                        break block0;
                    }
                    case LE: {
                        this.writer.writeByte(101);
                        break block0;
                    }
                    case GE: {
                        this.writer.writeByte(102);
                    }
                }
            }
        }
    }

    @Override
    public void visit(WasmIntUnary expression) {
        this.pushLocation(expression);
        expression.getOperand().acceptVisitor(this);
        block0 : switch (expression.getType()) {
            case INT32: {
                switch (expression.getOperation()) {
                    case EQZ: {
                        this.writer.writeByte(69);
                        break;
                    }
                    case CLZ: {
                        this.writer.writeByte(103);
                        break;
                    }
                    case CTZ: {
                        this.writer.writeByte(104);
                        break;
                    }
                    case POPCNT: {
                        this.writer.writeByte(105);
                    }
                }
                break;
            }
            case INT64: {
                switch (expression.getOperation()) {
                    case EQZ: {
                        this.writer.writeByte(80);
                        break block0;
                    }
                    case CLZ: {
                        this.writer.writeByte(121);
                        break block0;
                    }
                    case CTZ: {
                        this.writer.writeByte(122);
                        break block0;
                    }
                    case POPCNT: {
                        this.writer.writeByte(123);
                    }
                }
            }
        }
        this.popLocation();
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        this.pushLocation(expression);
        expression.getOperand().acceptVisitor(this);
        this.render0xD(expression);
        this.popLocation();
    }

    private void render0xD(WasmFloatUnary expression) {
        block0 : switch (expression.getType()) {
            case FLOAT32: {
                switch (expression.getOperation()) {
                    case ABS: {
                        this.writer.writeByte(139);
                        break;
                    }
                    case NEG: {
                        this.writer.writeByte(140);
                        break;
                    }
                    case CEIL: {
                        this.writer.writeByte(141);
                        break;
                    }
                    case FLOOR: {
                        this.writer.writeByte(142);
                        break;
                    }
                    case TRUNC: {
                        this.writer.writeByte(143);
                        break;
                    }
                    case NEAREST: {
                        this.writer.writeByte(144);
                        break;
                    }
                    case SQRT: {
                        this.writer.writeByte(145);
                        break;
                    }
                    case COPYSIGN: {
                        this.writer.writeByte(152);
                    }
                }
                break;
            }
            case FLOAT64: {
                switch (expression.getOperation()) {
                    case ABS: {
                        this.writer.writeByte(153);
                        break block0;
                    }
                    case NEG: {
                        this.writer.writeByte(154);
                        break block0;
                    }
                    case CEIL: {
                        this.writer.writeByte(155);
                        break block0;
                    }
                    case FLOOR: {
                        this.writer.writeByte(156);
                        break block0;
                    }
                    case TRUNC: {
                        this.writer.writeByte(157);
                        break block0;
                    }
                    case NEAREST: {
                        this.writer.writeByte(158);
                        break block0;
                    }
                    case SQRT: {
                        this.writer.writeByte(159);
                        break block0;
                    }
                    case COPYSIGN: {
                        this.writer.writeByte(166);
                    }
                }
            }
        }
    }

    @Override
    public void visit(WasmConversion expression) {
        this.pushLocation(expression);
        expression.getOperand().acceptVisitor(this);
        block0 : switch (expression.getSourceType()) {
            case INT32: {
                switch (expression.getTargetType()) {
                    case INT32: {
                        break;
                    }
                    case INT64: {
                        this.writer.writeByte(expression.isSigned() ? 172 : 173);
                        break;
                    }
                    case FLOAT32: {
                        if (expression.isReinterpret()) {
                            this.writer.writeByte(190);
                            break;
                        }
                        this.writer.writeByte(expression.isSigned() ? 178 : 179);
                        break;
                    }
                    case FLOAT64: {
                        this.writer.writeByte(expression.isSigned() ? 183 : 184);
                    }
                }
                break;
            }
            case INT64: {
                switch (expression.getTargetType()) {
                    case INT32: {
                        this.writer.writeByte(167);
                        break;
                    }
                    case INT64: {
                        break;
                    }
                    case FLOAT32: {
                        this.writer.writeByte(expression.isSigned() ? 180 : 181);
                        break;
                    }
                    case FLOAT64: {
                        if (expression.isReinterpret()) {
                            this.writer.writeByte(191);
                            break;
                        }
                        this.writer.writeByte(expression.isSigned() ? 185 : 186);
                    }
                }
                break;
            }
            case FLOAT32: {
                switch (expression.getTargetType()) {
                    case INT32: {
                        if (expression.isReinterpret()) {
                            this.writer.writeByte(188);
                            break;
                        }
                        this.writer.writeByte(expression.isSigned() ? 168 : 169);
                        break;
                    }
                    case INT64: {
                        this.writer.writeByte(expression.isSigned() ? 174 : 175);
                        break;
                    }
                    case FLOAT32: {
                        break;
                    }
                    case FLOAT64: {
                        this.writer.writeByte(187);
                    }
                }
                break;
            }
            case FLOAT64: {
                switch (expression.getTargetType()) {
                    case INT32: {
                        this.writer.writeByte(expression.isSigned() ? 170 : 171);
                        break block0;
                    }
                    case INT64: {
                        if (expression.isReinterpret()) {
                            this.writer.writeByte(189);
                            break block0;
                        }
                        this.writer.writeByte(expression.isSigned() ? 176 : 177);
                        break block0;
                    }
                    case FLOAT32: {
                        this.writer.writeByte(182);
                        break block0;
                    }
                }
            }
        }
        this.popLocation();
    }

    @Override
    public void visit(WasmCall expression) {
        Integer functionIndex;
        this.pushLocation(expression);
        for (WasmExpression argument : expression.getArguments()) {
            argument.acceptVisitor(this);
        }
        Integer n = functionIndex = !expression.isImported() ? this.functionIndexes.get(expression.getFunctionName()) : this.importedIndexes.get(expression.getFunctionName());
        if (functionIndex == null) {
            this.writer.writeByte(0);
            return;
        }
        this.writer.writeByte(16);
        this.writer.writeLEB(functionIndex);
        this.popLocation();
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        this.pushLocation(expression);
        for (WasmExpression argument : expression.getArguments()) {
            argument.acceptVisitor(this);
        }
        expression.getSelector().acceptVisitor(this);
        this.writer.writeByte(17);
        WasmType[] signatureTypes = new WasmType[expression.getParameterTypes().size() + 1];
        signatureTypes[0] = expression.getReturnType();
        for (int i = 0; i < expression.getParameterTypes().size(); ++i) {
            signatureTypes[i + 1] = expression.getParameterTypes().get(i);
        }
        this.writer.writeLEB(this.signatureIndexes.get(new WasmSignature(signatureTypes)));
        this.writer.writeByte(0);
        this.popLocation();
    }

    @Override
    public void visit(WasmDrop expression) {
        this.pushLocation(expression);
        expression.getOperand().acceptVisitor(this);
        this.writer.writeByte(26);
        this.popLocation();
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        switch (expression.getConvertFrom()) {
            case INT8: {
                this.writer.writeByte(44);
                break;
            }
            case UINT8: {
                this.writer.writeByte(45);
                break;
            }
            case INT16: {
                this.writer.writeByte(46);
                break;
            }
            case UINT16: {
                this.writer.writeByte(47);
                break;
            }
            case INT32: {
                this.writer.writeByte(40);
            }
        }
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        switch (expression.getConvertFrom()) {
            case INT8: {
                this.writer.writeByte(48);
                break;
            }
            case UINT8: {
                this.writer.writeByte(49);
                break;
            }
            case INT16: {
                this.writer.writeByte(50);
                break;
            }
            case UINT16: {
                this.writer.writeByte(51);
                break;
            }
            case INT32: {
                this.writer.writeByte(52);
                break;
            }
            case UINT32: {
                this.writer.writeByte(53);
                break;
            }
            case INT64: {
                this.writer.writeByte(41);
            }
        }
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        this.writer.writeByte(42);
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        this.writer.writeByte(43);
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
        switch (expression.getConvertTo()) {
            case INT8: 
            case UINT8: {
                this.writer.writeByte(58);
                break;
            }
            case INT16: 
            case UINT16: {
                this.writer.writeByte(59);
                break;
            }
            case INT32: {
                this.writer.writeByte(54);
            }
        }
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
        switch (expression.getConvertTo()) {
            case INT8: 
            case UINT8: {
                this.writer.writeByte(60);
                break;
            }
            case INT16: 
            case UINT16: {
                this.writer.writeByte(61);
                break;
            }
            case INT32: 
            case UINT32: {
                this.writer.writeByte(62);
                break;
            }
            case INT64: {
                this.writer.writeByte(55);
            }
        }
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
        this.writer.writeByte(56);
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
        this.writer.writeByte(57);
        this.writer.writeByte(this.alignment(expression.getAlignment()));
        this.writer.writeLEB(expression.getOffset());
        this.popLocation();
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        this.pushLocation(expression);
        expression.getAmount().acceptVisitor(this);
        this.writer.writeByte(64);
        this.writer.writeByte(0);
        this.popLocation();
    }

    @Override
    public void visit(WasmFill expression) {
        this.pushLocation(expression);
        expression.getIndex().acceptVisitor(this);
        expression.getValue().acceptVisitor(this);
        expression.getCount().acceptVisitor(this);
        this.writer.writeByte(252);
        this.writer.writeLEB(11);
        this.writer.writeByte(0);
    }

    @Override
    public void visit(WasmCopy expression) {
        this.pushLocation(expression);
        expression.getDestinationIndex().acceptVisitor(this);
        expression.getSourceIndex().acceptVisitor(this);
        expression.getCount().acceptVisitor(this);
        this.writer.writeByte(252);
        this.writer.writeLEB(10);
        this.writer.writeByte(0);
        this.writer.writeByte(0);
    }

    private int alignment(int value) {
        return 31 - Integer.numberOfLeadingZeros(Math.max(1, value));
    }

    private void writeLabel(WasmBlock target) {
        int blockDepth = this.blockDepths.get(target);
        this.writer.writeLEB(this.depth - blockDepth);
    }

    private void pushLocation(WasmExpression expression) {
        TextLocation location = expression.getLocation() != null ? expression.getLocation() : (this.locationStack.isEmpty() ? null : this.locationStack.get(this.locationStack.size() - 1));
        this.locationStack.add(location);
        if (location != null) {
            this.emitLocation(location);
        } else {
            this.emitDeferredLocation();
        }
    }

    private void popLocation() {
        TextLocation location = this.locationStack.remove(this.locationStack.size() - 1);
        if (location != null) {
            this.emitLocation(location);
        }
    }

    private void emitLocation(TextLocation location) {
        if (this.deferTextLocationToEmit) {
            if (location != null) {
                this.textLocationToEmit = location;
                this.deferTextLocationToEmit = false;
            } else {
                return;
            }
        }
        this.flushLocation();
        this.textLocationToEmit = location;
    }

    private void emitDeferredLocation() {
        if (this.textLocationToEmit != null) {
            this.flushLocation();
        }
        this.textLocationToEmit = null;
        this.deferTextLocationToEmit = true;
    }

    public void endLocation() {
        this.textLocationToEmit = null;
        this.deferTextLocationToEmit = false;
        this.flushLocation();
        if (this.debugLines != null) {
            this.debugLines.advance(this.writer.getPosition() + this.addressOffset);
            this.debugLines.end();
        }
    }

    private void flushLocation() {
        if (this.writer.getPosition() != this.positionToEmit) {
            if (!Objects.equals(this.lastEmittedLocation, this.textLocationToEmit)) {
                this.doEmitLocation();
            }
            this.lastEmittedLocation = this.textLocationToEmit;
            this.positionToEmit = this.writer.getPosition();
        }
    }

    private void doEmitLocation() {
        int address = this.positionToEmit + this.addressOffset;
        if (this.dwarfGenerator != null) {
            if (this.textLocationToEmit == null || this.textLocationToEmit.getFileName() == null) {
                this.dwarfGenerator.endLineNumberSequence(address);
            } else {
                this.dwarfGenerator.lineNumber(address, this.textLocationToEmit.getFileName(), this.textLocationToEmit.getLine());
            }
        }
        if (this.debugLines != null) {
            int commonPart;
            InliningInfo inlining;
            this.debugLines.advance(address);
            TextLocation loc = this.textLocationToEmit;
            InliningInfo inliningInfo = inlining = loc != null ? loc.getInlining() : null;
            while (inlining != null) {
                this.currentMethodStack.add(loc.getInlining().getMethod());
                inlining = inlining.getParent();
            }
            Collections.reverse(this.currentMethodStack);
            for (commonPart = 0; commonPart < this.currentMethodStack.size() && commonPart < this.methodStack.size() && this.currentMethodStack.get(commonPart).equals(this.methodStack.get(commonPart)); ++commonPart) {
            }
            while (this.methodStack.size() > commonPart) {
                this.debugLines.end();
                this.methodStack.remove(this.methodStack.size() - 1);
            }
            while (commonPart < this.currentMethodStack.size()) {
                MethodReference method = this.currentMethodStack.get(commonPart++);
                this.methodStack.add(method);
                this.debugLines.start(method);
            }
            this.currentMethodStack.clear();
            if (loc != null) {
                this.debugLines.location(loc.getFileName(), loc.getLine());
            } else {
                this.debugLines.emptyLocation();
            }
        }
    }
}

