/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.blob;

import org.teavm.backend.wasm.blob.BinaryDataConsumer;
import org.teavm.backend.wasm.blob.Blob;

public class BlobReader {
    private Blob blob;
    private BinaryDataConsumer consumer;
    private int ptr;
    private int currentChunk;
    private int offsetInChunk;

    BlobReader(Blob blob, BinaryDataConsumer consumer) {
        this.blob = blob;
        this.consumer = consumer;
    }

    public int position() {
        return this.ptr;
    }

    public void readRemaining() {
        this.advance(this.blob.size());
    }

    public void advance(int to) {
        if (to < this.ptr || to > this.blob.size()) {
            throw new IllegalArgumentException();
        }
        if (to == this.ptr) {
            return;
        }
        int ptr = this.ptr;
        int currentChunk = this.currentChunk;
        int offsetInChunk = this.offsetInChunk;
        while (ptr < to) {
            byte[] chunk = this.blob.chunkAt(currentChunk);
            int limit = Math.min(ptr + chunk.length - offsetInChunk, to);
            int bytesToWrite = limit - ptr;
            this.consumer.accept(chunk, offsetInChunk, offsetInChunk + bytesToWrite);
            ptr += bytesToWrite;
            if ((offsetInChunk += bytesToWrite) != chunk.length) continue;
            offsetInChunk = 0;
            ++currentChunk;
        }
        this.ptr = ptr;
        this.currentChunk = currentChunk;
        this.offsetInChunk = offsetInChunk;
    }
}

