/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.templating;

import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.templating.SourceFragment;
import org.teavm.backend.javascript.templating.TemplatingAstTransformer;
import org.teavm.backend.javascript.templating.TemplatingAstWriter;
import org.teavm.backend.javascript.templating.TemplatingFunctionIndex;
import org.teavm.model.ClassReaderSource;
import org.teavm.rhino.javascript.Node;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.FunctionNode;
import org.teavm.rhino.javascript.ast.Name;
import org.teavm.rhino.javascript.ast.Scope;

public class JavaScriptTemplate {
    private TemplatingFunctionIndex functionIndex = new TemplatingFunctionIndex();

    public JavaScriptTemplate(AstNode node, ClassReaderSource classSource) {
        new TemplatingAstTransformer(classSource).visit(node);
        this.functionIndex.visit(node);
    }

    public FragmentBuilder builder(String functionName) {
        FunctionNode function = this.functionIndex.getFunction(functionName);
        if (function == null) {
            throw new IllegalArgumentException("Function " + functionName + " was not found in JS template");
        }
        return new FragmentBuilder(function);
    }

    public static class FragmentBuilder {
        private FunctionNode node;
        private IntFunction<SourceFragment> parameters;
        private Map<String, SourceFragment> fragments = new HashMap<String, SourceFragment>();

        private FragmentBuilder(FunctionNode node) {
            this.node = node;
        }

        public FragmentBuilder withParameters(IntFunction<SourceFragment> parameters) {
            this.parameters = parameters;
            return this;
        }

        public FragmentBuilder withContext(GeneratorContext context) {
            return this.withParameters(param -> (writer, precedence) -> writer.append(context.getParameterName(param)));
        }

        public FragmentBuilder withFragment(String name, SourceFragment fragment) {
            this.fragments.put(name, fragment);
            return this;
        }

        public SourceFragment build() {
            IntFunction<SourceFragment> intParameters = this.parameters;
            HashMap<String, SourceFragment> nameParameters = new HashMap<String, SourceFragment>();
            for (int i = 0; i < this.node.getParams().size(); ++i) {
                AstNode param = (AstNode)this.node.getParams().get(i);
                if (!(param instanceof Name)) continue;
                nameParameters.put(((Name)param).getIdentifier(), intParameters.apply(i + 1));
            }
            SourceFragment thisFragment = this.parameters.apply(0);
            AstNode body = this.node.getBody();
            return (writer, precedence) -> {
                TemplatingAstWriter astWriter = new TemplatingAstWriter(writer, nameParameters, (Scope)this.node, null);
                for (Map.Entry<String, SourceFragment> entry : this.fragments.entrySet()) {
                    astWriter.setFragment(entry.getKey(), entry.getValue());
                }
                if (this.node.getSymbolTable() != null) {
                    for (String name : this.node.getSymbolTable().keySet()) {
                        astWriter.currentScopes.put(name, this.node);
                    }
                }
                if (thisFragment != null) {
                    astWriter.declareNameEmitter("this", thisPrecedence -> thisFragment.write(writer, thisPrecedence));
                }
                for (Node child = body.getFirstChild(); child != null; child = child.getNext()) {
                    astWriter.print((AstNode)child);
                    writer.softNewLine();
                }
            };
        }
    }
}

