/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.codegen.SourceWriterSink;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class NameFrequencyEstimator
implements SourceWriterSink {
    static final MethodReference MONITOR_ENTER_METHOD = new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE);
    static final MethodReference MONITOR_ENTER_SYNC_METHOD = new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE);
    static final MethodReference MONITOR_EXIT_METHOD = new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE);
    static final MethodReference MONITOR_EXIT_SYNC_METHOD = new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE);
    private Map<String, Entry> entries = new HashMap<String, Entry>();
    private Set<String> reservedNames = new HashSet<String>();

    @Override
    public SourceWriterSink appendClass(String cls) {
        String key = "c:" + cls;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameFor(cls);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    @Override
    public SourceWriterSink appendField(FieldReference field) {
        String key = "f:" + field;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameFor(field);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    @Override
    public SourceWriterSink appendStaticField(FieldReference field) {
        String key = "sf:" + field;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getFullNameFor(field);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    @Override
    public SourceWriterSink appendMethod(MethodDescriptor method) {
        String key = "r:" + method;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameFor(method);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    @Override
    public SourceWriterSink appendMethodBody(MethodReference method) {
        String key = "R:" + method;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getFullNameFor(method);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    @Override
    public SourceWriterSink appendFunction(String name) {
        String key = "n:" + name;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameForFunction(name);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    @Override
    public SourceWriterSink appendGlobal(String name) {
        this.reservedNames.add(name);
        return this;
    }

    @Override
    public SourceWriterSink appendInit(MethodReference method) {
        String key = "I:" + method;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameForInit(method);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    @Override
    public SourceWriterSink appendClassInit(String className) {
        String key = "C:" + className;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameForClassInit(className);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
        return this;
    }

    public void apply(NamingStrategy naming) {
        for (String name : this.reservedNames) {
            naming.reserveName(name);
        }
        ArrayList<Entry> entryList = new ArrayList<Entry>(this.entries.values());
        entryList.sort((o1, o2) -> Integer.compare(o2.frequency, o1.frequency));
        for (Entry entry : entryList) {
            entry.operation.perform(naming);
        }
    }

    private static class Entry {
        NamingOperation operation;
        int frequency;

        private Entry() {
        }
    }

    private static interface NamingOperation {
        public void perform(NamingStrategy var1);
    }
}

