/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.util.Date;
import java.util.function.Function;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.parsing.ClassDateProvider;
import org.teavm.parsing.ClasspathResourceMapper;
import org.teavm.parsing.resource.ClasspathResourceReader;
import org.teavm.parsing.resource.MapperClassHolderSource;
import org.teavm.parsing.resource.ResourceClassHolderMapper;

public class ClasspathClassHolderSource
implements ClassHolderSource,
ClassDateProvider {
    private MapperClassHolderSource innerClassSource;
    private ClasspathResourceMapper classPathMapper;

    public ClasspathClassHolderSource(ClassLoader classLoader, ReferenceCache referenceCache) {
        ClasspathResourceReader reader = new ClasspathResourceReader(classLoader);
        ResourceClassHolderMapper rawMapper = new ResourceClassHolderMapper(reader, referenceCache);
        this.classPathMapper = new ClasspathResourceMapper(classLoader, referenceCache, (Function<String, ClassHolder>)rawMapper);
        this.innerClassSource = new MapperClassHolderSource(this.classPathMapper);
    }

    public ClasspathClassHolderSource(ReferenceCache referenceCache) {
        this(ClasspathClassHolderSource.class.getClassLoader(), referenceCache);
    }

    @Override
    public ClassHolder get(String name) {
        return this.innerClassSource.get(name);
    }

    @Override
    public Date getModificationDate(String className) {
        return this.classPathMapper.getModificationDate(className);
    }
}

