/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.teavm.model.PrimitiveType;

public abstract class ValueType
implements Serializable {
    private static final Map<Class<?>, ValueType> primitiveMap = new HashMap();
    public static final Void VOID = new Void();
    public static final Primitive BOOLEAN = new Primitive(PrimitiveType.BOOLEAN, ValueType.object(Boolean.class.getName()));
    public static final Primitive BYTE = new Primitive(PrimitiveType.BYTE, ValueType.object(Byte.class.getName()));
    public static final Primitive SHORT = new Primitive(PrimitiveType.SHORT, ValueType.object(Short.class.getName()));
    public static final Primitive INTEGER = new Primitive(PrimitiveType.INTEGER, ValueType.object(Integer.class.getName()));
    public static final Primitive FLOAT = new Primitive(PrimitiveType.FLOAT, ValueType.object(Float.class.getName()));
    public static final Primitive LONG = new Primitive(PrimitiveType.LONG, ValueType.object(Long.class.getName()));
    public static final Primitive DOUBLE = new Primitive(PrimitiveType.DOUBLE, ValueType.object(Double.class.getName()));
    public static final Primitive CHARACTER = new Primitive(PrimitiveType.CHARACTER, ValueType.object(Character.class.getName()));

    private ValueType() {
    }

    public static Object object(String cls) {
        return new Object(cls);
    }

    public static ValueType arrayOf(ValueType type) {
        return new Array(type);
    }

    public static ValueType primitive(PrimitiveType type) {
        switch (type) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTE: {
                return BYTE;
            }
            case CHARACTER: {
                return CHARACTER;
            }
            case SHORT: {
                return SHORT;
            }
            case INTEGER: {
                return INTEGER;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new AssertionError((java.lang.Object)("Unknown primitive type " + String.valueOf(type)));
    }

    public static ValueType[] parseMany(String text) {
        ValueType[] types = ValueType.parseManyIfPossible(text);
        if (types == null) {
            throw new IllegalArgumentException("Illegal method type signature: " + text);
        }
        return types;
    }

    public static ValueType[] parseManyIfPossible(String text) {
        ArrayList<ValueType> types = new ArrayList<ValueType>();
        int index = 0;
        while (index < text.length()) {
            int nextIndex = ValueType.cut(text, index);
            ValueType type = ValueType.parseIfPossible(text.substring(index, nextIndex));
            if (type == null) {
                return null;
            }
            types.add(type);
            index = nextIndex;
        }
        return types.toArray(new ValueType[0]);
    }

    private static int cut(String text, int index) {
        while (text.charAt(index) == '[') {
            if (++index < text.length()) continue;
            return index;
        }
        if (text.charAt(index) != 'L') {
            return index + 1;
        }
        while (text.charAt(index) != ';') {
            if (++index < text.length()) continue;
            return index;
        }
        return index + 1;
    }

    public static ValueType parse(String string) {
        ValueType type = ValueType.parseIfPossible(string);
        if (type == null) {
            throw new IllegalArgumentException("Illegal type signature: " + string);
        }
        return type;
    }

    public static ValueType parseIfPossible(String string) {
        int arrayDegree = 0;
        int left = 0;
        while (string.charAt(left) == '[') {
            ++arrayDegree;
            ++left;
        }
        if ((string = string.substring(left)).isEmpty()) {
            return null;
        }
        ValueType type = ValueType.parseImpl(string);
        if (type == null) {
            return null;
        }
        while (arrayDegree-- > 0) {
            type = ValueType.arrayOf(type);
        }
        return type;
    }

    public static String manyToString(ValueType[] types) {
        StringBuilder sb = new StringBuilder();
        for (ValueType type : types) {
            sb.append(type);
        }
        return sb.toString();
    }

    public static String methodTypeToString(ValueType[] types) {
        return "(" + Arrays.stream(types, 0, types.length - 1).map(java.lang.Object::toString).collect(Collectors.joining()) + ")" + String.valueOf(types[types.length - 1]);
    }

    public abstract boolean isObject(String var1);

    public boolean isObject(Class<?> cls) {
        return this.isObject(cls.getName());
    }

    private static ValueType parseImpl(String string) {
        switch (string.charAt(0)) {
            case 'Z': {
                return ValueType.primitive(PrimitiveType.BOOLEAN);
            }
            case 'B': {
                return ValueType.primitive(PrimitiveType.BYTE);
            }
            case 'S': {
                return ValueType.primitive(PrimitiveType.SHORT);
            }
            case 'I': {
                return ValueType.primitive(PrimitiveType.INTEGER);
            }
            case 'J': {
                return ValueType.primitive(PrimitiveType.LONG);
            }
            case 'F': {
                return ValueType.primitive(PrimitiveType.FLOAT);
            }
            case 'D': {
                return ValueType.primitive(PrimitiveType.DOUBLE);
            }
            case 'C': {
                return ValueType.primitive(PrimitiveType.CHARACTER);
            }
            case 'V': {
                return VOID;
            }
            case 'L': {
                if (!string.endsWith(";")) {
                    return null;
                }
                return ValueType.object(string.substring(1, string.length() - 1).replace('/', '.'));
            }
        }
        return null;
    }

    public boolean isSubtypeOf(ValueType supertype) {
        if (supertype instanceof Object) {
            return !(this instanceof Primitive);
        }
        if (supertype instanceof Array && this instanceof Array) {
            return ((Array)this).getItemType().isSubtypeOf(((Array)supertype).getItemType());
        }
        return false;
    }

    public static ValueType parse(Class<?> cls) {
        if (cls.isPrimitive()) {
            return primitiveMap.get(cls);
        }
        if (cls.getComponentType() != null) {
            return ValueType.arrayOf(ValueType.parse(cls.getComponentType()));
        }
        return ValueType.object(cls.getName());
    }

    static {
        primitiveMap.put(Boolean.TYPE, BOOLEAN);
        primitiveMap.put(Character.TYPE, CHARACTER);
        primitiveMap.put(Byte.TYPE, BYTE);
        primitiveMap.put(Short.TYPE, SHORT);
        primitiveMap.put(Integer.TYPE, INTEGER);
        primitiveMap.put(Long.TYPE, LONG);
        primitiveMap.put(Float.TYPE, FLOAT);
        primitiveMap.put(Double.TYPE, DOUBLE);
        primitiveMap.put(java.lang.Void.TYPE, VOID);
    }

    public static class Object
    extends ValueType {
        private String className;
        private transient int hash;

        public Object(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return "L" + this.className.replace('.', '/') + ";";
        }

        @Override
        public boolean isObject(String className) {
            return this.className.equals(className);
        }

        public boolean equals(java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Object)) {
                return false;
            }
            Object that = (Object)obj;
            return that.className.equals(this.className);
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = 0x5170B48 ^ this.className.hashCode() * 167;
                if (this.hash == 0) {
                    ++this.hash;
                }
            }
            return this.hash;
        }
    }

    public static class Array
    extends ValueType {
        private ValueType itemType;
        private transient int hash;

        public Array(ValueType itemType) {
            this.itemType = itemType;
        }

        public ValueType getItemType() {
            return this.itemType;
        }

        public String toString() {
            return "[" + String.valueOf(this.itemType);
        }

        @Override
        public boolean isObject(String cls) {
            return false;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Array)) {
                return false;
            }
            Array that = (Array)obj;
            return this.itemType.equals(that.itemType);
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = 0x19C9884 ^ this.itemType.hashCode() * 193;
                if (this.hash == 0) {
                    ++this.hash;
                }
            }
            return this.hash;
        }
    }

    public static class Primitive
    extends ValueType {
        private PrimitiveType kind;
        private final Object boxedType;
        private int hash;

        private Primitive(PrimitiveType kind, Object boxedType) {
            this.kind = kind;
            this.boxedType = boxedType;
            this.hash = 0x1127CAE ^ kind.ordinal() * 31;
        }

        public PrimitiveType getKind() {
            return this.kind;
        }

        public Object getBoxedType() {
            return this.boxedType;
        }

        public String toString() {
            switch (this.kind) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case INTEGER: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case FLOAT: {
                    return "F";
                }
                case CHARACTER: {
                    return "C";
                }
                case DOUBLE: {
                    return "D";
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isObject(String cls) {
            return false;
        }

        public boolean equals(java.lang.Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static class Void
    extends ValueType {
        private Void() {
        }

        public String toString() {
            return "V";
        }

        @Override
        public boolean isObject(String cls) {
            return false;
        }

        public boolean equals(java.lang.Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 53604390;
        }
    }
}

