/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import org.teavm.asm.ClassReader;
import org.teavm.asm.ClassVisitor;
import org.teavm.asm.tree.ClassNode;
import org.teavm.cache.IncrementalDependencyProvider;
import org.teavm.cache.IncrementalDependencyRegistration;
import org.teavm.callgraph.CallGraph;
import org.teavm.common.CachedFunction;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.ClassClosureAnalyzer;
import org.teavm.dependency.ClassDependency;
import org.teavm.dependency.ClassSourcePacker;
import org.teavm.dependency.DefaultCallGraph;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyAnalyzerInterruptor;
import org.teavm.dependency.DependencyClassSource;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DependencyTypeFilter;
import org.teavm.dependency.DynamicCallSite;
import org.teavm.dependency.ExactTypeFilter;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.PluggableDependency;
import org.teavm.dependency.SuperArrayFilter;
import org.teavm.dependency.SuperClassFilter;
import org.teavm.dependency.Transition;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.cursors.IntCursor;
import org.teavm.interop.PlatformMarker;
import org.teavm.model.AnnotationReader;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ReferenceCache;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.BasicBlockSplitter;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;
import org.teavm.parsing.Parser;

public abstract class DependencyAnalyzer
implements DependencyInfo {
    private static final int PROPAGATION_STACK_THRESHOLD = 50;
    private static final MethodDescriptor CLINIT_METHOD = new MethodDescriptor("<clinit>", Void.TYPE);
    static final boolean shouldLog = System.getProperty("org.teavm.logDependencies", "false").equals("true");
    static final boolean shouldTag = System.getProperty("org.teavm.tagDependencies", "false").equals("true") || shouldLog;
    static final boolean dependencyReport = System.getProperty("org.teavm.dependencyReport", "false").equals("true");
    private int classNameSuffix;
    private ClassReaderSource unprocessedClassSource;
    private DependencyClassSource classSource;
    ClassReaderSource agentClassSource;
    private ClassLoader classLoader;
    private Map<String, Map<MethodDescriptor, Optional<MethodHolder>>> methodReaderCache = new HashMap<String, Map<MethodDescriptor, Optional<MethodHolder>>>(1000, 0.5f);
    private Map<MethodReference, MethodDependency> implementationCache = new HashMap<MethodReference, MethodDependency>();
    private Function<FieldReference, FieldHolder> fieldReaderCache;
    private Map<String, Map<MethodDescriptor, MethodDependency>> methodCache = new HashMap<String, Map<MethodDescriptor, MethodDependency>>();
    private Set<MethodReference> reachedMethods = new LinkedHashSet<MethodReference>();
    private Set<MethodReference> readonlyReachedMethods = Collections.unmodifiableSet(this.reachedMethods);
    private CachedFunction<FieldReference, FieldDependency> fieldCache;
    private CachedFunction<String, ClassDependency> classCache;
    private List<DependencyListener> listeners = new ArrayList<DependencyListener>();
    private ServiceRepository services;
    private Deque<Transition> pendingTransitions = new ArrayDeque<Transition>();
    private Deque<Runnable> tasks = new ArrayDeque<Runnable>();
    private Queue<Runnable> deferredTasks = new ArrayDeque<Runnable>();
    List<DependencyType> types = new ArrayList<DependencyType>();
    private Map<String, DependencyType> typeMap = new HashMap<String, DependencyType>();
    private DependencyAnalyzerInterruptor interruptor;
    private boolean interrupted;
    private Diagnostics diagnostics;
    DefaultCallGraph callGraph = new DefaultCallGraph();
    private DependencyAgent agent;
    Map<MethodReference, BootstrapMethodSubstitutor> bootstrapMethodSubstitutors = new HashMap<MethodReference, BootstrapMethodSubstitutor>();
    Map<MethodReference, DependencyPlugin> dependencyPlugins = new HashMap<MethodReference, DependencyPlugin>();
    private boolean completing;
    private Map<String, DependencyTypeFilter> superClassFilters = new HashMap<String, DependencyTypeFilter>();
    private List<DependencyNode> allNodes = new ArrayList<DependencyNode>();
    private ClassHierarchy classHierarchy;
    IncrementalCache incrementalCache = new IncrementalCache();
    boolean asyncSupported;
    private ReferenceCache referenceCache;
    private Set<String> generatedClassNames = new HashSet<String>();
    DependencyType classType;
    private int propagationDepth;

    DependencyAnalyzer(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Diagnostics diagnostics, ReferenceCache referenceCache) {
        this.unprocessedClassSource = classSource;
        this.diagnostics = diagnostics;
        this.referenceCache = referenceCache;
        this.classSource = new DependencyClassSource(classSource, diagnostics, this.incrementalCache);
        this.agentClassSource = this.classSource;
        this.classHierarchy = new ClassHierarchy(this.classSource);
        this.classLoader = classLoader;
        this.services = services;
        this.fieldReaderCache = new CachedFunction<FieldReference, FieldHolder>(preimage -> this.classSource.resolveMutable((FieldReference)preimage));
        this.fieldCache = new CachedFunction<FieldReference, FieldDependency>(preimage -> {
            FieldReader field = this.fieldReaderCache.apply((FieldReference)preimage);
            if (field != null && !field.getReference().equals(preimage)) {
                return this.fieldCache.apply(field.getReference());
            }
            FieldDependency node = this.createFieldNode((FieldReference)preimage, field);
            if (field != null && field.getInitialValue() instanceof String) {
                node.getValue().propagate(this.getType("java.lang.String"));
            }
            return node;
        });
        this.classCache = new CachedFunction<String, ClassDependency>(this::createClassDependency);
        this.agent = new DependencyAgent(this);
        this.classType = this.getType("java.lang.Class");
    }

    public void setObfuscated(boolean obfuscated) {
        this.classSource.obfuscated = obfuscated;
    }

    public void setStrict(boolean strict) {
        this.classSource.strict = strict;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public DependencyAgent getAgent() {
        return this.agent;
    }

    public DependencyAnalyzerInterruptor getInterruptor() {
        return this.interruptor;
    }

    public void setInterruptor(DependencyAnalyzerInterruptor interruptor) {
        this.interruptor = interruptor;
    }

    public boolean wasInterrupted() {
        return this.interrupted;
    }

    public DependencyType getType(String name) {
        DependencyType type = this.typeMap.get(name);
        if (type == null) {
            type = new DependencyType(this, name, this.types.size());
            this.types.add(type);
            this.typeMap.put(name, type);
        }
        return type;
    }

    public DependencyNode createNode() {
        return this.createNode(null);
    }

    DependencyNode createNode(ValueType typeFilter) {
        if (typeFilter != null && typeFilter.isObject("java.lang.Object")) {
            typeFilter = null;
        }
        DependencyNode node = new DependencyNode(this, typeFilter);
        this.allNodes.add(node);
        return node;
    }

    @Override
    public ClassReaderSource getClassSource() {
        return this.classSource != null ? this.classSource : this.agentClassSource;
    }

    public ClassReaderSource getUnprocessedClassSource() {
        return this.unprocessedClassSource;
    }

    public boolean isSynthesizedClass(String className) {
        return this.classSource != null ? this.classSource.isGeneratedClass(className) : this.generatedClassNames.contains(className);
    }

    public ClassHierarchy getClassHierarchy() {
        return this.classHierarchy;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String generateClassName() {
        return "$$teavm_generated_class$$" + this.classNameSuffix++;
    }

    public String submitClassFile(byte[] data) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(data);
        reader.accept((ClassVisitor)node, 0);
        this.submitClass(new Parser(this.referenceCache).parseClass(node));
        return node.name;
    }

    public void submitClass(ClassHolder cls) {
        if (this.completing) {
            throw new IllegalStateException("Can't submit class during completion phase");
        }
        this.classSource.submit(ModelUtils.copyClass(cls));
    }

    public void submitMethod(MethodReference methodRef, Program program) {
        if (!this.completing) {
            ClassHolder cls = this.classSource.get(methodRef.getClassName());
            if (cls == null) {
                throw new IllegalArgumentException("Class not found: " + methodRef.getClassName());
            }
            if (cls.getMethod(methodRef.getDescriptor()) != null) {
                throw new IllegalArgumentException("Method already exists: " + methodRef.getClassName());
            }
            MethodHolder method = new MethodHolder(methodRef.getDescriptor());
            method.getModifiers().add(ElementModifier.STATIC);
            method.setProgram(ProgramUtils.copy(program));
            new UnreachableBasicBlockEliminator().optimize(program);
            cls.addMethod(method);
        } else {
            MethodDependency dep = this.getMethod(methodRef);
            if (dep == null) {
                throw new IllegalArgumentException("Method was not reached: " + String.valueOf(methodRef));
            }
            MethodHolder method = dep.method;
            if (!method.hasModifier(ElementModifier.NATIVE)) {
                throw new IllegalArgumentException("Method is not native: " + String.valueOf(methodRef));
            }
            if (!dep.used) {
                return;
            }
            method.getModifiers().remove((Object)ElementModifier.NATIVE);
            method.setProgram(ProgramUtils.copy(program));
            new UnreachableBasicBlockEliminator().optimize(method.getProgram());
            dep.used = false;
            this.lock(dep, false);
            this.deferredTasks.add(() -> {
                this.processInvokeDynamic(dep);
                this.processMethod(dep);
                dep.used = true;
            });
            this.processQueue();
        }
    }

    protected abstract void processMethod(MethodDependency var1);

    public void addDependencyListener(DependencyListener listener) {
        this.listeners.add(listener);
        listener.started(this.agent);
    }

    public void addClassTransformer(ClassHolderTransformer transformer) {
        this.classSource.addTransformer(transformer);
    }

    public void addEntryPoint(MethodReference methodRef, String ... argumentTypes) {
        ValueType[] parameters = methodRef.getDescriptor().getParameterTypes();
        if (parameters.length + 1 != argumentTypes.length) {
            throw new IllegalArgumentException("argumentTypes length does not match the number of method's arguments");
        }
        MethodDependency method = this.linkMethod(methodRef);
        method.use();
        DependencyNode[] varNodes = method.getVariables();
        varNodes[0].propagate(this.getType(methodRef.getClassName()));
        for (int i = 0; i < argumentTypes.length; ++i) {
            varNodes[i + 1].propagate(this.getType(argumentTypes[i]));
        }
    }

    void schedulePropagation(DependencyConsumer consumer, DependencyType type) {
        if (this.propagationDepth < 50) {
            ++this.propagationDepth;
            consumer.consume(type);
            --this.propagationDepth;
        } else {
            this.tasks.add(() -> consumer.consume(type));
        }
    }

    void schedulePropagation(Transition consumer, DependencyType type) {
        if (!consumer.destination.filter(type)) {
            return;
        }
        if (consumer.pendingTypes == null && this.propagationDepth < 50 && consumer.pointsToDomainOrigin() && consumer.destination.propagateCount < 20) {
            ++this.propagationDepth;
            consumer.consume(type);
            --this.propagationDepth;
        } else {
            if (consumer.pendingTypes == null) {
                this.pendingTransitions.add(consumer);
                consumer.pendingTypes = new IntHashSet(50);
            }
            consumer.pendingTypes.add(type.index);
        }
    }

    void schedulePropagation(Transition consumer, DependencyType[] types) {
        if (types.length == 0) {
            return;
        }
        if (types.length == 1) {
            this.schedulePropagation(consumer, types[0]);
            return;
        }
        if (consumer.pendingTypes == null && this.propagationDepth < 50 && consumer.pointsToDomainOrigin() && consumer.destination.propagateCount < 20) {
            ++this.propagationDepth;
            consumer.consume(types);
            --this.propagationDepth;
        } else {
            if (consumer.pendingTypes == null) {
                this.pendingTransitions.add(consumer);
                consumer.pendingTypes = new IntHashSet(Math.max(50, types.length));
            }
            consumer.pendingTypes.ensureCapacity(types.length + consumer.pendingTypes.size());
            for (DependencyType type : types) {
                consumer.pendingTypes.add(type.index);
            }
        }
    }

    void schedulePropagation(DependencyConsumer consumer, DependencyType[] types) {
        if (types.length == 0) {
            return;
        }
        if (types.length == 1) {
            this.schedulePropagation(consumer, types[0]);
            return;
        }
        if (this.propagationDepth < 50) {
            ++this.propagationDepth;
            for (DependencyType type : types) {
                consumer.consume(type);
            }
            --this.propagationDepth;
        } else {
            this.tasks.add(() -> {
                for (DependencyType type : types) {
                    consumer.consume(type);
                }
            });
        }
    }

    public void defer(Runnable task) {
        this.deferredTasks.add(task);
    }

    public ClassDependency linkClass(String className) {
        if (this.completing && this.getClass(className) == null) {
            throw new IllegalStateException("Can't link class during completion phase");
        }
        ClassDependency dep = this.classCache.apply(className);
        if (!dep.activated) {
            dep.activated = true;
            if (!dep.isMissing()) {
                this.deferredTasks.add(() -> {
                    for (DependencyListener listener : this.listeners) {
                        listener.classReached(this.agent, className);
                    }
                });
                org.teavm.model.ClassReader cls = dep.getClassReader();
                if (cls.getParent() != null && !this.classCache.caches(cls.getParent())) {
                    this.linkClass(cls.getParent());
                }
                for (String iface : cls.getInterfaces()) {
                    if (this.classCache.caches(iface)) continue;
                    this.linkClass(iface);
                }
            }
        }
        return dep;
    }

    private ClassDependency createClassDependency(String className) {
        ClassHolder cls = this.classSource.get(className);
        return new ClassDependency(this, className, cls);
    }

    public MethodDependency linkMethod(String className, MethodDescriptor descriptor) {
        MethodDependency dep = this.getMethodDependency(className, descriptor);
        if (!dep.activated) {
            this.reachedMethods.add(dep.getReference());
            dep.activated = true;
            if (!dep.isMissing()) {
                for (DependencyListener listener : this.listeners) {
                    listener.methodReached(this.agent, dep);
                }
                this.activateDependencyPlugin(dep);
            }
        }
        return dep;
    }

    public MethodDependency linkMethod(MethodReference method) {
        return this.linkMethod(method.getClassName(), method.getDescriptor());
    }

    void initClass(ClassDependency cls, CallLocation location) {
        org.teavm.model.ClassReader reader = cls.getClassReader();
        MethodReader method = reader.getMethod(CLINIT_METHOD);
        if (method != null) {
            this.deferredTasks.add(() -> {
                MethodDependency initMethod = this.linkMethod(method.getReference());
                if (location != null) {
                    initMethod.addLocation(location);
                }
                initMethod.use();
            });
        }
    }

    private MethodDependency createMethodDep(MethodReference methodRef, MethodHolder method) {
        ValueType[] arguments = methodRef.getParameterTypes();
        int paramCount = arguments.length + 1;
        DependencyNode[] parameterNodes = new DependencyNode[arguments.length + 1];
        parameterNodes[0] = this.createParameterNode(methodRef, ValueType.object(methodRef.getClassName()), 0);
        for (int i = 0; i < arguments.length; ++i) {
            parameterNodes[i + 1] = this.createParameterNode(methodRef, arguments[i], i + 1);
        }
        DependencyNode resultNode = methodRef.getDescriptor().getResultType() == ValueType.VOID ? null : this.createResultNode(methodRef);
        DependencyNode thrown = this.createThrownNode(methodRef);
        MethodDependency dep = new MethodDependency(this, parameterNodes, paramCount, resultNode, thrown, method, methodRef);
        if (method != null) {
            this.deferredTasks.add(() -> this.linkClass(dep.getMethod().getOwnerName()).initClass(new CallLocation(dep.getMethod().getReference())));
        }
        return dep;
    }

    abstract DependencyNode createParameterNode(MethodReference var1, ValueType var2, int var3);

    abstract DependencyNode createResultNode(MethodReference var1);

    abstract DependencyNode createThrownNode(MethodReference var1);

    abstract DependencyNode createFieldNode(FieldReference var1, ValueType var2);

    abstract DependencyNode createArrayItemNode(DependencyNode var1);

    abstract DependencyNode createClassValueNode(int var1, DependencyNode var2);

    void scheduleMethodAnalysis(MethodDependency dep) {
        this.deferredTasks.add(() -> {
            this.processInvokeDynamic(dep);
            this.processMethod(dep);
        });
    }

    @Override
    public Collection<MethodReference> getReachableMethods() {
        return this.readonlyReachedMethods;
    }

    @Override
    public Collection<FieldReference> getReachableFields() {
        return this.fieldCache.getCachedPreimages();
    }

    @Override
    public Collection<String> getReachableClasses() {
        return this.classCache.getCachedPreimages();
    }

    public FieldDependency linkField(FieldReference fieldRef) {
        FieldDependency dep = this.fieldCache.apply(fieldRef);
        if (!dep.activated) {
            dep.activated = true;
            if (!dep.isMissing()) {
                for (DependencyListener listener : this.listeners) {
                    listener.fieldReached(this.agent, dep);
                }
            }
        }
        return dep;
    }

    @Override
    public FieldDependency getField(FieldReference fieldRef) {
        return this.fieldCache.getKnown(fieldRef);
    }

    @Override
    public ClassDependency getClass(String className) {
        return this.classCache.getKnown(className);
    }

    private FieldDependency createFieldNode(FieldReference fieldRef, FieldReader field) {
        DependencyNode node = this.createFieldNode(fieldRef, field != null ? field.getType() : null);
        return new FieldDependency(node, field, fieldRef);
    }

    private void activateDependencyPlugin(MethodDependency methodDep) {
        this.attachDependencyPlugin(methodDep);
        if (methodDep.dependencyPlugin != null) {
            methodDep.dependencyPlugin.methodReached(this.agent, methodDep);
        }
    }

    private void attachDependencyPlugin(MethodDependency methodDep) {
        Class<?> depClass;
        if (methodDep.dependencyPluginAttached) {
            return;
        }
        methodDep.dependencyPluginAttached = true;
        methodDep.dependencyPlugin = this.dependencyPlugins.get(methodDep.getReference());
        if (methodDep.dependencyPlugin != null || DependencyAnalyzer.isBootstrap()) {
            return;
        }
        AnnotationReader depAnnot = methodDep.getMethod().getAnnotations().get(PluggableDependency.class.getName());
        if (depAnnot == null) {
            return;
        }
        ValueType depType = depAnnot.getValue("value").getJavaClass();
        String depClassName = ((ValueType.Object)depType).getClassName();
        try {
            depClass = Class.forName(depClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dependency plugin not found: " + depClassName, e);
        }
        try {
            methodDep.dependencyPlugin = (DependencyPlugin)depClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can't instantiate dependency plugin " + depClassName, e);
        }
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }

    @Override
    public MethodDependency getMethod(MethodReference methodRef) {
        return this.getMethod(methodRef.getClassName(), methodRef.getDescriptor());
    }

    public MethodDependency getMethod(String className, MethodDescriptor descriptor) {
        Map<MethodDescriptor, MethodDependency> map = this.methodCache.get(className);
        if (map == null) {
            return null;
        }
        return map.get(descriptor);
    }

    @Override
    public MethodDependency getMethodImplementation(MethodReference methodRef) {
        return this.implementationCache.computeIfAbsent(methodRef, m -> {
            MethodReader resolved = this.agentClassSource.resolveImplementation((MethodReference)m);
            return resolved != null ? this.getMethod(resolved.getReference()) : null;
        });
    }

    private MethodHolder getMethodHolder(String className, MethodDescriptor descriptor) {
        return this.methodReaderCache.computeIfAbsent(className, k -> new HashMap(100, 0.5f)).computeIfAbsent(descriptor, k -> Optional.ofNullable(this.classSource.resolveMutableImplementation(className, (MethodDescriptor)k))).orElse(null);
    }

    private MethodDependency getMethodDependency(String className, MethodDescriptor descriptor) {
        Map map = this.methodCache.computeIfAbsent(className, k -> new HashMap());
        MethodDependency result = (MethodDependency)map.get(descriptor);
        if (result == null) {
            MethodHolder method = this.getMethodHolder(className, descriptor);
            if (!(method == null || method.getDescriptor().equals(descriptor) && method.getOwnerName().equals(className))) {
                result = this.getMethodDependency(method.getOwnerName(), method.getDescriptor());
            } else {
                MethodReference reference = method != null ? method.getReference() : new MethodReference(className, descriptor);
                result = this.createMethodDep(reference, method);
            }
            map.put(descriptor, result);
        }
        return result;
    }

    private void processQueue() {
        if (this.interrupted) {
            return;
        }
        while (!(this.deferredTasks.isEmpty() && this.tasks.isEmpty() && this.pendingTransitions.isEmpty())) {
            block5: {
                do {
                    this.processNodeToNodeTransitionQueue();
                    if (this.tasks.isEmpty()) break block5;
                    while (!this.tasks.isEmpty()) {
                        this.tasks.remove().run();
                    }
                } while (this.interruptor == null || this.interruptor.shouldContinue());
                this.interrupted = true;
                return;
            }
            this.propagationDepth = 50;
            while (!this.deferredTasks.isEmpty()) {
                this.deferredTasks.remove().run();
            }
            this.propagationDepth = 0;
        }
    }

    private void processNodeToNodeTransitionQueue() {
        while (!this.pendingTransitions.isEmpty()) {
            Transition transition = this.pendingTransitions.remove();
            IntHashSet pendingTypes = transition.pendingTypes;
            transition.pendingTypes = null;
            if (pendingTypes.size() == 1) {
                DependencyType type = this.types.get(((IntCursor)pendingTypes.iterator().next()).value);
                transition.consume(type);
                continue;
            }
            DependencyType[] typesToPropagate = new DependencyType[pendingTypes.size()];
            int index = 0;
            for (IntCursor cursor : pendingTypes) {
                typesToPropagate[index++] = this.types.get(cursor.value);
            }
            transition.consume(typesToPropagate);
        }
    }

    public void processDependencies() {
        this.interrupted = false;
        this.processQueue();
        if (!this.interrupted) {
            this.completing = true;
            this.lock();
            for (DependencyListener listener : this.listeners) {
                listener.completing(this.agent);
            }
        }
        for (DependencyListener listener : this.listeners) {
            listener.complete();
        }
        if (dependencyReport) {
            this.reportDependencies();
        }
    }

    private void reportDependencies() {
        ArrayList<ReportEntry> report = new ArrayList<ReportEntry>();
        int domainCount = 0;
        for (DependencyNode node : this.allNodes) {
            String tag = node.tag;
            if (node.typeSet != null && node.typeSet.origin == node) {
                ++domainCount;
                tag = tag + "{*}";
            }
            report.add(new ReportEntry(tag, node.getTypes().length));
        }
        report.sort(Comparator.comparingInt(n -> -n.count));
        for (ReportEntry entry : report) {
            System.out.println(entry.title + ": " + entry.count);
        }
        System.out.println("Total nodes: " + this.allNodes.size());
        System.out.println("Total domains: " + domainCount);
    }

    public void cleanup(ClassSourcePacker classSourcePacker) {
        for (DependencyNode dependencyNode : this.allNodes) {
            dependencyNode.followers = null;
            dependencyNode.transitions = null;
            dependencyNode.transitionList = null;
            dependencyNode.method = null;
        }
        for (DependencyNode dependencyNode : this.allNodes) {
            if (dependencyNode.typeSet == null) continue;
            dependencyNode.typeSet.cleanup();
        }
        for (Map map : this.methodCache.values()) {
            for (MethodDependency methodDependency : map.values()) {
                methodDependency.locationListeners = null;
                methodDependency.locations = null;
                methodDependency.cleanup();
            }
        }
        for (FieldReference fieldReference : this.fieldCache.getCachedPreimages()) {
            FieldDependency field = this.fieldCache.getKnown(fieldReference);
            if (field == null) continue;
            field.locationListeners = null;
            field.locations = null;
            field.cleanup();
        }
        for (String string : this.classCache.getCachedPreimages()) {
            ClassDependency cls = this.classCache.getKnown(string);
            cls.cleanup();
        }
        this.allNodes.clear();
        this.classSource.cleanup();
        this.agent.cleanup();
        this.listeners.clear();
        this.classSource.innerHierarchy = null;
        this.agentClassSource = classSourcePacker.pack(this.classSource, ClassClosureAnalyzer.build(this.classSource, new ArrayList<String>(this.classSource.cache.keySet())));
        if (this.classSource != this.agentClassSource) {
            this.classHierarchy = new ClassHierarchy(this.agentClassSource);
            this.generatedClassNames.addAll(this.classSource.getGeneratedClassNames());
        }
        this.classSource = null;
        this.methodReaderCache = null;
        this.fieldReaderCache = null;
    }

    public void cleanupTypes() {
        for (MethodReference reachableMethod : this.getReachableMethods()) {
            MethodDependency dependency = this.getMethod(reachableMethod);
            for (int i = dependency.getParameterCount() + 1; i < dependency.getVariableCount(); ++i) {
                dependency.variableNodes[i] = null;
            }
        }
    }

    private void lock() {
        for (MethodReference method : this.getReachableMethods()) {
            this.lock(this.getMethod(method), true);
        }
        for (FieldReference field : this.getReachableFields()) {
            this.lock(this.getField(field));
        }
    }

    private void lock(MethodDependency dep, boolean lock) {
        for (DependencyNode node : dep.variableNodes) {
            if (node == null) continue;
            node.locked = lock;
        }
        if (dep.resultNode != null) {
            dep.resultNode.locked = lock;
        }
        if (dep.thrown != null) {
            dep.thrown.locked = lock;
        }
    }

    private void lock(FieldDependency dep) {
        dep.value.locked = true;
    }

    public <T> T getService(Class<T> type) {
        return this.services.getService(type);
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public void addBootstrapMethodSubstitutor(MethodReference method, BootstrapMethodSubstitutor substitutor) {
        this.bootstrapMethodSubstitutors.put(method, substitutor);
    }

    public void addDependencyPlugin(MethodReference method, DependencyPlugin dependencyPlugin) {
        this.dependencyPlugins.put(method, dependencyPlugin);
    }

    public IncrementalDependencyProvider getIncrementalDependencies() {
        return this.incrementalCache;
    }

    DependencyTypeFilter getSuperClassFilter(String superClass) {
        DependencyTypeFilter result = this.superClassFilters.get(superClass);
        if (result == null) {
            if (superClass.startsWith("[")) {
                char second = superClass.charAt(1);
                if (second == '[') {
                    result = new SuperArrayFilter(this, this.getSuperClassFilter(superClass.substring(1)));
                } else if (second == 'L') {
                    ValueType.Object itemType = (ValueType.Object)ValueType.parse(superClass.substring(1));
                    result = new SuperArrayFilter(this, this.getSuperClassFilter(itemType.getClassName()));
                } else {
                    result = new ExactTypeFilter(this.getType(superClass));
                }
            } else {
                result = superClass.equals("java.lang.Object") ? t -> true : new SuperClassFilter(this, this.getType(superClass));
            }
            this.superClassFilters.put(superClass, result);
        }
        return result;
    }

    private void processInvokeDynamic(MethodDependency methodDep) {
        if (methodDep.method == null) {
            return;
        }
        Program program = methodDep.method.getProgram();
        if (program == null) {
            return;
        }
        ProgramEmitter pe = ProgramEmitter.create(program, this.classHierarchy);
        BasicBlockSplitter splitter = new BasicBlockSplitter(program);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                if (!(insn instanceof InvokeDynamicInstruction)) continue;
                block = insn.getBasicBlock();
                InvokeDynamicInstruction indy = (InvokeDynamicInstruction)insn;
                MethodReference bootstrapMethod = new MethodReference(indy.getBootstrapMethod().getClassName(), indy.getBootstrapMethod().getName(), indy.getBootstrapMethod().signature());
                BootstrapMethodSubstitutor substitutor = this.bootstrapMethodSubstitutors.get(bootstrapMethod);
                if (substitutor == null) {
                    NullConstantInstruction nullInsn = new NullConstantInstruction();
                    nullInsn.setReceiver(indy.getReceiver());
                    nullInsn.setLocation(indy.getLocation());
                    insn.replace(nullInsn);
                    CallLocation location = new CallLocation(methodDep.getReference(), insn.getLocation());
                    this.diagnostics.error(location, "Substitutor for bootstrap method {{m0}} was not found", bootstrapMethod);
                    continue;
                }
                BasicBlock splitBlock = splitter.split(block, insn);
                pe.enter(block);
                pe.setCurrentLocation(indy.getLocation());
                insn.delete();
                ArrayList<ValueEmitter> arguments = new ArrayList<ValueEmitter>();
                for (int k = 0; k < indy.getArguments().size(); ++k) {
                    arguments.add(pe.var(indy.getArguments().get(k), indy.getMethod().parameterType(k)));
                }
                DynamicCallSite callSite = new DynamicCallSite(methodDep.getReference(), indy.getMethod(), indy.getInstance() != null ? pe.var(indy.getInstance(), (ValueType)ValueType.object(methodDep.getMethod().getOwnerName())) : null, arguments, indy.getBootstrapMethod(), indy.getBootstrapArguments(), this.agent);
                ValueEmitter result = substitutor.substitute(callSite, pe);
                if (result.getVariable() != null && result.getVariable() != indy.getReceiver() && indy.getReceiver() != null) {
                    AssignInstruction assign = new AssignInstruction();
                    assign.setAssignee(result.getVariable());
                    assign.setReceiver(indy.getReceiver());
                    pe.addInstruction(assign);
                }
                pe.jump(splitBlock);
            }
        }
        splitter.fixProgram();
    }

    abstract boolean domainOptimizationEnabled();

    static class IncrementalCache
    implements IncrementalDependencyProvider,
    IncrementalDependencyRegistration {
        private final String[] emptyArray = new String[0];
        private Map<String, IncrementalItem> classes = new HashMap<String, IncrementalItem>();
        private Map<MethodReference, IncrementalItem> methods = new HashMap<MethodReference, IncrementalItem>();

        IncrementalCache() {
        }

        @Override
        public boolean isNoCache(String className) {
            IncrementalItem item = this.classes.get(className);
            return item != null && item.noCache;
        }

        @Override
        public boolean isNoCache(MethodReference method) {
            IncrementalItem item = this.methods.get(method);
            return item != null && item.noCache;
        }

        @Override
        public String[] getDependencies(String className) {
            IncrementalItem item = this.classes.get(className);
            return item != null && item.dependencies != null ? item.dependencies.toArray(new String[0]) : this.emptyArray;
        }

        @Override
        public String[] getDependencies(MethodReference method) {
            IncrementalItem item = this.methods.get(method);
            return item != null && item.dependencies != null ? item.dependencies.toArray(new String[0]) : this.emptyArray;
        }

        @Override
        public void setNoCache(String className) {
            this.classes.computeIfAbsent((String)className, (Function<String, IncrementalItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setNoCache$0(java.lang.String ), (Ljava/lang/String;)Lorg/teavm/dependency/DependencyAnalyzer$IncrementalItem;)()).noCache = true;
        }

        @Override
        public void setNoCache(MethodReference method) {
            this.methods.computeIfAbsent((MethodReference)method, (Function<MethodReference, IncrementalItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setNoCache$1(org.teavm.model.MethodReference ), (Lorg/teavm/model/MethodReference;)Lorg/teavm/dependency/DependencyAnalyzer$IncrementalItem;)()).noCache = true;
        }

        @Override
        public void addDependencies(String className, String ... dependencies) {
            IncrementalItem item = this.classes.computeIfAbsent(className, k -> new IncrementalItem());
            if (item.dependencies == null) {
                item.dependencies = new LinkedHashSet<String>();
            }
            item.dependencies.addAll(Arrays.asList(dependencies));
        }

        @Override
        public void addDependencies(MethodReference method, String ... dependencies) {
            IncrementalItem item = this.methods.computeIfAbsent(method, k -> new IncrementalItem());
            if (item.dependencies == null) {
                item.dependencies = new LinkedHashSet<String>();
            }
            item.dependencies.addAll(Arrays.asList(dependencies));
        }

        private static /* synthetic */ IncrementalItem lambda$setNoCache$1(MethodReference k) {
            return new IncrementalItem();
        }

        private static /* synthetic */ IncrementalItem lambda$setNoCache$0(String k) {
            return new IncrementalItem();
        }
    }

    static class ReportEntry {
        String title;
        int count;

        ReportEntry(String title, int count) {
            this.title = title;
            this.count = count;
        }
    }

    static class IncrementalItem {
        boolean noCache;
        Set<String> dependencies;

        IncrementalItem() {
        }
    }
}

