/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.ast.ArrayFromDataExpr;
import org.teavm.ast.ArrayType;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BoundCheckExpr;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConditionalExpr;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.ExprVisitor;
import org.teavm.ast.GotoPartStatement;
import org.teavm.ast.IdentifiedStatement;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.PrimitiveCastExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.ast.UnwrapArrayExpr;
import org.teavm.ast.VariableExpr;
import org.teavm.ast.WhileStatement;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmHeap;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.generate.ExpressionCache;
import org.teavm.backend.wasm.generate.TemporaryVariablePool;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmGenerationContext;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIntUnaryOperation;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.render.WasmTypeInference;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Address;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.classes.VirtualTable;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.CallSiteLocation;
import org.teavm.model.lowlevel.ExceptionHandlerDescriptor;
import org.teavm.model.lowlevel.ExceptionHandlingUtil;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.ExceptionHandling;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.ShadowStack;

class WasmGenerationVisitor
implements StatementVisitor,
ExprVisitor {
    private static final FieldReference MONITOR_FIELD = new FieldReference("java.lang.Object", "monitor");
    private static final MethodReference MONITOR_ENTER_SYNC = new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE);
    private static final MethodReference MONITOR_EXIT_SYNC = new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE);
    private static final MethodReference MONITOR_ENTER = new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE);
    private static final MethodReference MONITOR_EXIT = new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE);
    private static final MethodReference CATCH_METHOD = new MethodReference(ExceptionHandling.class, "catchException", Throwable.class);
    private static final MethodReference THROW_METHOD = new MethodReference(ExceptionHandling.class, "throwException", Throwable.class, Void.TYPE);
    private static final MethodReference THROW_CCE_METHOD = new MethodReference(ExceptionHandling.class, "throwClassCastException", Void.TYPE);
    private static final MethodReference THROW_NPE_METHOD = new MethodReference(ExceptionHandling.class, "throwNullPointerException", Void.TYPE);
    private static final MethodReference THROW_AIOOBE_METHOD = new MethodReference(ExceptionHandling.class, "throwArrayIndexOutOfBoundsException", Void.TYPE);
    private static final int SWITCH_TABLE_THRESHOLD = 256;
    private WasmGenerationContext context;
    private WasmClassGenerator classGenerator;
    private WasmTypeInference typeInference;
    private WasmFunction function;
    private MethodReference currentMethod;
    private int firstVariable;
    private IdentifiedStatement currentContinueTarget;
    private IdentifiedStatement currentBreakTarget;
    private Map<IdentifiedStatement, WasmBlock> breakTargets = new HashMap<IdentifiedStatement, WasmBlock>();
    private Map<IdentifiedStatement, WasmBlock> continueTargets = new HashMap<IdentifiedStatement, WasmBlock>();
    private Set<WasmBlock> usedBlocks = new HashSet<WasmBlock>();
    private TemporaryVariablePool tempVars;
    private ExpressionCache exprCache;
    private List<ExceptionHandlerDescriptor> handlers = new ArrayList<ExceptionHandlerDescriptor>();
    private WasmBlock lastTryBlock;
    private WasmBlock rethrowBlock;
    private List<WasmBlock> catchLabels = new ArrayList<WasmBlock>();
    private WasmLocal stackVariable;
    private BinaryWriter binaryWriter;
    private boolean async;
    private boolean managed;
    WasmExpression result;
    List<WasmExpression> resultConsumer;
    private WasmIntrinsicManager intrinsicManager = new WasmIntrinsicManager(){

        @Override
        public WasmExpression generate(Expr expr) {
            WasmGenerationVisitor.this.accept(expr);
            return WasmGenerationVisitor.this.result;
        }

        @Override
        public BinaryWriter getBinaryWriter() {
            return WasmGenerationVisitor.this.binaryWriter;
        }

        @Override
        public WasmStringPool getStringPool() {
            return WasmGenerationVisitor.this.context.getStringPool();
        }

        @Override
        public Diagnostics getDiagnostics() {
            return WasmGenerationVisitor.this.context.getDiagnostics();
        }

        @Override
        public NameProvider getNames() {
            return WasmGenerationVisitor.this.context.names;
        }

        @Override
        public WasmLocal getTemporary(WasmType type) {
            return WasmGenerationVisitor.this.tempVars.acquire(type);
        }

        @Override
        public void releaseTemporary(WasmLocal local) {
            WasmGenerationVisitor.this.tempVars.release(local);
        }

        @Override
        public int getStaticField(FieldReference field) {
            return WasmGenerationVisitor.this.classGenerator.getFieldOffset(field);
        }

        @Override
        public int getClassPointer(ValueType type) {
            return WasmGenerationVisitor.this.classGenerator.getClassPointer(type);
        }

        @Override
        public int getFunctionPointer(String name) {
            return WasmGenerationVisitor.this.classGenerator.getFunctionPointer(name);
        }

        @Override
        public boolean isManagedMethodCall(MethodReference method) {
            return WasmGenerationVisitor.this.needsCallSiteId() && ExceptionHandlingUtil.isManagedMethodCall(WasmGenerationVisitor.this.context.characteristics, method);
        }

        @Override
        public int generateCallSiteId(TextLocation location) {
            return WasmGenerationVisitor.this.generateCallSiteId(location);
        }

        @Override
        public WasmExpression generateRegisterCallSite(int callSite, TextLocation location) {
            return WasmGenerationVisitor.this.generateRegisterCallSite(callSite, location);
        }
    };

    WasmGenerationVisitor(WasmGenerationContext context, WasmClassGenerator classGenerator, BinaryWriter binaryWriter, WasmFunction function, MethodReference currentMethod, int firstVariable, boolean async) {
        this.context = context;
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
        this.function = function;
        this.currentMethod = currentMethod;
        this.firstVariable = firstVariable;
        this.tempVars = new TemporaryVariablePool(function);
        this.exprCache = new ExpressionCache(this.tempVars);
        this.typeInference = new WasmTypeInference(context);
        this.async = async;
        this.managed = context.characteristics.isManaged(currentMethod);
    }

    void generate(Statement statement, List<WasmExpression> target) {
        int lastTargetSize = target.size();
        this.resultConsumer = target;
        statement.acceptVisitor(this);
        this.resultConsumer = null;
        if (this.rethrowBlock != null) {
            List<WasmExpression> body = target.subList(lastTargetSize, target.size());
            this.rethrowBlock.getBody().addAll(body);
            body.clear();
            target.add(this.rethrowBlock);
            WasmExpression valueToReturn = WasmExpression.defaultValueOfType(this.function.getResult());
            if (valueToReturn != null) {
                target.add(new WasmReturn(valueToReturn));
            }
            if (!this.rethrowBlock.isTerminating()) {
                this.rethrowBlock.getBody().add(new WasmReturn());
            }
        }
    }

    private void accept(Expr expr) {
        expr.acceptVisitor(this);
    }

    private void accept(Statement statement) {
        statement.acceptVisitor(this);
    }

    @Override
    public void visit(BinaryExpr expr) {
        block0 : switch (expr.getOperation()) {
            case ADD: {
                this.generateBinary(WasmIntBinaryOperation.ADD, WasmFloatBinaryOperation.ADD, expr);
                break;
            }
            case SUBTRACT: {
                this.generateBinary(WasmIntBinaryOperation.SUB, WasmFloatBinaryOperation.SUB, expr);
                break;
            }
            case MULTIPLY: {
                this.generateBinary(WasmIntBinaryOperation.MUL, WasmFloatBinaryOperation.MUL, expr);
                break;
            }
            case DIVIDE: {
                this.generateBinary(WasmIntBinaryOperation.DIV_SIGNED, WasmFloatBinaryOperation.DIV, expr);
                break;
            }
            case MODULO: {
                switch (expr.getType()) {
                    case INT: 
                    case LONG: {
                        this.generateBinary(WasmIntBinaryOperation.REM_SIGNED, expr);
                        break block0;
                    }
                }
                Class<?> type = this.convertType(expr.getType());
                MethodReference method = new MethodReference(WasmRuntime.class, "remainder", type, type, type);
                WasmCall call = new WasmCall(this.context.names.forMethod(method), false);
                this.accept(expr.getFirstOperand());
                call.getArguments().add(this.result);
                this.accept(expr.getSecondOperand());
                call.getArguments().add(this.result);
                call.setLocation(expr.getLocation());
                this.result = call;
                break;
            }
            case BITWISE_AND: {
                this.generateBinary(WasmIntBinaryOperation.AND, expr);
                break;
            }
            case BITWISE_OR: {
                this.generateBinary(WasmIntBinaryOperation.OR, expr);
                break;
            }
            case BITWISE_XOR: {
                this.generateBinary(WasmIntBinaryOperation.XOR, expr);
                break;
            }
            case EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.EQ, WasmFloatBinaryOperation.EQ, expr);
                break;
            }
            case NOT_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.NE, WasmFloatBinaryOperation.NE, expr);
                break;
            }
            case GREATER: {
                this.generateBinary(WasmIntBinaryOperation.GT_SIGNED, WasmFloatBinaryOperation.GT, expr);
                break;
            }
            case GREATER_OR_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.GE_SIGNED, WasmFloatBinaryOperation.GE, expr);
                break;
            }
            case LESS: {
                this.generateBinary(WasmIntBinaryOperation.LT_SIGNED, WasmFloatBinaryOperation.LT, expr);
                break;
            }
            case LESS_OR_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.LE_SIGNED, WasmFloatBinaryOperation.LE, expr);
                break;
            }
            case LEFT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHL, expr);
                break;
            }
            case RIGHT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHR_SIGNED, expr);
                break;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHR_UNSIGNED, expr);
                break;
            }
            case COMPARE: {
                Class<?> type = this.convertType(expr.getType());
                MethodReference method = new MethodReference(WasmRuntime.class, "compare", type, type, Integer.TYPE);
                WasmCall call = new WasmCall(this.context.names.forMethod(method), false);
                this.accept(expr.getFirstOperand());
                call.getArguments().add(this.result);
                this.accept(expr.getSecondOperand());
                call.getArguments().add(this.result);
                call.setLocation(expr.getLocation());
                this.result = call;
                break;
            }
            case AND: {
                this.generateAnd(expr);
                break;
            }
            case OR: {
                this.generateOr(expr);
            }
        }
    }

    private void generateBinary(WasmIntBinaryOperation intOp, WasmFloatBinaryOperation floatOp, BinaryExpr expr) {
        this.accept(expr.getFirstOperand());
        WasmExpression first = this.result;
        this.accept(expr.getSecondOperand());
        WasmExpression second = this.result;
        if (expr.getType() == null) {
            this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
        } else {
            switch (expr.getType()) {
                case INT: {
                    this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
                    break;
                }
                case LONG: {
                    this.result = new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
                    break;
                }
                case FLOAT: {
                    this.result = new WasmFloatBinary(WasmFloatType.FLOAT32, floatOp, first, second);
                    break;
                }
                case DOUBLE: {
                    this.result = new WasmFloatBinary(WasmFloatType.FLOAT64, floatOp, first, second);
                }
            }
        }
        this.result.setLocation(expr.getLocation());
    }

    private void generateBinary(WasmIntBinaryOperation intOp, BinaryExpr expr) {
        this.accept(expr.getFirstOperand());
        WasmExpression first = this.result;
        this.accept(expr.getSecondOperand());
        WasmExpression second = this.result;
        if (expr.getType() == OperationType.LONG) {
            switch (expr.getOperation()) {
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    second = new WasmConversion(WasmType.INT32, WasmType.INT64, false, second);
                    break;
                }
            }
        }
        switch (expr.getType()) {
            case INT: {
                this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
                break;
            }
            case LONG: {
                this.result = new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                throw new AssertionError((Object)("Can't translate operation " + String.valueOf((Object)intOp) + " for type " + String.valueOf((Object)expr.getType())));
            }
        }
        this.result.setLocation(expr.getLocation());
    }

    private Class<?> convertType(OperationType type) {
        switch (type) {
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private void generateAnd(BinaryExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        this.accept(expr.getFirstOperand());
        WasmBranch branch = new WasmBranch(WasmGenerationVisitor.negate(this.result), block);
        branch.setResult(new WasmInt32Constant(0));
        branch.setLocation(expr.getLocation());
        branch.getResult().setLocation(expr.getLocation());
        block.getBody().add(new WasmDrop(branch));
        this.accept(expr.getSecondOperand());
        block.getBody().add(this.result);
        block.setLocation(expr.getLocation());
        this.result = block;
    }

    private void generateOr(BinaryExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        this.accept(expr.getFirstOperand());
        WasmBranch branch = new WasmBranch(this.result, block);
        branch.setResult(new WasmInt32Constant(1));
        branch.setLocation(expr.getLocation());
        branch.getResult().setLocation(expr.getLocation());
        block.getBody().add(new WasmDrop(branch));
        this.accept(expr.getSecondOperand());
        block.getBody().add(this.result);
        block.setLocation(expr.getLocation());
        this.result = block;
    }

    @Override
    public void visit(UnaryExpr expr) {
        switch (expr.getOperation()) {
            case INT_TO_BYTE: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(24));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_SIGNED, this.result, new WasmInt32Constant(24));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case INT_TO_SHORT: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_SIGNED, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case INT_TO_CHAR: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case LENGTH: {
                this.accept(expr.getOperand());
                this.result = this.generateArrayLength(this.result);
                break;
            }
            case NOT: {
                this.accept(expr.getOperand());
                this.result = WasmGenerationVisitor.negate(this.result);
                break;
            }
            case NEGATE: {
                this.accept(expr.getOperand());
                switch (expr.getType()) {
                    case INT: {
                        this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, new WasmInt32Constant(0), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case LONG: {
                        this.result = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.SUB, new WasmInt64Constant(0L), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case FLOAT: {
                        this.result = new WasmFloatBinary(WasmFloatType.FLOAT32, WasmFloatBinaryOperation.SUB, new WasmFloat32Constant(0.0f), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case DOUBLE: {
                        this.result = new WasmFloatBinary(WasmFloatType.FLOAT64, WasmFloatBinaryOperation.SUB, new WasmFloat64Constant(0.0), this.result);
                        this.result.setLocation(expr.getLocation());
                    }
                }
                break;
            }
            case NULL_CHECK: {
                if (!this.managed) {
                    expr.getOperand().acceptVisitor(this);
                    break;
                }
                this.result = this.nullCheck(expr.getOperand(), expr.getLocation());
            }
        }
    }

    private WasmExpression nullCheck(Expr value, TextLocation location) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        block.setLocation(location);
        this.accept(value);
        CachedExpression cachedValue = this.exprCache.create(this.result, WasmType.INT32, location, block.getBody());
        WasmBranch check = new WasmBranch(cachedValue.expr(), block);
        check.setResult(cachedValue.expr());
        block.getBody().add(new WasmDrop(check));
        int callSiteId = this.generateCallSiteId(location);
        block.getBody().add(this.generateRegisterCallSite(callSiteId, location));
        WasmCall call = new WasmCall(this.context.names.forMethod(THROW_NPE_METHOD));
        block.getBody().add(call);
        WasmBlock target = this.throwJumpTarget();
        WasmBreak breakExpr = new WasmBreak(target);
        if (target != this.rethrowBlock) {
            breakExpr.setResult(this.generateGetHandlerId(callSiteId, location));
            block.getBody().add(new WasmDrop(breakExpr));
        } else {
            block.getBody().add(breakExpr);
        }
        cachedValue.release();
        return block;
    }

    private WasmExpression generateArrayLength(WasmExpression array) {
        int sizeOffset = this.classGenerator.getFieldOffset(new FieldReference(RuntimeArray.class.getName(), "size"));
        WasmLoadInt32 length = new WasmLoadInt32(4, array, WasmInt32Subtype.INT32);
        length.setOffset(sizeOffset);
        length.setLocation(array.getLocation());
        return length;
    }

    @Override
    public void visit(AssignmentStatement statement) {
        Expr left = statement.getLeftValue();
        if (left == null) {
            if (statement.getRightValue() instanceof InvocationExpr) {
                InvocationExpr invocation;
                this.invocation(invocation, this.resultConsumer, (invocation = (InvocationExpr)statement.getRightValue()).getMethod().getReturnType() != ValueType.VOID);
            } else {
                this.accept(statement.getRightValue());
                this.result.acceptVisitor(this.typeInference);
                if (this.typeInference.getResult() != null) {
                    this.result = new WasmDrop(this.result);
                    this.result.setLocation(statement.getLocation());
                }
                this.resultConsumer.add(this.result);
                this.result = null;
            }
        } else if (left instanceof VariableExpr) {
            VariableExpr varExpr = (VariableExpr)left;
            WasmLocal local = this.function.getLocalVariables().get(varExpr.getIndex() - this.firstVariable);
            this.accept(statement.getRightValue());
            WasmSetLocal setLocal = new WasmSetLocal(local, this.result);
            setLocal.setLocation(statement.getLocation());
            this.resultConsumer.add(setLocal);
        } else if (left instanceof QualificationExpr) {
            QualificationExpr lhs = (QualificationExpr)left;
            this.storeField(lhs.getQualified(), lhs.getField(), statement.getRightValue(), statement.getLocation());
        } else if (left instanceof SubscriptExpr) {
            SubscriptExpr lhs = (SubscriptExpr)left;
            this.storeArrayItem(lhs, statement.getRightValue());
        } else {
            throw new UnsupportedOperationException("This expression is not supported yet");
        }
    }

    private void storeField(Expr qualified, FieldReference field, Expr value, TextLocation location) {
        WasmExpression resultExpr;
        block11: {
            WasmExpression address;
            block10: {
                address = this.getAddress(qualified, field, location);
                this.accept(value);
                if (field.equals(MONITOR_FIELD)) {
                    this.storeMonitor(address, this.result, location);
                    return;
                }
                ValueType type = this.context.getFieldType(field);
                if (!(type instanceof ValueType.Primitive)) break block10;
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        resultExpr = new WasmStoreInt32(1, address, this.result, WasmInt32Subtype.INT8);
                        break block11;
                    }
                    case SHORT: {
                        resultExpr = new WasmStoreInt32(2, address, this.result, WasmInt32Subtype.INT16);
                        break block11;
                    }
                    case CHARACTER: {
                        resultExpr = new WasmStoreInt32(2, address, this.result, WasmInt32Subtype.UINT16);
                        break block11;
                    }
                    case INTEGER: {
                        resultExpr = new WasmStoreInt32(4, address, this.result, WasmInt32Subtype.INT32);
                        break block11;
                    }
                    case LONG: {
                        resultExpr = new WasmStoreInt64(8, address, this.result, WasmInt64Subtype.INT64);
                        break block11;
                    }
                    case FLOAT: {
                        resultExpr = new WasmStoreFloat32(4, address, this.result);
                        break block11;
                    }
                    case DOUBLE: {
                        resultExpr = new WasmStoreFloat64(8, address, this.result);
                        break block11;
                    }
                    default: {
                        throw new AssertionError((Object)type.toString());
                    }
                }
            }
            resultExpr = new WasmStoreInt32(4, address, this.result, WasmInt32Subtype.INT32);
        }
        resultExpr.setOffset(this.getOffset(qualified, field));
        WasmExpression result = resultExpr;
        result.setLocation(location);
        this.resultConsumer.add(result);
    }

    private void storeMonitor(WasmExpression address, WasmExpression value, TextLocation location) {
        value = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, value, new WasmInt32Constant(1));
        value = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.OR, value, new WasmInt32Constant(Integer.MIN_VALUE));
        WasmStoreInt32 store = new WasmStoreInt32(4, address, value, WasmInt32Subtype.INT32);
        store.setLocation(location);
        store.setOffset(4);
        this.resultConsumer.add(store);
    }

    private void storeArrayItem(SubscriptExpr leftValue, Expr rightValue) {
        leftValue.getArray().acceptVisitor(this);
        WasmExpression array = this.result;
        leftValue.getIndex().acceptVisitor(this);
        WasmExpression index = this.result;
        rightValue.acceptVisitor(this);
        WasmExpression value = this.result;
        this.resultConsumer.add(WasmGenerationVisitor.storeArrayItem(this.getArrayElementPointer(array, index, leftValue.getType()), value, leftValue.getType()));
    }

    private static WasmExpression storeArrayItem(WasmExpression array, WasmExpression value, ArrayType type) {
        switch (type) {
            case BYTE: {
                return new WasmStoreInt32(1, array, value, WasmInt32Subtype.INT8);
            }
            case SHORT: {
                return new WasmStoreInt32(2, array, value, WasmInt32Subtype.INT16);
            }
            case CHAR: {
                return new WasmStoreInt32(2, array, value, WasmInt32Subtype.UINT16);
            }
            case INT: 
            case OBJECT: {
                return new WasmStoreInt32(4, array, value, WasmInt32Subtype.INT32);
            }
            case LONG: {
                return new WasmStoreInt64(8, array, value, WasmInt64Subtype.INT64);
            }
            case FLOAT: {
                return new WasmStoreFloat32(4, array, value);
            }
            case DOUBLE: {
                return new WasmStoreFloat64(8, array, value);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void visit(ConditionalExpr expr) {
        this.accept(expr.getCondition());
        WasmConditional conditional = new WasmConditional(this.forCondition(this.result));
        this.accept(expr.getConsequent());
        conditional.getThenBlock().getBody().add(this.result);
        this.result.acceptVisitor(this.typeInference);
        WasmType thenType = this.typeInference.getResult();
        conditional.getThenBlock().setType(thenType);
        this.accept(expr.getAlternative());
        conditional.getElseBlock().getBody().add(this.result);
        this.result.acceptVisitor(this.typeInference);
        WasmType elseType = this.typeInference.getResult();
        conditional.getElseBlock().setType(elseType);
        assert (thenType == elseType);
        conditional.setType(thenType);
        this.result = conditional;
    }

    @Override
    public void visit(SequentialStatement statement) {
        for (Statement part : statement.getSequence()) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(ConstantExpr expr) {
        if (expr.getValue() == null) {
            this.result = new WasmInt32Constant(0);
        } else if (expr.getValue() instanceof Integer) {
            this.result = new WasmInt32Constant((Integer)expr.getValue());
        } else if (expr.getValue() instanceof Long) {
            this.result = new WasmInt64Constant((Long)expr.getValue());
        } else if (expr.getValue() instanceof Float) {
            this.result = new WasmFloat32Constant(((Float)expr.getValue()).floatValue());
        } else if (expr.getValue() instanceof Double) {
            this.result = new WasmFloat64Constant((Double)expr.getValue());
        } else if (expr.getValue() instanceof String) {
            String str = (String)expr.getValue();
            this.result = new WasmInt32Constant(this.context.getStringPool().getStringPointer(str));
        } else if (expr.getValue() instanceof ValueType) {
            int pointer = this.classGenerator.getClassPointer((ValueType)expr.getValue());
            this.result = new WasmInt32Constant(pointer);
        } else {
            throw new IllegalArgumentException("Constant unsupported: " + String.valueOf(expr.getValue()));
        }
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.accept(statement.getCondition());
        WasmConditional conditional = new WasmConditional(this.forCondition(this.result));
        this.visitMany(statement.getConsequent(), conditional.getThenBlock().getBody());
        this.visitMany(statement.getAlternative(), conditional.getElseBlock().getBody());
        this.resultConsumer.add(conditional);
    }

    @Override
    public void visit(VariableExpr expr) {
        this.result = new WasmGetLocal(this.localVar(expr.getIndex()));
    }

    private WasmLocal localVar(int index) {
        return this.function.getLocalVariables().get(index - this.firstVariable);
    }

    @Override
    public void visit(SubscriptExpr expr) {
        WasmExpression ptr = this.getArrayElementPointer(expr);
        switch (expr.getType()) {
            case BYTE: {
                this.result = new WasmLoadInt32(1, ptr, WasmInt32Subtype.INT8);
                break;
            }
            case SHORT: {
                this.result = new WasmLoadInt32(2, ptr, WasmInt32Subtype.INT16);
                break;
            }
            case CHAR: {
                this.result = new WasmLoadInt32(2, ptr, WasmInt32Subtype.UINT16);
                break;
            }
            case INT: 
            case OBJECT: {
                this.result = new WasmLoadInt32(4, ptr, WasmInt32Subtype.INT32);
                break;
            }
            case LONG: {
                this.result = new WasmLoadInt64(8, ptr, WasmInt64Subtype.INT64);
                break;
            }
            case FLOAT: {
                this.result = new WasmLoadFloat32(4, ptr);
                break;
            }
            case DOUBLE: {
                this.result = new WasmLoadFloat64(8, ptr);
            }
        }
    }

    private WasmExpression getArrayElementPointer(SubscriptExpr expr) {
        expr.getArray().acceptVisitor(this);
        WasmExpression array = this.result;
        expr.getIndex().acceptVisitor(this);
        WasmExpression index = this.result;
        return this.getArrayElementPointer(array, index, expr.getType());
    }

    private WasmExpression getArrayElementPointer(WasmExpression array, WasmExpression index, ArrayType type) {
        int size = -1;
        switch (type) {
            case BYTE: {
                size = 0;
                break;
            }
            case SHORT: 
            case CHAR: {
                size = 1;
                break;
            }
            case INT: 
            case OBJECT: 
            case FLOAT: {
                size = 2;
                break;
            }
            case LONG: 
            case DOUBLE: {
                size = 3;
            }
        }
        int base = BinaryWriter.align(this.classGenerator.getClassSize(RuntimeArray.class.getName()), 1 << size);
        array = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, array, new WasmInt32Constant(base));
        if (size != 0) {
            index = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, index, new WasmInt32Constant(size));
        }
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, array, index);
    }

    @Override
    public void visit(SwitchStatement statement) {
        int min = statement.getClauses().stream().flatMapToInt(clause -> Arrays.stream(clause.getConditions())).min().orElse(0);
        int max = statement.getClauses().stream().flatMapToInt(clause -> Arrays.stream(clause.getConditions())).max().orElse(0);
        WasmBlock defaultBlock = new WasmBlock(false);
        this.breakTargets.put(statement, defaultBlock);
        IdentifiedStatement oldBreakTarget = this.currentBreakTarget;
        this.currentBreakTarget = statement;
        WasmBlock wrapper = new WasmBlock(false);
        this.accept(statement.getValue());
        WasmExpression condition = this.result;
        WasmBlock initialWrapper = wrapper;
        List<SwitchClause> clauses = statement.getClauses();
        WasmBlock[] targets = new WasmBlock[clauses.size()];
        for (int i = 0; i < clauses.size(); ++i) {
            SwitchClause clause2 = clauses.get(i);
            WasmBlock caseBlock = new WasmBlock(false);
            caseBlock.getBody().add(wrapper);
            targets[i] = wrapper;
            this.visitMany(clause2.getBody(), caseBlock.getBody());
            wrapper = caseBlock;
        }
        defaultBlock.getBody().add(wrapper);
        this.visitMany(statement.getDefaultClause(), defaultBlock.getBody());
        WasmBlock defaultTarget = wrapper;
        wrapper = defaultBlock;
        if ((long)max - (long)min >= 256L) {
            this.translateSwitchToBinarySearch(statement, condition, initialWrapper, defaultTarget, targets);
        } else {
            this.translateSwitchToWasmSwitch(statement, condition, initialWrapper, defaultTarget, targets, min, max);
        }
        this.breakTargets.remove(statement);
        this.currentBreakTarget = oldBreakTarget;
        this.resultConsumer.add(wrapper);
    }

    private void translateSwitchToBinarySearch(SwitchStatement statement, WasmExpression condition, WasmBlock initialWrapper, WasmBlock defaultTarget, WasmBlock[] targets) {
        ArrayList<TableEntry> entries = new ArrayList<TableEntry>();
        for (int i = 0; i < statement.getClauses().size(); ++i) {
            SwitchClause clause = statement.getClauses().get(i);
            for (int label : clause.getConditions()) {
                entries.add(new TableEntry(label, targets[i]));
            }
        }
        entries.sort(Comparator.comparingInt(entry -> entry.label));
        CachedExpression cachedCondition = this.exprCache.create(condition, WasmType.INT32, statement.getValue().getLocation(), initialWrapper.getBody());
        this.generateBinarySearch(entries, 0, entries.size() - 1, initialWrapper, defaultTarget, cachedCondition);
        cachedCondition.release();
    }

    private void generateBinarySearch(List<TableEntry> entries, int lower, int upper, WasmBlock consumer, WasmBlock defaultTarget, CachedExpression testValue) {
        if (upper - lower == 0) {
            int label = entries.get((int)lower).label;
            WasmIntBinary condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, testValue.expr(), new WasmInt32Constant(label));
            WasmConditional conditional = new WasmConditional(condition);
            consumer.getBody().add(conditional);
            conditional.getThenBlock().getBody().add(new WasmBreak(entries.get((int)lower).target));
            conditional.getElseBlock().getBody().add(new WasmBreak(defaultTarget));
        } else if (upper - lower <= 0) {
            consumer.getBody().add(new WasmBreak(defaultTarget));
        } else {
            int mid = (upper + lower) / 2;
            int label = entries.get((int)mid).label;
            WasmIntBinary condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GT_SIGNED, testValue.expr(), new WasmInt32Constant(label));
            WasmConditional conditional = new WasmConditional(condition);
            consumer.getBody().add(conditional);
            this.generateBinarySearch(entries, mid + 1, upper, conditional.getThenBlock(), defaultTarget, testValue);
            this.generateBinarySearch(entries, lower, mid, conditional.getElseBlock(), defaultTarget, testValue);
        }
    }

    private void translateSwitchToWasmSwitch(SwitchStatement statement, WasmExpression condition, WasmBlock initialWrapper, WasmBlock defaultTarget, WasmBlock[] targets, int min, int max) {
        if (min != 0) {
            condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, condition, new WasmInt32Constant(min));
        }
        WasmSwitch wasmSwitch = new WasmSwitch(condition, initialWrapper);
        initialWrapper.getBody().add(wasmSwitch);
        wasmSwitch.setDefaultTarget(defaultTarget);
        WasmBlock[] expandedTargets = new WasmBlock[max - min + 1];
        for (int i = 0; i < statement.getClauses().size(); ++i) {
            SwitchClause clause = statement.getClauses().get(i);
            for (int label : clause.getConditions()) {
                expandedTargets[label - min] = targets[i];
            }
        }
        for (WasmBlock target : expandedTargets) {
            wasmSwitch.getTargets().add(target != null ? target : wasmSwitch.getDefaultTarget());
        }
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        this.accept(expr.getArray());
    }

    @Override
    public void visit(WhileStatement statement) {
        WasmBlock wrapper = new WasmBlock(false);
        WasmBlock loop = new WasmBlock(true);
        this.continueTargets.put(statement, loop);
        this.breakTargets.put(statement, wrapper);
        IdentifiedStatement oldBreakTarget = this.currentBreakTarget;
        IdentifiedStatement oldContinueTarget = this.currentContinueTarget;
        this.currentBreakTarget = statement;
        this.currentContinueTarget = statement;
        if (statement.getCondition() != null) {
            this.accept(statement.getCondition());
            loop.getBody().add(new WasmBranch(WasmGenerationVisitor.negate(this.result), wrapper));
            this.usedBlocks.add(wrapper);
        }
        this.visitMany(statement.getBody(), loop.getBody());
        loop.getBody().add(new WasmBreak(loop));
        this.currentBreakTarget = oldBreakTarget;
        this.currentContinueTarget = oldContinueTarget;
        this.continueTargets.remove(statement);
        this.breakTargets.remove(statement);
        if (this.usedBlocks.contains(wrapper)) {
            wrapper.getBody().add(loop);
            this.resultConsumer.add(wrapper);
        } else {
            this.resultConsumer.add(loop);
        }
    }

    @Override
    public void visit(InvocationExpr expr) {
        this.result = this.invocation(expr, null, false);
    }

    private WasmExpression invocation(InvocationExpr expr, List<WasmExpression> resultConsumer, boolean willDrop) {
        WasmIntrinsic intrinsic;
        if (expr.getMethod().getClassName().equals(ShadowStack.class.getName())) {
            switch (expr.getMethod().getName()) {
                case "allocStack": {
                    this.generateAllocStack(expr.getArguments().get(0));
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
                case "releaseStack": {
                    this.generateReleaseStack();
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
                case "registerGCRoot": {
                    this.generateRegisterGcRoot(expr.getArguments().get(0), expr.getArguments().get(1));
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
                case "removeGCRoot": {
                    this.generateRemoveGcRoot(expr.getArguments().get(0));
                    this.result.setLocation(expr.getLocation());
                    if (resultConsumer != null) {
                        resultConsumer.add(this.result);
                        return null;
                    }
                    return this.result;
                }
            }
        }
        if ((intrinsic = this.context.getIntrinsic(expr.getMethod())) != null) {
            WasmExpression resultExpr = intrinsic.apply(expr, this.intrinsicManager);
            return this.trivialInvocation(resultExpr, resultConsumer, expr.getLocation(), willDrop);
        }
        int callSiteId = this.generateCallSiteId(expr.getLocation());
        if (this.needsCallSiteId() && ExceptionHandlingUtil.isManagedMethodCall(this.context.characteristics, expr.getMethod())) {
            WasmBlock block;
            List<WasmExpression> targetList;
            WasmExpression invocation = this.generateInvocation(expr, callSiteId);
            WasmType type = WasmGeneratorUtil.mapType(expr.getMethod().getReturnType());
            if (resultConsumer != null) {
                targetList = resultConsumer;
                this.result = null;
                block = null;
            } else {
                block = new WasmBlock(false);
                block.setType(type);
                block.setLocation(expr.getLocation());
                targetList = block.getBody();
                this.result = block;
            }
            if (expr.getArguments().isEmpty()) {
                targetList.add(this.generateRegisterCallSite(callSiteId, expr.getLocation()));
            }
            WasmLocal resultVar = null;
            if (!willDrop) {
                if (type != null) {
                    resultVar = this.tempVars.acquire(type);
                    WasmSetLocal setLocal = new WasmSetLocal(resultVar, invocation);
                    setLocal.setLocation(expr.getLocation());
                    targetList.add(setLocal);
                } else {
                    targetList.add(invocation);
                }
            } else if (type == null) {
                targetList.add(invocation);
            } else {
                WasmDrop drop = new WasmDrop(invocation);
                drop.setLocation(expr.getLocation());
                targetList.add(drop);
            }
            this.checkHandlerId(targetList, callSiteId, expr.getLocation());
            if (resultVar != null) {
                WasmGetLocal getLocal = new WasmGetLocal(resultVar);
                getLocal.setLocation(expr.getLocation());
                targetList.add(getLocal);
                this.tempVars.release(resultVar);
            }
            return block;
        }
        WasmExpression resultExpr = this.generateInvocation(expr, -1);
        return this.trivialInvocation(resultExpr, resultConsumer, expr.getLocation(), willDrop);
    }

    private WasmExpression trivialInvocation(WasmExpression resultExpr, List<WasmExpression> resultConsumer, TextLocation location, boolean willDrop) {
        if (resultConsumer != null) {
            if (willDrop) {
                WasmDrop drop = new WasmDrop(resultExpr);
                drop.setLocation(location);
                resultConsumer.add(drop);
            } else {
                resultConsumer.add(resultExpr);
            }
            this.result = null;
            return null;
        }
        return resultExpr;
    }

    private int generateCallSiteId(TextLocation location) {
        CallSiteLocation[] callSiteLocations = CallSiteLocation.fromTextLocation(location, this.currentMethod);
        CallSiteDescriptor callSite = new CallSiteDescriptor(this.context.callSites.size(), callSiteLocations);
        ArrayList<ExceptionHandlerDescriptor> reverseHandlers = new ArrayList<ExceptionHandlerDescriptor>(this.handlers);
        Collections.reverse(reverseHandlers);
        callSite.getHandlers().addAll(reverseHandlers);
        this.context.callSites.add(callSite);
        return callSite.getId();
    }

    private void checkHandlerId(List<WasmExpression> target, int callSiteId, TextLocation location) {
        WasmBlock jumpTarget = this.throwJumpTarget();
        if (jumpTarget == this.rethrowBlock) {
            WasmExpression handlerId = this.generateGetHandlerId(callSiteId, location);
            WasmBranch br = new WasmBranch(handlerId, this.throwJumpTarget());
            target.add(br);
        } else {
            WasmLocal handlerVar = this.tempVars.acquire(WasmType.INT32);
            WasmExpression handlerId = this.generateGetHandlerId(callSiteId, location);
            WasmSetLocal saveHandler = new WasmSetLocal(handlerVar, handlerId);
            saveHandler.setLocation(location);
            target.add(saveHandler);
            WasmBranch br = new WasmBranch(new WasmGetLocal(handlerVar), this.throwJumpTarget());
            br.setResult(new WasmGetLocal(handlerVar));
            WasmDrop dropBr = new WasmDrop(br);
            dropBr.setLocation(location);
            target.add(dropBr);
            this.tempVars.release(handlerVar);
        }
    }

    private WasmBlock throwJumpTarget() {
        return this.lastTryBlock != null ? this.lastTryBlock : this.rethrowBlock();
    }

    private WasmExpression generateInvocation(InvocationExpr expr, int callSiteId) {
        int i;
        if (expr.getType() == InvocationType.STATIC || expr.getType() == InvocationType.SPECIAL) {
            MethodReader method = this.context.getClassSource().resolve(expr.getMethod());
            MethodReference reference = method != null ? method.getReference() : expr.getMethod();
            String methodName = this.context.names.forMethod(reference);
            WasmCall call = new WasmCall(methodName);
            if (this.context.getImportedMethod(reference) != null) {
                call.setImported(true);
            }
            for (Expr argument : expr.getArguments()) {
                this.accept(argument);
                call.getArguments().add(this.result);
            }
            this.addCallSiteIdToLastArg(callSiteId, call.getArguments());
            call.setLocation(expr.getLocation());
            return call;
        }
        if (expr.getType() == InvocationType.CONSTRUCTOR) {
            WasmBlock block = new WasmBlock(false);
            block.setType(WasmType.INT32);
            WasmLocal tmp = this.tempVars.acquire(WasmType.INT32);
            if (callSiteId >= 0) {
                this.generateRegisterCallSite(callSiteId, expr.getLocation());
            }
            block.getBody().add(new WasmSetLocal(tmp, this.allocateObject(expr.getMethod().getClassName(), expr.getLocation())));
            String methodName = this.context.names.forMethod(expr.getMethod());
            WasmCall call = new WasmCall(methodName);
            call.getArguments().add(new WasmGetLocal(tmp));
            for (Expr argument : expr.getArguments()) {
                this.accept(argument);
                call.getArguments().add(this.result);
            }
            this.addCallSiteIdToLastArg(callSiteId, call.getArguments());
            block.getBody().add(call);
            block.getBody().add(new WasmGetLocal(tmp));
            this.tempVars.release(tmp);
            return block;
        }
        MethodReference reference = expr.getMethod();
        this.accept(expr.getArguments().get(0));
        WasmExpression instance = this.result;
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmGeneratorUtil.mapType(reference.getReturnType()));
        WasmLocal instanceVar = this.tempVars.acquire(WasmType.INT32);
        block.getBody().add(new WasmSetLocal(instanceVar, instance));
        instance = new WasmGetLocal(instanceVar);
        int vtableOffset = this.classGenerator.getClassSize(RuntimeClass.class.getName());
        VirtualTable vtable = this.context.getVirtualTableProvider().lookup(reference.getClassName());
        if (vtable != null) {
            vtable = vtable.findMethodContainer(reference.getDescriptor());
        }
        if (vtable == null) {
            return new WasmUnreachable();
        }
        int vtableIndex = vtable.getMethods().indexOf(reference.getDescriptor());
        if (vtable.getParent() != null) {
            vtableIndex += vtable.getParent().size();
        }
        WasmExpression classRef = this.getReferenceToClass(instance);
        WasmLoadInt32 methodIndex = new WasmLoadInt32(4, classRef, WasmInt32Subtype.INT32);
        methodIndex.setOffset(vtableIndex * 4 + vtableOffset);
        WasmIndirectCall call = new WasmIndirectCall(methodIndex);
        call.getParameterTypes().add(WasmType.INT32);
        for (i = 0; i < expr.getMethod().parameterCount(); ++i) {
            call.getParameterTypes().add(WasmGeneratorUtil.mapType(expr.getMethod().parameterType(i)));
        }
        if (expr.getMethod().getReturnType() != ValueType.VOID) {
            call.setReturnType(WasmGeneratorUtil.mapType(expr.getMethod().getReturnType()));
        }
        call.getArguments().add(instance);
        for (i = 1; i < expr.getArguments().size(); ++i) {
            this.accept(expr.getArguments().get(i));
            call.getArguments().add(this.result);
        }
        this.addCallSiteIdToLastArg(callSiteId, call.getArguments());
        block.getBody().add(call);
        this.tempVars.release(instanceVar);
        return block;
    }

    private void addCallSiteIdToLastArg(int callSiteId, List<WasmExpression> args) {
        if (args.isEmpty() || callSiteId < 0) {
            return;
        }
        WasmExpression arg = args.get(args.size() - 1);
        WasmBlock block = new WasmBlock(false);
        arg.acceptVisitor(this.typeInference);
        block.setType(this.typeInference.getResult());
        block.setLocation(arg.getLocation());
        block.getBody().add(arg);
        args.set(args.size() - 1, block);
        block.getBody().add(this.generateRegisterCallSite(callSiteId, arg.getLocation()));
    }

    private boolean needsCallSiteId() {
        return this.managed;
    }

    private void generateAllocStack(Expr sizeExpr) {
        if (this.stackVariable != null) {
            throw new IllegalStateException("Call to ShadowStack.allocStack must be done only once");
        }
        this.stackVariable = this.tempVars.acquire(WasmType.INT32);
        this.stackVariable.setName("__stack__");
        InvocationExpr expr = new InvocationExpr();
        expr.setType(InvocationType.SPECIAL);
        expr.setMethod(new MethodReference(WasmRuntime.class, "allocStack", Integer.TYPE, Address.class));
        expr.getArguments().add(sizeExpr);
        expr.acceptVisitor(this);
        this.result = new WasmSetLocal(this.stackVariable, this.result);
    }

    private void generateReleaseStack() {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.releaseStack must be dominated by Mutator.allocStack");
        }
        int offset = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "stack"));
        WasmExpression oldValue = new WasmGetLocal(this.stackVariable);
        oldValue = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, oldValue, new WasmInt32Constant(4));
        this.result = new WasmStoreInt32(4, new WasmInt32Constant(offset), oldValue, WasmInt32Subtype.INT32);
    }

    private WasmExpression generateRegisterCallSite(int callSite, TextLocation location) {
        return this.generateRegisterCallSite(new WasmInt32Constant(callSite), location);
    }

    private WasmExpression generateRegisterCallSite(WasmExpression callSite, TextLocation location) {
        WasmStoreInt32 result = new WasmStoreInt32(4, new WasmGetLocal(this.stackVariable), callSite, WasmInt32Subtype.INT32);
        result.setLocation(location);
        return result;
    }

    private WasmExpression generateGetHandlerId(int callSite, TextLocation location) {
        WasmExpression handlerId = new WasmLoadInt32(4, new WasmGetLocal(this.stackVariable), WasmInt32Subtype.INT32);
        if (callSite > 0) {
            handlerId = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, handlerId, new WasmInt32Constant(callSite));
        }
        handlerId.setLocation(location);
        return handlerId;
    }

    private void generateRegisterGcRoot(Expr slotExpr, Expr gcRootExpr) {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.registerGCRoot must be dominated by Mutator.allocStack");
        }
        slotExpr.acceptVisitor(this);
        WasmExpression slotOffset = this.getSlotOffset(this.result);
        WasmExpression address = new WasmGetLocal(this.stackVariable);
        if (!(slotOffset instanceof WasmInt32Constant)) {
            address = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, address, slotOffset);
        }
        gcRootExpr.acceptVisitor(this);
        WasmExpression gcRoot = this.result;
        WasmStoreInt32 store = new WasmStoreInt32(4, address, gcRoot, WasmInt32Subtype.INT32);
        if (slotOffset instanceof WasmInt32Constant) {
            store.setOffset(((WasmInt32Constant)slotOffset).getValue());
        }
        this.result = store;
    }

    private void generateRemoveGcRoot(Expr slotExpr) {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.removeGCRoot must be dominated by Mutator.allocStack");
        }
        slotExpr.acceptVisitor(this);
        WasmExpression slotOffset = this.getSlotOffset(this.result);
        WasmExpression address = new WasmGetLocal(this.stackVariable);
        if (!(slotOffset instanceof WasmInt32Constant)) {
            address = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, address, slotOffset);
        }
        WasmStoreInt32 store = new WasmStoreInt32(4, address, new WasmInt32Constant(0), WasmInt32Subtype.INT32);
        if (slotOffset instanceof WasmInt32Constant) {
            store.setOffset(((WasmInt32Constant)slotOffset).getValue());
        }
        this.result = store;
    }

    private WasmExpression getSlotOffset(WasmExpression slot) {
        if (slot instanceof WasmInt32Constant) {
            int slotConstant = ((WasmInt32Constant)slot).getValue();
            return new WasmInt32Constant((slotConstant << 2) + 4);
        }
        slot = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, slot, new WasmInt32Constant(2));
        slot = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, slot, new WasmInt32Constant(4));
        return slot;
    }

    @Override
    public void visit(BlockStatement statement) {
        WasmBlock block = new WasmBlock(false);
        if (statement.getId() != null) {
            this.breakTargets.put(statement, block);
        }
        this.visitMany(statement.getBody(), block.getBody());
        if (statement.getId() != null) {
            this.breakTargets.remove(statement);
        }
        this.resultConsumer.add(block);
    }

    @Override
    public void visit(QualificationExpr expr) {
        WasmExpression resultExpr;
        block11: {
            WasmExpression address;
            block10: {
                address = this.getAddress(expr.getQualified(), expr.getField(), expr.getLocation());
                if (expr.getField().equals(MONITOR_FIELD)) {
                    this.result = this.getMonitor(address, expr.getLocation());
                    return;
                }
                ValueType type = this.context.getFieldType(expr.getField());
                if (!(type instanceof ValueType.Primitive)) break block10;
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        resultExpr = new WasmLoadInt32(1, address, WasmInt32Subtype.INT8);
                        break block11;
                    }
                    case SHORT: {
                        resultExpr = new WasmLoadInt32(2, address, WasmInt32Subtype.INT16);
                        break block11;
                    }
                    case CHARACTER: {
                        resultExpr = new WasmLoadInt32(2, address, WasmInt32Subtype.UINT16);
                        break block11;
                    }
                    case INTEGER: {
                        resultExpr = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
                        break block11;
                    }
                    case LONG: {
                        resultExpr = new WasmLoadInt64(8, address, WasmInt64Subtype.INT64);
                        break block11;
                    }
                    case FLOAT: {
                        resultExpr = new WasmLoadFloat32(4, address);
                        break block11;
                    }
                    case DOUBLE: {
                        resultExpr = new WasmLoadFloat64(8, address);
                        break block11;
                    }
                    default: {
                        throw new AssertionError((Object)type.toString());
                    }
                }
            }
            resultExpr = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
        }
        resultExpr.setOffset(this.getOffset(expr.getQualified(), expr.getField()));
        this.result = resultExpr;
    }

    private WasmExpression getMonitor(WasmExpression address, TextLocation location) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        block.setLocation(location);
        WasmLocal tmp = this.tempVars.acquire(WasmType.INT32);
        WasmLoadInt32 monitor = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
        monitor.setOffset(4);
        block.getBody().add(new WasmSetLocal(tmp, monitor));
        WasmIntBinary isMonitor = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, new WasmGetLocal(tmp), new WasmInt32Constant(Integer.MIN_VALUE));
        WasmIntBinary shiftMonitor = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, new WasmGetLocal(tmp), new WasmInt32Constant(1));
        WasmConditional cond = new WasmConditional(isMonitor);
        cond.setType(WasmType.INT32);
        cond.getThenBlock().getBody().add(shiftMonitor);
        cond.getElseBlock().getBody().add(new WasmInt32Constant(0));
        block.getBody().add(cond);
        this.tempVars.release(tmp);
        return block;
    }

    private WasmExpression getAddress(Expr qualified, FieldReference field, TextLocation location) {
        if (qualified == null) {
            int offset = this.classGenerator.getFieldOffset(field);
            WasmInt32Constant result = new WasmInt32Constant(offset);
            result.setLocation(location);
            return result;
        }
        this.accept(qualified);
        return this.result;
    }

    private int getOffset(Expr qualified, FieldReference field) {
        if (qualified == null) {
            return 0;
        }
        return this.classGenerator.getFieldOffset(field);
    }

    @Override
    public void visit(BreakStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentBreakTarget;
        }
        WasmBlock wasmTarget = this.breakTargets.get(target);
        this.usedBlocks.add(wasmTarget);
        WasmBreak br = new WasmBreak(wasmTarget);
        br.setLocation(statement.getLocation());
        this.resultConsumer.add(br);
    }

    @Override
    public void visit(ContinueStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentContinueTarget;
        }
        WasmBlock wasmTarget = this.continueTargets.get(target);
        this.usedBlocks.add(wasmTarget);
        WasmBreak br = new WasmBreak(wasmTarget);
        br.setLocation(statement.getLocation());
        this.resultConsumer.add(br);
    }

    @Override
    public void visit(NewExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setLocation(expr.getLocation());
        block.setType(WasmType.INT32);
        int callSiteId = this.generateCallSiteId(expr.getLocation());
        block.getBody().add(this.generateRegisterCallSite(callSiteId, expr.getLocation()));
        block.getBody().add(this.allocateObject(expr.getConstructedClass(), expr.getLocation()));
        this.result = block;
    }

    private WasmExpression allocateObject(String className, TextLocation location) {
        int tag = this.classGenerator.getClassPointer(ValueType.object(className));
        String allocName = this.context.names.forMethod(new MethodReference(Allocator.class, "allocate", RuntimeClass.class, Address.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(tag));
        call.setLocation(location);
        return call;
    }

    @Override
    public void visit(NewArrayExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        int callSiteId = this.generateCallSiteId(expr.getLocation());
        block.getBody().add(this.generateRegisterCallSite(callSiteId, expr.getLocation()));
        ValueType type = expr.getType();
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(type));
        String allocName = this.context.names.forMethod(new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        this.accept(expr.getLength());
        call.getArguments().add(this.result);
        call.setLocation(expr.getLocation());
        block.getBody().add(call);
        this.result = block;
    }

    @Override
    public void visit(ArrayFromDataExpr expr) {
        ValueType type = expr.getType();
        ArrayType arrayType = ArrayType.OBJECT;
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    arrayType = ArrayType.BYTE;
                    break;
                }
                case SHORT: {
                    arrayType = ArrayType.SHORT;
                    break;
                }
                case CHARACTER: {
                    arrayType = ArrayType.CHAR;
                    break;
                }
                case INTEGER: {
                    arrayType = ArrayType.INT;
                    break;
                }
                case LONG: {
                    arrayType = ArrayType.LONG;
                    break;
                }
                case FLOAT: {
                    arrayType = ArrayType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    arrayType = ArrayType.DOUBLE;
                }
            }
        }
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        int callSiteId = this.generateCallSiteId(expr.getLocation());
        block.getBody().add(this.generateRegisterCallSite(callSiteId, expr.getLocation()));
        WasmLocal array = this.tempVars.acquire(WasmType.INT32);
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(type));
        String allocName = this.context.names.forMethod(new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        call.getArguments().add(new WasmInt32Constant(expr.getData().size()));
        call.setLocation(expr.getLocation());
        block.getBody().add(new WasmSetLocal(array, call));
        for (int i = 0; i < expr.getData().size(); ++i) {
            WasmExpression ptr = this.getArrayElementPointer(new WasmGetLocal(array), new WasmInt32Constant(i), arrayType);
            expr.getData().get(i).acceptVisitor(this);
            block.getBody().add(WasmGenerationVisitor.storeArrayItem(ptr, this.result, arrayType));
        }
        block.getBody().add(new WasmGetLocal(array));
        block.setLocation(expr.getLocation());
        this.tempVars.release(array);
        this.result = block;
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        ValueType type = expr.getType();
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        int dimensionList = -1;
        for (Expr dimension : expr.getDimensions()) {
            int dimensionAddress = this.binaryWriter.append(DataPrimitives.INT.createValue());
            if (dimensionList < 0) {
                dimensionList = dimensionAddress;
            }
            this.accept(dimension);
            block.getBody().add(new WasmStoreInt32(4, new WasmInt32Constant(dimensionAddress), this.result, WasmInt32Subtype.INT32));
        }
        int classPointer = this.classGenerator.getClassPointer(type);
        String allocName = this.context.names.forMethod(new MethodReference(Allocator.class, "allocateMultiArray", RuntimeClass.class, Address.class, Integer.TYPE, RuntimeArray.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        call.getArguments().add(new WasmInt32Constant(dimensionList));
        call.getArguments().add(new WasmInt32Constant(expr.getDimensions().size()));
        call.setLocation(expr.getLocation());
        block.getBody().add(call);
        this.result = block;
    }

    @Override
    public void visit(ReturnStatement statement) {
        if (statement.getResult() != null) {
            this.accept(statement.getResult());
        } else {
            this.result = null;
        }
        WasmReturn wasmStatement = new WasmReturn(this.result);
        wasmStatement.setLocation(statement.getLocation());
        this.resultConsumer.add(wasmStatement);
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        String className;
        ValueType type = expr.getType();
        if (type instanceof ValueType.Object && !this.context.characteristics.isManaged(className = ((ValueType.Object)type).getClassName())) {
            expr.getExpr().acceptVisitor(this);
            return;
        }
        this.classGenerator.getClassPointer(type);
        this.accept(expr.getExpr());
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        block.setLocation(expr.getLocation());
        CachedExpression cachedObject = this.exprCache.create(this.result, WasmType.INT32, expr.getLocation(), block.getBody());
        WasmBranch ifNull = new WasmBranch(this.genIsZero(cachedObject.expr()), block);
        ifNull.setResult(new WasmInt32Constant(0));
        block.getBody().add(new WasmDrop(ifNull));
        WasmCall supertypeCall = new WasmCall(this.context.names.forSupertypeFunction(expr.getType()));
        WasmExpression classRef = new WasmLoadInt32(4, cachedObject.expr(), WasmInt32Subtype.INT32);
        classRef = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, classRef, new WasmInt32Constant(3));
        supertypeCall.getArguments().add(classRef);
        block.getBody().add(supertypeCall);
        cachedObject.release();
        this.result = block;
    }

    @Override
    public void visit(ThrowStatement statement) {
        int callSiteId = this.generateCallSiteId(statement.getLocation());
        this.resultConsumer.add(this.generateRegisterCallSite(callSiteId, statement.getLocation()));
        this.accept(statement.getException());
        WasmCall call = new WasmCall(this.context.names.forMethod(THROW_METHOD), this.result);
        call.setLocation(statement.getLocation());
        this.resultConsumer.add(call);
        WasmBlock target = this.throwJumpTarget();
        WasmBreak breakExpr = new WasmBreak(target);
        breakExpr.setLocation(statement.getLocation());
        if (target != this.rethrowBlock) {
            breakExpr.setResult(this.generateGetHandlerId(callSiteId, statement.getLocation()));
        }
        this.resultConsumer.add(breakExpr);
    }

    @Override
    public void visit(CastExpr expr) {
        String className;
        ValueType type = expr.getTarget();
        if (type instanceof ValueType.Object && !this.context.characteristics.isManaged(className = ((ValueType.Object)type).getClassName())) {
            expr.getValue().acceptVisitor(this);
            return;
        }
        this.classGenerator.getClassPointer(type);
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        block.setLocation(expr.getLocation());
        this.accept(expr.getValue());
        CachedExpression valueToCast = this.exprCache.create(this.result, WasmType.INT32, expr.getLocation(), block.getBody());
        WasmBranch nullCheck = new WasmBranch(this.genIsZero(valueToCast.expr()), block);
        nullCheck.setResult(valueToCast.expr());
        block.getBody().add(new WasmDrop(nullCheck));
        WasmCall supertypeCall = new WasmCall(this.context.names.forSupertypeFunction(expr.getTarget()));
        WasmExpression classRef = new WasmLoadInt32(4, valueToCast.expr(), WasmInt32Subtype.INT32);
        classRef = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, classRef, new WasmInt32Constant(3));
        supertypeCall.getArguments().add(classRef);
        WasmBranch breakIfPassed = new WasmBranch(supertypeCall, block);
        breakIfPassed.setResult(valueToCast.expr());
        block.getBody().add(new WasmDrop(breakIfPassed));
        int callSiteId = this.generateCallSiteId(expr.getLocation());
        block.getBody().add(this.generateRegisterCallSite(callSiteId, expr.getLocation()));
        WasmCall call = new WasmCall(this.context.names.forMethod(THROW_CCE_METHOD));
        block.getBody().add(call);
        WasmBlock target = this.throwJumpTarget();
        WasmBreak breakExpr = new WasmBreak(target);
        if (target != this.rethrowBlock) {
            breakExpr.setResult(this.generateGetHandlerId(callSiteId, expr.getLocation()));
        }
        block.getBody().add(breakExpr);
        valueToCast.release();
        this.result = block;
    }

    @Override
    public void visit(InitClassStatement statement) {
        if (this.classGenerator.hasClinit(statement.getClassName())) {
            WasmCall call = new WasmCall(this.context.names.forClassInitializer(statement.getClassName()));
            call.setLocation(statement.getLocation());
            int callSiteId = this.generateCallSiteId(statement.getLocation());
            this.resultConsumer.add(this.generateRegisterCallSite(callSiteId, statement.getLocation()));
            this.resultConsumer.add(call);
            this.checkHandlerId(this.resultConsumer, callSiteId, statement.getLocation());
        }
    }

    @Override
    public void visit(PrimitiveCastExpr expr) {
        this.accept(expr.getValue());
        this.result = new WasmConversion(WasmGeneratorUtil.mapType(expr.getSource()), WasmGeneratorUtil.mapType(expr.getTarget()), true, this.result);
        this.result.setLocation(expr.getLocation());
    }

    @Override
    public void visit(TryCatchStatement statement) {
        boolean isTopMostTryCatch;
        Statement next;
        ArrayList<TryCatchStatement> tryCatchStatements = new ArrayList<TryCatchStatement>();
        while (statement.getProtectedBody().size() == 1 && (next = statement.getProtectedBody().get(0)) instanceof TryCatchStatement) {
            tryCatchStatements.add(statement);
            statement = (TryCatchStatement)next;
        }
        tryCatchStatements.add(statement);
        int firstId = this.handlers.size();
        WasmBlock innerCatchBlock = new WasmBlock(false);
        WasmBlock bodyBlock = new WasmBlock(false);
        bodyBlock.setType(WasmType.INT32);
        boolean bl = isTopMostTryCatch = this.lastTryBlock == null;
        if (isTopMostTryCatch) {
            this.catchLabels.add(this.rethrowBlock());
        }
        ArrayList<WasmBlock> catchBlocks = new ArrayList<WasmBlock>();
        for (int i = 0; i < tryCatchStatements.size(); ++i) {
            TryCatchStatement tryCatch = (TryCatchStatement)tryCatchStatements.get(i);
            this.handlers.add(new ExceptionHandlerDescriptor(firstId + i, tryCatch.getExceptionType()));
            catchBlocks.add(new WasmBlock(false));
        }
        WasmBlock outerCatchBlock = (WasmBlock)catchBlocks.get(0);
        this.catchLabels.addAll(catchBlocks.subList(1, catchBlocks.size()));
        this.catchLabels.add(innerCatchBlock);
        WasmBlock lastTryBlockBackup = this.lastTryBlock;
        this.lastTryBlock = bodyBlock;
        this.visitMany(statement.getProtectedBody(), bodyBlock.getBody());
        this.lastTryBlock = lastTryBlockBackup;
        this.handlers.subList(firstId, this.handlers.size()).clear();
        if (!bodyBlock.isTerminating()) {
            bodyBlock.getBody().add(new WasmBreak(outerCatchBlock));
        }
        WasmBlock currentBlock = innerCatchBlock;
        WasmIntBinary handlerIdExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, bodyBlock, new WasmInt32Constant(1));
        WasmSwitch switchExpr = new WasmSwitch(handlerIdExpr, outerCatchBlock);
        switchExpr.getTargets().addAll(this.catchLabels);
        innerCatchBlock.getBody().add(switchExpr);
        this.catchLabels.subList(this.catchLabels.size() - tryCatchStatements.size(), this.catchLabels.size()).clear();
        if (isTopMostTryCatch) {
            this.catchLabels.remove(this.catchLabels.size() - 1);
            assert (this.catchLabels.isEmpty());
        }
        for (int i = tryCatchStatements.size() - 1; i >= 0; --i) {
            TryCatchStatement tryCatch = (TryCatchStatement)tryCatchStatements.get(i);
            WasmBlock catchBlock = (WasmBlock)catchBlocks.get(i);
            catchBlock.getBody().add(currentBlock);
            String catchMethodName = this.context.names.forMethod(CATCH_METHOD);
            WasmCall catchCall = new WasmCall(catchMethodName);
            WasmExpression catchWrapper = tryCatch.getExceptionVariable() != null ? new WasmSetLocal(this.localVar(tryCatch.getExceptionVariable()), catchCall) : new WasmDrop(catchCall);
            catchBlock.getBody().add(catchWrapper);
            this.visitMany(tryCatch.getHandler(), catchBlock.getBody());
            if (!catchBlock.isTerminating() && catchBlock != outerCatchBlock) {
                catchBlock.getBody().add(new WasmBreak(outerCatchBlock));
            }
            currentBlock = catchBlock;
        }
        this.resultConsumer.add(outerCatchBlock);
    }

    private WasmBlock rethrowBlock() {
        if (this.rethrowBlock == null) {
            this.rethrowBlock = new WasmBlock(false);
        }
        return this.rethrowBlock;
    }

    private void visitMany(List<Statement> statements, List<WasmExpression> target) {
        List<WasmExpression> oldTarget = this.resultConsumer;
        this.resultConsumer = target;
        for (Statement part : statements) {
            this.accept(part);
        }
        this.resultConsumer = oldTarget;
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        WasmCall call = new WasmCall(this.context.names.forMethod(this.async ? MONITOR_ENTER : MONITOR_ENTER_SYNC));
        call.setLocation(statement.getLocation());
        statement.getObjectRef().acceptVisitor(this);
        call.getArguments().add(this.result);
        int callSiteId = this.generateCallSiteId(statement.getLocation());
        this.resultConsumer.add(this.generateRegisterCallSite(callSiteId, statement.getLocation()));
        this.resultConsumer.add(call);
        this.checkHandlerId(this.resultConsumer, callSiteId, statement.getLocation());
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        WasmCall call = new WasmCall(this.context.names.forMethod(this.async ? MONITOR_EXIT : MONITOR_EXIT_SYNC));
        call.setLocation(statement.getLocation());
        statement.getObjectRef().acceptVisitor(this);
        call.getArguments().add(this.result);
        int callSiteId = this.generateCallSiteId(statement.getLocation());
        this.resultConsumer.add(this.generateRegisterCallSite(callSiteId, statement.getLocation()));
        this.resultConsumer.add(call);
        this.checkHandlerId(this.resultConsumer, callSiteId, statement.getLocation());
    }

    @Override
    public void visit(BoundCheckExpr expr) {
        if (!this.managed) {
            expr.getIndex().acceptVisitor(this);
            return;
        }
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        block.setLocation(expr.getLocation());
        this.accept(expr.getIndex());
        CachedExpression index = this.exprCache.create(this.result, WasmType.INT32, expr.getLocation(), block.getBody());
        if (expr.getArray() != null) {
            WasmBlock condBlock = block;
            if (expr.isLower()) {
                condBlock = new WasmBlock(false);
                block.getBody().add(condBlock);
                WasmIntBinary lowerCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, index.expr(), new WasmInt32Constant(0));
                WasmBranch lowerBranch = new WasmBranch(lowerCond, condBlock);
                condBlock.getBody().add(lowerBranch);
            }
            this.accept(expr.getArray());
            WasmExpression upperBound = this.generateArrayLength(this.result);
            WasmIntBinary upperCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, index.expr(), upperBound);
            WasmBranch upperBranch = new WasmBranch(upperCond, block);
            upperBranch.setResult(index.expr());
            condBlock.getBody().add(new WasmDrop(upperBranch));
        } else if (expr.isLower()) {
            WasmIntBinary lowerCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, index.expr(), new WasmInt32Constant(0));
            WasmBranch lowerBranch = new WasmBranch(lowerCond, block);
            lowerBranch.setResult(index.expr());
            block.getBody().add(new WasmDrop(lowerBranch));
        }
        int callSiteId = this.generateCallSiteId(expr.getLocation());
        block.getBody().add(this.generateRegisterCallSite(callSiteId, expr.getLocation()));
        block.getBody().add(new WasmCall(this.context.names.forMethod(THROW_AIOOBE_METHOD)));
        WasmBreak br = new WasmBreak(this.throwJumpTarget());
        if (br.getTarget() != this.rethrowBlock) {
            br.setResult(this.generateGetHandlerId(callSiteId, expr.getLocation()));
        }
        block.getBody().add(br);
        this.result = block;
    }

    private static WasmExpression negate(WasmExpression expr) {
        WasmFloatBinaryOperation negatedOp;
        WasmExpression binary;
        if (expr instanceof WasmIntBinary) {
            WasmIntBinaryOperation negatedOp2;
            binary = (WasmIntBinary)expr;
            if (((WasmIntBinary)binary).getType() == WasmIntType.INT32 && ((WasmIntBinary)binary).getOperation() == WasmIntBinaryOperation.XOR) {
                if (WasmGenerationVisitor.isOne(((WasmIntBinary)binary).getFirst())) {
                    WasmExpression result = ((WasmIntBinary)binary).getSecond();
                    if (result.getLocation() == null && expr.getLocation() != null) {
                        result.setLocation(expr.getLocation());
                    }
                    return result;
                }
                if (WasmGenerationVisitor.isOne(((WasmIntBinary)binary).getSecond())) {
                    WasmExpression result = ((WasmIntBinary)binary).getFirst();
                    if (result.getLocation() == null && expr.getLocation() != null) {
                        result.setLocation(expr.getLocation());
                    }
                    return result;
                }
            }
            if ((negatedOp2 = WasmGenerationVisitor.negate(((WasmIntBinary)binary).getOperation())) != null) {
                WasmIntBinary result = new WasmIntBinary(((WasmIntBinary)binary).getType(), negatedOp2, ((WasmIntBinary)binary).getFirst(), ((WasmIntBinary)binary).getSecond());
                result.setLocation(expr.getLocation());
                return result;
            }
        } else if (expr instanceof WasmFloatBinary && (negatedOp = WasmGenerationVisitor.negate(((WasmFloatBinary)(binary = (WasmFloatBinary)expr)).getOperation())) != null) {
            WasmFloatBinary result = new WasmFloatBinary(((WasmFloatBinary)binary).getType(), negatedOp, ((WasmFloatBinary)binary).getFirst(), ((WasmFloatBinary)binary).getSecond());
            result.setLocation(expr.getLocation());
            return result;
        }
        WasmIntBinary result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, expr, new WasmInt32Constant(0));
        result.setLocation(expr.getLocation());
        return result;
    }

    private static boolean isOne(WasmExpression expression) {
        return expression instanceof WasmInt32Constant && ((WasmInt32Constant)expression).getValue() == 1;
    }

    private static boolean isZero(WasmExpression expression) {
        return expression instanceof WasmInt32Constant && ((WasmInt32Constant)expression).getValue() == 0;
    }

    private boolean isBoolean(WasmExpression expression) {
        if (expression instanceof WasmIntBinary) {
            WasmIntBinary binary = (WasmIntBinary)expression;
            switch (binary.getOperation()) {
                case EQ: 
                case NE: 
                case LT_SIGNED: 
                case LT_UNSIGNED: 
                case LE_SIGNED: 
                case LE_UNSIGNED: 
                case GT_SIGNED: 
                case GT_UNSIGNED: 
                case GE_SIGNED: 
                case GE_UNSIGNED: {
                    return true;
                }
            }
            return false;
        }
        if (expression instanceof WasmFloatBinary) {
            WasmFloatBinary binary = (WasmFloatBinary)expression;
            switch (binary.getOperation()) {
                case EQ: 
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private WasmExpression forCondition(WasmExpression expression) {
        if (expression instanceof WasmIntBinary) {
            WasmIntBinary binary = (WasmIntBinary)expression;
            switch (binary.getOperation()) {
                case EQ: {
                    if (WasmGenerationVisitor.isZero(binary.getFirst()) && this.isBoolean(binary.getSecond())) {
                        return WasmGenerationVisitor.negate(binary.getSecond());
                    }
                    if (!WasmGenerationVisitor.isZero(binary.getSecond()) || !this.isBoolean(binary.getFirst())) break;
                    return WasmGenerationVisitor.negate(binary.getFirst());
                }
                case NE: {
                    if (WasmGenerationVisitor.isZero(binary.getFirst()) && this.isBoolean(binary.getSecond())) {
                        return binary.getSecond();
                    }
                    if (!WasmGenerationVisitor.isZero(binary.getSecond()) || !this.isBoolean(binary.getFirst())) break;
                    return binary.getFirst();
                }
            }
        }
        return expression;
    }

    private static WasmIntBinaryOperation negate(WasmIntBinaryOperation op) {
        switch (op) {
            case EQ: {
                return WasmIntBinaryOperation.NE;
            }
            case NE: {
                return WasmIntBinaryOperation.EQ;
            }
            case LT_SIGNED: {
                return WasmIntBinaryOperation.GE_SIGNED;
            }
            case LT_UNSIGNED: {
                return WasmIntBinaryOperation.GE_UNSIGNED;
            }
            case LE_SIGNED: {
                return WasmIntBinaryOperation.GT_SIGNED;
            }
            case LE_UNSIGNED: {
                return WasmIntBinaryOperation.GT_UNSIGNED;
            }
            case GT_SIGNED: {
                return WasmIntBinaryOperation.LE_SIGNED;
            }
            case GT_UNSIGNED: {
                return WasmIntBinaryOperation.LE_UNSIGNED;
            }
            case GE_SIGNED: {
                return WasmIntBinaryOperation.LT_SIGNED;
            }
            case GE_UNSIGNED: {
                return WasmIntBinaryOperation.LT_UNSIGNED;
            }
        }
        return null;
    }

    private static WasmFloatBinaryOperation negate(WasmFloatBinaryOperation op) {
        switch (op) {
            case EQ: {
                return WasmFloatBinaryOperation.NE;
            }
            case NE: {
                return WasmFloatBinaryOperation.EQ;
            }
            case LT: {
                return WasmFloatBinaryOperation.GE;
            }
            case LE: {
                return WasmFloatBinaryOperation.GT;
            }
            case GT: {
                return WasmFloatBinaryOperation.LE;
            }
            case GE: {
                return WasmFloatBinaryOperation.LT;
            }
        }
        return null;
    }

    private WasmExpression getReferenceToClass(WasmExpression instance) {
        WasmLoadInt32 classIndex = new WasmLoadInt32(4, instance, WasmInt32Subtype.INT32);
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, classIndex, new WasmInt32Constant(3));
    }

    private WasmExpression genIsZero(WasmExpression value) {
        return new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.EQZ, value);
    }

    static class TableEntry {
        final int label;
        final WasmBlock target;

        TableEntry(int label, WasmBlock target) {
            this.label = label;
            this.target = target;
        }
    }
}

