/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.ast.ArrayFromDataExpr;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BinaryOperation;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BoundCheckExpr;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConditionalExpr;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.ExprVisitor;
import org.teavm.ast.GotoPartStatement;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.ast.MethodNode;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.PrimitiveCastExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.ast.UnwrapArrayExpr;
import org.teavm.ast.VariableExpr;
import org.teavm.ast.WhileStatement;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.NameFrequencyEstimator;
import org.teavm.backend.javascript.rendering.Precedence;
import org.teavm.backend.javascript.rendering.RenderingContext;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.rendering.VariableNameGenerator;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.DeferredCallSite;
import org.teavm.hppc.IntArrayList;
import org.teavm.hppc.IntIndexedContainer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.vm.RenderingException;

public class StatementRenderer
implements ExprVisitor,
StatementVisitor {
    private RenderingContext context;
    private SourceWriter writer;
    private ClassReaderSource classSource;
    private boolean async;
    private boolean minifying;
    private Precedence precedence;
    private DebugInformationEmitter debugEmitter;
    private NamingStrategy naming;
    private DeferredCallSite lastCallSite;
    private DeferredCallSite prevCallSite;
    private boolean end;
    private final Map<String, String> blockIdMap = new HashMap<String, String>();
    private int currentPart;
    private List<String> blockIds = new ArrayList<String>();
    private IntIndexedContainer blockIndexMap = new IntArrayList();
    private boolean longLibraryUsed;
    private static final MethodDescriptor CLINIT_METHOD = new MethodDescriptor("<clinit>", ValueType.VOID);
    private VariableNameGenerator variableNameGenerator;

    public StatementRenderer(RenderingContext context, SourceWriter writer) {
        this.context = context;
        this.writer = writer;
        this.classSource = context.getClassSource();
        this.minifying = context.isMinifying();
        this.naming = context.getNaming();
        this.debugEmitter = context.getDebugEmitter();
        this.variableNameGenerator = new VariableNameGenerator(this.minifying);
    }

    public boolean isLongLibraryUsed() {
        return this.longLibraryUsed;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setCurrentMethod(MethodNode currentMethod) {
        this.variableNameGenerator.setCurrentMethod(currentMethod);
    }

    public void setCurrentPart(int currentPart) {
        this.currentPart = currentPart;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    private void pushLocation(TextLocation location) {
        this.context.pushLocation(location);
    }

    private void popLocation() {
        this.context.popLocation();
    }

    @Override
    public void visit(AssignmentStatement statement) throws RenderingException {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.prevCallSite = this.debugEmitter.emitCallSite();
            if (statement.getLeftValue() != null) {
                if (statement.isAsync()) {
                    this.writer.append(this.context.tempVarName());
                } else {
                    this.precedence = Precedence.COMMA;
                    statement.getLeftValue().acceptVisitor(this);
                }
                this.writer.ws().append("=").ws();
            }
            this.precedence = Precedence.COMMA;
            statement.getRightValue().acceptVisitor(this);
            this.debugEmitter.emitCallSite();
            this.writer.append(";").softNewLine();
            if (statement.isAsync()) {
                this.emitSuspendChecker();
                if (statement.getLeftValue() != null) {
                    this.precedence = Precedence.COMMA;
                    statement.getLeftValue().acceptVisitor(this);
                    this.writer.ws().append("=").ws().append(this.context.tempVarName()).append(";").softNewLine();
                }
            }
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visitStatements(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        try {
            boolean needClosingBracket;
            block12: {
                while (true) {
                    this.debugEmitter.emitStatementStart();
                    if (statement.getCondition().getLocation() != null) {
                        this.pushLocation(statement.getCondition().getLocation());
                    }
                    this.prevCallSite = this.debugEmitter.emitCallSite();
                    this.writer.append("if").ws().append("(");
                    this.precedence = Precedence.COMMA;
                    statement.getCondition().acceptVisitor(this);
                    if (statement.getCondition().getLocation() != null) {
                        this.popLocation();
                    }
                    this.debugEmitter.emitCallSite();
                    this.writer.append(")");
                    if (this.isSimpleIfContent(statement.getConsequent())) {
                        needClosingBracket = false;
                    } else {
                        this.writer.ws().append("{");
                        needClosingBracket = true;
                    }
                    this.writer.softNewLine().indent();
                    this.visitStatements(statement.getConsequent());
                    if (statement.getAlternative().isEmpty()) break block12;
                    this.writer.outdent();
                    if (needClosingBracket) {
                        this.writer.append("}").ws();
                    }
                    if (statement.getAlternative().size() != 1 || !(statement.getAlternative().get(0) instanceof ConditionalStatement)) break;
                    statement = (ConditionalStatement)statement.getAlternative().get(0);
                    this.writer.append("else ");
                }
                this.writer.append("else");
                if (this.isSimpleIfContent(statement.getAlternative())) {
                    if (this.minifying) {
                        this.writer.append(" ");
                    }
                    needClosingBracket = false;
                } else {
                    this.writer.ws().append("{");
                    needClosingBracket = true;
                }
                this.writer.indent().softNewLine();
                this.visitStatements(statement.getAlternative());
            }
            this.writer.outdent();
            if (needClosingBracket) {
                this.writer.append("}").softNewLine();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private boolean isSimpleIfContent(List<Statement> statements) {
        if (statements.size() != 1) {
            return false;
        }
        Statement statement = statements.get(0);
        return !(statement instanceof ConditionalStatement) && !(statement instanceof GotoPartStatement);
    }

    @Override
    public void visit(SwitchStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getValue().getLocation() != null) {
                this.pushLocation(statement.getValue().getLocation());
            }
            if (statement.getId() != null) {
                this.writer.append(this.mapBlockId(statement.getId())).append(":").ws();
            }
            this.prevCallSite = this.debugEmitter.emitCallSite();
            this.writer.append("switch").ws().append("(");
            this.precedence = Precedence.min();
            statement.getValue().acceptVisitor(this);
            if (statement.getValue().getLocation() != null) {
                this.popLocation();
            }
            this.debugEmitter.emitCallSite();
            this.writer.append(")").ws().append("{").softNewLine().indent();
            for (SwitchClause clause : statement.getClauses()) {
                for (int condition : clause.getConditions()) {
                    this.writer.append("case ").append(condition).append(":").softNewLine();
                }
                this.writer.indent();
                boolean oldEnd = this.end;
                for (Statement part : clause.getBody()) {
                    this.end = false;
                    part.acceptVisitor(this);
                }
                this.end = oldEnd;
                this.writer.outdent();
            }
            if (statement.getDefaultClause() != null) {
                this.writer.append("default:").softNewLine().indent();
                boolean oldEnd = this.end;
                for (Statement part : statement.getDefaultClause()) {
                    this.end = false;
                    part.acceptVisitor(this);
                }
                this.end = oldEnd;
                this.writer.outdent();
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getId() != null) {
                this.writer.append(this.mapBlockId(statement.getId())).append(":").ws();
            }
            this.writer.append("while");
            this.writer.ws().append("(");
            if (statement.getCondition() != null) {
                this.prevCallSite = this.debugEmitter.emitCallSite();
                this.precedence = Precedence.min();
                statement.getCondition().acceptVisitor(this);
                this.debugEmitter.emitCallSite();
            } else {
                this.writer.append("true");
            }
            this.writer.append(")").ws().append("{").softNewLine().indent();
            boolean oldEnd = this.end;
            for (Statement part : statement.getBody()) {
                this.end = false;
                part.acceptVisitor(this);
            }
            this.end = oldEnd;
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private String mapBlockId(String id) {
        String name = this.blockIdMap.get(id);
        if (name == null) {
            int index = this.blockIdMap.size();
            name = this.generateBlockId(index);
            this.blockIdMap.put(id, name);
        }
        return name;
    }

    private String generateBlockId(int index) {
        while (this.blockIds.size() <= index) {
            int mappedIndex = this.blockIndexMap.isEmpty() ? -1 : this.blockIndexMap.get(this.blockIds.size() - 1);
            ++mappedIndex;
            while (RenderingUtil.KEYWORDS.contains(RenderingUtil.indexToId(mappedIndex))) {
                ++mappedIndex;
            }
            this.blockIndexMap.add(mappedIndex);
            this.blockIds.add(RenderingUtil.indexToId(mappedIndex));
        }
        return this.blockIds.get(index);
    }

    @Override
    public void visit(BlockStatement statement) {
        try {
            this.writer.append(this.mapBlockId(statement.getId())).append(":").ws().append("{").softNewLine().indent();
            this.visitStatements(statement.getBody());
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(BreakStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.append("break");
            if (statement.getTarget() != null) {
                this.writer.append(' ').append(this.mapBlockId(statement.getTarget().getId()));
            }
            this.writer.append(";").softNewLine();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(ContinueStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.append("continue");
            if (statement.getTarget() != null) {
                this.writer.append(' ').append(this.mapBlockId(statement.getTarget().getId()));
            }
            this.writer.append(";").softNewLine();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.append("return");
            if (statement.getResult() != null) {
                this.writer.append(' ');
                this.prevCallSite = this.debugEmitter.emitCallSite();
                this.precedence = Precedence.min();
                statement.getResult().acceptVisitor(this);
                this.debugEmitter.emitCallSite();
            }
            this.writer.append(";").softNewLine();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.appendFunction("$rt_throw").append("(");
            this.prevCallSite = this.debugEmitter.emitCallSite();
            this.precedence = Precedence.min();
            statement.getException().acceptVisitor(this);
            this.writer.append(");").softNewLine();
            this.debugEmitter.emitCallSite();
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(InitClassStatement statement) {
        ClassReader cls = this.classSource.get(statement.getClassName());
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(CLINIT_METHOD);
        if (method == null) {
            return;
        }
        try {
            this.debugEmitter.emitStatementStart();
            if (statement.getLocation() != null) {
                this.pushLocation(statement.getLocation());
            }
            this.writer.appendClassInit(statement.getClassName()).append("();").softNewLine();
            if (statement.isAsync()) {
                this.emitSuspendChecker();
            }
            if (statement.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    public String variableName(int index) {
        return this.variableNameGenerator.variableName(index);
    }

    private void visitBinary(BinaryExpr expr, String op, boolean guarded) {
        if (expr.getLocation() != null) {
            this.pushLocation(expr.getLocation());
        }
        if (guarded) {
            this.visitBinary(BinaryOperation.OR, "|", () -> this.visitBinary(expr, op, false), () -> {
                try {
                    this.writer.append("0");
                }
                catch (IOException e) {
                    throw new RenderingException("IO error occurred", e);
                }
            });
        } else {
            this.visitBinary(expr.getOperation(), op, () -> expr.getFirstOperand().acceptVisitor(this), () -> expr.getSecondOperand().acceptVisitor(this));
        }
        if (expr.getLocation() != null) {
            this.popLocation();
        }
    }

    private void visitBinary(BinaryOperation operation, String infixText, Runnable a, Runnable b) {
        try {
            Precedence outerPrecedence = this.precedence;
            Precedence innerPrecedence = StatementRenderer.getPrecedence(operation);
            if (innerPrecedence.ordinal() < outerPrecedence.ordinal()) {
                this.writer.append('(');
            }
            switch (operation) {
                case ADD: 
                case SUBTRACT: 
                case MULTIPLY: 
                case DIVIDE: 
                case AND: 
                case OR: 
                case BITWISE_AND: 
                case BITWISE_OR: 
                case BITWISE_XOR: 
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    this.precedence = innerPrecedence;
                    break;
                }
                default: {
                    this.precedence = innerPrecedence.next();
                }
            }
            a.run();
            this.writer.ws().append(infixText).ws();
            switch (operation) {
                case ADD: 
                case MULTIPLY: 
                case AND: 
                case OR: 
                case BITWISE_AND: 
                case BITWISE_OR: 
                case BITWISE_XOR: {
                    this.precedence = innerPrecedence;
                    break;
                }
                default: {
                    this.precedence = innerPrecedence.next();
                }
            }
            b.run();
            if (innerPrecedence.ordinal() < outerPrecedence.ordinal()) {
                this.writer.append(')');
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private static Precedence getPrecedence(BinaryOperation op) {
        switch (op) {
            case ADD: 
            case SUBTRACT: {
                return Precedence.ADDITION;
            }
            case MULTIPLY: 
            case DIVIDE: {
                return Precedence.MULTIPLICATION;
            }
            case MODULO: {
                return Precedence.MODULO;
            }
            case AND: {
                return Precedence.LOGICAL_AND;
            }
            case OR: {
                return Precedence.LOGICAL_OR;
            }
            case EQUALS: 
            case NOT_EQUALS: {
                return Precedence.EQUALITY;
            }
            case GREATER: 
            case GREATER_OR_EQUALS: 
            case LESS: 
            case LESS_OR_EQUALS: {
                return Precedence.COMPARISON;
            }
            case BITWISE_AND: {
                return Precedence.BITWISE_AND;
            }
            case BITWISE_OR: {
                return Precedence.BITWISE_OR;
            }
            case BITWISE_XOR: {
                return Precedence.BITWISE_XOR;
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return Precedence.BITWISE_SHIFT;
            }
        }
        return Precedence.GROUPING;
    }

    private void visitBinaryFunction(BinaryExpr expr, String function) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.writer.appendFunction(function);
            this.writer.append('(');
            this.precedence = Precedence.min();
            expr.getFirstOperand().acceptVisitor(this);
            this.writer.append(",").ws();
            this.precedence = Precedence.min();
            expr.getSecondOperand().acceptVisitor(this);
            this.writer.append(')');
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        if (expr.getType() == OperationType.LONG) {
            this.longLibraryUsed = true;
            switch (expr.getOperation()) {
                case ADD: {
                    this.visitBinaryFunction(expr, "Long_add");
                    break;
                }
                case SUBTRACT: {
                    this.visitBinaryFunction(expr, "Long_sub");
                    break;
                }
                case MULTIPLY: {
                    this.visitBinaryFunction(expr, "Long_mul");
                    break;
                }
                case DIVIDE: {
                    this.visitBinaryFunction(expr, "Long_div");
                    break;
                }
                case MODULO: {
                    this.visitBinaryFunction(expr, "Long_rem");
                    break;
                }
                case BITWISE_OR: {
                    this.visitBinaryFunction(expr, "Long_or");
                    break;
                }
                case BITWISE_AND: {
                    this.visitBinaryFunction(expr, "Long_and");
                    break;
                }
                case BITWISE_XOR: {
                    this.visitBinaryFunction(expr, "Long_xor");
                    break;
                }
                case LEFT_SHIFT: {
                    this.visitBinaryFunction(expr, "Long_shl");
                    break;
                }
                case RIGHT_SHIFT: {
                    this.visitBinaryFunction(expr, "Long_shr");
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    this.visitBinaryFunction(expr, "Long_shru");
                    break;
                }
                case COMPARE: {
                    this.visitBinaryFunction(expr, "Long_compare");
                    break;
                }
                case EQUALS: {
                    this.visitBinaryFunction(expr, "Long_eq");
                    break;
                }
                case NOT_EQUALS: {
                    this.visitBinaryFunction(expr, "Long_ne");
                    break;
                }
                case LESS: {
                    this.visitBinaryFunction(expr, "Long_lt");
                    break;
                }
                case LESS_OR_EQUALS: {
                    this.visitBinaryFunction(expr, "Long_le");
                    break;
                }
                case GREATER: {
                    this.visitBinaryFunction(expr, "Long_gt");
                    break;
                }
                case GREATER_OR_EQUALS: {
                    this.visitBinaryFunction(expr, "Long_ge");
                    break;
                }
            }
        } else {
            switch (expr.getOperation()) {
                case ADD: {
                    this.visitBinary(expr, "+", expr.getType() == OperationType.INT);
                    break;
                }
                case SUBTRACT: {
                    this.visitBinary(expr, "-", expr.getType() == OperationType.INT);
                    break;
                }
                case MULTIPLY: {
                    if (expr.getType() != OperationType.INT || RenderingUtil.isSmallInteger(expr.getFirstOperand()) || RenderingUtil.isSmallInteger(expr.getSecondOperand())) {
                        this.visitBinary(expr, "*", expr.getType() == OperationType.INT);
                        break;
                    }
                    this.visitBinaryFunction(expr, "$rt_imul");
                    break;
                }
                case DIVIDE: {
                    this.visitBinary(expr, "/", expr.getType() == OperationType.INT);
                    break;
                }
                case MODULO: {
                    this.visitBinary(expr, "%", expr.getType() == OperationType.INT);
                    break;
                }
                case EQUALS: {
                    if (expr.getType() == OperationType.INT) {
                        this.visitBinary(expr, "==", false);
                        break;
                    }
                    this.visitBinary(expr, "===", false);
                    break;
                }
                case NOT_EQUALS: {
                    if (expr.getType() == OperationType.INT) {
                        this.visitBinary(expr, "!=", false);
                        break;
                    }
                    this.visitBinary(expr, "!==", false);
                    break;
                }
                case GREATER: {
                    this.visitBinary(expr, ">", false);
                    break;
                }
                case GREATER_OR_EQUALS: {
                    this.visitBinary(expr, ">=", false);
                    break;
                }
                case LESS: {
                    this.visitBinary(expr, "<", false);
                    break;
                }
                case LESS_OR_EQUALS: {
                    this.visitBinary(expr, "<=", false);
                    break;
                }
                case COMPARE: {
                    this.visitBinaryFunction(expr, "$rt_compare");
                    break;
                }
                case OR: {
                    this.visitBinary(expr, "||", false);
                    break;
                }
                case AND: {
                    this.visitBinary(expr, "&&", false);
                    break;
                }
                case BITWISE_OR: {
                    this.visitBinary(expr, "|", false);
                    break;
                }
                case BITWISE_AND: {
                    this.visitBinary(expr, "&", false);
                    break;
                }
                case BITWISE_XOR: {
                    this.visitBinary(expr, "^", false);
                    break;
                }
                case LEFT_SHIFT: {
                    this.visitBinary(expr, "<<", false);
                    break;
                }
                case RIGHT_SHIFT: {
                    this.visitBinary(expr, ">>", false);
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    this.visitBinary(expr, ">>>", true);
                }
            }
        }
    }

    @Override
    public void visit(UnaryExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            Precedence outerPrecedence = this.precedence;
            switch (expr.getOperation()) {
                case NOT: {
                    if (expr.getType() == OperationType.LONG) {
                        this.longLibraryUsed = true;
                        this.writer.appendFunction("Long_not").append("(");
                        this.precedence = Precedence.min();
                        expr.getOperand().acceptVisitor(this);
                        this.writer.append(')');
                        break;
                    }
                    if (outerPrecedence.ordinal() > Precedence.UNARY.ordinal()) {
                        this.writer.append('(');
                    }
                    this.writer.append(expr.getType() == null ? "!" : "~");
                    this.precedence = Precedence.UNARY;
                    expr.getOperand().acceptVisitor(this);
                    if (outerPrecedence.ordinal() <= Precedence.UNARY.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case NEGATE: {
                    if (expr.getType() == OperationType.LONG) {
                        this.longLibraryUsed = true;
                        this.writer.appendFunction("Long_neg").append("(");
                        this.precedence = Precedence.min();
                        expr.getOperand().acceptVisitor(this);
                        this.writer.append(')');
                        break;
                    }
                    if (expr.getType() == OperationType.INT) {
                        if (outerPrecedence.ordinal() > Precedence.BITWISE_OR.ordinal()) {
                            this.writer.append('(');
                        }
                        this.writer.append(" -");
                        this.precedence = Precedence.UNARY;
                        expr.getOperand().acceptVisitor(this);
                        this.writer.ws().append("|").ws();
                        this.writer.append("0");
                        if (outerPrecedence.ordinal() <= Precedence.BITWISE_OR.ordinal()) break;
                        this.writer.append(')');
                        break;
                    }
                    if (outerPrecedence.ordinal() > Precedence.UNARY.ordinal()) {
                        this.writer.append('(');
                    }
                    this.writer.append(" -");
                    this.precedence = Precedence.UNARY;
                    expr.getOperand().acceptVisitor(this);
                    if (outerPrecedence.ordinal() <= Precedence.UNARY.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case LENGTH: {
                    this.precedence = Precedence.MEMBER_ACCESS;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(".length");
                    break;
                }
                case INT_TO_BYTE: {
                    if (outerPrecedence.ordinal() > Precedence.BITWISE_SHIFT.ordinal()) {
                        this.writer.append('(');
                    }
                    this.precedence = Precedence.BITWISE_SHIFT;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.ws().append("<<").ws().append("24").ws().append(">>").ws().append("24");
                    if (outerPrecedence.ordinal() <= Precedence.BITWISE_SHIFT.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case INT_TO_SHORT: {
                    if (outerPrecedence.ordinal() > Precedence.BITWISE_SHIFT.ordinal()) {
                        this.writer.append('(');
                    }
                    this.precedence = Precedence.BITWISE_SHIFT;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.ws().append("<<").ws().append("16").ws().append(">>").ws().append("16");
                    if (outerPrecedence.ordinal() <= Precedence.BITWISE_SHIFT.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case INT_TO_CHAR: {
                    if (outerPrecedence.ordinal() > Precedence.BITWISE_AND.ordinal()) {
                        this.writer.append('(');
                    }
                    this.precedence = Precedence.BITWISE_AND;
                    expr.getOperand().acceptVisitor(this);
                    this.writer.ws().append("&").ws().append("65535");
                    if (outerPrecedence.ordinal() <= Precedence.BITWISE_AND.ordinal()) break;
                    this.writer.append(')');
                    break;
                }
                case NULL_CHECK: {
                    this.writer.appendFunction("$rt_nullCheck").append("(");
                    this.precedence = Precedence.min();
                    expr.getOperand().acceptVisitor(this);
                    this.writer.append(')');
                }
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(CastExpr expr) {
        if (this.context.isStrict()) {
            try {
                if (expr.getLocation() != null) {
                    this.pushLocation(expr.getLocation());
                }
                if (StatementRenderer.isClass(expr.getTarget(), this.context.getClassSource())) {
                    this.writer.appendFunction("$rt_castToClass");
                } else {
                    this.writer.appendFunction("$rt_castToInterface");
                }
                this.writer.append("(");
                this.precedence = Precedence.min();
                expr.getValue().acceptVisitor(this);
                this.writer.append(",").ws();
                this.context.typeToClsString(this.writer, expr.getTarget());
                this.writer.append(")");
                if (expr.getLocation() == null) return;
                this.popLocation();
                return;
            }
            catch (IOException e) {
                throw new RenderingException("IO error occurred", e);
            }
        } else {
            expr.getValue().acceptVisitor(this);
        }
    }

    static boolean isClass(ValueType type, ClassReaderSource classSource) {
        if (!(type instanceof ValueType.Object)) {
            return false;
        }
        String className = ((ValueType.Object)type).getClassName();
        ClassReader cls = classSource.get(className);
        return cls != null && !cls.hasModifier(ElementModifier.INTERFACE);
    }

    @Override
    public void visit(PrimitiveCastExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            block1 : switch (expr.getSource()) {
                case INT: {
                    if (expr.getTarget() == OperationType.LONG) {
                        this.writer.appendFunction("Long_fromInt").append("(");
                        this.precedence = Precedence.min();
                        expr.getValue().acceptVisitor(this);
                        this.writer.append(')');
                        break;
                    }
                    expr.getValue().acceptVisitor(this);
                    break;
                }
                case LONG: {
                    switch (expr.getTarget()) {
                        case INT: {
                            this.precedence = Precedence.MEMBER_ACCESS;
                            Expr longShifted = this.extractLongRightShiftedBy32(expr.getValue());
                            if (longShifted != null) {
                                this.writer.appendFunction("Long_hi").append("(");
                                longShifted.acceptVisitor(this);
                                this.writer.append(")");
                                break block1;
                            }
                            this.writer.appendFunction("Long_lo").append("(");
                            expr.getValue().acceptVisitor(this);
                            this.writer.append(")");
                            break block1;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            this.writer.appendFunction("Long_toNumber").append("(");
                            this.precedence = Precedence.min();
                            expr.getValue().acceptVisitor(this);
                            this.writer.append(')');
                            break block1;
                        }
                    }
                    expr.getValue().acceptVisitor(this);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    switch (expr.getTarget()) {
                        case LONG: {
                            this.writer.appendFunction("Long_fromNumber").append("(");
                            this.precedence = Precedence.min();
                            expr.getValue().acceptVisitor(this);
                            this.writer.append(')');
                            break block1;
                        }
                        case INT: {
                            this.visitBinary(BinaryOperation.BITWISE_OR, "|", () -> expr.getValue().acceptVisitor(this), () -> {
                                try {
                                    this.writer.append("0");
                                }
                                catch (IOException e) {
                                    throw new RenderingException("IO error occurred", e);
                                }
                            });
                            break block1;
                        }
                    }
                    expr.getValue().acceptVisitor(this);
                }
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private Expr extractLongRightShiftedBy32(Expr expr) {
        if (!(expr instanceof BinaryExpr)) {
            return null;
        }
        BinaryExpr binary = (BinaryExpr)expr;
        if (binary.getOperation() != BinaryOperation.RIGHT_SHIFT && binary.getOperation() != BinaryOperation.UNSIGNED_RIGHT_SHIFT) {
            return null;
        }
        if (binary.getType() != OperationType.LONG) {
            return null;
        }
        if (!(binary.getSecondOperand() instanceof ConstantExpr)) {
            return null;
        }
        Object rightConstant = ((ConstantExpr)binary.getSecondOperand()).getValue();
        if (rightConstant.equals(32) || rightConstant.equals(32L)) {
            return binary.getFirstOperand();
        }
        return null;
    }

    @Override
    public void visit(ConditionalExpr expr) {
        try {
            Precedence outerPrecedence;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((outerPrecedence = this.precedence).ordinal() > Precedence.CONDITIONAL.ordinal()) {
                this.writer.append('(');
            }
            this.precedence = Precedence.CONDITIONAL.next();
            expr.getCondition().acceptVisitor(this);
            this.writer.ws().append("?").ws();
            this.precedence = Precedence.CONDITIONAL.next();
            expr.getConsequent().acceptVisitor(this);
            this.writer.ws().append(":").ws();
            this.precedence = Precedence.CONDITIONAL;
            expr.getAlternative().acceptVisitor(this);
            if (outerPrecedence.ordinal() > Precedence.CONDITIONAL.ordinal()) {
                this.writer.append(')');
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(ConstantExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.context.constantToString(this.writer, expr.getValue());
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(VariableExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.writer.append(this.variableName(expr.getIndex()));
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(SubscriptExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.precedence = Precedence.MEMBER_ACCESS;
            expr.getArray().acceptVisitor(this);
            this.writer.append('[');
            this.precedence = Precedence.min();
            expr.getIndex().acceptVisitor(this);
            this.writer.append(']');
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.precedence = Precedence.MEMBER_ACCESS;
            expr.getArray().acceptVisitor(this);
            this.writer.append(".data");
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(InvocationExpr expr) {
        try {
            Injector injector;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((injector = this.context.getInjector(expr.getMethod())) != null) {
                injector.generate(new InjectorContextImpl(expr.getArguments()), expr.getMethod());
            } else {
                boolean shouldEraseCallSite;
                Precedence outerPrecedence = this.precedence;
                if (outerPrecedence.ordinal() > Precedence.FUNCTION_CALL.ordinal()) {
                    this.writer.append('(');
                }
                if (expr.getType() == InvocationType.DYNAMIC) {
                    this.precedence = Precedence.MEMBER_ACCESS;
                    expr.getArguments().get(0).acceptVisitor(this);
                }
                MethodReference method = expr.getMethod();
                String name = this.naming.getNameFor(method.getDescriptor());
                DeferredCallSite callSite = this.prevCallSite;
                boolean bl = shouldEraseCallSite = this.lastCallSite == null;
                if (this.lastCallSite == null) {
                    this.lastCallSite = callSite;
                }
                boolean virtual = false;
                switch (expr.getType()) {
                    case STATIC: {
                        this.writer.appendMethodBody(method).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        for (int i = 0; i < expr.getArguments().size(); ++i) {
                            if (i > 0) {
                                this.writer.append(",").ws();
                            }
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        break;
                    }
                    case SPECIAL: {
                        this.writer.appendMethodBody(method).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        this.precedence = Precedence.min();
                        expr.getArguments().get(0).acceptVisitor(this);
                        for (int i = 1; i < expr.getArguments().size(); ++i) {
                            this.writer.append(",").ws();
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        break;
                    }
                    case DYNAMIC: {
                        this.writer.append(".").append(name).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        for (int i = 1; i < expr.getArguments().size(); ++i) {
                            if (i > 1) {
                                this.writer.append(",").ws();
                            }
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        virtual = true;
                        break;
                    }
                    case CONSTRUCTOR: {
                        this.writer.appendInit(expr.getMethod()).append("(");
                        this.prevCallSite = this.debugEmitter.emitCallSite();
                        for (int i = 0; i < expr.getArguments().size(); ++i) {
                            if (i > 0) {
                                this.writer.append(",").ws();
                            }
                            this.precedence = Precedence.min();
                            expr.getArguments().get(i).acceptVisitor(this);
                        }
                        break;
                    }
                }
                this.writer.append(')');
                if (this.lastCallSite != null) {
                    if (virtual) {
                        this.lastCallSite.setVirtualMethod(expr.getMethod());
                    } else {
                        this.lastCallSite.setStaticMethod(expr.getMethod());
                    }
                    this.lastCallSite = callSite;
                }
                if (shouldEraseCallSite) {
                    this.lastCallSite = null;
                }
                if (outerPrecedence.ordinal() > Precedence.FUNCTION_CALL.ordinal()) {
                    this.writer.append(')');
                }
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(QualificationExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            this.precedence = Precedence.MEMBER_ACCESS;
            if (expr.getQualified() != null) {
                expr.getQualified().acceptVisitor(this);
                this.writer.append('.').appendField(expr.getField());
            } else {
                this.writer.appendStaticField(expr.getField());
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(NewExpr expr) {
        try {
            Precedence outerPrecedence;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((outerPrecedence = this.precedence).ordinal() > Precedence.NEW.ordinal()) {
                this.writer.append('(');
            }
            this.precedence = Precedence.NEW;
            this.writer.append("new ").appendClass(expr.getConstructedClass());
            if (outerPrecedence.ordinal() > Precedence.NEW.ordinal()) {
                this.writer.append(')');
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(NewArrayExpr expr) {
        try {
            ValueType type;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((type = expr.getType()) instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        this.writer.appendFunction("$rt_createBooleanArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case BYTE: {
                        this.writer.appendFunction("$rt_createByteArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case SHORT: {
                        this.writer.appendFunction("$rt_createShortArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case INTEGER: {
                        this.writer.appendFunction("$rt_createIntArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case LONG: {
                        this.writer.appendFunction("$rt_createLongArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case FLOAT: {
                        this.writer.appendFunction("$rt_createFloatArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.appendFunction("$rt_createDoubleArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                        break;
                    }
                    case CHARACTER: {
                        this.writer.appendFunction("$rt_createCharArray").append("(");
                        this.precedence = Precedence.min();
                        expr.getLength().acceptVisitor(this);
                        this.writer.append(")");
                    }
                }
            } else {
                this.writer.appendFunction("$rt_createArray").append("(");
                this.context.typeToClsString(this.writer, expr.getType());
                this.writer.append(",").ws();
                this.precedence = Precedence.min();
                expr.getLength().acceptVisitor(this);
                this.writer.append(")");
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(ArrayFromDataExpr expr) {
        try {
            ValueType type;
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if ((type = expr.getType()) instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        this.writer.appendFunction("$rt_createBooleanArrayFromData");
                        break;
                    }
                    case BYTE: {
                        this.writer.appendFunction("$rt_createByteArrayFromData");
                        break;
                    }
                    case SHORT: {
                        this.writer.appendFunction("$rt_createShortArrayFromData");
                        break;
                    }
                    case INTEGER: {
                        this.writer.appendFunction("$rt_createIntArrayFromData");
                        break;
                    }
                    case LONG: {
                        this.writer.appendFunction("$rt_createLongArrayFromData");
                        break;
                    }
                    case FLOAT: {
                        this.writer.appendFunction("$rt_createFloatArrayFromData");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.appendFunction("$rt_createDoubleArrayFromData");
                        break;
                    }
                    case CHARACTER: {
                        this.writer.appendFunction("$rt_createCharArrayFromData");
                    }
                }
                this.writer.append("(");
            } else {
                this.writer.appendFunction("$rt_createArrayFromData").append("(");
                this.context.typeToClsString(this.writer, expr.getType());
                this.writer.append(",").ws();
            }
            this.writer.append("[");
            this.writeCommaSeparated(expr.getData());
            this.writer.append("])");
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private void writeCommaSeparated(List<Expr> expressions) throws IOException {
        boolean first = true;
        for (Expr element : expressions) {
            if (!first) {
                this.writer.append(",").ws();
            }
            first = false;
            this.precedence = Precedence.min();
            element.acceptVisitor(this);
        }
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            ValueType type = expr.getType();
            for (int i = 0; i < expr.getDimensions().size(); ++i) {
                type = ((ValueType.Array)type).getItemType();
            }
            if (type instanceof ValueType.Primitive) {
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: {
                        this.writer.append("$rt_createBooleanMultiArray(");
                        break;
                    }
                    case BYTE: {
                        this.writer.append("$rt_createByteMultiArray(");
                        break;
                    }
                    case SHORT: {
                        this.writer.append("$rt_createShortMultiArray(");
                        break;
                    }
                    case INTEGER: {
                        this.writer.append("$rt_createIntMultiArray(");
                        break;
                    }
                    case LONG: {
                        this.writer.append("$rt_createLongMultiArray(");
                        break;
                    }
                    case FLOAT: {
                        this.writer.append("$rt_createFloatMultiArray(");
                        break;
                    }
                    case DOUBLE: {
                        this.writer.append("$rt_createDoubleMultiArray(");
                        break;
                    }
                    case CHARACTER: {
                        this.writer.append("$rt_createCharMultiArray(");
                    }
                }
            } else {
                this.writer.append("$rt_createMultiArray(");
                this.context.typeToClsString(this.writer, type);
                this.writer.append(",").ws();
            }
            this.writer.append("[");
            boolean first = true;
            ArrayList<Expr> dimensions = new ArrayList<Expr>(expr.getDimensions());
            Collections.reverse(dimensions);
            for (Expr dimension : dimensions) {
                if (!first) {
                    this.writer.append(",").ws();
                }
                first = false;
                this.precedence = Precedence.min();
                dimension.acceptVisitor(this);
            }
            this.writer.append("])");
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if (StatementRenderer.isClass(expr.getType(), this.context.getClassSource())) {
                boolean needsParentheses;
                boolean bl = needsParentheses = Precedence.COMPARISON.ordinal() < this.precedence.ordinal();
                if (needsParentheses) {
                    this.writer.append('(');
                }
                this.precedence = Precedence.CONDITIONAL.next();
                expr.getExpr().acceptVisitor(this);
                this.writer.append(" instanceof ");
                this.context.typeToClsString(this.writer, expr.getType());
                if (needsParentheses) {
                    this.writer.append(')');
                }
            } else {
                this.writer.appendFunction("$rt_isInstance").append("(");
                this.precedence = Precedence.min();
                expr.getExpr().acceptVisitor(this);
                this.writer.append(",").ws();
                this.context.typeToClsString(this.writer, expr.getType());
                this.writer.append(")");
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private void visitStatements(List<Statement> statements) {
        if (statements.isEmpty()) {
            return;
        }
        boolean oldEnd = this.end;
        for (int i = 0; i < statements.size() - 1; ++i) {
            this.end = false;
            statements.get(i).acceptVisitor(this);
        }
        this.end = oldEnd;
        statements.get(statements.size() - 1).acceptVisitor(this);
        this.end = oldEnd;
    }

    @Override
    public void visit(TryCatchStatement statement) {
        try {
            this.writer.append("try").ws().append("{").softNewLine().indent();
            ArrayList<TryCatchStatement> sequence = new ArrayList<TryCatchStatement>();
            sequence.add(statement);
            List<Statement> protectedBody = statement.getProtectedBody();
            while (protectedBody.size() == 1 && protectedBody.get(0) instanceof TryCatchStatement) {
                TryCatchStatement nextStatement = (TryCatchStatement)protectedBody.get(0);
                sequence.add(nextStatement);
                protectedBody = nextStatement.getProtectedBody();
            }
            this.visitStatements(protectedBody);
            this.writer.outdent().append("}").ws().append("catch").ws().append("($$e)").ws().append("{").indent().softNewLine();
            this.writer.append("$$je").ws().append("=").ws().appendFunction("$rt_wrapException").append("($$e);").softNewLine();
            boolean first = true;
            boolean defaultHandlerOccurred = false;
            for (int i = sequence.size() - 1; i >= 0; --i) {
                TryCatchStatement catchClause = (TryCatchStatement)sequence.get(i);
                if (!first) {
                    this.writer.ws().append("else");
                }
                if (catchClause.getExceptionType() != null) {
                    if (!first) {
                        this.writer.append(" ");
                    }
                    this.writer.append("if").ws().append("($$je instanceof ").appendClass(catchClause.getExceptionType());
                    this.writer.append(")").ws();
                } else {
                    defaultHandlerOccurred = true;
                }
                if (catchClause.getExceptionType() != null || !first) {
                    this.writer.append("{").indent().softNewLine();
                }
                if (catchClause.getExceptionVariable() != null) {
                    this.writer.append(this.variableName(catchClause.getExceptionVariable())).ws().append("=").ws().append("$$je;").softNewLine();
                }
                this.visitStatements(catchClause.getHandler());
                if (catchClause.getExceptionType() != null || !first) {
                    this.writer.outdent().append("}");
                }
                first = false;
                if (defaultHandlerOccurred) break;
            }
            if (!defaultHandlerOccurred) {
                this.writer.ws().append("else").ws().append("{").indent().softNewLine();
                this.writer.append("throw $$e;").softNewLine();
                this.writer.outdent().append("}").softNewLine();
            } else {
                this.writer.softNewLine();
            }
            this.writer.outdent().append("}").softNewLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    @Override
    public void visit(GotoPartStatement statement) {
        try {
            if (statement.getPart() != this.currentPart) {
                this.writer.append(this.context.pointerName()).ws().append("=").ws().append(statement.getPart()).append(";").softNewLine();
            }
            if (!this.end || statement.getPart() != this.currentPart + 1) {
                this.writer.append("continue ").append(this.context.mainLoopName()).append(";").softNewLine();
            }
        }
        catch (IOException ex) {
            throw new RenderingException("IO error occurred", ex);
        }
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        try {
            if (this.async) {
                this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_ENTER_METHOD).append("(");
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
                this.emitSuspendChecker();
            } else {
                this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_ENTER_SYNC_METHOD).append('(');
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
            }
        }
        catch (IOException ex) {
            throw new RenderingException("IO error occurred", ex);
        }
    }

    public void emitSuspendChecker() throws IOException {
        this.writer.append("if").ws().append("(").appendFunction("$rt_suspending").append("())").ws().append("{").indent().softNewLine();
        this.writer.append("break ").append(this.context.mainLoopName()).append(";").softNewLine();
        this.writer.outdent().append("}").softNewLine();
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        try {
            if (this.async) {
                this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_EXIT_METHOD).append("(");
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
            } else {
                this.writer.appendMethodBody(NameFrequencyEstimator.MONITOR_EXIT_SYNC_METHOD).append('(');
                this.precedence = Precedence.min();
                statement.getObjectRef().acceptVisitor(this);
                this.writer.append(");").softNewLine();
            }
        }
        catch (IOException ex) {
            throw new RenderingException("IO error occurred", ex);
        }
    }

    @Override
    public void visit(BoundCheckExpr expr) {
        try {
            if (expr.getLocation() != null) {
                this.pushLocation(expr.getLocation());
            }
            if (expr.getArray() != null && expr.isLower()) {
                this.writer.appendFunction("$rt_checkBounds").append("(");
            } else if (expr.getArray() != null) {
                this.writer.appendFunction("$rt_checkUpperBound").append("(");
            } else if (expr.isLower()) {
                this.writer.appendFunction("$rt_checkLowerBound").append("(");
            }
            expr.getIndex().acceptVisitor(this);
            if (expr.getArray() != null) {
                this.writer.append(",").ws();
                expr.getArray().acceptVisitor(this);
            }
            if (expr.getArray() != null || expr.isLower()) {
                this.writer.append(")");
            }
            if (expr.getLocation() != null) {
                this.popLocation();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private class InjectorContextImpl
    implements InjectorContext {
        private final List<Expr> arguments;
        private final Precedence precedence;

        InjectorContextImpl(List<Expr> arguments) {
            this.precedence = StatementRenderer.this.precedence;
            this.arguments = arguments;
        }

        @Override
        public Expr getArgument(int index) {
            return this.arguments.get(index);
        }

        @Override
        public boolean isMinifying() {
            return StatementRenderer.this.minifying;
        }

        @Override
        public SourceWriter getWriter() {
            return StatementRenderer.this.writer;
        }

        @Override
        public void writeEscaped(String str) throws IOException {
            StatementRenderer.this.writer.append(RenderingUtil.escapeString(str));
        }

        @Override
        public void writeType(ValueType type) throws IOException {
            StatementRenderer.this.context.typeToClsString(StatementRenderer.this.writer, type);
        }

        @Override
        public void writeExpr(Expr expr) {
            this.writeExpr(expr, Precedence.GROUPING);
        }

        @Override
        public void writeExpr(Expr expr, Precedence precedence) {
            StatementRenderer.this.precedence = precedence;
            expr.acceptVisitor(StatementRenderer.this);
        }

        @Override
        public int argumentCount() {
            return this.arguments.size();
        }

        @Override
        public <T> T getService(Class<T> type) {
            return StatementRenderer.this.context.getServices().getService(type);
        }

        @Override
        public Properties getProperties() {
            return new Properties(StatementRenderer.this.context.getProperties());
        }

        @Override
        public Precedence getPrecedence() {
            return this.precedence;
        }

        @Override
        public ClassLoader getClassLoader() {
            return StatementRenderer.this.context.getClassLoader();
        }

        @Override
        public ListableClassReaderSource getClassSource() {
            return StatementRenderer.this.context.getClassSource();
        }

        @Override
        public String importModule(String name) {
            return StatementRenderer.this.context.importModule(name);
        }
    }
}

