/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing.substitution;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ClassMappings
implements Function<String, List<String>> {
    private final Map<String, List<String>> mappedClassNames = new LinkedHashMap<String, List<String>>();
    private final List<String> mappedPackageNames = new LinkedList<String>();
    private final List<String> mappedPackageHierarchyNames = new LinkedList<String>();
    private final Map<String, ClassMappings> subMappings = new HashMap<String, ClassMappings>();

    @Override
    public List<String> apply(String className) {
        LinkedList<String> mappings = new LinkedList<String>();
        this.getMappingsInto(className.split("\\."), mappings);
        return mappings;
    }

    public void addPackageHierarchyMappingRule(String[] packageNameSegments, String mappedPackageName) {
        if (packageNameSegments == null || packageNameSegments.length < 1) {
            this.mappedPackageHierarchyNames.add(mappedPackageName);
        } else {
            this.subMappings.computeIfAbsent(packageNameSegments[0], packageName -> new ClassMappings()).addPackageHierarchyMappingRule(Arrays.copyOfRange(packageNameSegments, 1, packageNameSegments.length), mappedPackageName);
        }
    }

    public void addPackageMappingRule(String[] packageNameSegments, String mappedPackageName) {
        if (packageNameSegments == null || packageNameSegments.length < 1) {
            this.mappedPackageNames.add(mappedPackageName);
        } else {
            this.subMappings.computeIfAbsent(packageNameSegments[0], packageName -> new ClassMappings()).addPackageMappingRule(Arrays.copyOfRange(packageNameSegments, 1, packageNameSegments.length), mappedPackageName);
        }
    }

    public void addClassMappingRule(String[] classNameSegments, String mappedClassName) {
        if (classNameSegments == null || classNameSegments.length < 1) {
            return;
        }
        if (classNameSegments.length == 1) {
            this.mappedClassNames.computeIfAbsent(classNameSegments[0], simpleClassName -> new LinkedList()).add(mappedClassName);
            return;
        }
        this.subMappings.computeIfAbsent(classNameSegments[0], packageName -> new ClassMappings()).addClassMappingRule(Arrays.copyOfRange(classNameSegments, 1, classNameSegments.length), mappedClassName);
    }

    private void getMappingsInto(String[] classNameSegments, List<String> mappings) {
        if (classNameSegments == null || classNameSegments.length < 1) {
            return;
        }
        if (classNameSegments.length == 1) {
            List<String> classNameMappings = this.mappedClassNames.get(classNameSegments[0]);
            if (classNameMappings != null) {
                mappings.addAll(classNameMappings);
            }
            if (!this.mappedPackageNames.isEmpty()) {
                String mappingSuffix = "." + classNameSegments[0];
                for (String packageName : this.mappedPackageNames) {
                    mappings.add(packageName + mappingSuffix);
                }
            }
        } else {
            ClassMappings classMappings = this.subMappings.get(classNameSegments[0]);
            if (classMappings != null) {
                classMappings.getMappingsInto(Arrays.copyOfRange(classNameSegments, 1, classNameSegments.length), mappings);
            }
        }
        if (!this.mappedPackageHierarchyNames.isEmpty()) {
            String mappingSuffix = "." + String.join((CharSequence)".", classNameSegments);
            for (String packageName : this.mappedPackageHierarchyNames) {
                mappings.add(packageName + mappingSuffix);
            }
        }
    }
}

