/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import org.teavm.common.Graph;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.common.IntegerArray;
import org.teavm.common.MutableDirectedGraph;
import org.teavm.hppc.IntIntHashMap;

public class DefaultGraphSplittingBackend
implements GraphSplittingBackend {
    private MutableDirectedGraph graph;
    private int index;
    private IntegerArray prototypeNodes;
    private IntegerArray copyIndexes;
    private int[] copyCount;

    public DefaultGraphSplittingBackend(Graph graph) {
        this.graph = new MutableDirectedGraph(graph);
        this.prototypeNodes = new IntegerArray(graph.size());
        this.copyIndexes = new IntegerArray(graph.size());
        this.copyCount = new int[graph.size()];
        this.index = graph.size();
        for (int i = 0; i < graph.size(); ++i) {
            this.prototypeNodes.add(i);
            this.copyIndexes.add(0);
        }
    }

    public Graph getGraph() {
        return this.graph.copyToImmutable();
    }

    public int prototype(int index) {
        return this.prototypeNodes.get(index);
    }

    @Override
    public int[] split(int[] domain, int[] nodes) {
        int node;
        int i;
        int[] copies = new int[nodes.length];
        IntIntHashMap map = new IntIntHashMap();
        for (i = 0; i < nodes.length; ++i) {
            ++this.index;
            map.put(nodes[i], copies[i] + 1);
            int proto = this.prototypeNodes.get(nodes[i]);
            this.prototypeNodes.add(proto);
            int n = proto;
            int n2 = this.copyCount[n] + 1;
            this.copyCount[n] = n2;
            this.copyIndexes.add(n2);
        }
        for (i = 0; i < domain.length; ++i) {
            node = domain[i];
            for (int succ : this.graph.outgoingEdges(node)) {
                int succCopy = map.get(succ);
                if (succCopy == 0) continue;
                this.graph.deleteEdge(node, succ);
                this.graph.addEdge(node, --succCopy);
            }
        }
        for (i = 0; i < nodes.length; ++i) {
            node = nodes[i];
            int nodeCopy = copies[i];
            for (int succ : this.graph.outgoingEdges(node)) {
                int succCopy = map.get(succ);
                if (succCopy != 0) {
                    this.graph.addEdge(nodeCopy, succCopy - 1);
                    continue;
                }
                this.graph.addEdge(nodeCopy, succ);
            }
        }
        return copies;
    }
}

