/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.Arrays;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.render.WasmBinaryVersion;

public class WasmBinaryWriter {
    private byte[] data = new byte[1024];
    private int pointer;

    public void writeByte(int v) {
        this.alloc(1);
        this.data[this.pointer++] = (byte)v;
    }

    public void writeType(WasmType type, WasmBinaryVersion version) {
        if (type == null) {
            this.writeByte(64);
            return;
        }
        switch (type) {
            case INT32: {
                this.writeByte(127);
                break;
            }
            case INT64: {
                this.writeByte(126);
                break;
            }
            case FLOAT32: {
                this.writeByte(125);
                break;
            }
            case FLOAT64: {
                this.writeByte(124);
            }
        }
    }

    public int getPosition() {
        return this.pointer;
    }

    public void writeBytes(byte[] bytes) {
        this.alloc(bytes.length);
        System.arraycopy(bytes, 0, this.data, this.pointer, bytes.length);
        this.pointer += bytes.length;
    }

    public void writeAsciiString(String str) {
        this.writeLEB(str.length());
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            bytes[i] = (byte)str.charAt(i);
        }
        this.writeBytes(bytes);
    }

    public void writeInt32(int v) {
        this.alloc(4);
        for (int i = 0; i < 4; ++i) {
            this.data[this.pointer++] = (byte)(v & 0xFF);
            v >>>= 8;
        }
    }

    public void writeLEB(int v) {
        this.alloc(5);
        while (true) {
            boolean last;
            int digit = v & 0x7F;
            int next = v >>> 7;
            boolean bl = last = next == 0;
            if (!last) {
                digit |= 0xFFFFFF80;
            }
            this.data[this.pointer++] = (byte)digit;
            if (last) break;
            v = next;
        }
    }

    public void writeLEB4(int v) {
        this.alloc(4);
        for (int i = 0; i < 3; ++i) {
            int digit = v & 0x7F;
            this.data[this.pointer++] = (byte)(digit | 0x80);
            v >>>= 7;
        }
        this.data[this.pointer++] = (byte)(v & 0x7F);
    }

    public void writeSignedLEB(int v) {
        boolean last;
        this.alloc(5);
        do {
            int digit = v & 0x7F;
            boolean bl = last = (v >>= 7) == 0 && (digit & 0x40) == 0 || v == -1 && (digit & 0x40) != 0;
            if (!last) {
                digit |= 0xFFFFFF80;
            }
            this.data[this.pointer++] = (byte)digit;
        } while (!last);
    }

    public void writeLEB(long v) {
        this.alloc(10);
        while (true) {
            boolean last;
            int digit = (int)(v & 0x7FL);
            long next = v >>> 7;
            boolean bl = last = next == 0L;
            if (!last) {
                digit |= 0xFFFFFF80;
            }
            this.data[this.pointer++] = (byte)digit;
            if (last) break;
            v = next;
        }
    }

    public void writeSignedLEB(long v) {
        boolean last;
        this.alloc(10);
        do {
            int digit = (int)(v & 0x7FL);
            boolean bl = last = (v >>= 7) == 0L && (digit & 0x40) == 0 || v == -1L && (digit & 0x40) != 0;
            if (!last) {
                digit |= 0xFFFFFF80;
            }
            this.data[this.pointer++] = (byte)digit;
        } while (!last);
    }

    public void writeFixed(int v) {
        this.alloc(4);
        for (int i = 0; i < 4; ++i) {
            this.data[this.pointer++] = (byte)v;
            v >>>= 8;
        }
    }

    public void writeFixed(long v) {
        this.alloc(8);
        for (int i = 0; i < 8; ++i) {
            this.data[this.pointer++] = (byte)v;
            v >>>= 8;
        }
    }

    private void alloc(int size) {
        if (this.data.length - this.pointer < size) {
            int newLength = this.data.length * 2;
            if (newLength < this.pointer + size) {
                newLength = (this.pointer + size) * 2;
            }
            this.data = Arrays.copyOf(this.data, newLength);
        }
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.pointer);
    }
}

