/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import org.teavm.rhino.javascript.Node;
import org.teavm.rhino.javascript.ast.ArrayComprehension;
import org.teavm.rhino.javascript.ast.ArrayComprehensionLoop;
import org.teavm.rhino.javascript.ast.ArrayLiteral;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.AstRoot;
import org.teavm.rhino.javascript.ast.Block;
import org.teavm.rhino.javascript.ast.BreakStatement;
import org.teavm.rhino.javascript.ast.CatchClause;
import org.teavm.rhino.javascript.ast.ConditionalExpression;
import org.teavm.rhino.javascript.ast.ContinueStatement;
import org.teavm.rhino.javascript.ast.DoLoop;
import org.teavm.rhino.javascript.ast.ElementGet;
import org.teavm.rhino.javascript.ast.EmptyExpression;
import org.teavm.rhino.javascript.ast.EmptyStatement;
import org.teavm.rhino.javascript.ast.ExpressionStatement;
import org.teavm.rhino.javascript.ast.ForInLoop;
import org.teavm.rhino.javascript.ast.ForLoop;
import org.teavm.rhino.javascript.ast.FunctionCall;
import org.teavm.rhino.javascript.ast.FunctionNode;
import org.teavm.rhino.javascript.ast.GeneratorExpression;
import org.teavm.rhino.javascript.ast.GeneratorExpressionLoop;
import org.teavm.rhino.javascript.ast.IfStatement;
import org.teavm.rhino.javascript.ast.InfixExpression;
import org.teavm.rhino.javascript.ast.LabeledStatement;
import org.teavm.rhino.javascript.ast.LetNode;
import org.teavm.rhino.javascript.ast.Name;
import org.teavm.rhino.javascript.ast.NewExpression;
import org.teavm.rhino.javascript.ast.NumberLiteral;
import org.teavm.rhino.javascript.ast.ObjectLiteral;
import org.teavm.rhino.javascript.ast.ObjectProperty;
import org.teavm.rhino.javascript.ast.ParenthesizedExpression;
import org.teavm.rhino.javascript.ast.PropertyGet;
import org.teavm.rhino.javascript.ast.RegExpLiteral;
import org.teavm.rhino.javascript.ast.ReturnStatement;
import org.teavm.rhino.javascript.ast.Scope;
import org.teavm.rhino.javascript.ast.StringLiteral;
import org.teavm.rhino.javascript.ast.SwitchCase;
import org.teavm.rhino.javascript.ast.SwitchStatement;
import org.teavm.rhino.javascript.ast.ThrowStatement;
import org.teavm.rhino.javascript.ast.TryStatement;
import org.teavm.rhino.javascript.ast.UnaryExpression;
import org.teavm.rhino.javascript.ast.VariableDeclaration;
import org.teavm.rhino.javascript.ast.VariableInitializer;
import org.teavm.rhino.javascript.ast.WhileLoop;

public class AstVisitor {
    public void accept(AstNode node) {
        switch (node.getType()) {
            case 140: {
                this.visitRoot((AstRoot)node);
                break;
            }
            case 30: 
            case 38: {
                this.visitFunctionCall((FunctionCall)node);
                break;
            }
            case 113: {
                this.visitFunction((FunctionNode)node);
                break;
            }
            case 161: {
                this.visitArrayComprehension((ArrayComprehension)node);
                break;
            }
            case 33: {
                this.visitPropertyGet((PropertyGet)node);
                break;
            }
            case 166: {
                this.visitGenerator((GeneratorExpression)node);
                break;
            }
            case 40: {
                this.visitNumber((NumberLiteral)node);
                break;
            }
            case 41: {
                this.visitString((StringLiteral)node);
                break;
            }
            case 45: {
                this.visitTrue(node);
                break;
            }
            case 44: {
                this.visitFalse(node);
                break;
            }
            case 43: {
                this.visitThis(node);
                break;
            }
            case 42: {
                this.visitNull(node);
                break;
            }
            case 39: {
                this.visitName((Name)node);
                break;
            }
            case 48: {
                this.visitRegexp((RegExpLiteral)node);
                break;
            }
            case 67: {
                this.visitObjectLiteral((ObjectLiteral)node);
                break;
            }
            case 66: {
                this.visitArrayLiteral((ArrayLiteral)node);
                break;
            }
            case 133: {
                if (node instanceof Block) {
                    this.visitBlock((Block)node);
                    break;
                }
                if (!(node instanceof Scope)) break;
                this.visitScope((Scope)node);
                break;
            }
            case 106: {
                this.visitConditionalExpr((ConditionalExpression)node);
                break;
            }
            case 36: {
                this.visitElementGet((ElementGet)node);
                break;
            }
            case 162: {
                this.visitLet((LetNode)node);
                break;
            }
            case 90: {
                this.visitParenthesized((ParenthesizedExpression)node);
                break;
            }
            case 132: {
                if (node instanceof EmptyStatement) {
                    this.visitEmpty((EmptyStatement)node);
                    break;
                }
                this.visitEmpty((EmptyExpression)node);
                break;
            }
            case 137: 
            case 138: {
                if (node instanceof ExpressionStatement) {
                    this.visitExpressionStatement((ExpressionStatement)node);
                    break;
                }
                if (!(node instanceof LabeledStatement)) break;
                this.visitLabeledStatement((LabeledStatement)node);
                break;
            }
            case 124: {
                this.visitBreak((BreakStatement)node);
                break;
            }
            case 125: {
                this.visitContinue((ContinueStatement)node);
                break;
            }
            case 4: {
                this.visitReturn((ReturnStatement)node);
                break;
            }
            case 122: {
                this.visitDo((DoLoop)node);
                break;
            }
            case 123: {
                if (node instanceof ForInLoop) {
                    this.visitForIn((ForInLoop)node);
                    break;
                }
                if (!(node instanceof ForLoop)) break;
                this.visitFor((ForLoop)node);
                break;
            }
            case 116: {
                this.visitIf((IfStatement)node);
                break;
            }
            case 118: {
                this.visitSwitch((SwitchStatement)node);
                break;
            }
            case 50: {
                this.visitThrow((ThrowStatement)node);
                break;
            }
            case 84: {
                this.visitTry((TryStatement)node);
                break;
            }
            case 126: 
            case 157: 
            case 158: {
                this.visitVariableDeclaration((VariableDeclaration)node);
                break;
            }
            case 121: {
                this.visitWhile((WhileLoop)node);
                break;
            }
            default: {
                if (node instanceof InfixExpression) {
                    this.visitInfix((InfixExpression)node);
                    break;
                }
                if (!(node instanceof UnaryExpression)) break;
                this.visitUnary((UnaryExpression)node);
            }
        }
    }

    protected void visitRoot(AstRoot node) {
        for (Node child : node) {
            this.accept((AstNode)child);
        }
    }

    protected void visitBlock(Block node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            this.accept((AstNode)child);
        }
    }

    protected void visitScope(Scope node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            this.accept((AstNode)child);
        }
    }

    protected void visitLabeledStatement(LabeledStatement node) {
        this.accept(node.getStatement());
    }

    protected void visitBreak(BreakStatement node) {
    }

    protected void visitContinue(ContinueStatement node) {
    }

    protected void visitReturn(ReturnStatement node) {
        if (node.getReturnValue() != null) {
            this.accept(node.getReturnValue());
        }
    }

    protected void visitThrow(ThrowStatement node) {
        this.accept(node.getExpression());
    }

    protected void visitDo(DoLoop node) {
        this.accept(node.getBody());
        this.accept(node.getCondition());
    }

    protected void visitForIn(ForInLoop node) {
        this.accept(node.getIterator());
        this.accept(node.getIteratedObject());
        this.accept(node.getBody());
    }

    protected void visitFor(ForLoop node) {
        this.accept(node.getInitializer());
        this.accept(node.getCondition());
        this.accept(node.getIncrement());
        this.accept(node.getBody());
    }

    protected void visitWhile(WhileLoop node) {
        this.accept(node.getCondition());
        this.accept(node.getBody());
    }

    protected void visitIf(IfStatement node) {
        this.accept(node.getCondition());
        this.accept(node.getThenPart());
        if (node.getElsePart() != null) {
            this.accept(node.getElsePart());
        }
    }

    protected void visitSwitch(SwitchStatement node) {
        this.accept(node.getExpression());
        for (SwitchCase sc : node.getCases()) {
            if (sc.getExpression() != null) {
                this.accept(sc.getExpression());
            }
            if (sc.getStatements() == null) continue;
            for (AstNode stmt : sc.getStatements()) {
                this.accept(stmt);
            }
        }
    }

    protected void visitTry(TryStatement node) {
        this.accept(node.getTryBlock());
        for (CatchClause cc : node.getCatchClauses()) {
            if (cc.getCatchCondition() != null) {
                this.accept(cc.getCatchCondition());
            }
            this.accept((AstNode)cc.getBody());
        }
        if (node.getFinallyBlock() != null) {
            this.accept(node.getFinallyBlock());
        }
    }

    protected void visitVariableDeclaration(VariableDeclaration node) {
        for (int i = 1; i < node.getVariables().size(); ++i) {
            this.visitVariableInitializer((VariableInitializer)node.getVariables().get(i));
        }
    }

    protected void visitVariableInitializer(VariableInitializer node) {
        this.accept(node.getTarget());
        if (node.getInitializer() != null) {
            this.accept(node.getInitializer());
        }
    }

    protected void visitExpressionStatement(ExpressionStatement node) {
        this.accept(node.getExpression());
    }

    protected void visitElementGet(ElementGet node) {
        this.accept(node.getTarget());
        this.accept(node.getElement());
    }

    protected void visitPropertyGet(PropertyGet node) {
        this.accept(node.getLeft());
        this.accept(node.getRight());
    }

    protected void visitFunctionCall(FunctionCall node) {
        NewExpression newExpr;
        this.accept(node.getTarget());
        for (AstNode arg : node.getArguments()) {
            this.accept(arg);
        }
        if (node instanceof NewExpression && (newExpr = (NewExpression)node).getInitializer() != null) {
            this.accept((AstNode)newExpr.getInitializer());
        }
    }

    protected void visitConditionalExpr(ConditionalExpression node) {
        this.accept(node.getTestExpression());
        this.accept(node.getTrueExpression());
        this.accept(node.getFalseExpression());
    }

    protected void visitArrayComprehension(ArrayComprehension node) {
        for (ArrayComprehensionLoop loop : node.getLoops()) {
            this.accept(loop.getIterator());
            this.accept(loop.getIteratedObject());
        }
        if (node.getFilter() != null) {
            this.accept(node.getFilter());
        }
        this.accept(node.getResult());
    }

    protected void visitGenerator(GeneratorExpression node) {
        for (GeneratorExpressionLoop loop : node.getLoops()) {
            this.accept(loop.getIterator());
            this.accept(loop.getIteratedObject());
        }
        if (node.getFilter() != null) {
            this.accept(node.getFilter());
        }
        this.accept(node.getResult());
    }

    protected void visitNumber(NumberLiteral node) {
    }

    protected void visitString(StringLiteral node) {
    }

    protected void visitThis(AstNode node) {
    }

    protected void visitTrue(AstNode node) {
    }

    protected void visitFalse(AstNode node) {
    }

    protected void visitNull(AstNode node) {
    }

    protected void visitEmpty(EmptyStatement node) {
    }

    protected void visitEmpty(EmptyExpression node) {
    }

    protected void visitName(Name node) {
    }

    protected void visitRegexp(RegExpLiteral node) {
    }

    protected void visitArrayLiteral(ArrayLiteral node) {
        for (AstNode element : node.getElements()) {
            this.accept(element);
        }
    }

    protected void visitObjectLiteral(ObjectLiteral node) {
        if (node.getElements() != null) {
            for (ObjectProperty property : node.getElements()) {
                this.visitObjectProperty(property);
            }
        }
    }

    protected void visitObjectProperty(ObjectProperty node) {
        this.accept(node.getLeft());
        this.accept(node.getRight());
    }

    protected void visitFunction(FunctionNode node) {
        if (node.getFunctionName() != null) {
            this.accept((AstNode)node.getFunctionName());
        }
        for (AstNode param : node.getParams()) {
            this.accept(param);
        }
        this.accept(node.getBody());
    }

    protected void visitLet(LetNode node) {
        this.accept((AstNode)node.getVariables());
        this.accept(node.getBody());
    }

    protected void visitParenthesized(ParenthesizedExpression node) {
        this.accept(node.getExpression());
    }

    protected void visitUnary(UnaryExpression node) {
        this.accept(node.getOperand());
    }

    protected void visitInfix(InfixExpression node) {
        this.accept(node.getLeft());
        this.accept(node.getRight());
    }
}

