/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import org.teavm.backend.wasm.blob.Blob;
import org.teavm.backend.wasm.blob.Marker;
import org.teavm.backend.wasm.debug.info.VariableType;
import org.teavm.backend.wasm.dwarf.DwarfAbbreviation;
import org.teavm.backend.wasm.dwarf.DwarfInfoWriter;
import org.teavm.backend.wasm.generate.DwarfClassGenerator;
import org.teavm.backend.wasm.generate.DwarfGenerator;
import org.teavm.backend.wasm.generate.DwarfStrings;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.model.MethodDescriptor;

public class DwarfFunctionGenerator {
    private DwarfClassGenerator classGen;
    private DwarfGenerator generator;
    private WasmFunction function;
    private int offset;
    private Marker endProgramMarker;
    private DwarfAbbreviation methodAbbrev;
    private DwarfAbbreviation functionAbbrev;
    private DwarfAbbreviation parameterAbbrev;
    private DwarfAbbreviation variableAbbrev;
    private DwarfClassGenerator.Subprogram subprogram;

    public DwarfFunctionGenerator(DwarfClassGenerator classGen, DwarfGenerator generator) {
        this.classGen = classGen;
        this.generator = generator;
    }

    public void begin(WasmFunction function, int offset) {
        if (function.getName() == null) {
            return;
        }
        this.subprogram = this.classGen.getSubprogram(function.getName());
        DwarfInfoWriter writer = this.generator.getInfoWriter();
        DwarfStrings strings = this.generator.strings;
        writer.tag(this.subprogram != null ? this.getMethodAbbrev() : this.getFunctionAbbrev());
        if (this.subprogram != null) {
            writer.ref(this.subprogram.ref, Blob::writeInt);
        } else {
            writer.writeInt(strings.stringRef(this.subprogram != null ? this.subprogram.name : function.getName()));
        }
        writer.writeInt(offset);
        this.endProgramMarker = writer.marker();
        writer.skip(4);
        this.function = function;
        this.offset = offset;
        this.writeLocals();
    }

    private void writeLocals() {
        Blob operations;
        WasmLocal local;
        int i;
        if (this.subprogram == null) {
            return;
        }
        MethodDescriptor descriptor = this.subprogram.descriptor;
        if (descriptor == null) {
            return;
        }
        DwarfInfoWriter writer = this.generator.getInfoWriter();
        DwarfStrings strings = this.generator.strings;
        int offset = this.subprogram.isStatic ? 0 : 1;
        int count = Math.min(this.function.getLocalVariables().size() - offset, descriptor.parameterCount());
        for (i = 0; i < count; ++i) {
            local = this.function.getLocalVariables().get(i + offset);
            if (local.getName() == null) continue;
            writer.tag(this.getParameterAbbrev());
            writer.writeInt(strings.stringRef(local.getName()));
            writer.ref(this.classGen.getTypePtr(descriptor.parameterType(i)), Blob::writeInt);
            operations = new Blob();
            operations.writeByte(237).writeByte(0).writeLEB(i + 1);
            writer.writeLEB(operations.size());
            operations.newReader(writer::write).readRemaining();
        }
        for (i = count + offset; i < this.function.getLocalVariables().size(); ++i) {
            local = this.function.getLocalVariables().get(i);
            if (local.getName() == null || local.getJavaType() == null) continue;
            writer.tag(this.getVariableAbbrev());
            writer.writeInt(strings.stringRef(local.getName()));
            writer.ref(this.classGen.getTypePtr(local.getJavaType()), Blob::writeInt);
            operations = new Blob();
            operations.writeByte(237).writeByte(0).writeLEB(i + 1);
            if (local.getJavaType() == VariableType.OBJECT) {
                operations.writeByte(159);
            }
            writer.writeLEB(operations.size());
            operations.newReader(writer::write).readRemaining();
        }
    }

    public void end(int size) {
        if (this.function == null) {
            return;
        }
        DwarfInfoWriter writer = this.generator.getInfoWriter();
        if (this.endProgramMarker != null) {
            Marker backup = writer.marker();
            this.endProgramMarker.rewind();
            writer.writeInt(this.offset + size);
            backup.rewind();
        }
        writer.emptyTag();
        this.classGen.flushTypes();
        this.subprogram = null;
        this.endProgramMarker = null;
        this.function = null;
    }

    private DwarfAbbreviation getMethodAbbrev() {
        if (this.methodAbbrev == null) {
            this.methodAbbrev = this.generator.getInfoWriter().abbreviation(46, true, data -> {
                data.writeLEB(71).writeLEB(19);
                data.writeLEB(17).writeLEB(1);
                data.writeLEB(18).writeLEB(1);
            });
        }
        return this.methodAbbrev;
    }

    private DwarfAbbreviation getFunctionAbbrev() {
        if (this.functionAbbrev == null) {
            this.functionAbbrev = this.generator.getInfoWriter().abbreviation(46, true, data -> {
                data.writeLEB(3).writeLEB(14);
                data.writeLEB(17).writeLEB(1);
                data.writeLEB(18).writeLEB(1);
            });
        }
        return this.functionAbbrev;
    }

    private DwarfAbbreviation getParameterAbbrev() {
        if (this.parameterAbbrev == null) {
            this.parameterAbbrev = this.generator.getInfoWriter().abbreviation(5, false, data -> {
                data.writeLEB(3).writeLEB(14);
                data.writeLEB(73).writeLEB(19);
                data.writeLEB(2).writeLEB(24);
            });
        }
        return this.parameterAbbrev;
    }

    private DwarfAbbreviation getVariableAbbrev() {
        if (this.variableAbbrev == null) {
            this.variableAbbrev = this.generator.getInfoWriter().abbreviation(52, false, data -> {
                data.writeLEB(3).writeLEB(14);
                data.writeLEB(73).writeLEB(19);
                data.writeLEB(2).writeLEB(24);
            });
        }
        return this.variableAbbrev;
    }
}

