/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.wasm.blob.Blob;
import org.teavm.backend.wasm.debug.info.VariableType;
import org.teavm.backend.wasm.dwarf.DwarfAbbreviation;
import org.teavm.backend.wasm.dwarf.DwarfInfoWriter;
import org.teavm.backend.wasm.dwarf.DwarfPlaceholder;
import org.teavm.backend.wasm.generate.DwarfStrings;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.PrimitiveType;
import org.teavm.model.ValueType;

public class DwarfClassGenerator {
    private static final ValueType objectType = ValueType.object("java.lang.Object");
    final Namespace root = new Namespace(null);
    final Map<String, Subprogram> subprogramsByFunctionName = new HashMap<String, Subprogram>();
    final List<Subprogram> rootSubprograms = new ArrayList<Subprogram>();
    private final DwarfInfoWriter writer;
    private final DwarfStrings strings;
    private DwarfAbbreviation nsAbbrev;
    private DwarfAbbreviation classTypeAbbrev;
    private DwarfAbbreviation inheritanceAbbrev;
    private DwarfAbbreviation methodAbbrev;
    private DwarfPlaceholder[] primitiveTypes = new DwarfPlaceholder[PrimitiveType.values().length];
    private DwarfPlaceholder unspecifiedType;
    private DwarfAbbreviation baseTypeAbbrev;
    private DwarfAbbreviation pointerAbbrev;
    private DwarfAbbreviation variableAbbrev;
    private List<Runnable> postponedWrites = new ArrayList<Runnable>();
    private ClassType classClass;

    public DwarfClassGenerator(DwarfInfoWriter writer, DwarfStrings strings) {
        this.writer = writer;
        this.strings = strings;
    }

    public void flushTypes() {
        for (Runnable postponedWrite : this.postponedWrites) {
            postponedWrite.run();
        }
        this.postponedWrites.clear();
    }

    public ClassType getClass(String fullName) {
        int next;
        int index = 0;
        Namespace ns = this.root;
        while ((next = fullName.indexOf(46, index)) >= 0) {
            ns = ns.getNamespace(fullName.substring(index, next));
            index = next + 1;
        }
        return ns.getClass(fullName.substring(index));
    }

    public void registerSubprogram(String functionName, Subprogram subprogram) {
        this.subprogramsByFunctionName.put(functionName, subprogram);
    }

    public Subprogram getSubprogram(String functionName) {
        return this.subprogramsByFunctionName.get(functionName);
    }

    public void write() {
        this.classClass = this.getClass("java.lang.Class");
        this.root.writeChildren();
        for (Subprogram subprogram : this.rootSubprograms) {
            subprogram.write();
        }
        this.flushTypes();
    }

    private DwarfAbbreviation getMethodAbbrev() {
        if (this.methodAbbrev == null) {
            this.methodAbbrev = this.writer.abbreviation(46, true, data -> {
                data.writeLEB(3).writeLEB(14);
                data.writeLEB(60).writeLEB(25);
            });
        }
        return this.methodAbbrev;
    }

    private DwarfAbbreviation getNsAbbrev() {
        if (this.nsAbbrev == null) {
            this.nsAbbrev = this.writer.abbreviation(57, true, data -> data.writeLEB(3).writeLEB(14));
        }
        return this.nsAbbrev;
    }

    private DwarfAbbreviation getClassTypeAbbrev() {
        if (this.classTypeAbbrev == null) {
            this.classTypeAbbrev = this.writer.abbreviation(2, true, data -> {
                data.writeLEB(3).writeLEB(14);
                data.writeLEB(11).writeLEB(5);
            });
        }
        return this.classTypeAbbrev;
    }

    private DwarfAbbreviation getInheritanceAbbrev() {
        if (this.inheritanceAbbrev == null) {
            this.inheritanceAbbrev = this.writer.abbreviation(28, false, data -> data.writeLEB(73).writeLEB(19));
        }
        return this.inheritanceAbbrev;
    }

    public DwarfPlaceholder getTypePtr(VariableType type) {
        switch (type) {
            case INT: {
                return this.getPrimitivePtr(ValueType.Primitive.INTEGER);
            }
            case LONG: {
                return this.getPrimitivePtr(ValueType.Primitive.LONG);
            }
            case FLOAT: {
                return this.getPrimitivePtr(ValueType.Primitive.FLOAT);
            }
            case DOUBLE: {
                return this.getPrimitivePtr(ValueType.Primitive.DOUBLE);
            }
        }
        return this.getTypePtr(objectType);
    }

    public DwarfPlaceholder getTypePtr(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            return this.getPrimitivePtr((ValueType.Primitive)type);
        }
        if (type instanceof ValueType.Object) {
            return this.getClassType(((ValueType.Object)type).getClassName());
        }
        return this.getClassType("java.lang.Object");
    }

    private DwarfPlaceholder getUnspecifiedType() {
        if (this.unspecifiedType == null) {
            this.unspecifiedType = this.writer.placeholder(4);
            DwarfAbbreviation abbrev = this.writer.abbreviation(59, false, blob -> blob.writeInt(3).writeInt(14));
            this.writer.mark(this.unspecifiedType).tag(abbrev).writeInt(this.strings.stringRef("<unspecified>"));
        }
        return this.unspecifiedType;
    }

    private DwarfPlaceholder getClassType(String name) {
        return this.getClass((String)name).ptr;
    }

    private DwarfPlaceholder getPrimitivePtr(ValueType.Primitive type) {
        DwarfPlaceholder result = this.primitiveTypes[type.getKind().ordinal()];
        if (result == null) {
            int encoding;
            int byteSize;
            String name;
            switch (type.getKind()) {
                case BOOLEAN: {
                    name = "boolean";
                    byteSize = 1;
                    encoding = 2;
                    break;
                }
                case BYTE: {
                    name = "byte";
                    byteSize = 1;
                    encoding = 5;
                    break;
                }
                case SHORT: {
                    name = "short";
                    byteSize = 2;
                    encoding = 5;
                    break;
                }
                case CHARACTER: {
                    name = "char";
                    byteSize = 2;
                    encoding = 16;
                    break;
                }
                case INTEGER: {
                    name = "int";
                    byteSize = 4;
                    encoding = 5;
                    break;
                }
                case LONG: {
                    name = "long";
                    byteSize = 8;
                    encoding = 5;
                    break;
                }
                case FLOAT: {
                    name = "float";
                    encoding = 4;
                    byteSize = 4;
                    break;
                }
                case DOUBLE: {
                    name = "double";
                    encoding = 4;
                    byteSize = 8;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            DwarfPlaceholder ptr = this.writer.placeholder(4);
            this.postponedWrites.add(() -> {
                this.writer.mark(ptr).tag(this.getBaseTypeAbbrev());
                this.writer.writeInt(this.strings.stringRef(name));
                this.writer.writeByte(byteSize);
                this.writer.writeByte(encoding);
            });
            result = ptr;
            this.primitiveTypes[type.getKind().ordinal()] = ptr;
        }
        return result;
    }

    private DwarfAbbreviation getBaseTypeAbbrev() {
        if (this.baseTypeAbbrev == null) {
            this.baseTypeAbbrev = this.writer.abbreviation(36, false, blob -> {
                blob.writeLEB(3).writeLEB(14);
                blob.writeLEB(11).writeLEB(11);
                blob.writeLEB(62).writeLEB(11);
            });
        }
        return this.baseTypeAbbrev;
    }

    private DwarfAbbreviation getPointerAbbrev() {
        if (this.pointerAbbrev == null) {
            this.pointerAbbrev = this.writer.abbreviation(15, false, blob -> blob.writeLEB(73).writeLEB(19));
        }
        return this.pointerAbbrev;
    }

    private DwarfAbbreviation getVariableAbbrev() {
        if (this.variableAbbrev == null) {
            this.variableAbbrev = this.writer.abbreviation(52, false, blob -> {
                blob.writeLEB(3).writeLEB(14);
                blob.writeLEB(73).writeLEB(19);
                blob.writeLEB(2).writeLEB(24);
            });
        }
        return this.variableAbbrev;
    }

    public class Namespace {
        public final String name;
        final Map<String, Namespace> namespaces = new LinkedHashMap<String, Namespace>();
        final Map<String, ClassType> classes = new LinkedHashMap<String, ClassType>();

        private Namespace(String name) {
            this.name = name;
        }

        private Namespace getNamespace(String name) {
            return this.namespaces.computeIfAbsent(name, x$0 -> new Namespace((String)x$0));
        }

        private void write() {
            DwarfClassGenerator.this.writer.tag(DwarfClassGenerator.this.getNsAbbrev());
            DwarfClassGenerator.this.writer.writeInt(DwarfClassGenerator.this.strings.stringRef(this.name));
            this.writeChildren();
            DwarfClassGenerator.this.writer.emptyTag();
        }

        private void writeChildren() {
            for (Namespace namespace : this.namespaces.values()) {
                namespace.write();
            }
            for (ClassType classType : this.classes.values()) {
                classType.write();
            }
        }

        ClassType getClass(String name) {
            return this.classes.computeIfAbsent(name, x$0 -> new ClassType((String)x$0));
        }
    }

    public class ClassType {
        public final String name;
        final DwarfPlaceholder ptr;
        private DwarfPlaceholder pointerPtr;
        final Map<MethodDescriptor, Subprogram> subprograms = new LinkedHashMap<MethodDescriptor, Subprogram>();
        private ClassType superclass;
        private int size;
        private int pointer = -1;

        private ClassType(String name) {
            this.ptr = DwarfClassGenerator.this.writer.placeholder(4);
            this.name = name;
        }

        public void setSuperclass(ClassType superclass) {
            this.superclass = superclass;
        }

        public Subprogram getSubprogram(MethodDescriptor desc) {
            return this.subprograms.computeIfAbsent(desc, d -> new Subprogram(d.getName(), desc));
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setPointer(int pointer) {
            this.pointer = pointer;
        }

        public DwarfPlaceholder getPointerPtr() {
            if (this.pointerPtr == null) {
                this.pointerPtr = DwarfClassGenerator.this.writer.placeholder(4);
            }
            return this.pointerPtr;
        }

        private void write() {
            DwarfClassGenerator.this.writer.mark(this.ptr).tag(DwarfClassGenerator.this.getClassTypeAbbrev());
            DwarfClassGenerator.this.writer.writeInt(DwarfClassGenerator.this.strings.stringRef(this.name));
            DwarfClassGenerator.this.writer.writeShort(this.size);
            if (this.superclass != null) {
                DwarfClassGenerator.this.writer.tag(DwarfClassGenerator.this.getInheritanceAbbrev()).ref(this.superclass.ptr, Blob::writeInt);
            }
            for (Subprogram child : this.subprograms.values()) {
                child.write();
            }
            if (this.pointerPtr != null) {
                DwarfClassGenerator.this.writer.mark(this.pointerPtr).tag(DwarfClassGenerator.this.getPointerAbbrev());
                DwarfClassGenerator.this.writer.ref(this.ptr, Blob::writeInt);
            }
            if (this.pointer >= 0) {
                DwarfClassGenerator.this.writer.tag(DwarfClassGenerator.this.getVariableAbbrev());
                DwarfClassGenerator.this.writer.writeInt(DwarfClassGenerator.this.strings.stringRef("__class__"));
                DwarfClassGenerator.this.writer.ref(DwarfClassGenerator.this.classClass.ptr, Blob::writeInt);
                Blob ops = new Blob();
                ops.writeByte(3).writeInt(this.pointer).writeByte(159);
                DwarfClassGenerator.this.writer.writeLEB(ops.size());
                ops.newReader(DwarfClassGenerator.this.writer::write).readRemaining();
            }
            DwarfClassGenerator.this.writer.emptyTag();
        }
    }

    public class Subprogram {
        public final String name;
        public boolean isStatic;
        public final MethodDescriptor descriptor;
        public final DwarfPlaceholder ref;

        private Subprogram(String name, MethodDescriptor descriptor) {
            this.name = name;
            this.descriptor = descriptor;
            this.ref = DwarfClassGenerator.this.writer.placeholder(4);
        }

        private void write() {
            DwarfClassGenerator.this.writer.mark(this.ref).tag(DwarfClassGenerator.this.getMethodAbbrev());
            DwarfClassGenerator.this.writer.writeInt(DwarfClassGenerator.this.strings.stringRef(this.name));
            DwarfClassGenerator.this.writer.emptyTag();
        }
    }
}

