/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.binary.DataStructure;
import org.teavm.backend.wasm.binary.DataValue;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.ValueType;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.CallSiteLocation;
import org.teavm.model.lowlevel.ExceptionHandlerDescriptor;

public class CallSiteBinaryGenerator {
    private static final int CALL_SITE_FIRST_HANDLER = 0;
    private static final int CALL_SITE_LOCATION = 1;
    private static final int EXCEPTION_HANDLER_ID = 0;
    private static final int EXCEPTION_HANDLER_CLASS = 1;
    private static final int EXCEPTION_HANDLER_NEXT = 2;
    private static final int LOCATION_METHOD = 0;
    private static final int LOCATION_LINE = 1;
    private static final int LOCATION_NEXT = 2;
    private static final int METHOD_LOCATION_FILE = 0;
    private static final int METHOD_LOCATION_CLASS = 1;
    private static final int METHOD_LOCATION_METHOD = 2;
    private DataStructure callSiteStructure = new DataStructure(0, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS);
    private DataStructure exceptionHandlerStructure = new DataStructure(0, DataPrimitives.INT, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS);
    private DataStructure locationStructure = new DataStructure(0, DataPrimitives.ADDRESS, DataPrimitives.INT, DataPrimitives.ADDRESS);
    private DataStructure methodLocationStructure = new DataStructure(0, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS, DataPrimitives.ADDRESS);
    private BinaryWriter writer;
    private WasmClassGenerator classGenerator;
    private WasmStringPool stringPool;
    private ObjectIntMap<String> stringIndirectPointerCache = new ObjectIntHashMap();
    private boolean obfuscated;

    public CallSiteBinaryGenerator(BinaryWriter writer, WasmClassGenerator classGenerator, WasmStringPool stringPool, boolean obfuscated) {
        this.writer = writer;
        this.classGenerator = classGenerator;
        this.stringPool = stringPool;
        this.obfuscated = obfuscated;
    }

    public int writeCallSites(List<? extends CallSiteDescriptor> callSites) {
        if (callSites.isEmpty()) {
            return 0;
        }
        int firstCallSite = -1;
        ArrayList<DataValue> binaryCallSites = new ArrayList<DataValue>();
        for (int i = 0; i < callSites.size(); ++i) {
            DataValue binaryCallSite = this.callSiteStructure.createValue();
            int address = this.writer.append(binaryCallSite);
            if (firstCallSite < 0) {
                firstCallSite = address;
            }
            binaryCallSites.add(binaryCallSite);
        }
        ObjectIntHashMap locationCache = new ObjectIntHashMap();
        ObjectIntHashMap methodLocationCache = new ObjectIntHashMap();
        for (int callSiteId = 0; callSiteId < callSites.size(); ++callSiteId) {
            int i;
            DataValue binaryCallSite = (DataValue)binaryCallSites.get(callSiteId);
            CallSiteDescriptor callSite = callSites.get(callSiteId);
            boolean firstHandlerSet = false;
            ArrayList<DataValue> binaryExceptionHandlers = new ArrayList<DataValue>();
            for (i = 0; i < callSite.getHandlers().size(); ++i) {
                DataValue binaryExceptionHandler = this.exceptionHandlerStructure.createValue();
                int address = this.writer.append(binaryExceptionHandler);
                binaryExceptionHandlers.add(binaryExceptionHandler);
                binaryExceptionHandler.setInt(0, callSiteId + i + 1);
                if (!firstHandlerSet) {
                    binaryCallSite.setAddress(0, address);
                    firstHandlerSet = true;
                }
                if (i <= 0) continue;
                ((DataValue)binaryExceptionHandlers.get(i - 1)).setAddress(2, address);
            }
            for (i = 0; i < callSite.getHandlers().size(); ++i) {
                ExceptionHandlerDescriptor exceptionHandler = callSite.getHandlers().get(i);
                DataValue binaryExceptionHandler = (DataValue)binaryExceptionHandlers.get(i);
                if (exceptionHandler.getClassName() == null) continue;
                ValueType.Object type = ValueType.object(exceptionHandler.getClassName());
                int classPointer = this.classGenerator.getClassPointer(type);
                binaryExceptionHandler.setAddress(1, classPointer);
            }
            if (this.obfuscated) continue;
            binaryCallSite.setAddress(1, this.generateLocations((ObjectIntMap<MethodLocation>)methodLocationCache, (ObjectIntMap<LocationList>)locationCache, callSite));
        }
        return firstCallSite;
    }

    private int generateLocations(ObjectIntMap<MethodLocation> methodLocationCache, ObjectIntMap<LocationList> locationCache, CallSiteDescriptor callSite) {
        CallSiteLocation[] locations = callSite.getLocations();
        LocationList prevList = null;
        int locationAddress = 0;
        int previousLocationAddress = 0;
        for (int i = locations.length - 1; i >= 0; --i) {
            LocationList list = new LocationList(locations[i], prevList);
            locationAddress = locationCache.getOrDefault((Object)list, 0);
            if (locationAddress == 0) {
                DataValue binaryLocation = this.locationStructure.createValue();
                locationAddress = this.writer.append(binaryLocation);
                locationCache.put((Object)list, locationAddress);
                CallSiteLocation location = list.location;
                MethodLocation methodLocation = new MethodLocation(location.getFileName(), location.getClassName(), location.getMethodName());
                int methodLocationAddress = methodLocationCache.getOrDefault((Object)methodLocation, -1);
                if (methodLocationAddress < 0) {
                    DataValue binaryMethodLocation = this.methodLocationStructure.createValue();
                    methodLocationAddress = this.writer.append(binaryMethodLocation);
                    methodLocationCache.put((Object)methodLocation, methodLocationAddress);
                    if (location.getFileName() != null) {
                        binaryMethodLocation.setAddress(0, this.getStringIndirectPointer(location.getFileName()));
                    }
                    if (location.getClassName() != null) {
                        binaryMethodLocation.setAddress(1, this.getStringIndirectPointer(location.getClassName()));
                    }
                    if (location.getMethodName() != null) {
                        binaryMethodLocation.setAddress(2, this.getStringIndirectPointer(location.getMethodName()));
                    }
                }
                binaryLocation.setAddress(0, methodLocationAddress);
                binaryLocation.setInt(1, location.getLineNumber());
                binaryLocation.setAddress(2, previousLocationAddress);
            }
            previousLocationAddress = locationAddress;
        }
        return locationAddress;
    }

    private int getStringIndirectPointer(String str) {
        int result = this.stringIndirectPointerCache.getOrDefault((Object)str, -1);
        if (result < 0) {
            DataValue indirectValue = DataPrimitives.ADDRESS.createValue();
            result = this.writer.append(indirectValue);
            indirectValue.setAddress(0, this.stringPool.getStringPointer(str));
        }
        return result;
    }

    static final class LocationList {
        final CallSiteLocation location;
        final LocationList next;

        LocationList(CallSiteLocation location, LocationList next) {
            this.location = location;
            this.next = next;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocationList)) {
                return false;
            }
            LocationList that = (LocationList)o;
            return this.location.equals(that.location) && Objects.equals(this.next, that.next);
        }

        public int hashCode() {
            return Objects.hash(this.location, this.next);
        }
    }

    static final class MethodLocation {
        final String file;
        final String className;
        final String methodName;

        MethodLocation(String file, String className, String methodName) {
            this.file = file;
            this.className = className;
            this.methodName = methodName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodLocation)) {
                return false;
            }
            MethodLocation that = (MethodLocation)o;
            return Objects.equals(this.file, that.file) && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.className, this.methodName);
        }
    }
}

