/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generate;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.teavm.backend.c.generate.CodeWriter;

public class BufferedCodeWriter
extends CodeWriter {
    private List<Fragment> fragments = new ArrayList<Fragment>();
    private int currentIndent;
    private int lastIndent;
    private StringBuilder buffer = new StringBuilder();
    private boolean lineNumbersEmitted;
    private String lastFileName;
    private int lastLineNumber;
    private boolean locationDirty;

    public BufferedCodeWriter(boolean lineNumbersEmitted) {
        this.lineNumbersEmitted = lineNumbersEmitted;
    }

    public void writeTo(PrintWriter writer, String fileName) {
        WriterWithContext writerWithContext = new WriterWithContext(writer, fileName);
        for (Fragment fragment : this.fragments) {
            fragment.writeTo(writerWithContext);
        }
    }

    @Override
    public CodeWriter fragment() {
        this.flush();
        BufferedCodeWriter innerWriter = new BufferedCodeWriter(this.lineNumbersEmitted);
        innerWriter.lastFileName = this.lastFileName;
        innerWriter.lastLineNumber = this.lastLineNumber;
        innerWriter.locationDirty = this.locationDirty;
        this.fragments.add(new InnerWriterFragment(innerWriter.fragments));
        this.locationDirty = true;
        return innerWriter;
    }

    @Override
    protected void newLine() {
        this.fragments.add(new SimpleFragment(true, this.lastIndent, this.buffer.toString()));
        this.buffer.setLength(0);
        this.lastIndent = this.currentIndent;
        this.currentIndent = 0;
        if (this.lineNumbersEmitted) {
            ++this.lastLineNumber;
        }
    }

    @Override
    protected void append(String text) {
        this.buffer.append(text);
    }

    @Override
    protected void indentBy(int amount) {
        if (this.buffer.length() == 0) {
            this.lastIndent += amount;
        } else {
            this.currentIndent += amount;
        }
    }

    @Override
    public void source(String fileName, int lineNumber) {
        if (!this.lineNumbersEmitted) {
            return;
        }
        if (!Objects.equals(this.lastFileName, fileName) || this.lastLineNumber != lineNumber || this.locationDirty) {
            this.flush();
            this.fragments.add(new SourceFragment(fileName, lineNumber));
            this.lastFileName = fileName;
            this.lastLineNumber = lineNumber;
            this.locationDirty = false;
        }
    }

    @Override
    public void nosource() {
        this.source(null, 0);
    }

    @Override
    public void flush() {
        if (this.buffer.length() > 0 || this.lastIndent != 0 || this.currentIndent != 0) {
            this.fragments.add(new SimpleFragment(false, this.lastIndent, this.buffer.toString()));
            this.lastIndent = this.currentIndent;
            this.currentIndent = 0;
            this.buffer.setLength(0);
        }
    }

    private static void escape(PrintWriter writer, String string) {
        int chunkSize = 256;
        for (int i = 0; i < string.length(); i += chunkSize) {
            int last = Math.min(i + chunkSize, string.length());
            block8: for (int j = i; j < last; ++j) {
                char c = string.charAt(j);
                switch (c) {
                    case '\\': {
                        writer.print("\\\\");
                        continue block8;
                    }
                    case '\"': {
                        writer.print("\\\"");
                        continue block8;
                    }
                    case '\r': {
                        writer.print("\\r");
                        continue block8;
                    }
                    case '\n': {
                        writer.print("\\n");
                        continue block8;
                    }
                    case '\t': {
                        writer.print("\\t");
                        continue block8;
                    }
                    default: {
                        if (c < ' ') {
                            writer.print("\\0" + Character.forDigit(c >> 3, 8) + Character.forDigit(c & 7, 8));
                            continue block8;
                        }
                        if (c > '\u007f') {
                            writer.print("\\u" + Character.forDigit(c >> 12, 16) + Character.forDigit(c >> 8 & 0xF, 16) + Character.forDigit(c >> 4 & 0xF, 16) + Character.forDigit(c & 0xF, 16));
                            continue block8;
                        }
                        writer.print(c);
                    }
                }
            }
        }
    }

    static class WriterWithContext {
        PrintWriter writer;
        boolean isNewLine = true;
        int indentLevel;
        String initialFileName;
        String fileName;
        int lineNumber;
        int absLineNumber = 1;
        String pendingFileName;
        int pendingLineNumber = -1;

        WriterWithContext(PrintWriter writer, String fileName) {
            this.writer = writer;
            this.fileName = fileName;
            this.initialFileName = fileName;
            this.lineNumber = 1;
        }

        void append(String text) {
            if (text.isEmpty()) {
                return;
            }
            if (this.isNewLine) {
                if (this.pendingFileName != null && this.pendingLineNumber >= 0) {
                    this.printLineDirective(this.pendingFileName, this.pendingLineNumber);
                    this.pendingLineNumber = -1;
                    this.pendingFileName = null;
                }
                this.printIndent();
                this.isNewLine = false;
            }
            this.writer.print(text);
        }

        private void printLineDirective(String fileName, int lineNumber) {
            if (Objects.equals(this.fileName, fileName) && lineNumber == this.lineNumber) {
                return;
            }
            this.printIndent();
            this.writer.print("#line ");
            if (Objects.equals(fileName, this.initialFileName)) {
                lineNumber = this.absLineNumber + 1;
            }
            this.writer.print(lineNumber);
            if (!Objects.equals(fileName, this.fileName)) {
                this.writer.print(" \"");
                BufferedCodeWriter.escape(this.writer, fileName);
                this.writer.print("\"");
            }
            this.writer.println();
            ++this.absLineNumber;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        void newLine() {
            ++this.lineNumber;
            ++this.absLineNumber;
            this.writer.println();
            this.isNewLine = true;
        }

        private void printIndent() {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.writer.print("    ");
            }
        }

        void source(String fileName, int lineNumber) {
            if (fileName == null) {
                fileName = this.initialFileName;
                lineNumber = this.absLineNumber;
            }
            if (this.isNewLine) {
                this.pendingFileName = fileName;
                this.pendingLineNumber = lineNumber;
            } else if (!Objects.equals(this.fileName, fileName) || this.lineNumber != lineNumber) {
                ++this.lineNumber;
                ++this.absLineNumber;
                this.writer.println();
                this.printLineDirective(fileName, lineNumber);
                this.isNewLine = true;
            }
        }
    }

    static abstract class Fragment {
        Fragment() {
        }

        abstract void writeTo(WriterWithContext var1);
    }

    static class InnerWriterFragment
    extends Fragment {
        List<Fragment> fragments;

        InnerWriterFragment(List<Fragment> fragments) {
            this.fragments = fragments;
        }

        @Override
        void writeTo(WriterWithContext writer) {
            for (Fragment fragment : this.fragments) {
                fragment.writeTo(writer);
            }
        }
    }

    static class SimpleFragment
    extends Fragment {
        boolean newLine;
        int indentLevel;
        String text;

        SimpleFragment(boolean newLine, int indentLevel, String text) {
            this.newLine = newLine;
            this.indentLevel = indentLevel;
            this.text = text;
        }

        @Override
        void writeTo(WriterWithContext writer) {
            writer.indentLevel += this.indentLevel;
            writer.append(this.text);
            if (this.newLine) {
                writer.newLine();
            }
        }
    }

    static class SourceFragment
    extends Fragment {
        private String fileName;
        private int lineNumber;

        SourceFragment(String fileName, int lineNumber) {
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @Override
        void writeTo(WriterWithContext writer) {
            writer.source(this.fileName, this.lineNumber);
        }
    }
}

