/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerArray;
import org.teavm.hppc.IntArrayDeque;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntObjectHashMap;
import org.teavm.hppc.IntObjectMap;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.Outgoing;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Sigma;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BoundCheckInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.TransitionExtractor;
import org.teavm.model.util.UsageExtractor;

public class PhiUpdater {
    private Program program;
    private Graph cfg;
    private DominatorTree domTree;
    private Graph domGraph;
    private int[][] domFrontiers;
    private Variable[] variableMap;
    private boolean[] variableDefined;
    private List<List<Variable>> definedVersions = new ArrayList<List<Variable>>();
    private BasicBlock currentBlock;
    private Phi[][] phiMap;
    private int[][] phiIndexMap;
    private List<List<Phi>> synthesizedPhisByBlock = new ArrayList<List<Phi>>();
    private IntObjectMap<Phi> phisByReceiver = new IntObjectHashMap<Phi>();
    private BitSet usedPhis = new BitSet();
    private boolean[] usedDefinitions;
    private IntegerArray variableToSourceMap = new IntegerArray(10);
    private List<Phi> synthesizedPhis = new ArrayList<Phi>();
    private Sigma[][] sigmas;
    private Predicate<Instruction> sigmaPredicate = instruction -> false;
    private int[][][] frontierVariableCache;
    private InstructionVisitor consumer = new AbstractInstructionVisitor(){

        @Override
        public void visit(ClassConstantInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(BinaryInstruction insn) {
            insn.setFirstOperand(PhiUpdater.this.use(insn.getFirstOperand()));
            insn.setSecondOperand(PhiUpdater.this.use(insn.getSecondOperand()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(NegateInstruction insn) {
            insn.setOperand(PhiUpdater.this.use(insn.getOperand()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(AssignInstruction insn) {
            insn.setAssignee(PhiUpdater.this.use(insn.getAssignee()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(BranchingInstruction insn) {
            insn.setOperand(PhiUpdater.this.use(insn.getOperand()));
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
            insn.setFirstOperand(PhiUpdater.this.use(insn.getFirstOperand()));
            insn.setSecondOperand(PhiUpdater.this.use(insn.getSecondOperand()));
        }

        @Override
        public void visit(SwitchInstruction insn) {
            insn.setCondition(PhiUpdater.this.use(insn.getCondition()));
        }

        @Override
        public void visit(ExitInstruction insn) {
            if (insn.getValueToReturn() != null) {
                insn.setValueToReturn(PhiUpdater.this.use(insn.getValueToReturn()));
            }
        }

        @Override
        public void visit(RaiseInstruction insn) {
            insn.setException(PhiUpdater.this.use(insn.getException()));
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            insn.setSize(PhiUpdater.this.use(insn.getSize()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(ConstructInstruction insn) {
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            List<Variable> dimensions = insn.getDimensions();
            for (int i = 0; i < dimensions.size(); ++i) {
                dimensions.set(i, PhiUpdater.this.use(dimensions.get(i)));
            }
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() != null) {
                insn.setInstance(PhiUpdater.this.use(insn.getInstance()));
            }
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (insn.getInstance() != null) {
                insn.setInstance(PhiUpdater.this.use(insn.getInstance()));
            }
            insn.setValue(PhiUpdater.this.use(insn.getValue()));
        }

        @Override
        public void visit(GetElementInstruction insn) {
            insn.setArray(PhiUpdater.this.use(insn.getArray()));
            insn.setIndex(PhiUpdater.this.use(insn.getIndex()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(PutElementInstruction insn) {
            insn.setArray(PhiUpdater.this.use(insn.getArray()));
            insn.setIndex(PhiUpdater.this.use(insn.getIndex()));
            insn.setValue(PhiUpdater.this.use(insn.getValue()));
        }

        @Override
        public void visit(InvokeInstruction insn) {
            insn.replaceArguments(v -> PhiUpdater.this.use(v));
            if (insn.getInstance() != null) {
                insn.setInstance(PhiUpdater.this.use(insn.getInstance()));
            }
            if (insn.getReceiver() != null) {
                insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
            }
        }

        @Override
        public void visit(InvokeDynamicInstruction insn) {
            List<Variable> args = insn.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                args.set(i, PhiUpdater.this.use(args.get(i)));
            }
            if (insn.getInstance() != null) {
                insn.setInstance(PhiUpdater.this.use(insn.getInstance()));
            }
            if (insn.getReceiver() != null) {
                insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
            }
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            insn.setValue(PhiUpdater.this.use(insn.getValue()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CastInstruction insn) {
            insn.setValue(PhiUpdater.this.use(insn.getValue()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            insn.setValue(PhiUpdater.this.use(insn.getValue()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            insn.setValue(PhiUpdater.this.use(insn.getValue()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            insn.setArray(PhiUpdater.this.use(insn.getArray()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            insn.setArray(PhiUpdater.this.use(insn.getArray()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            insn.setArray(PhiUpdater.this.use(insn.getArray()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            insn.setValue(PhiUpdater.this.use(insn.getValue()));
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
            insn.setObjectRef(PhiUpdater.this.use(insn.getObjectRef()));
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
            insn.setObjectRef(PhiUpdater.this.use(insn.getObjectRef()));
        }

        @Override
        public void visit(BoundCheckInstruction insn) {
            insn.setIndex(PhiUpdater.this.use(insn.getIndex()));
            if (insn.getArray() != null) {
                insn.setArray(PhiUpdater.this.use(insn.getArray()));
            }
            insn.setReceiver(PhiUpdater.this.define(insn.getReceiver()));
        }
    };

    public int getSourceVariable(int var) {
        if (var >= this.variableToSourceMap.size()) {
            return -1;
        }
        return this.variableToSourceMap.get(var);
    }

    public List<Phi> getSynthesizedPhis() {
        return this.synthesizedPhis;
    }

    public void updatePhis(Program program, int parameterCount) {
        Variable[] parameters = new Variable[parameterCount];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = program.variableAt(i);
        }
        this.updatePhis(program, parameters);
    }

    public Sigma[] getSigmasAt(int blockIndex) {
        Sigma[] result = this.sigmas[blockIndex];
        return result != null ? (Sigma[])result.clone() : null;
    }

    public void setSigmaPredicate(Predicate<Instruction> sigmaPredicate) {
        this.sigmaPredicate = sigmaPredicate;
    }

    public void updatePhis(Program program, Variable[] parameters) {
        int i;
        if (program.basicBlockCount() == 0) {
            return;
        }
        this.frontierVariableCache = new int[program.basicBlockCount()][][];
        this.program = program;
        this.phisByReceiver.clear();
        this.cfg = ProgramUtils.buildControlFlowGraph(program);
        this.domTree = GraphUtils.buildDominatorTree(this.cfg);
        this.domFrontiers = new int[this.cfg.size()][];
        this.domGraph = GraphUtils.buildDominatorGraph(this.domTree, program.basicBlockCount());
        this.variableMap = new Variable[program.variableCount()];
        this.usedDefinitions = new boolean[program.variableCount()];
        for (i = 0; i < parameters.length; ++i) {
            this.variableMap[i] = parameters[i];
            this.usedDefinitions[i] = true;
        }
        for (i = 0; i < program.variableCount(); ++i) {
            this.variableToSourceMap.add(-1);
        }
        this.definedVersions.addAll(Collections.nCopies(program.variableCount(), null));
        this.phiMap = new Phi[program.basicBlockCount()][];
        this.phiIndexMap = new int[program.basicBlockCount()][];
        for (i = 0; i < this.phiMap.length; ++i) {
            this.phiMap[i] = new Phi[program.variableCount()];
            this.phiIndexMap[i] = new int[program.variableCount()];
        }
        this.domFrontiers = GraphUtils.findDominanceFrontiers(this.cfg, this.domTree);
        this.synthesizedPhisByBlock.clear();
        for (i = 0; i < program.basicBlockCount(); ++i) {
            this.synthesizedPhisByBlock.add(new ArrayList());
        }
        this.estimateSigmas();
        this.estimatePhis();
        this.renameVariables();
        this.propagatePhiUsageInformation();
        this.addSynthesizedPhis();
    }

    private void estimateSigmas() {
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        UsageExtractor usageExtractor = new UsageExtractor();
        this.sigmas = new Sigma[this.program.basicBlockCount()][];
        for (int i = 0; i < this.sigmas.length; ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            Instruction instruction = block.getLastInstruction();
            if (instruction == null) continue;
            instruction.acceptVisitor(transitionExtractor);
            BasicBlock[] targets = transitionExtractor.getTargets();
            if (targets == null || targets.length < 2 || !this.sigmaPredicate.test(instruction)) continue;
            instruction.acceptVisitor(usageExtractor);
            Variable[] variables = usageExtractor.getUsedVariables();
            Sigma[] sigmasInBlock = new Sigma[variables.length];
            for (int j = 0; j < sigmasInBlock.length; ++j) {
                Sigma sigma;
                sigmasInBlock[j] = sigma = new Sigma(block, variables[j]);
                for (BasicBlock target : targets) {
                    Variable outgoingVar = this.program.createVariable();
                    this.variableToSourceMap.add(sigma.getValue().getIndex());
                    outgoingVar.setDebugName(sigma.getValue().getDebugName());
                    outgoingVar.setLabel(sigma.getValue().getLabel());
                    Outgoing outgoing = new Outgoing(outgoingVar, target);
                    sigma.getOutgoings().add(outgoing);
                }
            }
            this.sigmas[i] = sigmasInBlock;
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void estimatePhis() {
        DefinitionExtractor definitionExtractor = new DefinitionExtractor();
        this.variableDefined = new boolean[this.program.variableCount()];
        IntArrayDeque stack = new IntArrayDeque();
        stack.addLast(0);
        while (!stack.isEmpty()) {
            int i = stack.removeLast();
            this.currentBlock = this.program.basicBlockAt(i);
            for (int predecessor : this.cfg.incomingEdges(i)) {
                if (this.sigmas[predecessor] == null || this.domTree.immediateDominatorOf(i) != predecessor) continue;
                block2: for (Sigma sigma : this.sigmas[predecessor]) {
                    for (Outgoing outgoing : sigma.getOutgoings()) {
                        if (outgoing.getTarget() != this.currentBlock) continue;
                        this.markAssignment(sigma.getValue());
                        continue block2;
                    }
                }
            }
            if (this.currentBlock.getExceptionVariable() != null) {
                this.markAssignment(this.currentBlock.getExceptionVariable());
            }
            Object object = this.currentBlock.getPhis().iterator();
            while (object.hasNext()) {
                Phi phi = (Phi)object.next();
                this.markAssignment(phi.getReceiver());
            }
            for (Instruction insn : this.currentBlock) {
                int predecessor;
                this.currentBlock = this.program.basicBlockAt(i);
                insn.acceptVisitor(definitionExtractor);
                Variable[] variableArray = definitionExtractor.getDefinedVariables();
                predecessor = variableArray.length;
                for (int j = 0; j < predecessor; ++j) {
                    Variable var = variableArray[j];
                    this.markAssignment(var);
                }
            }
            if (this.sigmas[i] != null) {
                for (int sigma : this.sigmas[i]) {
                    this.markAssignment(sigma.getValue());
                }
            }
            for (int successor : (Object)this.domGraph.outgoingEdges(i)) {
                stack.addLast(successor);
            }
        }
    }

    private void renameVariables() {
        Task task;
        ArrayDeque<Task> stack = new ArrayDeque<Task>();
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            if (this.domGraph.incomingEdgesCount(i) != 0) continue;
            task = new Task();
            task.block = this.program.basicBlockAt(i);
            task.variables = (Variable[])this.variableMap.clone();
            stack.push(task);
        }
        List<List<Incoming>> phiOutputs = ProgramUtils.getPhiOutputs(this.program);
        while (!stack.isEmpty()) {
            Object insn2;
            Collections.fill(this.definedVersions, null);
            task = (Task)stack.pop();
            this.currentBlock = task.block;
            int index = this.currentBlock.getIndex();
            this.variableMap = (Variable[])task.variables.clone();
            if (this.currentBlock.getExceptionVariable() != null) {
                this.currentBlock.setExceptionVariable(this.define(this.currentBlock.getExceptionVariable()));
            }
            for (Phi phi : this.synthesizedPhisByBlock.get(index)) {
                Variable var = this.program.createVariable();
                var.setDebugName(phi.getReceiver().getDebugName());
                var.setLabel(phi.getReceiver().getLabel());
                this.mapVariable(phi.getReceiver().getIndex(), var);
                this.phisByReceiver.put(var.getIndex(), phi);
                phi.setReceiver(var);
            }
            for (Phi phi : this.currentBlock.getPhis()) {
                phi.setReceiver(this.define(phi.getReceiver()));
            }
            for (Object insn2 : this.currentBlock) {
                ((Instruction)insn2).acceptVisitor(this.consumer);
            }
            int[] successors = this.domGraph.outgoingEdges(index);
            insn2 = phiOutputs.get(index).iterator();
            while (insn2.hasNext()) {
                Incoming output = (Incoming)insn2.next();
                Variable var = output.getValue();
                Variable sigmaVar = this.applySigmaRename(output.getPhi().getBasicBlock(), var);
                var = sigmaVar != var ? sigmaVar : this.use(var);
                output.setValue(var);
            }
            Sigma[] nextSigmas = this.sigmas[index];
            for (int j = successors.length - 1; j >= 0; --j) {
                int successor = successors[j];
                Task next = new Task();
                next.variables = (Variable[])this.variableMap.clone();
                next.block = this.program.basicBlockAt(successor);
                if (nextSigmas != null) {
                    block7: for (Sigma sigma : nextSigmas) {
                        for (Outgoing outgoing : sigma.getOutgoings()) {
                            if (outgoing.getTarget().getIndex() != successor) continue;
                            next.variables[sigma.getValue().getIndex()] = outgoing.getValue();
                            continue block7;
                        }
                    }
                }
                stack.push(next);
            }
            IntHashSet exceptionHandlingSuccessors = new IntHashSet();
            for (TryCatchBlock tryCatch : this.currentBlock.getTryCatchBlocks()) {
                exceptionHandlingSuccessors.add(tryCatch.getHandler().getIndex());
            }
            for (Sigma successor : (Sigma[])this.cfg.outgoingEdges(index)) {
                this.renameOutgoingPhis((int)successor, exceptionHandlingSuccessors.contains((int)successor));
            }
            if (this.sigmas[index] == null) continue;
            for (Sigma sigma : this.sigmas[index]) {
                sigma.setValue(this.use(sigma.getValue()));
            }
        }
    }

    private void addSynthesizedPhis() {
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            for (Phi phi : this.synthesizedPhisByBlock.get(i)) {
                if (!this.usedPhis.get(phi.getReceiver().getIndex()) || phi.getIncomings().isEmpty()) continue;
                this.program.basicBlockAt(i).getPhis().add(phi);
                this.synthesizedPhis.add(phi);
            }
        }
    }

    private void propagatePhiUsageInformation() {
        IntArrayDeque worklist = new IntArrayDeque();
        for (int receiverIndex : this.phisByReceiver.keys().toArray()) {
            if (!this.usedPhis.get(receiverIndex)) continue;
            worklist.addLast(receiverIndex);
        }
        IntHashSet visited = new IntHashSet();
        while (!worklist.isEmpty()) {
            int varIndex = worklist.removeFirst();
            if (!visited.add(varIndex)) continue;
            this.usedPhis.set(varIndex);
            Phi phi = this.phisByReceiver.get(varIndex);
            if (phi == null) continue;
            for (Incoming incoming : phi.getIncomings()) {
                if (visited.contains(incoming.getValue().getIndex())) continue;
                worklist.addLast(incoming.getValue().getIndex());
            }
        }
    }

    private void renameOutgoingPhis(int successor, boolean allVersions) {
        int[] phiIndexes = this.phiIndexMap[successor];
        List<Phi> phis = this.synthesizedPhisByBlock.get(successor);
        for (int j = 0; j < phis.size(); ++j) {
            Phi phi = phis.get(j);
            Variable originalVar = this.program.variableAt(phiIndexes[j]);
            Variable var = this.variableMap[phiIndexes[j]];
            if (var == null) continue;
            List<Variable> versions = this.definedVersions.get(phiIndexes[j]);
            if (versions != null && allVersions) {
                for (Variable version : versions) {
                    Incoming incoming = new Incoming();
                    incoming.setSource(this.currentBlock);
                    incoming.setValue(version);
                    phi.getIncomings().add(incoming);
                }
            }
            Variable sigmaVar = this.applySigmaRename(this.program.basicBlockAt(successor), originalVar);
            Incoming incoming = new Incoming();
            incoming.setSource(this.currentBlock);
            incoming.setValue(sigmaVar != originalVar ? sigmaVar : var);
            phi.getIncomings().add(incoming);
            phi.getReceiver().setDebugName(var.getDebugName());
        }
    }

    private Variable applySigmaRename(BasicBlock target, Variable var) {
        Sigma[] blockSigmas = this.sigmas[this.currentBlock.getIndex()];
        if (blockSigmas == null) {
            return var;
        }
        for (Sigma sigma : blockSigmas) {
            if (sigma.getValue() != var) continue;
            for (Outgoing outgoing : sigma.getOutgoings()) {
                if (outgoing.getTarget() != target) continue;
                return outgoing.getValue();
            }
        }
        return var;
    }

    private void markAssignment(Variable var) {
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        worklist.push(this.currentBlock);
        if (this.variableDefined[var.getIndex()]) {
            for (TryCatchBlock tryCatch : this.currentBlock.getTryCatchBlocks()) {
                this.placePhi(tryCatch.getHandler().getIndex(), var, this.currentBlock, worklist);
            }
        } else {
            this.variableDefined[var.getIndex()] = true;
        }
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.pop();
            int[] frontiers = this.domFrontiers[block.getIndex()];
            if (frontiers == null) continue;
            for (int frontier : frontiers) {
                this.placePhi(frontier, var, block, worklist);
            }
        }
    }

    private int[][] getIncomingVariablesForFrontier(int frontier) {
        Object result = this.frontierVariableCache[frontier];
        if (result == null) {
            ArrayList<Object> builder = new ArrayList<Object>(Collections.nCopies(this.program.basicBlockCount(), null));
            for (Phi phi : this.program.basicBlockAt(frontier).getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    ArrayList<Variable> variables = (ArrayList<Variable>)builder.get(incoming.getSource().getIndex());
                    if (variables == null) {
                        variables = new ArrayList<Variable>();
                        builder.set(incoming.getSource().getIndex(), variables);
                    }
                    variables.add(incoming.getValue());
                }
            }
            result = new int[this.program.basicBlockCount()][];
            for (int i = 0; i < ((int[][])result).length; ++i) {
                List builderVariables = (List)builder.get(i);
                if (builderVariables == null) continue;
                int[] resultVariables = new int[builderVariables.size()];
                for (int j = 0; j < resultVariables.length; ++j) {
                    resultVariables[j] = ((Variable)builderVariables.get(j)).getIndex();
                }
                result[i] = resultVariables;
            }
            this.frontierVariableCache[frontier] = result;
        }
        return result;
    }

    private void placePhi(int frontier, Variable var, BasicBlock block, Deque<BasicBlock> worklist) {
        Phi phi;
        BasicBlock frontierBlock = this.program.basicBlockAt(frontier);
        if (frontierBlock.getExceptionVariable() == var) {
            return;
        }
        int[] frontierIncomingVariables = this.getIncomingVariablesForFrontier(frontier)[block.getIndex()];
        if (frontierIncomingVariables != null) {
            for (int incoming : frontierIncomingVariables) {
                if (incoming != var.getIndex()) continue;
                return;
            }
        }
        if ((phi = this.phiMap[frontier][var.getIndex()]) == null) {
            phi = new Phi();
            phi.setReceiver(var);
            this.phiIndexMap[frontier][this.synthesizedPhisByBlock.get((int)frontier).size()] = var.getIndex();
            this.synthesizedPhisByBlock.get(frontier).add(phi);
            this.phiMap[frontier][var.getIndex()] = phi;
            worklist.push(frontierBlock);
        }
    }

    private Variable define(Variable var) {
        Variable old = this.variableMap[var.getIndex()];
        if (old != null) {
            if (this.definedVersions.get(var.getIndex()) == null) {
                this.definedVersions.set(var.getIndex(), new ArrayList());
            }
            this.definedVersions.get(var.getIndex()).add(old);
        }
        Variable original = var;
        var = this.introduce(var);
        this.mapVariable(original.getIndex(), var);
        return var;
    }

    private void mapVariable(int index, Variable var) {
        this.variableMap[index] = var;
        while (this.variableToSourceMap.size() <= var.getIndex()) {
            this.variableToSourceMap.add(-1);
        }
        this.variableToSourceMap.set(var.getIndex(), index);
    }

    private Variable introduce(Variable var) {
        if (!this.usedDefinitions[var.getIndex()]) {
            this.usedDefinitions[var.getIndex()] = true;
        } else {
            Variable old = var;
            var = this.program.createVariable();
            var.setDebugName(old.getDebugName());
            var.setLabel(old.getLabel());
        }
        return var;
    }

    private Variable use(Variable var) {
        Variable mappedVar = this.variableMap[var.getIndex()];
        if (mappedVar == null) {
            throw new AssertionError((Object)("Variable used before definition: @" + var.getDisplayLabel() + " at $" + this.currentBlock.getIndex()));
        }
        this.usedPhis.set(mappedVar.getIndex());
        return mappedVar;
    }

    private static class Task {
        Variable[] variables;
        BasicBlock block;

        private Task() {
        }
    }
}

