/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.ByteShortHashMap;
import org.teavm.hppc.HashOrderMixing;

public class ByteShortScatterMap
extends ByteShortHashMap {
    public ByteShortScatterMap() {
        this(4);
    }

    public ByteShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(byte key) {
        return BitMixer.mixPhi(key);
    }

    public static ByteShortScatterMap from(byte[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteShortScatterMap map = new ByteShortScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

