/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MemberHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.transformation.ClassInitInsertion;

public class Linker {
    private DependencyInfo dependency;
    private ClassInitInsertion classInitInsertion;

    public Linker(DependencyInfo dependency) {
        this.dependency = dependency;
        this.classInitInsertion = new ClassInitInsertion(dependency);
    }

    public void link(ClassHolder cls) {
        for (MethodHolder methodHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            MethodReference methodRef = methodHolder.getReference();
            MethodDependencyInfo methodDep = this.dependency.getMethod(methodRef);
            if (methodDep == null || !methodDep.isUsed()) {
                if (methodHolder.hasModifier(ElementModifier.STATIC)) {
                    cls.removeMethod(methodHolder);
                    continue;
                }
                methodHolder.getModifiers().add(ElementModifier.ABSTRACT);
                methodHolder.getModifiers().remove((Object)ElementModifier.NATIVE);
                methodHolder.setProgram(null);
                continue;
            }
            if (methodHolder.getProgram() == null) continue;
            this.link(methodHolder, methodHolder.getProgram());
        }
        for (MemberHolder memberHolder : cls.getFields().toArray(new FieldHolder[0])) {
            FieldReference fieldRef = new FieldReference(cls.getName(), memberHolder.getName());
            if (this.dependency.getField(fieldRef) != null) continue;
            cls.removeField((FieldHolder)memberHolder);
        }
    }

    public void link(MethodReader method, Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                PutFieldInstruction putField;
                FieldDependencyInfo linkedField;
                if (insn instanceof InvokeInstruction) {
                    MethodDependencyInfo linkedMethod;
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    MethodReference calledRef = invoke.getMethod();
                    if (invoke.getType() == InvocationType.SPECIAL) {
                        linkedMethod = this.dependency.getMethodImplementation(calledRef);
                        if (linkedMethod == null) continue;
                        invoke.setMethod(linkedMethod.getReference());
                        continue;
                    }
                    if (invoke.getType() != InvocationType.VIRTUAL || (linkedMethod = this.dependency.getMethodImplementation(calledRef)) == null || linkedMethod.isMissing()) continue;
                    calledRef = linkedMethod.getReference();
                    ClassReader cls = this.dependency.getClassSource().get(calledRef.getClassName());
                    boolean isFinal = false;
                    if (cls != null) {
                        if (cls.hasModifier(ElementModifier.FINAL)) {
                            isFinal = true;
                        } else {
                            MethodReader calledMethod = cls.getMethod(calledRef.getDescriptor());
                            if (calledMethod != null && (calledMethod.hasModifier(ElementModifier.FINAL) || calledMethod.getLevel() == AccessLevel.PRIVATE)) {
                                isFinal = true;
                            }
                        }
                    }
                    if (!isFinal) continue;
                    invoke.setType(InvocationType.SPECIAL);
                    invoke.setMethod(calledRef);
                    continue;
                }
                if (insn instanceof GetFieldInstruction) {
                    GetFieldInstruction getField = (GetFieldInstruction)insn;
                    linkedField = this.dependency.getField(getField.getField());
                    if (linkedField == null) continue;
                    getField.setField(linkedField.getReference());
                    continue;
                }
                if (!(insn instanceof PutFieldInstruction) || (linkedField = this.dependency.getField((putField = (PutFieldInstruction)insn).getField())) == null) continue;
                putField.setField(linkedField.getReference());
            }
        }
        this.classInitInsertion.apply(program, method);
    }
}

