/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.teavm.cache.IncrementalDependencyRegistration;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.ModelUtils;

class DependencyClassSource
implements ClassHolderSource {
    private ClassReaderSource innerSource;
    ClassHierarchy innerHierarchy;
    private Diagnostics diagnostics;
    private IncrementalDependencyRegistration dependencyRegistration;
    private Map<String, ClassHolder> generatedClasses = new LinkedHashMap<String, ClassHolder>();
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    boolean obfuscated;
    boolean strict;
    Map<String, Optional<ClassHolder>> cache = new LinkedHashMap<String, Optional<ClassHolder>>(1000, 0.5f);
    final ClassHolderTransformerContext transformContext = new ClassHolderTransformerContext(){

        @Override
        public ClassHierarchy getHierarchy() {
            return DependencyClassSource.this.innerHierarchy;
        }

        @Override
        public Diagnostics getDiagnostics() {
            return DependencyClassSource.this.diagnostics;
        }

        @Override
        public IncrementalDependencyRegistration getIncrementalCache() {
            return DependencyClassSource.this.dependencyRegistration;
        }

        @Override
        public boolean isObfuscated() {
            return DependencyClassSource.this.obfuscated;
        }

        @Override
        public boolean isStrict() {
            return DependencyClassSource.this.strict;
        }

        @Override
        public void submit(ClassHolder cls) {
            DependencyClassSource.this.submit(cls);
        }
    };

    DependencyClassSource(ClassReaderSource innerSource, Diagnostics diagnostics, IncrementalDependencyRegistration dependencyRegistration) {
        this.innerSource = innerSource;
        this.diagnostics = diagnostics;
        this.innerHierarchy = new ClassHierarchy(innerSource);
        this.dependencyRegistration = dependencyRegistration;
    }

    @Override
    public ClassHolder get(String name) {
        return this.cache.computeIfAbsent(name, n -> Optional.ofNullable(this.findAndTransformClass((String)n))).orElse(null);
    }

    public void submit(ClassHolder cls) {
        if (this.innerSource.get(cls.getName()) != null || this.generatedClasses.containsKey(cls.getName())) {
            throw new IllegalArgumentException("Class " + cls.getName() + " is already defined");
        }
        if (!this.transformers.isEmpty()) {
            for (ClassHolderTransformer transformer : this.transformers) {
                transformer.transformClass(cls, this.transformContext);
            }
            cls = ModelUtils.copyClass(cls);
        }
        this.generatedClasses.put(cls.getName(), cls);
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
            new UnreachableBasicBlockEliminator().optimize(method.getProgram());
        }
        this.cache.remove(cls.getName());
    }

    private ClassHolder findAndTransformClass(String name) {
        ClassHolder cls = this.findClass(name);
        if (cls != null && !this.transformers.isEmpty()) {
            for (ClassHolderTransformer transformer : this.transformers) {
                transformer.transformClass(cls, this.transformContext);
            }
        }
        return cls;
    }

    private ClassHolder findClass(String name) {
        ClassReader cls = this.innerSource.get(name);
        if (cls != null) {
            return ModelUtils.copyClass(cls);
        }
        return this.generatedClasses.get(name);
    }

    Collection<String> getGeneratedClassNames() {
        return this.generatedClasses.keySet();
    }

    public Collection<ClassHolder> getGeneratedClasses() {
        return this.generatedClasses.values();
    }

    public boolean isGeneratedClass(String className) {
        return this.generatedClasses.containsKey(className);
    }

    public void addTransformer(ClassHolderTransformer transformer) {
        this.transformers.add(transformer);
    }

    public void cleanup() {
        this.transformers.clear();
    }
}

