/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.ScopedName;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class DefaultAliasProvider
implements AliasProvider {
    private int topLevelAliasLimit;
    private final Map<String, ScopedName> classAliases = new HashMap<String, ScopedName>();
    private final Set<String> knownAliases = new HashSet<String>(200, 0.5f);
    private final ObjectIntMap<String> knowAliasesCounter = new ObjectIntHashMap<String>();
    private final Set<String> knownScopedAliases = new HashSet<String>(200, 0.5f);
    private final ObjectIntMap<String> knowScopedAliasesCounter = new ObjectIntHashMap<String>();
    private final Set<String> knownVirtualAliases = new HashSet<String>(200, 0.5f);
    private final ObjectIntMap<String> knowVirtualAliasesCounter = new ObjectIntHashMap<String>();

    public DefaultAliasProvider(int topLevelAliasLimit) {
        this.topLevelAliasLimit = topLevelAliasLimit;
    }

    @Override
    public ScopedName getClassAlias(String cls) {
        return this.classAliases.computeIfAbsent(cls, key -> this.makeUniqueTopLevel(DefaultAliasProvider.suggestAliasForClass(key)));
    }

    private static String suggestAliasForClass(String cls) {
        StringBuilder alias = new StringBuilder();
        int lastIndex = 0;
        while (true) {
            int index;
            if ((index = cls.indexOf(46, lastIndex)) == -1) {
                if (lastIndex > 0) {
                    alias.append("_");
                }
                break;
            }
            if (index > lastIndex) {
                alias.append(cls.charAt(lastIndex));
            }
            lastIndex = index + 1;
        }
        alias.append(cls.substring(lastIndex));
        for (int i = 1; i < alias.length(); ++i) {
            char c = alias.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            alias.setCharAt(i, '_');
        }
        if (!Character.isJavaIdentifierStart(alias.charAt(0))) {
            alias.setCharAt(0, '_');
        }
        return alias.toString();
    }

    @Override
    public String getMethodAlias(MethodDescriptor method) {
        String alias;
        switch (alias = method.getName()) {
            case "<init>": {
                alias = "$_init_";
                break;
            }
            case "<clinit>": {
                alias = "$_clinit_";
                break;
            }
            default: {
                alias = "$" + alias;
            }
        }
        return this.makeUnique(this.knownVirtualAliases, this.knowVirtualAliasesCounter, alias);
    }

    @Override
    public ScopedName getStaticMethodAlias(MethodReference method) {
        String suggested;
        switch (suggested = method.getDescriptor().getName()) {
            case "<init>": {
                suggested = "_init_";
                break;
            }
            case "<clinit>": {
                suggested = "_clinit_";
            }
        }
        return this.makeUniqueTopLevel(this.getClassAlias((String)method.getClassName()).value + "_" + suggested);
    }

    @Override
    public String getFieldAlias(FieldReference field) {
        return this.makeUnique(this.knownVirtualAliases, this.knowVirtualAliasesCounter, "$" + field.getFieldName());
    }

    @Override
    public ScopedName getStaticFieldAlias(FieldReference field) {
        return this.makeUniqueTopLevel(this.getClassAlias((String)field.getClassName()).value + "_" + field.getFieldName());
    }

    @Override
    public String getFunctionAlias(String name) {
        return name;
    }

    @Override
    public ScopedName getClassInitAlias(String className) {
        return this.makeUniqueTopLevel(DefaultAliasProvider.suggestAliasForClass(className) + "_$callClinit");
    }

    @Override
    public String getScopeAlias() {
        return this.makeUnique(this.knownAliases, this.knowAliasesCounter, "$java");
    }

    private ScopedName makeUniqueTopLevel(String suggested) {
        if (this.knownAliases.size() < this.topLevelAliasLimit) {
            return new ScopedName(false, this.makeUnique(this.knownAliases, this.knowAliasesCounter, suggested));
        }
        return new ScopedName(true, this.makeUnique(this.knownScopedAliases, this.knowScopedAliasesCounter, suggested));
    }

    private String sanitize(String s) {
        if (s.isEmpty()) {
            return "_";
        }
        boolean changed = false;
        StringBuilder sb = new StringBuilder(s.length());
        char c = s.charAt(0);
        if (DefaultAliasProvider.isIdentifierStart(c)) {
            sb.append(c);
        } else {
            sb.append('_');
            changed = true;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (DefaultAliasProvider.isIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            changed = true;
        }
        return changed ? sb.toString() : s;
    }

    private static boolean isIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$';
    }

    private static boolean isIdentifierPart(char c) {
        return DefaultAliasProvider.isIdentifierStart(c) || c >= '0' && c <= '9';
    }

    private String makeUnique(Set<String> knowAliases, ObjectIntMap<String> indexMap, String alias) {
        String uniqueAlias = alias = this.sanitize(alias);
        int index = indexMap.get(alias);
        if (index > 0) {
            uniqueAlias = alias + index++;
        }
        while (!knowAliases.add(uniqueAlias)) {
            uniqueAlias = alias + index++;
        }
        indexMap.put(alias, index);
        return uniqueAlias;
    }
}

