/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import org.teavm.common.GraphSplittingBackend;
import org.teavm.hppc.IntIntHashMap;
import org.teavm.model.BasicBlock;
import org.teavm.model.Program;
import org.teavm.model.util.BasicBlockMapper;
import org.teavm.model.util.ProgramUtils;

public class ProgramNodeSplittingBackend
implements GraphSplittingBackend {
    private Program program;

    public ProgramNodeSplittingBackend(Program program) {
        this.program = program;
    }

    @Override
    public int[] split(int[] domain, int[] nodes) {
        int[] copies = new int[nodes.length];
        IntIntHashMap map = new IntIntHashMap();
        for (int i = 0; i < nodes.length; ++i) {
            int node = nodes[i];
            BasicBlock block2 = this.program.basicBlockAt(node);
            BasicBlock blockCopy = this.program.createBasicBlock();
            ProgramUtils.copyBasicBlock(block2, blockCopy);
            copies[i] = blockCopy.getIndex();
            map.put(nodes[i], copies[i] + 1);
        }
        BasicBlockMapper copyBlockMapper = new BasicBlockMapper(block -> {
            int mappedIndex = map.get(block);
            return mappedIndex == 0 ? block : mappedIndex - 1;
        });
        for (int copy : copies) {
            copyBlockMapper.transform(this.program.basicBlockAt(copy));
        }
        for (int domainNode : domain) {
            copyBlockMapper.transform(this.program.basicBlockAt(domainNode));
        }
        return copies;
    }
}

