/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import org.teavm.interop.Address;
import org.teavm.interop.Function;
import org.teavm.interop.Import;
import org.teavm.interop.Structure;
import org.teavm.interop.c.Include;

public final class GtkExample {
    private GtkExample() {
    }

    public static void main(String[] args) {
        Gtk.init(null, null);
        Gtk.Window window = Gtk.windowNew(0);
        GLib.signalConnect(window, "delete-event", (GLib.Callback)Function.get(GLib.Callback.class, GtkExample.class, (String)"windowDeleted"), null);
        GLib.signalConnect(window, "destroy", (GLib.Callback)Function.get(GLib.Callback.class, GtkExample.class, (String)"destroy"), null);
        Gtk.setBorderWidth(window, 10);
        Gtk.Button button = Gtk.buttonNewWithLabel("Hello, world");
        GLib.signalConnect(button, "clicked", (GLib.Callback)Function.get(GLib.Callback.class, GtkExample.class, (String)"hello"), null);
        Gtk.add(window, button);
        Gtk.show(button);
        Gtk.show(window);
        Gtk.main();
    }

    private static void hello(Gtk.Widget widget, Address data) {
        System.out.println("Hello, world!");
    }

    private static boolean windowDeleted(Gtk.Widget widget, Address event, Address data) {
        System.out.println("System event occurred");
        return false;
    }

    private static void destroy(Gtk.Widget widget, Address data) {
        Gtk.mainQuit();
    }

    static class GLib {
        GLib() {
        }

        @Import(name="g_signal_connect")
        static native long signalConnect(GObject var0, String var1, Callback var2, Address var3);

        static abstract class Callback
        extends Function {
            Callback() {
            }

            abstract void call();
        }

        static class GObject
        extends Structure {
            GObject() {
            }
        }
    }

    @Include(value="gtk/gtk.h")
    static class Gtk {
        static final int WINDOW_TOPLEVEL = 0;
        static final int WINDOW_POPUP = 1;

        Gtk() {
        }

        @Import(name="gtk_init")
        static native void init(Address var0, Address var1);

        @Import(name="gtk_window_new")
        static native Window windowNew(int var0);

        @Import(name="gtk_widget_show")
        static native void show(Widget var0);

        @Import(name="gtk_main")
        static native void main();

        @Import(name="gtk_main_quit")
        static native void mainQuit();

        @Import(name="gtk_container_set_border_width")
        static native void setBorderWidth(Container var0, int var1);

        @Import(name="gtk_button_new_with_label")
        static native Button buttonNewWithLabel(String var0);

        @Import(name="gtk_container_add")
        static native void add(Container var0, Widget var1);

        static class Button
        extends Widget {
            Button() {
            }
        }

        static class Container
        extends Widget {
            Container() {
            }
        }

        static class Window
        extends Container {
            Window() {
            }
        }

        static class Widget
        extends GLib.GObject {
            Widget() {
            }
        }
    }
}

