/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.util.json;

import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.c.util.json.JsonAllErrorVisitor;
import org.teavm.backend.c.util.json.JsonErrorReporter;
import org.teavm.backend.c.util.json.JsonVisitor;

public class JsonPropertyVisitor
extends JsonAllErrorVisitor {
    private Map<String, JsonVisitor> properties = new HashMap<String, JsonVisitor>();
    private boolean skipNonExistentProperties;

    public JsonPropertyVisitor(boolean skipNonExistentProperties) {
        this.skipNonExistentProperties = skipNonExistentProperties;
    }

    public void addProperty(String propertyName, JsonVisitor visitor) {
        this.properties.put(propertyName, visitor);
    }

    @Override
    public JsonVisitor property(JsonErrorReporter reporter, String name) {
        if (!this.skipNonExistentProperties && !this.properties.containsKey(name)) {
            reporter.error("Unexpected property name: " + name);
        }
        return this.properties.get(name);
    }
}

