/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.ast;

import java.util.List;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConditionalExpr;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.ExprVisitor;
import org.teavm.ast.GotoPartStatement;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.PrimitiveCastExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.ast.UnwrapArrayExpr;
import org.teavm.ast.VariableExpr;
import org.teavm.ast.WhileStatement;

public class RecursiveVisitor
implements ExprVisitor,
StatementVisitor {
    protected void beforeVisit(Expr expr) {
    }

    protected void afterVisit(Expr expr) {
    }

    @Override
    public void visit(BinaryExpr expr) {
        this.beforeVisit(expr);
        expr.getFirstOperand().acceptVisitor(this);
        expr.getSecondOperand().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(UnaryExpr expr) {
        this.beforeVisit(expr);
        expr.getOperand().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(AssignmentStatement statement) {
        if (statement.getLeftValue() != null) {
            statement.getLeftValue().acceptVisitor(this);
        }
        statement.getRightValue().acceptVisitor(this);
    }

    @Override
    public void visit(ConditionalExpr expr) {
        this.beforeVisit(expr);
        expr.getCondition().acceptVisitor(this);
        expr.getConsequent().acceptVisitor(this);
        expr.getAlternative().acceptVisitor(this);
        this.afterVisit(expr);
    }

    public void visit(List<Statement> statements) {
        for (Statement part : statements) {
            part.acceptVisitor(this);
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visit(statement.getSequence());
    }

    @Override
    public void visit(ConstantExpr expr) {
        this.beforeVisit(expr);
        this.afterVisit(expr);
    }

    @Override
    public void visit(ConditionalStatement statement) {
        statement.getCondition().acceptVisitor(this);
        this.visit(statement.getConsequent());
        this.visit(statement.getAlternative());
    }

    @Override
    public void visit(VariableExpr expr) {
        this.beforeVisit(expr);
        this.afterVisit(expr);
    }

    @Override
    public void visit(SubscriptExpr expr) {
        this.beforeVisit(expr);
        expr.getArray().acceptVisitor(this);
        expr.getIndex().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(SwitchStatement statement) {
        statement.getValue().acceptVisitor(this);
        for (SwitchClause clause : statement.getClauses()) {
            this.visit(clause.getBody());
        }
        this.visit(statement.getDefaultClause());
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        this.beforeVisit(expr);
        expr.getArray().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(WhileStatement statement) {
        if (statement.getCondition() != null) {
            statement.getCondition().acceptVisitor(this);
        }
        this.visit(statement.getBody());
    }

    @Override
    public void visit(InvocationExpr expr) {
        this.beforeVisit(expr);
        for (Expr argument : expr.getArguments()) {
            argument.acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(BlockStatement statement) {
        this.visit(statement.getBody());
    }

    @Override
    public void visit(QualificationExpr expr) {
        this.beforeVisit(expr);
        if (expr.getQualified() != null) {
            expr.getQualified().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(NewExpr expr) {
        this.beforeVisit(expr);
        this.afterVisit(expr);
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(NewArrayExpr expr) {
        this.beforeVisit(expr);
        expr.getLength().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        this.beforeVisit(expr);
        for (Expr dimension : expr.getDimensions()) {
            dimension.acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(ReturnStatement statement) {
        if (statement.getResult() != null) {
            statement.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        this.beforeVisit(expr);
        expr.getExpr().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(ThrowStatement statement) {
        statement.getException().acceptVisitor(this);
    }

    @Override
    public void visit(CastExpr expr) {
        this.beforeVisit(expr);
        expr.getValue().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(PrimitiveCastExpr expr) {
        this.beforeVisit(expr);
        expr.getValue().acceptVisitor(this);
        this.afterVisit(expr);
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visit(statement.getProtectedBody());
        this.visit(statement.getHandler());
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        statement.getObjectRef().acceptVisitor(this);
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        statement.getObjectRef().acceptVisitor(this);
    }
}

