/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementHolder;
import org.teavm.model.FieldHolder;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;

public class ClassHolder
extends ElementHolder
implements ClassReader {
    private String parent = Object.class.getName();
    private Set<String> interfaces = new LinkedHashSet<String>();
    private Map<MethodDescriptor, MethodHolder> methods = new LinkedHashMap<MethodDescriptor, MethodHolder>();
    private Map<String, FieldHolder> fields = new LinkedHashMap<String, FieldHolder>();
    private String ownerName;

    public ClassHolder(String name) {
        super(name);
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public MethodHolder getMethod(MethodDescriptor method) {
        return this.methods.get(method);
    }

    public Collection<MethodHolder> getMethods() {
        return this.methods.values();
    }

    public void addMethod(MethodHolder method) {
        if (method.getOwner() != null) {
            throw new IllegalArgumentException("Method " + method.getDescriptor() + " is already in another class (" + method.getOwner().getName() + ")");
        }
        method.setOwner(this);
        MethodHolder oldMethod = this.methods.put(method.getDescriptor(), method);
        if (oldMethod != null) {
            oldMethod.setOwner(null);
        }
    }

    public void removeMethod(MethodHolder method) {
        if (method.getOwner() != this) {
            throw new IllegalArgumentException("Method " + method.getOwner().getName() + "." + method.getDescriptor() + " is not a member of " + this.getName());
        }
        this.methods.remove(method.getDescriptor());
        method.setOwner(null);
    }

    @Override
    public FieldHolder getField(String name) {
        return this.fields.get(name);
    }

    public Collection<FieldHolder> getFields() {
        return this.fields.values();
    }

    public void addField(FieldHolder field) {
        if (field.getOwner() != null) {
            throw new IllegalArgumentException("Field " + field.getName() + " is already " + "in another class (" + field.getOwner().getName() + ")");
        }
        field.setOwner(this);
        FieldHolder oldField = this.fields.put(field.getName(), field);
        if (oldField != null) {
            oldField.setOwner(null);
        }
    }

    public void removeField(FieldHolder field) {
        if (field.getOwner() != this) {
            throw new IllegalArgumentException("Field " + field.getOwner().getName() + "." + field.getName() + " is not a member of " + this.getName());
        }
        this.fields.remove(field.getName());
        field.setOwner(null);
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
}

