/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.ArrayList;
import java.util.List;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;

public class MutableDirectedGraph
implements Graph {
    private List<IntSet> successors = new ArrayList<IntSet>();
    private List<IntSet> predecessors = new ArrayList<IntSet>();

    public MutableDirectedGraph() {
    }

    public MutableDirectedGraph(Graph graph) {
        int[] data = new int[graph.size()];
        for (int i = 0; i < graph.size(); ++i) {
            int sz = graph.copyOutgoingEdges(i, data);
            for (int j = 0; j < sz; ++j) {
                this.addEdge(i, data[j]);
            }
        }
    }

    public Graph copyToImmutable() {
        GraphBuilder builder = new GraphBuilder(this.successors.size());
        for (int i = 0; i < this.successors.size(); ++i) {
            for (IntCursor cursor : this.successors.get(i)) {
                builder.addEdge(i, cursor.value);
            }
        }
        return builder.build();
    }

    @Override
    public int size() {
        return this.successors.size();
    }

    public void addEdge(int from, int to) {
        int max = Math.max(from, to);
        while (max >= this.successors.size()) {
            this.successors.add((IntSet)new IntOpenHashSet(1));
            this.predecessors.add((IntSet)new IntOpenHashSet(1));
        }
        this.successors.get(from).add(to);
        this.predecessors.get(to).add(from);
    }

    public void deleteEdge(int from, int to) {
        if (from >= this.successors.size() || to >= this.successors.size()) {
            return;
        }
        this.successors.get(from).removeAllOccurrences(to);
        this.predecessors.get(to).removeAllOccurrences(from);
    }

    public void detachNode(int node) {
        for (IntCursor succ : this.successors.get(node)) {
            this.predecessors.get(succ.value).removeAllOccurrences(node);
        }
        for (IntCursor pred : this.predecessors.get(node)) {
            this.successors.get(pred.value).removeAllOccurrences(node);
        }
        this.predecessors.get(node).clear();
        this.successors.get(node).clear();
    }

    @Override
    public int[] incomingEdges(int node) {
        return this.predecessors.get(node).toArray();
    }

    @Override
    public int copyIncomingEdges(int node, int[] target) {
        int index = 0;
        for (IntCursor cursor : this.predecessors.get(node)) {
            target[index++] = cursor.value;
        }
        return index;
    }

    @Override
    public int[] outgoingEdges(int node) {
        return this.successors.get(node).toArray();
    }

    @Override
    public int copyOutgoingEdges(int node, int[] target) {
        int index = 0;
        for (IntCursor cursor : this.successors.get(node)) {
            target[index++] = cursor.value;
        }
        return index;
    }

    @Override
    public int incomingEdgesCount(int node) {
        return this.predecessors.get(node).size();
    }

    @Override
    public int outgoingEdgesCount(int node) {
        return this.successors.get(node).size();
    }
}

