/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Structure;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.FreeChunk;
import org.teavm.runtime.FreeChunkHolder;
import org.teavm.runtime.MarkQueue;
import org.teavm.runtime.Mutator;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.ShadowStack;

@Unmanaged
@StaticInit
public final class GC {
    static Address currentChunkLimit;
    static FreeChunk currentChunk;
    static FreeChunkHolder currentChunkPointer;
    static int freeChunks;
    static int freeMemory;

    private GC() {
    }

    static native Address gcStorageAddress();

    static native int gcStorageSize();

    private static native Address heapAddress();

    private static native Region regionsAddress();

    private static native int regionMaxCount();

    public static native long availableBytes();

    private static native int regionSize();

    public static int getFreeMemory() {
        return freeMemory;
    }

    public static RuntimeObject alloc(int size) {
        FreeChunk current = currentChunk;
        Address next = currentChunk.toAddress().add(size);
        if (!next.add(Structure.sizeOf(FreeChunk.class)).isLessThan(currentChunkLimit)) {
            GC.getAvailableChunk(size);
            current = currentChunk;
            next = currentChunk.toAddress().add(size);
        }
        int freeSize = current.size;
        if ((freeSize -= size) > 0) {
            currentChunk = (FreeChunk)next.toStructure();
            GC.currentChunk.size = freeSize;
        } else {
            freeMemory -= size;
            GC.getAvailableChunkIfPossible(GC.currentChunk.size + 1);
        }
        GC.currentChunk.classReference = 0;
        freeMemory -= size;
        return current;
    }

    private static void getAvailableChunk(int size) {
        if (GC.getAvailableChunkIfPossible(size)) {
            return;
        }
        GC.collectGarbage(size);
        GC.getAvailableChunkIfPossible(size);
    }

    private static boolean getAvailableChunkIfPossible(int size) {
        if (freeChunks == 0) {
            return false;
        }
        while (currentChunk.toAddress().add(size) != currentChunkLimit && !currentChunk.toAddress().add(size + Structure.sizeOf(FreeChunk.class)).isLessThan(currentChunkLimit)) {
            if (--freeChunks == 0) {
                return false;
            }
            freeMemory -= GC.currentChunk.size;
            currentChunkPointer = Structure.add(FreeChunkHolder.class, currentChunkPointer, 1);
            currentChunk = GC.currentChunkPointer.value;
            currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        }
        return true;
    }

    public static boolean collectGarbage(int size) {
        GC.mark();
        GC.sweep();
        GC.updateFreeMemory();
        return true;
    }

    private static void mark() {
        Allocator.fillZero(GC.regionsAddress().toAddress(), GC.regionMaxCount() * Structure.sizeOf(Region.class));
        Address staticRoots = Mutator.getStaticGCRoots();
        int staticCount = staticRoots.getInt();
        staticRoots = staticRoots.add(8);
        while (staticCount-- > 0) {
            RuntimeObject object = (RuntimeObject)staticRoots.getAddress().getAddress().toStructure();
            if (object != null) {
                GC.mark(object);
            }
            staticRoots = staticRoots.add(Address.sizeOf());
        }
        Address stackRoots = ShadowStack.getStackTop();
        while (stackRoots != null) {
            int count = ShadowStack.getStackRootCount(stackRoots);
            Address stackRootsPtr = ShadowStack.getStackRootPointer(stackRoots);
            while (count-- > 0) {
                RuntimeObject obj = (RuntimeObject)stackRootsPtr.getAddress().toStructure();
                GC.mark(obj);
                stackRootsPtr = stackRootsPtr.add(Address.sizeOf());
            }
            stackRoots = ShadowStack.getNextStackFrame(stackRoots);
        }
    }

    private static void mark(RuntimeObject object) {
        if (object == null || GC.isMarked(object)) {
            return;
        }
        MarkQueue.init();
        MarkQueue.enqueue(object);
        while (!MarkQueue.isEmpty()) {
            RuntimeObject reference;
            object = MarkQueue.dequeue();
            if (GC.isMarked(object)) continue;
            object.classReference |= Integer.MIN_VALUE;
            long offset = object.toAddress().toLong() - GC.heapAddress().toLong();
            Region region = Structure.add(Region.class, GC.regionsAddress(), (int)(offset / (long)GC.regionSize()));
            short relativeOffset = (short)(offset % (long)GC.regionSize() + 1L);
            if (region.start == 0 || region.start > relativeOffset) {
                region.start = relativeOffset;
            }
            RuntimeClass cls = RuntimeClass.getClass(object);
            if (cls.itemType == null) {
                while (cls != null) {
                    Address layout = cls.layout;
                    if (layout != null) {
                        short fieldCount = layout.getShort();
                        while (true) {
                            short s = fieldCount;
                            fieldCount = (short)(fieldCount - 1);
                            if (s <= 0) break;
                            layout = layout.add(2);
                            short fieldOffset = layout.getShort();
                            reference = (RuntimeObject)object.toAddress().add(fieldOffset).getAddress().toStructure();
                            if (reference == null || GC.isMarked(reference)) continue;
                            MarkQueue.enqueue(reference);
                        }
                    }
                    cls = cls.parent;
                }
                continue;
            }
            if ((cls.itemType.flags & 2) != 0) continue;
            RuntimeArray array = (RuntimeArray)object;
            Address base = Address.align(array.toAddress().add(RuntimeArray.class, 1), 4);
            for (int i = 0; i < array.size; ++i) {
                reference = (RuntimeObject)base.getAddress().toStructure();
                if (reference != null && !GC.isMarked(reference)) {
                    MarkQueue.enqueue(reference);
                }
                base = base.add(4);
            }
        }
    }

    private static void sweep() {
        FreeChunkHolder freeChunkPtr = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        freeChunks = 0;
        RuntimeObject object = (RuntimeObject)GC.heapAddress().toStructure();
        Structure lastFreeSpace = null;
        long heapSize = GC.availableBytes();
        long reclaimedSpace = 0L;
        long maxFreeChunk = 0L;
        int currentRegionIndex = 0;
        int regionsCount = (int)((heapSize - 1L) / (long)GC.regionSize()) + 1;
        Address currentRegionEnd = object.toAddress().add(GC.regionSize());
        Address limit = GC.heapAddress().add(heapSize);
        block0: while (object.toAddress().isLessThan(limit)) {
            boolean free;
            int tag = object.classReference;
            if (tag == 0) {
                free = true;
            } else {
                boolean bl = free = (tag & Integer.MIN_VALUE) == 0;
                if (!free) {
                    tag &= Integer.MAX_VALUE;
                }
                object.classReference = tag;
            }
            if (free) {
                if (lastFreeSpace == null) {
                    lastFreeSpace = (FreeChunk)object;
                }
                if (!object.toAddress().isLessThan(currentRegionEnd)) {
                    currentRegionIndex = (int)((object.toAddress().toLong() - GC.heapAddress().toLong()) / (long)GC.regionSize());
                    Region currentRegion = Structure.add(Region.class, GC.regionsAddress(), currentRegionIndex);
                    if (currentRegion.start == 0) {
                        do {
                            if (++currentRegionIndex == regionsCount) {
                                object = (RuntimeObject)limit.toStructure();
                                break block0;
                            }
                            currentRegion = Structure.add(Region.class, GC.regionsAddress(), currentRegionIndex);
                        } while (currentRegion.start == 0);
                    }
                    currentRegionEnd = currentRegion.toAddress().add(GC.regionSize());
                }
            } else if (lastFreeSpace != null) {
                ((FreeChunk)lastFreeSpace).size = (int)(object.toAddress().toLong() - lastFreeSpace.toAddress().toLong());
                freeChunkPtr.value = lastFreeSpace;
                freeChunkPtr = Structure.add(FreeChunkHolder.class, freeChunkPtr, 1);
                ++freeChunks;
                reclaimedSpace += (long)((FreeChunk)lastFreeSpace).size;
                if (maxFreeChunk < (long)((FreeChunk)lastFreeSpace).size) {
                    maxFreeChunk = ((FreeChunk)lastFreeSpace).size;
                }
                lastFreeSpace = null;
            }
            int size = GC.objectSize(object);
            object = (RuntimeObject)object.toAddress().add(size).toStructure();
        }
        if (lastFreeSpace != null) {
            int freeSize;
            ((FreeChunk)lastFreeSpace).size = freeSize = (int)(object.toAddress().toLong() - lastFreeSpace.toAddress().toLong());
            freeChunkPtr.value = lastFreeSpace;
            freeChunkPtr = Structure.add(FreeChunkHolder.class, freeChunkPtr, 1);
            ++freeChunks;
            reclaimedSpace += (long)freeSize;
            if (maxFreeChunk < (long)freeSize) {
                maxFreeChunk = freeSize;
            }
        }
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        GC.sortFreeChunks(0, freeChunks - 1);
        currentChunk = GC.currentChunkPointer.value;
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
    }

    private static void updateFreeMemory() {
        freeMemory = 0;
        FreeChunkHolder freeChunkPtr = currentChunkPointer;
        for (int i = 0; i < freeChunks; ++i) {
            freeMemory += freeChunkPtr.value.size;
            freeChunkPtr = Structure.add(FreeChunkHolder.class, freeChunkPtr, 1);
        }
    }

    private static void sortFreeChunks(int lower, int upper) {
        int start = lower;
        int end = upper;
        int mid = (lower + upper) / 2;
        FreeChunk midChunk = GC.getFreeChunk((int)mid).value;
        block0: while (lower != upper) {
            if (GC.getFreeChunk((int)lower).value.size > midChunk.size) {
                ++lower;
                continue;
            }
            while (lower != upper) {
                if (GC.getFreeChunk((int)upper).value.size <= midChunk.size) {
                    --upper;
                    continue;
                }
                FreeChunk tmp = GC.getFreeChunk((int)lower).value;
                GC.getFreeChunk((int)lower).value = GC.getFreeChunk((int)upper).value;
                GC.getFreeChunk((int)upper).value = tmp;
                continue block0;
            }
            break block0;
        }
        if (lower - start > 0) {
            GC.sortFreeChunks(start, lower);
        }
        if (end - lower - 1 > 0) {
            GC.sortFreeChunks(lower + 1, end);
        }
    }

    private static FreeChunkHolder getFreeChunk(int index) {
        return Structure.add(FreeChunkHolder.class, currentChunkPointer, index);
    }

    private static int objectSize(RuntimeObject object) {
        if (object.classReference == 0) {
            return ((FreeChunk)object).size;
        }
        RuntimeClass cls = RuntimeClass.getClass(object);
        if (cls.itemType == null) {
            return cls.size;
        }
        int itemSize = (cls.itemType.flags & 2) == 0 ? Address.sizeOf() : cls.itemType.size;
        RuntimeArray array = (RuntimeArray)object;
        Address address = Address.fromInt(Structure.sizeOf(RuntimeArray.class));
        address = Address.align(address, itemSize);
        address = address.add(itemSize * array.size);
        address = Address.align(address, 4);
        return address.toInt();
    }

    private static boolean isMarked(RuntimeObject object) {
        return (object.classReference & Integer.MIN_VALUE) != 0;
    }

    static {
        freeMemory = (int)GC.availableBytes();
        currentChunk = (FreeChunk)GC.heapAddress().toStructure();
        GC.currentChunk.classReference = 0;
        GC.currentChunk.size = (int)GC.availableBytes();
        currentChunkLimit = currentChunk.toAddress().add(GC.currentChunk.size);
        currentChunkPointer = (FreeChunkHolder)GC.gcStorageAddress().toStructure();
        GC.currentChunkPointer.value = currentChunk;
        freeChunks = 1;
        GC.getAvailableChunkIfPossible(0);
    }

    static class Region
    extends Structure {
        short start;

        Region() {
        }
    }
}

