/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.classes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;

public class InterfaceToClassMapping {
    private Map<String, String> map = new HashMap<String, String>();

    public InterfaceToClassMapping(ListableClassReaderSource classSource) {
        for (String className : classSource.getClassNames()) {
            ClassReader cls = classSource.get(className);
            if (cls.hasModifier(ElementModifier.INTERFACE)) continue;
            this.map.put(className, className);
            for (String iface : InterfaceToClassMapping.getInterfaces(classSource, className)) {
                String existing = this.map.get(iface);
                if (existing == null) {
                    this.map.put(iface, className);
                    continue;
                }
                this.map.put(iface, InterfaceToClassMapping.commonSuperClass(classSource, className, existing));
            }
        }
    }

    private static Set<String> getInterfaces(ClassReaderSource classSource, String className) {
        HashSet<String> interfaces = new HashSet<String>();
        InterfaceToClassMapping.getInterfaces(classSource, className, interfaces);
        return interfaces;
    }

    private static void getInterfaces(ClassReaderSource classSource, String className, Set<String> interfaces) {
        if (!interfaces.add(className)) {
            return;
        }
        ClassReader cls = classSource.get(className);
        if (cls == null) {
            return;
        }
        for (String iface : cls.getInterfaces()) {
            InterfaceToClassMapping.getInterfaces(classSource, iface, interfaces);
        }
    }

    private static String commonSuperClass(ClassReaderSource classSource, String a, String b) {
        if (a.equals(b)) {
            return a;
        }
        List<String> firstPath = InterfaceToClassMapping.pathToRoot(classSource, a);
        List<String> secondPath = InterfaceToClassMapping.pathToRoot(classSource, b);
        Collections.reverse(firstPath);
        Collections.reverse(secondPath);
        int min = Math.min(firstPath.size(), secondPath.size());
        for (int i = 1; i < min; ++i) {
            if (firstPath.get(i).equals(secondPath.get(i))) continue;
            return firstPath.get(i - 1);
        }
        return firstPath.get(0);
    }

    private static List<String> pathToRoot(ClassReaderSource classSource, String className) {
        ArrayList<String> path = new ArrayList<String>();
        while (true) {
            path.add(className);
            ClassReader cls = classSource.get(className);
            if (cls == null || cls.getParent() == null) break;
            className = cls.getParent();
        }
        return path;
    }

    public String mapClass(String className) {
        return this.map.get(className);
    }
}

