/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.analysis;

import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.IntSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;

public class ClassInference {
    private DependencyInfo dependencyInfo;
    private Graph assignmentGraph;
    private Graph cloneGraph;
    private Graph arrayGraph;
    private Graph itemGraph;
    private List<IntObjectMap<ValueType>> casts;
    private IntObjectMap<IntSet> exceptionMap;
    private VirtualCallSite[][] virtualCallSites;
    private List<Task> initialTasks;
    private List<List<Set<String>>> types;
    private List<Set<String>> finalTypes;

    public ClassInference(DependencyInfo dependencyInfo) {
        this.dependencyInfo = dependencyInfo;
    }

    public void infer(Program program, MethodReference methodReference) {
        int i;
        MethodDependencyInfo thisMethodDep = this.dependencyInfo.getMethod(methodReference);
        this.buildGraphs(program, thisMethodDep);
        block0: for (i = 0; i <= methodReference.parameterCount(); ++i) {
            ValueDependencyInfo paramDep = thisMethodDep.getVariable(i);
            if (paramDep == null) continue;
            int degree = 0;
            while (true) {
                for (String paramType : paramDep.getTypes()) {
                    this.initialTasks.add(new Task(i, degree, paramType));
                }
                if (!paramDep.hasArrayType()) continue block0;
                paramDep = paramDep.getArrayItem();
                ++degree;
            }
        }
        this.types = new ArrayList<List<Set<String>>>(program.variableCount());
        for (i = 0; i < program.variableCount(); ++i) {
            ArrayList variableTypes = new ArrayList();
            this.types.add(variableTypes);
            for (int j = 0; j < 3; ++j) {
                variableTypes.add(new LinkedHashSet());
            }
        }
        this.propagate(program);
        this.assignmentGraph = null;
        this.cloneGraph = null;
        this.arrayGraph = null;
        this.itemGraph = null;
        this.casts = null;
        this.exceptionMap = null;
        this.virtualCallSites = null;
        this.finalTypes = new ArrayList<Set<String>>(program.variableCount());
        for (i = 0; i < program.variableCount(); ++i) {
            this.finalTypes.add(this.types.get(i).get(0));
        }
        this.types = null;
    }

    public String[] classesOf(int variableIndex) {
        return this.finalTypes.get(variableIndex).toArray(new String[0]);
    }

    private void buildGraphs(Program program, MethodDependencyInfo thisMethodDep) {
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(program.variableCount(), this.dependencyInfo);
        visitor.thisMethodDep = thisMethodDep;
        Iterator<BasicBlock> iterator = program.getBasicBlocks().iterator();
        while (iterator.hasNext()) {
            BasicBlock block;
            visitor.currentBlock = block = iterator.next();
            for (Phi phi : block.getPhis()) {
                visitor.visit(phi);
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(visitor);
            }
        }
        this.assignmentGraph = visitor.assignmentGraphBuilder.build();
        this.cloneGraph = visitor.cloneGraphBuilder.build();
        this.arrayGraph = visitor.arrayGraphBuilder.build();
        this.itemGraph = visitor.itemGraphBuilder.build();
        this.casts = visitor.casts;
        this.exceptionMap = visitor.exceptionMap;
        this.initialTasks = visitor.tasks;
        this.virtualCallSites = new VirtualCallSite[program.variableCount()][];
        for (int i = 0; i < this.virtualCallSites.length; ++i) {
            List<VirtualCallSite> buildCallSites = visitor.virtualCallSites.get(i);
            if (buildCallSites == null) continue;
            this.virtualCallSites[i] = buildCallSites.toArray(new VirtualCallSite[0]);
        }
    }

    private void propagate(Program program) {
        ClassReaderSource classSource = this.dependencyInfo.getClassSource();
        ArrayDeque<Task> queue = new ArrayDeque<Task>();
        queue.addAll(this.initialTasks);
        this.initialTasks = null;
        block0: while (!queue.isEmpty()) {
            ValueType type;
            int n;
            Set<String> typeSet;
            Task task = (Task)queue.remove();
            if (task.degree < 0) {
                BasicBlock block = program.basicBlockAt(task.variable);
                for (TryCatchBlock tryCatchBlock : block.getTryCatchBlocks()) {
                    if (tryCatchBlock.getExceptionType() != null && !classSource.isSuperType(tryCatchBlock.getExceptionType(), task.className).orElse(false).booleanValue()) continue;
                    Variable exception = tryCatchBlock.getHandler().getExceptionVariable();
                    if (exception == null) continue block0;
                    queue.add(new Task(exception.getIndex(), 0, task.className));
                    continue block0;
                }
                continue;
            }
            List<Set<String>> variableTypes = this.types.get(task.variable);
            if (task.degree >= variableTypes.size() || !(typeSet = variableTypes.get(task.degree)).add(task.className)) continue;
            for (int successor2 : this.assignmentGraph.outgoingEdges(task.variable)) {
                List<Set<String>> successorVariableTypes;
                queue.add(new Task(successor2, task.degree, task.className));
                int itemDegree = task.degree + 1;
                if (itemDegree < variableTypes.size()) {
                    for (String string : variableTypes.get(itemDegree)) {
                        queue.add(new Task(successor2, itemDegree, string));
                    }
                }
                if (itemDegree >= (successorVariableTypes = this.types.get(successor2)).size()) continue;
                for (String type3 : successorVariableTypes.get(itemDegree)) {
                    queue.add(new Task(task.variable, itemDegree, type3));
                }
            }
            if (task.degree > 0) {
                for (int predecessor : this.assignmentGraph.incomingEdges(task.variable)) {
                    queue.add(new Task(predecessor, task.degree, task.className));
                }
                for (int successor2 : this.itemGraph.outgoingEdges(task.variable)) {
                    queue.add(new Task(successor2, task.degree - 1, task.className));
                }
            } else {
                VirtualCallSite[] callSites;
                int successor2;
                for (int successor2 : this.cloneGraph.outgoingEdges(task.variable)) {
                    queue.add(new Task(successor2, 0, task.className));
                }
                IntSet intSet = (IntSet)this.exceptionMap.get(task.variable);
                if (intSet != null) {
                    int[] exception = intSet.toArray();
                    int n2 = exception.length;
                    for (successor2 = 0; successor2 < n2; ++successor2) {
                        int block = exception[successor2];
                        queue.add(new Task(block, -1, task.className));
                    }
                }
                if ((callSites = this.virtualCallSites[task.variable]) != null) {
                    VirtualCallSite[] virtualCallSiteArray = callSites;
                    successor2 = virtualCallSiteArray.length;
                    for (n = 0; n < successor2; ++n) {
                        MethodDependencyInfo methodDep;
                        MethodReference resolvedMethodRef;
                        VirtualCallSite callSite = virtualCallSiteArray[n];
                        MethodReference methodReference = new MethodReference(task.className, callSite.method.getDescriptor());
                        MethodReader resolvedMethod = classSource.resolve(methodReference);
                        if (resolvedMethod == null || !callSite.resolvedMethods.add(resolvedMethodRef = resolvedMethod.getReference()) || (methodDep = this.dependencyInfo.getMethod(resolvedMethodRef)) == null) continue;
                        if (callSite.receiver >= 0) {
                            ClassInference.readValue(methodDep.getResult(), program.variableAt(callSite.receiver), queue);
                        }
                        for (int i = 0; i < callSite.arguments.length; ++i) {
                            ClassInference.writeValue(methodDep.getVariable(i + 1), program.variableAt(callSite.arguments[i]), queue);
                        }
                        for (String type4 : methodDep.getThrown().getTypes()) {
                            queue.add(new Task(callSite.block, -1, type4));
                        }
                    }
                }
            }
            for (int successor2 : this.arrayGraph.outgoingEdges(task.variable)) {
                queue.add(new Task(successor2, task.degree + 1, task.className));
            }
            IntObjectMap<ValueType> intObjectMap = this.casts.get(task.variable);
            if (intObjectMap == null) continue;
            if (task.className.startsWith("[")) {
                type = ValueType.parseIfPossible(task.className);
                if (type == null) {
                    type = ValueType.arrayOf(ValueType.object("java.lang.Object"));
                }
            } else {
                type = ValueType.object(task.className);
            }
            int[] nArray = intObjectMap.keys().toArray();
            int n3 = nArray.length;
            for (n = 0; n < n3; ++n) {
                int target = nArray[n];
                ValueType valueType = (ValueType)intObjectMap.get(target);
                if (!classSource.isSuperType(valueType, type).orElse(false).booleanValue()) continue;
                queue.add(new Task(target, 0, task.className));
            }
        }
    }

    private static void readValue(ValueDependencyInfo valueDep, Variable receiver, Collection<Task> tasks) {
        boolean hasArrayType;
        int depth = 0;
        do {
            for (String type : valueDep.getTypes()) {
                tasks.add(new Task(receiver.getIndex(), depth, type));
            }
            ++depth;
            hasArrayType = valueDep.hasArrayType();
            valueDep = valueDep.getArrayItem();
        } while (hasArrayType);
    }

    private static void writeValue(ValueDependencyInfo valueDep, Variable source, Collection<Task> tasks) {
        int depth = 0;
        while (valueDep.hasArrayType()) {
            ++depth;
            valueDep = valueDep.getArrayItem();
            for (String type : valueDep.getTypes()) {
                tasks.add(new Task(source.getIndex(), depth, type));
            }
        }
    }

    static class VirtualCallSite {
        Set<MethodReference> resolvedMethods = new HashSet<MethodReference>();
        MethodReference method;
        int[] arguments;
        int receiver;
        int block;

        VirtualCallSite() {
        }
    }

    static class Task {
        int variable;
        int degree;
        String className;

        Task(int variable, int degree, String className) {
            this.variable = variable;
            this.degree = degree;
            this.className = className;
        }
    }

    static class GraphBuildingVisitor
    extends AbstractInstructionVisitor {
        DependencyInfo dependencyInfo;
        GraphBuilder assignmentGraphBuilder;
        GraphBuilder cloneGraphBuilder;
        GraphBuilder arrayGraphBuilder;
        GraphBuilder itemGraphBuilder;
        MethodDependencyInfo thisMethodDep;
        List<IntObjectMap<ValueType>> casts = new ArrayList<IntObjectMap<ValueType>>();
        IntObjectMap<IntSet> exceptionMap = new IntObjectOpenHashMap();
        List<Task> tasks = new ArrayList<Task>();
        List<List<VirtualCallSite>> virtualCallSites = new ArrayList<List<VirtualCallSite>>();
        BasicBlock currentBlock;

        GraphBuildingVisitor(int variableCount, DependencyInfo dependencyInfo) {
            this.dependencyInfo = dependencyInfo;
            this.assignmentGraphBuilder = new GraphBuilder(variableCount);
            this.cloneGraphBuilder = new GraphBuilder(variableCount);
            this.arrayGraphBuilder = new GraphBuilder(variableCount);
            this.itemGraphBuilder = new GraphBuilder(variableCount);
            this.casts = new ArrayList<IntObjectMap<ValueType>>(variableCount);
            for (int i = 0; i < variableCount; ++i) {
                this.casts.add((IntObjectMap<ValueType>)new IntObjectOpenHashMap());
            }
            this.virtualCallSites = new ArrayList<Object>(Collections.nCopies(variableCount, null));
        }

        public void visit(Phi phi) {
            for (Incoming incoming : phi.getIncomings()) {
                this.assignmentGraphBuilder.addEdge(incoming.getValue().getIndex(), phi.getReceiver().getIndex());
            }
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.tasks.add(new Task(insn.getReceiver().getIndex(), 0, "java.lang.Class"));
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.tasks.add(new Task(insn.getReceiver().getIndex(), 0, "java.lang.String"));
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.assignmentGraphBuilder.addEdge(insn.getAssignee().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.casts.get(insn.getValue().getIndex()).put(insn.getReceiver().getIndex(), (Object)insn.getTargetType());
        }

        @Override
        public void visit(RaiseInstruction insn) {
            IntSet blockIndexes = (IntSet)this.exceptionMap.get(insn.getException().getIndex());
            if (blockIndexes == null) {
                blockIndexes = new IntOpenHashSet();
                this.exceptionMap.put(insn.getException().getIndex(), (Object)blockIndexes);
            }
            blockIndexes.add(this.currentBlock.getIndex());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            this.tasks.add(new Task(insn.getReceiver().getIndex(), 0, ValueType.arrayOf(insn.getItemType()).toString()));
        }

        @Override
        public void visit(ConstructInstruction insn) {
            this.tasks.add(new Task(insn.getReceiver().getIndex(), 0, insn.getType()));
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            ValueType type = insn.getItemType();
            for (int i = 0; i < insn.getDimensions().size(); ++i) {
                type = ValueType.arrayOf(type);
            }
            this.tasks.add(new Task(insn.getReceiver().getIndex(), 0, type.toString()));
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            FieldDependencyInfo fieldDep = this.dependencyInfo.getField(insn.getField());
            ValueDependencyInfo valueDep = fieldDep.getValue();
            ClassInference.readValue(valueDep, insn.getReceiver(), this.tasks);
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            FieldDependencyInfo fieldDep = this.dependencyInfo.getField(insn.getField());
            ValueDependencyInfo valueDep = fieldDep.getValue();
            ClassInference.writeValue(valueDep, insn.getValue(), this.tasks);
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.cloneGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.assignmentGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(GetElementInstruction insn) {
            this.itemGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(PutElementInstruction insn) {
            this.arrayGraphBuilder.addEdge(insn.getValue().getIndex(), insn.getArray().getIndex());
        }

        @Override
        public void visit(ExitInstruction insn) {
            if (insn.getValueToReturn() != null) {
                ValueDependencyInfo resultDependency = this.thisMethodDep.getResult();
                int resultDegree = 0;
                while (resultDependency.hasArrayType()) {
                    resultDependency = resultDependency.getArrayItem();
                    for (String paramType : resultDependency.getTypes()) {
                        this.tasks.add(new Task(insn.getValueToReturn().getIndex(), ++resultDegree, paramType));
                    }
                }
            }
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getType() == InvocationType.VIRTUAL) {
                int instance = insn.getInstance().getIndex();
                List<VirtualCallSite> callSites = this.virtualCallSites.get(instance);
                if (callSites == null) {
                    callSites = new ArrayList<VirtualCallSite>();
                    this.virtualCallSites.set(instance, callSites);
                }
                VirtualCallSite callSite = new VirtualCallSite();
                callSite.method = insn.getMethod();
                callSite.arguments = new int[insn.getArguments().size()];
                for (int i = 0; i < insn.getArguments().size(); ++i) {
                    callSite.arguments[i] = insn.getArguments().get(i).getIndex();
                }
                callSite.receiver = insn.getReceiver() != null ? insn.getReceiver().getIndex() : -1;
                callSite.block = this.currentBlock.getIndex();
                callSites.add(callSite);
                return;
            }
            MethodDependencyInfo methodDep = this.dependencyInfo.getMethod(insn.getMethod());
            if (methodDep != null) {
                if (insn.getReceiver() != null) {
                    ClassInference.readValue(methodDep.getResult(), insn.getReceiver(), this.tasks);
                }
                for (int i = 0; i < insn.getArguments().size(); ++i) {
                    ClassInference.writeValue(methodDep.getVariable(i + 1), insn.getArguments().get(i), this.tasks);
                }
                for (String type : methodDep.getThrown().getTypes()) {
                    this.tasks.add(new Task(this.currentBlock.getIndex(), -1, type));
                }
            }
        }
    }
}

