/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.common.ServiceRepository;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;

public class RenderingContext {
    private final DebugInformationEmitter debugEmitter;
    private ListableClassReaderSource classSource;
    private ClassLoader classLoader;
    private ServiceRepository services;
    private Properties properties;
    private NamingStrategy naming;
    private final Deque<LocationStackEntry> locationStack = new ArrayDeque<LocationStackEntry>();
    private final Map<String, Integer> stringPoolMap = new HashMap<String, Integer>();
    private final List<String> stringPool = new ArrayList<String>();
    private final List<String> readonlyStringPool = Collections.unmodifiableList(this.stringPool);
    private final Map<MethodReference, InjectorHolder> injectorMap = new HashMap<MethodReference, InjectorHolder>();
    private boolean minifying;

    public RenderingContext(DebugInformationEmitter debugEmitter, ListableClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Properties properties, NamingStrategy naming) {
        this.debugEmitter = debugEmitter;
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.services = services;
        this.properties = properties;
        this.naming = naming;
    }

    public ListableClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ServiceRepository getServices() {
        return this.services;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public NamingStrategy getNaming() {
        return this.naming;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void pushLocation(TextLocation location) {
        LocationStackEntry prevEntry = this.locationStack.peek();
        if (location != null) {
            if (prevEntry == null || !location.equals(prevEntry.location)) {
                this.debugEmitter.emitLocation(location.getFileName(), location.getLine());
            }
        } else if (prevEntry != null) {
            this.debugEmitter.emitLocation(null, -1);
        }
        this.locationStack.push(new LocationStackEntry(location));
    }

    public void popLocation() {
        LocationStackEntry prevEntry = this.locationStack.pop();
        LocationStackEntry entry = this.locationStack.peek();
        if (entry != null) {
            if (!entry.location.equals(prevEntry.location)) {
                this.debugEmitter.emitLocation(entry.location.getFileName(), entry.location.getLine());
            }
        } else {
            this.debugEmitter.emitLocation(null, -1);
        }
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public int lookupString(String string) {
        return this.stringPoolMap.computeIfAbsent(string, key -> {
            this.stringPool.add((String)key);
            return this.stringPool.size() - 1;
        });
    }

    public List<String> getStringPool() {
        return this.readonlyStringPool;
    }

    public String constantToString(Object cst) {
        if (cst == null) {
            return "null";
        }
        if (cst instanceof ValueType) {
            ValueType type = (ValueType)cst;
            return this.naming.getNameForFunction("$rt_cls") + "(" + this.typeToClsString(type) + ")";
        }
        if (cst instanceof String) {
            String string = (String)cst;
            int index = this.lookupString(string);
            return this.naming.getNameForFunction("$rt_s") + "(" + index + ")";
        }
        if (cst instanceof Long) {
            long value = (Long)cst;
            if (value == 0L) {
                return "Long_ZERO";
            }
            if ((long)((int)value) == value) {
                return "Long_fromInt(" + value + ")";
            }
            return "new Long(" + (value & 0xFFFFFFFFL) + ", " + (value >>> 32) + ")";
        }
        if (cst instanceof Character) {
            return Integer.toString(((Character)cst).charValue());
        }
        return cst.toString();
    }

    public String typeToClsString(ValueType type) {
        String value;
        int arrayCount = 0;
        while (type instanceof ValueType.Array) {
            ++arrayCount;
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            ValueType.Object objType = (ValueType.Object)type;
            value = this.naming.getNameFor(objType.getClassName());
        } else if (type instanceof ValueType.Void) {
            value = "$rt_voidcls()";
        } else if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitiveType = (ValueType.Primitive)type;
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    value = "$rt_booleancls()";
                    break;
                }
                case CHARACTER: {
                    value = "$rt_charcls()";
                    break;
                }
                case BYTE: {
                    value = "$rt_bytecls()";
                    break;
                }
                case SHORT: {
                    value = "$rt_shortcls()";
                    break;
                }
                case INTEGER: {
                    value = "$rt_intcls()";
                    break;
                }
                case LONG: {
                    value = "$rt_longcls()";
                    break;
                }
                case FLOAT: {
                    value = "$rt_floatcls()";
                    break;
                }
                case DOUBLE: {
                    value = "$rt_doublecls()";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type is not renderable");
                }
            }
        } else {
            throw new IllegalArgumentException("The type is not renderable");
        }
        for (int i = 0; i < arrayCount; ++i) {
            value = "$rt_arraycls(" + value + ")";
        }
        return value;
    }

    public String pointerName() {
        return this.minifying ? "$p" : "$ptr";
    }

    public String mainLoopName() {
        return this.minifying ? "_" : "main";
    }

    public String tempVarName() {
        return this.minifying ? "$z" : "$tmp";
    }

    public String threadName() {
        return this.minifying ? "$T" : "$thread";
    }

    public void addInjector(MethodReference method, Injector injector) {
        this.injectorMap.put(method, new InjectorHolder(injector));
    }

    public Injector getInjector(MethodReference ref) {
        InjectorHolder holder = this.injectorMap.get(ref);
        if (holder == null) {
            AnnotationReader injectedByAnnot;
            MethodReader method;
            holder = new InjectorHolder(null);
            ClassReader cls = this.classSource.get(ref.getClassName());
            if (cls != null && (method = cls.getMethod(ref.getDescriptor())) != null && (injectedByAnnot = method.getAnnotations().get(InjectedBy.class.getName())) != null) {
                ValueType type = injectedByAnnot.getValue("value").getJavaClass();
                holder = new InjectorHolder(this.instantiateInjector(((ValueType.Object)type).getClassName()));
            }
            this.injectorMap.put(ref, holder);
        }
        return holder.injector;
    }

    private Injector instantiateInjector(String type) {
        try {
            Class<Injector> cls = Class.forName(type, true, this.classLoader).asSubclass(Injector.class);
            Constructor<Injector> cons = cls.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Illegal injector: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Default constructor was not found in the " + type + " injector", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Error instantiating injector " + type, e);
        }
    }

    private static class InjectorHolder {
        public final Injector injector;

        private InjectorHolder(Injector injector) {
            this.injector = injector;
        }
    }

    private static class LocationStackEntry {
        final TextLocation location;

        LocationStackEntry(TextLocation location) {
            this.location = location;
        }
    }
}

