/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.teavm.common.Graph;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.Program;
import org.teavm.model.util.ProgramUtils;

class LocationGraphBuilder {
    private Map<InstructionLocation, Set<InstructionLocation>> graphBuilder;
    private List<Set<InstructionLocation>> startLocations;
    private List<AdditionalConnection> additionalConnections;

    LocationGraphBuilder() {
    }

    public Map<InstructionLocation, InstructionLocation[]> build(Program program) {
        this.graphBuilder = new HashMap<InstructionLocation, Set<InstructionLocation>>();
        Graph graph = ProgramUtils.buildControlFlowGraph(program);
        this.dfs(graph, program);
        return this.assemble();
    }

    private void dfs(Graph graph, Program program) {
        this.startLocations = new ArrayList<Object>(Collections.nCopies(graph.size(), null));
        this.additionalConnections = new ArrayList<AdditionalConnection>();
        ArrayDeque<Step> stack = new ArrayDeque<Step>();
        for (int i = 0; i < graph.size(); ++i) {
            if (graph.incomingEdgesCount(i) != 0) continue;
            stack.push(new Step(null, new HashSet<InstructionLocation>(), i));
        }
        boolean[] visited = new boolean[graph.size()];
        InstructionLocation[] blockLocations = new InstructionLocation[graph.size()];
        while (!stack.isEmpty()) {
            Step step = (Step)stack.pop();
            if (visited[step.block]) {
                if (step.location == null) continue;
                this.additionalConnections.add(new AdditionalConnection(step.location, this.startLocations.get(step.block)));
                continue;
            }
            visited[step.block] = true;
            this.startLocations.set(step.block, step.startLocations);
            BasicBlock block = program.basicBlockAt(step.block);
            InstructionLocation location = step.location;
            boolean started = false;
            for (Instruction insn : block.getInstructions()) {
                if (insn.getLocation() == null) continue;
                if (!started) {
                    step.startLocations.add(insn.getLocation());
                }
                started = true;
                if (blockLocations[step.block] == null) {
                    blockLocations[step.block] = insn.getLocation();
                }
                if (location != null && !Objects.equals(location, insn.getLocation())) {
                    this.addEdge(location, insn.getLocation());
                }
                location = insn.getLocation();
            }
            if (graph.outgoingEdgesCount(step.block) == 0) {
                if (location == null) continue;
                this.addEdge(location, new InstructionLocation(null, -1));
                continue;
            }
            for (Object next : (Object)graph.outgoingEdges(step.block)) {
                stack.push(new Step(location, started ? new HashSet() : step.startLocations, (int)next));
            }
        }
    }

    private Map<InstructionLocation, InstructionLocation[]> assemble() {
        for (AdditionalConnection additionalConn : this.additionalConnections) {
            for (InstructionLocation succ : additionalConn.successors) {
                this.addEdge(additionalConn.location, succ);
            }
        }
        HashMap<InstructionLocation, InstructionLocation[]> locationGraph = new HashMap<InstructionLocation, InstructionLocation[]>();
        for (Map.Entry<InstructionLocation, Set<InstructionLocation>> entry : this.graphBuilder.entrySet()) {
            InstructionLocation[] successors = entry.getValue().toArray(new InstructionLocation[0]);
            for (int i = 0; i < successors.length; ++i) {
                if (successors[i] == null || successors[i].getLine() >= 0) continue;
                successors[i] = null;
            }
            locationGraph.put(entry.getKey(), successors);
        }
        return locationGraph;
    }

    private void addEdge(InstructionLocation source, InstructionLocation dest) {
        Set<InstructionLocation> successors = this.graphBuilder.get(source);
        if (successors == null) {
            successors = new HashSet<InstructionLocation>();
            this.graphBuilder.put(source, successors);
        }
        successors.add(dest);
    }

    static class AdditionalConnection {
        InstructionLocation location;
        Set<InstructionLocation> successors;

        public AdditionalConnection(InstructionLocation location, Set<InstructionLocation> successors) {
            this.location = location;
            this.successors = successors;
        }
    }

    static class Step {
        InstructionLocation location;
        Set<InstructionLocation> startLocations;
        int block;

        public Step(InstructionLocation location, Set<InstructionLocation> startLocations, int block) {
            this.location = location;
            this.startLocations = startLocations;
            this.block = block;
        }
    }
}

