/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.teavm.debugging.Breakpoint;
import org.teavm.debugging.CallFrame;
import org.teavm.debugging.DebuggerListener;
import org.teavm.debugging.VariableMap;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationProvider;
import org.teavm.debugging.information.DebuggerCallSite;
import org.teavm.debugging.information.DebuggerCallSiteVisitor;
import org.teavm.debugging.information.DebuggerStaticCallSite;
import org.teavm.debugging.information.DebuggerVirtualCallSite;
import org.teavm.debugging.information.GeneratedLocation;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.debugging.javascript.JavaScriptBreakpoint;
import org.teavm.debugging.javascript.JavaScriptCallFrame;
import org.teavm.debugging.javascript.JavaScriptDebugger;
import org.teavm.debugging.javascript.JavaScriptDebuggerListener;
import org.teavm.debugging.javascript.JavaScriptLocation;
import org.teavm.model.MethodReference;

public class Debugger {
    private static final Object dummyObject = new Object();
    private ConcurrentMap<DebuggerListener, Object> listeners = new ConcurrentHashMap<DebuggerListener, Object>();
    private JavaScriptDebugger javaScriptDebugger;
    private DebugInformationProvider debugInformationProvider;
    private BlockingQueue<JavaScriptBreakpoint> temporaryBreakpoints = new LinkedBlockingQueue<JavaScriptBreakpoint>();
    private ConcurrentMap<String, DebugInformation> debugInformationMap = new ConcurrentHashMap<String, DebugInformation>();
    private ConcurrentMap<String, ConcurrentMap<DebugInformation, Object>> debugInformationFileMap = new ConcurrentHashMap<String, ConcurrentMap<DebugInformation, Object>>();
    private ConcurrentMap<DebugInformation, String> scriptMap = new ConcurrentHashMap<DebugInformation, String>();
    ConcurrentMap<JavaScriptBreakpoint, Breakpoint> breakpointMap = new ConcurrentHashMap<JavaScriptBreakpoint, Breakpoint>();
    ConcurrentMap<Breakpoint, Object> breakpoints = new ConcurrentHashMap<Breakpoint, Object>();
    private volatile CallFrame[] callStack;
    private JavaScriptDebuggerListener javaScriptListener = new JavaScriptDebuggerListener(){

        @Override
        public void resumed() {
            Debugger.this.fireResumed();
        }

        @Override
        public void paused() {
            Debugger.access$102(Debugger.this, null);
            for (DebuggerListener listener : Debugger.this.getListeners()) {
                listener.paused();
            }
        }

        @Override
        public void scriptAdded(String name) {
            Debugger.this.addScript(name);
        }

        @Override
        public void attached() {
            Debugger.this.fireAttached();
        }

        @Override
        public void detached() {
            Debugger.this.fireDetached();
        }

        @Override
        public void breakpointChanged(JavaScriptBreakpoint jsBreakpoint) {
            Debugger.this.fireBreakpointChanged(jsBreakpoint);
        }
    };

    public Debugger(JavaScriptDebugger javaScriptDebugger, DebugInformationProvider debugInformationProvider) {
        this.javaScriptDebugger = javaScriptDebugger;
        this.debugInformationProvider = debugInformationProvider;
        javaScriptDebugger.addListener(this.javaScriptListener);
    }

    public JavaScriptDebugger getJavaScriptDebugger() {
        return this.javaScriptDebugger;
    }

    public void addListener(DebuggerListener listener) {
        this.listeners.put(listener, dummyObject);
    }

    public void removeListener(DebuggerListener listener) {
        this.listeners.remove(listener);
    }

    public void suspend() {
        this.javaScriptDebugger.suspend();
    }

    public void resume() {
        this.javaScriptDebugger.resume();
    }

    public void stepInto() {
        this.step(true);
    }

    public void stepOut() {
        this.javaScriptDebugger.stepOut();
    }

    public void stepOver() {
        this.step(false);
    }

    private void jsStep(boolean enterMethod) {
        if (enterMethod) {
            this.javaScriptDebugger.stepInto();
        } else {
            this.javaScriptDebugger.stepOver();
        }
    }

    private void step(boolean enterMethod) {
        CallFrame[] callStack = this.getCallStack();
        if (callStack == null || callStack.length == 0) {
            this.jsStep(enterMethod);
            return;
        }
        CallFrame recentFrame = callStack[0];
        if (recentFrame.getLocation() == null || recentFrame.getLocation().getFileName() == null || recentFrame.getLocation().getLine() < 0) {
            this.jsStep(enterMethod);
            return;
        }
        HashSet<JavaScriptLocation> successors = new HashSet<JavaScriptLocation>();
        for (CallFrame frame : callStack) {
            boolean exits;
            String script = frame.getOriginalLocation().getScript();
            DebugInformation debugInfo = (DebugInformation)this.debugInformationMap.get(script);
            if (frame.getLocation() != null && frame.getLocation().getFileName() != null && frame.getLocation().getLine() >= 0 && debugInfo != null) {
                exits = this.addFollowing(debugInfo, frame.getLocation(), script, new HashSet<SourceLocation>(), successors);
                if (enterMethod) {
                    DebuggerCallSite[] callSites;
                    CallSiteSuccessorFinder successorFinder = new CallSiteSuccessorFinder(debugInfo, script, successors);
                    for (DebuggerCallSite callSite : callSites = debugInfo.getCallSites(frame.getLocation())) {
                        callSite.acceptVisitor(successorFinder);
                    }
                }
            } else {
                exits = true;
            }
            if (!exits) break;
            enterMethod = true;
        }
        for (JavaScriptLocation successor : successors) {
            this.temporaryBreakpoints.add(this.javaScriptDebugger.createBreakpoint(successor));
        }
        this.javaScriptDebugger.resume();
    }

    private boolean addFollowing(DebugInformation debugInfo, SourceLocation location, String script, Set<SourceLocation> visited, Set<JavaScriptLocation> successors) {
        if (!visited.add(location)) {
            return false;
        }
        SourceLocation[] following = debugInfo.getFollowingLines(location);
        boolean exits = false;
        if (following != null) {
            for (SourceLocation successor : following) {
                if (successor == null) {
                    exits = true;
                    continue;
                }
                Collection<GeneratedLocation> genLocations = debugInfo.getGeneratedLocations(successor);
                if (!genLocations.isEmpty()) {
                    for (GeneratedLocation loc : genLocations) {
                        loc = debugInfo.getStatementLocation(loc);
                        successors.add(new JavaScriptLocation(script, loc.getLine(), loc.getColumn()));
                    }
                    continue;
                }
                exits |= this.addFollowing(debugInfo, successor, script, visited, successors);
            }
        }
        return exits;
    }

    private List<DebugInformation> debugInformationBySource(String sourceFile) {
        Map list = (Map)this.debugInformationFileMap.get(sourceFile);
        return list != null ? new ArrayList(list.keySet()) : Collections.emptyList();
    }

    public void continueToLocation(SourceLocation location) {
        this.continueToLocation(location.getFileName(), location.getLine());
    }

    public void continueToLocation(String fileName, int line) {
        if (!this.javaScriptDebugger.isSuspended()) {
            return;
        }
        for (DebugInformation debugInformation : this.debugInformationBySource(fileName)) {
            Collection<GeneratedLocation> locations = debugInformation.getGeneratedLocations(fileName, line);
            for (GeneratedLocation location : locations) {
                JavaScriptLocation jsLocation = new JavaScriptLocation((String)this.scriptMap.get(debugInformation), location.getLine(), location.getColumn());
                JavaScriptBreakpoint jsBreakpoint = this.javaScriptDebugger.createBreakpoint(jsLocation);
                if (jsBreakpoint == null) continue;
                this.temporaryBreakpoints.add(jsBreakpoint);
            }
        }
        this.javaScriptDebugger.resume();
    }

    public boolean isSuspended() {
        return this.javaScriptDebugger.isSuspended();
    }

    public Breakpoint createBreakpoint(String file, int line) {
        return this.createBreakpoint(new SourceLocation(file, line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breakpoint createBreakpoint(SourceLocation location) {
        ConcurrentMap<JavaScriptBreakpoint, Breakpoint> concurrentMap = this.breakpointMap;
        synchronized (concurrentMap) {
            Breakpoint breakpoint = new Breakpoint(this, location);
            this.breakpoints.put(breakpoint, dummyObject);
            this.updateInternalBreakpoints(breakpoint);
            this.updateBreakpointStatus(breakpoint, false);
            return breakpoint;
        }
    }

    public Set<Breakpoint> getBreakpoints() {
        return new HashSet<Breakpoint>(this.breakpoints.keySet());
    }

    void updateInternalBreakpoints(Breakpoint breakpoint) {
        if (breakpoint.isDestroyed()) {
            return;
        }
        for (JavaScriptBreakpoint jsBreakpoint : breakpoint.jsBreakpoints) {
            this.breakpointMap.remove(jsBreakpoint);
            jsBreakpoint.destroy();
        }
        ArrayList<JavaScriptBreakpoint> jsBreakpoints = new ArrayList<JavaScriptBreakpoint>();
        SourceLocation location = breakpoint.getLocation();
        for (DebugInformation debugInformation : this.debugInformationBySource(location.getFileName())) {
            Collection<GeneratedLocation> locations = debugInformation.getGeneratedLocations(location);
            for (GeneratedLocation genLocation : locations) {
                JavaScriptLocation jsLocation = new JavaScriptLocation((String)this.scriptMap.get(debugInformation), genLocation.getLine(), genLocation.getColumn());
                JavaScriptBreakpoint jsBreakpoint = this.javaScriptDebugger.createBreakpoint(jsLocation);
                jsBreakpoints.add(jsBreakpoint);
                this.breakpointMap.put(jsBreakpoint, breakpoint);
            }
        }
        breakpoint.jsBreakpoints = jsBreakpoints;
    }

    private DebuggerListener[] getListeners() {
        return this.listeners.keySet().toArray(new DebuggerListener[0]);
    }

    void updateBreakpointStatus(Breakpoint breakpoint, boolean fireEvent) {
        boolean valid = false;
        for (JavaScriptBreakpoint jsBreakpoint : breakpoint.jsBreakpoints) {
            if (!jsBreakpoint.isValid()) continue;
            valid = true;
        }
        if (breakpoint.valid != valid) {
            breakpoint.valid = valid;
            if (fireEvent) {
                for (DebuggerListener listener : this.getListeners()) {
                    listener.breakpointStatusChanged(breakpoint);
                }
            }
        }
    }

    public CallFrame[] getCallStack() {
        if (!this.isSuspended()) {
            return null;
        }
        if (this.callStack == null) {
            ArrayList<CallFrame> frames = new ArrayList<CallFrame>();
            boolean wasEmpty = false;
            for (JavaScriptCallFrame jsFrame : this.javaScriptDebugger.getCallStack()) {
                MethodReference method;
                DebugInformation debugInformation = (DebugInformation)this.debugInformationMap.get(jsFrame.getLocation().getScript());
                SourceLocation loc = debugInformation != null ? debugInformation.getSourceLocation(jsFrame.getLocation().getLine(), jsFrame.getLocation().getColumn()) : null;
                boolean empty = loc == null || loc.getFileName() == null && loc.getLine() < 0;
                MethodReference methodReference = method = !empty ? debugInformation.getMethodAt(jsFrame.getLocation().getLine(), jsFrame.getLocation().getColumn()) : null;
                if (!empty || !wasEmpty) {
                    VariableMap vars = new VariableMap(jsFrame.getVariables(), this, jsFrame.getLocation());
                    frames.add(new CallFrame(this, jsFrame, loc, method, vars));
                }
                wasEmpty = empty;
            }
            this.callStack = frames.toArray(new CallFrame[0]);
        }
        return (CallFrame[])this.callStack.clone();
    }

    private void addScript(String name) {
        if (this.debugInformationMap.containsKey(name)) {
            this.updateBreakpoints();
            return;
        }
        DebugInformation debugInfo = this.debugInformationProvider.getDebugInformation(name);
        if (debugInfo == null) {
            this.updateBreakpoints();
            return;
        }
        if (this.debugInformationMap.putIfAbsent(name, debugInfo) != null) {
            this.updateBreakpoints();
            return;
        }
        for (String sourceFile : debugInfo.getFilesNames()) {
            ConcurrentMap existing;
            ConcurrentMap<DebugInformation, Object> list = (ConcurrentHashMap<DebugInformation, Object>)this.debugInformationFileMap.get(sourceFile);
            if (list == null && (existing = (ConcurrentMap)this.debugInformationFileMap.putIfAbsent(sourceFile, list = new ConcurrentHashMap<DebugInformation, Object>())) != null) {
                list = existing;
            }
            list.put(debugInfo, dummyObject);
        }
        this.scriptMap.put(debugInfo, name);
        this.updateBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBreakpoints() {
        ConcurrentMap<JavaScriptBreakpoint, Breakpoint> concurrentMap = this.breakpointMap;
        synchronized (concurrentMap) {
            for (Breakpoint breakpoint : this.breakpoints.keySet()) {
                this.updateInternalBreakpoints(breakpoint);
                this.updateBreakpointStatus(breakpoint, true);
            }
        }
    }

    public boolean isAttached() {
        return this.javaScriptDebugger.isAttached();
    }

    public void detach() {
        this.javaScriptDebugger.detach();
    }

    void destroyBreakpoint(Breakpoint breakpoint) {
        for (JavaScriptBreakpoint jsBreakpoint : breakpoint.jsBreakpoints) {
            jsBreakpoint.destroy();
            this.breakpointMap.remove(jsBreakpoint);
        }
        breakpoint.jsBreakpoints = new ArrayList<JavaScriptBreakpoint>();
        this.breakpoints.remove(breakpoint);
    }

    private void fireResumed() {
        ArrayList temporaryBreakpoints = new ArrayList();
        this.temporaryBreakpoints.drainTo(temporaryBreakpoints);
        for (JavaScriptBreakpoint jsBreakpoint : temporaryBreakpoints) {
            jsBreakpoint.destroy();
        }
        for (DebuggerListener listener : this.getListeners()) {
            listener.resumed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttached() {
        DebuggerListener[] debuggerListenerArray = this.breakpointMap;
        synchronized (this.breakpointMap) {
            for (Breakpoint breakpoint : this.breakpoints.keySet()) {
                this.updateInternalBreakpoints(breakpoint);
                this.updateBreakpointStatus(breakpoint, false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (DebuggerListener listener : this.getListeners()) {
                listener.attached();
            }
            return;
        }
    }

    private void fireDetached() {
        for (Breakpoint breakpoint : this.breakpoints.keySet()) {
            this.updateBreakpointStatus(breakpoint, false);
        }
        for (DebuggerListener listener : this.getListeners()) {
            listener.detached();
        }
    }

    private void fireBreakpointChanged(JavaScriptBreakpoint jsBreakpoint) {
        Breakpoint breakpoint = (Breakpoint)this.breakpointMap.get(jsBreakpoint);
        if (breakpoint != null) {
            this.updateBreakpointStatus(breakpoint, true);
        }
    }

    String[] mapVariable(String variable, JavaScriptLocation location) {
        DebugInformation debugInfo = (DebugInformation)this.debugInformationMap.get(location.getScript());
        if (debugInfo == null) {
            return new String[0];
        }
        return debugInfo.getVariableMeaningAt(location.getLine(), location.getColumn(), variable);
    }

    String mapField(String className, String jsField) {
        for (DebugInformation debugInfo : this.debugInformationMap.values()) {
            String meaning = debugInfo.getFieldMeaning(className, jsField);
            if (meaning == null) continue;
            return meaning;
        }
        return null;
    }

    static /* synthetic */ CallFrame[] access$102(Debugger x0, CallFrame[] x1) {
        x0.callStack = x1;
        return x1;
    }

    private static class CallSiteSuccessorFinder
    implements DebuggerCallSiteVisitor {
        private DebugInformation debugInfo;
        private String script;
        Set<JavaScriptLocation> locations;

        public CallSiteSuccessorFinder(DebugInformation debugInfo, String script, Set<JavaScriptLocation> locations) {
            this.debugInfo = debugInfo;
            this.script = script;
            this.locations = locations;
        }

        @Override
        public void visit(DebuggerVirtualCallSite callSite) {
            for (MethodReference potentialMethod : this.debugInfo.getOverridingMethods(callSite.getMethod())) {
                for (GeneratedLocation loc : this.debugInfo.getMethodEntrances(potentialMethod)) {
                    loc = this.debugInfo.getStatementLocation(loc);
                    this.locations.add(new JavaScriptLocation(this.script, loc.getLine(), loc.getColumn()));
                }
            }
        }

        @Override
        public void visit(DebuggerStaticCallSite callSite) {
            for (GeneratedLocation loc : this.debugInfo.getMethodEntrances(callSite.getMethod())) {
                loc = this.debugInfo.getStatementLocation(loc);
                this.locations.add(new JavaScriptLocation(this.script, loc.getLine(), loc.getColumn()));
            }
        }
    }
}

